/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import me.shenfeng.http.HttpMethod;
import me.shenfeng.http.client.Decoder;
import me.shenfeng.http.client.IRespListener;
import me.shenfeng.http.client.PriorityQueue;

public class Request
implements Comparable<Request> {
    final InetSocketAddress addr;
    final Decoder decoder;
    final ByteBuffer request;
    private final PriorityQueue<Request> clients;
    public final int timeOutMs;
    private boolean isDone = false;
    SelectionKey key;
    private long timeoutTs;
    private boolean connected = false;

    public Request(InetSocketAddress addr, ByteBuffer request, IRespListener handler, PriorityQueue<Request> clients, int timeOutMs, HttpMethod method) {
        this.decoder = new Decoder(handler, method);
        this.timeOutMs = timeOutMs;
        this.request = request;
        this.clients = clients;
        this.addr = addr;
        this.timeoutTs = (long)this.timeOutMs + System.currentTimeMillis();
    }

    public void onProgress(long now) {
        this.clients.remove(this);
        this.timeoutTs = (long)this.timeOutMs + now;
        this.clients.offer(this);
    }

    public void finish() {
        this.clients.remove(this);
        if (this.isDone) {
            return;
        }
        this.isDone = true;
        this.decoder.listener.onCompleted();
    }

    public boolean connected() {
        return this.connected;
    }

    public void setConnected() {
        this.connected = true;
    }

    public boolean isTimeout(long now) {
        return this.timeoutTs < now;
    }

    public void finish(Throwable t) {
        this.clients.remove(this);
        if (this.isDone) {
            return;
        }
        this.isDone = true;
        this.decoder.listener.onThrowable(t);
    }

    @Override
    public int compareTo(Request o) {
        return (int)(this.timeoutTs - o.timeoutTs);
    }
}

