/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import me.shenfeng.http.HttpMethod;
import me.shenfeng.http.HttpStatus;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.HttpVersion;
import me.shenfeng.http.LineTooLargeException;
import me.shenfeng.http.ProtocolException;
import me.shenfeng.http.client.AbortException;
import me.shenfeng.http.client.IRespListener;
import me.shenfeng.http.client.State;

public class Decoder {
    private final Map<String, String> headers = new TreeMap<String, String>();
    final IRespListener listener;
    final byte[] lineBuffer = new byte[4096];
    int lineBufferCnt = 0;
    int readRemaining = 0;
    State state = State.READ_INITIAL;
    public final HttpMethod method;

    public Decoder(IRespListener listener, HttpMethod method) {
        this.listener = listener;
        this.method = method;
    }

    private void parseInitialLine(String sb) throws ProtocolException, AbortException {
        int cEnd;
        int aStart = HttpUtils.findNonWhitespace(sb, 0);
        int aEnd = HttpUtils.findWhitespace(sb, aStart);
        int bStart = HttpUtils.findNonWhitespace(sb, aEnd);
        int bEnd = HttpUtils.findWhitespace(sb, bStart);
        int cStart = HttpUtils.findNonWhitespace(sb, bEnd);
        if (cStart < (cEnd = HttpUtils.findEndOfString(sb))) {
            try {
                int status = Integer.parseInt(sb.substring(bStart, bEnd));
                HttpStatus s = HttpStatus.valueOf(status);
                HttpVersion version = HttpVersion.HTTP_1_1;
                if ("HTTP/1.0".equals(sb.substring(aStart, cEnd))) {
                    version = HttpVersion.HTTP_1_0;
                }
                this.listener.onInitialLineReceived(version, s);
                this.state = State.READ_HEADER;
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("not http prototol? " + sb);
            }
        } else {
            throw new ProtocolException("not http prototol? " + sb);
        }
    }

    public State decode(ByteBuffer buffer) throws LineTooLargeException, ProtocolException, AbortException {
        byte[] bodyBuffer = new byte[65536];
        while (buffer.hasRemaining() && this.state != State.ALL_READ) {
            switch (this.state) {
                case READ_INITIAL: {
                    String line = this.readLine(buffer);
                    if (line == null) break;
                    this.parseInitialLine(line);
                    break;
                }
                case READ_HEADER: {
                    this.readHeaders(buffer);
                    break;
                }
                case READ_CHUNK_SIZE: {
                    String line = this.readLine(buffer);
                    if (line == null) break;
                    this.readRemaining = HttpUtils.getChunkSize(line);
                    if (this.readRemaining == 0) {
                        this.state = State.READ_CHUNK_FOOTER;
                        break;
                    }
                    this.state = State.READ_CHUNKED_CONTENT;
                    break;
                }
                case READ_FIXED_LENGTH_CONTENT: {
                    int toRead = Math.min(buffer.remaining(), this.readRemaining);
                    buffer.get(bodyBuffer, 0, toRead);
                    this.listener.onBodyReceived(bodyBuffer, toRead);
                    this.readRemaining -= toRead;
                    if (this.readRemaining != 0) break;
                    this.state = State.ALL_READ;
                    break;
                }
                case READ_CHUNKED_CONTENT: {
                    int toRead = Math.min(buffer.remaining(), this.readRemaining);
                    buffer.get(bodyBuffer, 0, toRead);
                    this.listener.onBodyReceived(bodyBuffer, toRead);
                    this.readRemaining -= toRead;
                    if (this.readRemaining != 0) break;
                    this.state = State.READ_CHUNK_DELIMITER;
                    break;
                }
                case READ_CHUNK_FOOTER: {
                    this.readEmptyLine(buffer);
                    this.state = State.ALL_READ;
                    break;
                }
                case READ_CHUNK_DELIMITER: {
                    this.readEmptyLine(buffer);
                    this.state = State.READ_CHUNK_SIZE;
                    break;
                }
                case READ_VARIABLE_LENGTH_CONTENT: {
                    int toRead = buffer.remaining();
                    buffer.get(bodyBuffer, 0, toRead);
                    this.listener.onBodyReceived(bodyBuffer, toRead);
                }
            }
        }
        return this.state;
    }

    void readEmptyLine(ByteBuffer buffer) {
        byte b = buffer.get();
        if (b == 13 && buffer.hasRemaining()) {
            buffer.get();
        }
    }

    private void readHeaders(ByteBuffer buffer) throws LineTooLargeException, AbortException {
        String line = this.readLine(buffer);
        while (line != null && !line.isEmpty()) {
            HttpUtils.splitAndAddHeader(line, this.headers);
            line = this.readLine(buffer);
        }
        if (line == null) {
            return;
        }
        this.listener.onHeadersReceived(this.headers);
        if (this.method == HttpMethod.HEAD) {
            this.state = State.ALL_READ;
            return;
        }
        String te = this.headers.get("transfer-encoding");
        if ("chunked".equals(te)) {
            this.state = State.READ_CHUNK_SIZE;
        } else {
            String cl = this.headers.get("content-length");
            if (cl != null) {
                this.readRemaining = Integer.parseInt(cl);
                this.state = this.readRemaining == 0 ? State.ALL_READ : State.READ_FIXED_LENGTH_CONTENT;
            } else {
                this.state = State.READ_VARIABLE_LENGTH_CONTENT;
            }
        }
    }

    String readLine(ByteBuffer buffer) throws LineTooLargeException {
        boolean more = true;
        while (buffer.hasRemaining() && more) {
            byte b = buffer.get();
            if (b == 13) {
                if (!buffer.hasRemaining() || buffer.get() != 10) continue;
                more = false;
                continue;
            }
            if (b == 10) {
                more = false;
                continue;
            }
            this.lineBuffer[this.lineBufferCnt] = b;
            ++this.lineBufferCnt;
            if (this.lineBufferCnt < 4096) continue;
            throw new LineTooLargeException("exceed max line 4096");
        }
        String line = null;
        if (!more) {
            line = new String(this.lineBuffer, 0, this.lineBufferCnt);
            this.lineBufferCnt = 0;
        }
        return line;
    }

    public void reset() {
        this.headers.clear();
        this.state = State.READ_INITIAL;
    }
}

