/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.server;

import clojure.lang.IFn;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.HttpVersion;
import me.shenfeng.http.PrefixThreafFactory;
import me.shenfeng.http.server.ClojureRing;
import me.shenfeng.http.server.HttpRequest;
import me.shenfeng.http.server.IHandler;
import me.shenfeng.http.server.IListenableFuture;
import me.shenfeng.http.server.ResponseCallback;
import me.shenfeng.http.ws.CloseFrame;
import me.shenfeng.http.ws.TextFrame;
import me.shenfeng.http.ws.WSFrame;
import me.shenfeng.http.ws.WsCon;

public class RingHandler
implements IHandler {
    final ExecutorService execs;
    final IFn handler;

    public RingHandler(int thread, IFn handler, String prefix) {
        PrefixThreafFactory factory = new PrefixThreafFactory(prefix);
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(386);
        this.execs = new ThreadPoolExecutor(thread, thread, 0L, TimeUnit.MILLISECONDS, queue, factory);
        this.handler = handler;
    }

    @Override
    public void handle(final HttpRequest req, final ResponseCallback cb) {
        this.execs.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Map resp = (Map)RingHandler.this.handler.invoke((Object)ClojureRing.buildRequestMap(req));
                    if (resp != null) {
                        Object body = resp.get(ClojureRing.BODY);
                        if (body instanceof IListenableFuture) {
                            this.asyncHandle(cb, resp, (IListenableFuture)body);
                        } else {
                            cb.run(ClojureRing.encode(ClojureRing.getStatus(resp), this.getHeaders(resp), body));
                        }
                    } else {
                        cb.run(ClojureRing.encode(404, new TreeMap<String, Object>(), null));
                    }
                }
                catch (Throwable e) {
                    cb.run(ClojureRing.encode(500, new TreeMap<String, Object>(), e.getMessage()));
                    HttpUtils.printError("ring handler: " + e.getMessage(), e);
                }
            }

            private Map<String, Object> getHeaders(Map resp) {
                TreeMap<String, Object> headers = (TreeMap<String, Object>)resp.get(ClojureRing.HEADERS);
                headers = headers == null ? new TreeMap<String, Object>() : new TreeMap(headers);
                if (req.version == HttpVersion.HTTP_1_0 && req.isKeepAlive() && !headers.containsKey("Connection")) {
                    headers.put("Connection", "Keep-Alive");
                }
                return headers;
            }

            private void asyncHandle(final ResponseCallback cb2, final Map resp, final IListenableFuture future) {
                future.addListener(new Runnable(){

                    @Override
                    public void run() {
                        Object r = future.get();
                        if (r instanceof Map) {
                            Map resp2 = (Map)r;
                            cb2.run(ClojureRing.encode(ClojureRing.getStatus(resp2), this.getHeaders(resp2), resp2.get(ClojureRing.BODY)));
                        } else {
                            cb2.run(ClojureRing.encode(ClojureRing.getStatus(resp), this.getHeaders(resp), r));
                        }
                    }
                });
            }
        });
    }

    @Override
    public void close() {
        this.execs.shutdownNow();
    }

    @Override
    public void handle(final WsCon con, final WSFrame frame) {
        this.execs.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (frame instanceof TextFrame) {
                        con.messageRecieved(((TextFrame)frame).getText());
                    } else if (frame instanceof CloseFrame) {
                        con.clientClosed(((CloseFrame)frame).getStatus());
                    }
                }
                catch (Throwable e) {
                    HttpUtils.printError("handle websocket frame " + frame, e);
                }
            }
        });
    }
}

