/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http;

import java.nio.charset.Charset;
import java.util.Arrays;
import me.shenfeng.http.HttpUtils;

public class DynamicBytes {
    private byte[] data;
    private int idx = 0;

    public DynamicBytes(int size) {
        this.data = new byte[size];
    }

    private void expandIfNessarry(int more) {
        if (this.idx + more > this.data.length) {
            int after = (int)((double)(this.idx + more) * 1.33);
            this.data = Arrays.copyOf(this.data, after);
        }
    }

    public byte[] get() {
        return this.data;
    }

    public int length() {
        return this.idx;
    }

    public DynamicBytes append(byte b) {
        this.expandIfNessarry(1);
        this.data[this.idx++] = b;
        return this;
    }

    public String toString() {
        return "DynamicBytes[len=" + this.idx + ", cap=[" + this.data.length + ']';
    }

    public DynamicBytes append(byte[] d, int offset, int length) {
        this.expandIfNessarry(length);
        System.arraycopy(d, offset, this.data, this.idx, length);
        this.idx += length;
        return this;
    }

    public DynamicBytes append(String str) {
        return this.append(str, HttpUtils.ASCII);
    }

    public DynamicBytes append(String str, Charset c) {
        byte[] bs = str.getBytes(c);
        return this.append(bs, 0, bs.length);
    }
}

