/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.ws;

import clojure.lang.IFn;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import me.shenfeng.http.server.HttpServer;
import me.shenfeng.http.ws.WSEncoder;
import me.shenfeng.http.ws.WsServerAtta;

public class WsCon {
    final SelectionKey key;
    final List<IFn> onRecieveListeners = new ArrayList<IFn>(1);
    final List<IFn> onCloseListeners = new ArrayList<IFn>(1);
    private volatile boolean isClosedRuned = false;
    private final HttpServer server;

    public WsCon(SelectionKey key, HttpServer server) {
        this.key = key;
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnCloseListener(IFn fn) {
        List<IFn> list = this.onCloseListeners;
        synchronized (list) {
            this.onCloseListeners.add(fn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecieveListener(IFn fn) {
        List<IFn> list = this.onRecieveListeners;
        synchronized (list) {
            this.onRecieveListeners.add(fn);
        }
    }

    public void clientClosed(int status) {
        this.onClose(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClose(int status) {
        if (!this.isClosedRuned) {
            IFn[] listeners;
            this.isClosedRuned = true;
            List<IFn> list = this.onCloseListeners;
            synchronized (list) {
                listeners = new IFn[this.onCloseListeners.size()];
                listeners = this.onCloseListeners.toArray(listeners);
            }
            IFn[] iFnArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                IFn l = iFnArray[n2];
                l.invoke((Object)status);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageRecieved(String mesg) {
        IFn[] listeners;
        List<IFn> list = this.onRecieveListeners;
        synchronized (list) {
            listeners = new IFn[this.onRecieveListeners.size()];
            listeners = this.onRecieveListeners.toArray(listeners);
        }
        IFn[] iFnArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IFn l = iFnArray[n2];
            l.invoke((Object)mesg);
            ++n2;
        }
    }

    public void send(String msg) {
        ByteBuffer buffer = WSEncoder.encode(msg);
        WsServerAtta atta = (WsServerAtta)this.key.attachment();
        atta.addBuffer(buffer);
        this.server.queueWrite(this.key);
    }

    public void serverClose() {
        this.serverClose(1000);
    }

    public void serverClose(int status) {
        ByteBuffer s = ByteBuffer.allocate(2).putShort((short)status);
        WsServerAtta atta = (WsServerAtta)this.key.attachment();
        atta.addBuffer(WSEncoder.encode((byte)8, s.array()));
        atta.closeOnfinish = true;
        this.server.queueWrite(this.key);
        this.onClose(status);
    }

    public String toString() {
        Socket s = ((SocketChannel)this.key.channel()).socket();
        return "WsCon[" + s.getLocalSocketAddress() + "<->" + s.getRemoteSocketAddress() + "]";
    }
}

