/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.ssl;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import me.shenfeng.ssl.SslContextFactory;

public class SSLEngineSimpleDemo {
    private static boolean logging = true;
    private static boolean debug = false;
    private SSLContext sslc = SslContextFactory.getClientContext();
    private SSLEngine clientEngine;
    private ByteBuffer clientOut;
    private ByteBuffer clientIn;
    private SSLEngine serverEngine;
    private ByteBuffer serverOut;
    private ByteBuffer serverIn;
    private ByteBuffer cTOs;
    private ByteBuffer sTOc;
    private static String keyStoreFile = "testkeys";
    private static String trustStoreFile = "testkeys";
    private static String passwd = "passphrase";
    private static boolean resultOnce = true;

    public static void main(String[] args) throws Exception {
        if (debug) {
            System.setProperty("javax.net.debug", "all");
        }
        SSLEngineSimpleDemo demo = new SSLEngineSimpleDemo();
        demo.runDemo();
        System.out.println("Demo Completed.");
    }

    private void runDemo() throws Exception {
        boolean dataDone = false;
        this.createSSLEngines();
        this.createBuffers();
        while (!SSLEngineSimpleDemo.isEngineClosed(this.clientEngine) || !SSLEngineSimpleDemo.isEngineClosed(this.serverEngine)) {
            SSLEngineSimpleDemo.log("================");
            SSLEngineResult clientResult = this.clientEngine.wrap(this.clientOut, this.cTOs);
            SSLEngineSimpleDemo.log("client wrap: ", clientResult);
            SSLEngineSimpleDemo.runDelegatedTasks(clientResult, this.clientEngine);
            SSLEngineResult serverResult = this.serverEngine.wrap(this.serverOut, this.sTOc);
            SSLEngineSimpleDemo.log("server wrap: ", serverResult);
            SSLEngineSimpleDemo.runDelegatedTasks(serverResult, this.serverEngine);
            this.cTOs.flip();
            this.sTOc.flip();
            SSLEngineSimpleDemo.log("----");
            clientResult = this.clientEngine.unwrap(this.sTOc, this.clientIn);
            SSLEngineSimpleDemo.log("client unwrap: ", clientResult);
            SSLEngineSimpleDemo.runDelegatedTasks(clientResult, this.clientEngine);
            serverResult = this.serverEngine.unwrap(this.cTOs, this.serverIn);
            SSLEngineSimpleDemo.log("server unwrap: ", serverResult);
            SSLEngineSimpleDemo.runDelegatedTasks(serverResult, this.serverEngine);
            this.cTOs.compact();
            this.sTOc.compact();
            if (dataDone || this.clientOut.limit() != this.serverIn.position() || this.serverOut.limit() != this.clientIn.position()) continue;
            SSLEngineSimpleDemo.checkTransfer(this.serverOut, this.clientIn);
            SSLEngineSimpleDemo.checkTransfer(this.clientOut, this.serverIn);
            SSLEngineSimpleDemo.log("\tClosing clientEngine's *OUTBOUND*...");
            this.clientEngine.closeOutbound();
            dataDone = true;
        }
    }

    private void createSSLEngines() throws Exception {
        this.serverEngine = this.sslc.createSSLEngine();
        this.serverEngine.setUseClientMode(false);
        this.serverEngine.setNeedClientAuth(true);
        this.clientEngine = this.sslc.createSSLEngine("client", 80);
        this.clientEngine.setUseClientMode(true);
    }

    private void createBuffers() {
        SSLSession session = this.clientEngine.getSession();
        int appBufferMax = session.getApplicationBufferSize();
        int netBufferMax = session.getPacketBufferSize();
        this.clientIn = ByteBuffer.allocate(appBufferMax + 50);
        this.serverIn = ByteBuffer.allocate(appBufferMax + 50);
        this.cTOs = ByteBuffer.allocateDirect(netBufferMax);
        this.sTOc = ByteBuffer.allocateDirect(netBufferMax);
        this.clientOut = ByteBuffer.wrap("Hi Server, I'm Client".getBytes());
        this.serverOut = ByteBuffer.wrap("Hello Client, I'm Server".getBytes());
    }

    private static void runDelegatedTasks(SSLEngineResult result, SSLEngine engine) throws Exception {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = engine.getDelegatedTask()) != null) {
                SSLEngineSimpleDemo.log("\trunning delegated task...");
                runnable.run();
            }
            SSLEngineResult.HandshakeStatus hsStatus = engine.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                throw new Exception("handshake shouldn't need additional tasks");
            }
            SSLEngineSimpleDemo.log("\tnew HandshakeStatus: " + (Object)((Object)hsStatus));
        }
    }

    private static boolean isEngineClosed(SSLEngine engine) {
        return engine.isOutboundDone() && engine.isInboundDone();
    }

    private static void checkTransfer(ByteBuffer a, ByteBuffer b) throws Exception {
        a.flip();
        b.flip();
        if (!a.equals(b)) {
            throw new Exception("Data didn't transfer cleanly");
        }
        SSLEngineSimpleDemo.log("\tData transferred cleanly");
        a.position(a.limit());
        b.position(b.limit());
        a.limit(a.capacity());
        b.limit(b.capacity());
    }

    private static void log(String str, SSLEngineResult result) {
        if (!logging) {
            return;
        }
        if (resultOnce) {
            resultOnce = false;
            System.out.println("The format of the SSLEngineResult is: \n\t\"getStatus() / getHandshakeStatus()\" +\n\t\"bytesConsumed() / bytesProduced()\"\n");
        }
        SSLEngineResult.HandshakeStatus hsStatus = result.getHandshakeStatus();
        SSLEngineSimpleDemo.log(String.valueOf(str) + (Object)((Object)result.getStatus()) + "/" + (Object)((Object)hsStatus) + ", " + result.bytesConsumed() + "/" + result.bytesProduced() + " bytes");
        if (hsStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            SSLEngineSimpleDemo.log("\t...ready for application data");
        }
    }

    private static void log(String str) {
        if (logging) {
            System.out.println(str);
        }
    }
}

