/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.server;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import me.shenfeng.http.HttpMethod;
import me.shenfeng.http.HttpVersion;
import me.shenfeng.http.server.BytesInputStream;
import me.shenfeng.http.ws.WsCon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest {
    private int serverPort;
    private String serverName;
    private InetSocketAddress remoteAddr;
    public final String queryString;
    public final String uri;
    public final HttpMethod method;
    private Map<String, String> headers;
    public final HttpVersion version;
    private int contentLength = 0;
    private byte[] body;
    private String contentType;
    private String charset = "utf8";
    private boolean isKeepAlive = false;
    private boolean isWebSocket = false;
    private WsCon webSocketCon;

    public HttpRequest(HttpMethod method, String url, HttpVersion version) {
        this.method = method;
        this.version = version;
        int idx = url.indexOf(63);
        if (idx > 0) {
            this.uri = url.substring(0, idx);
            this.queryString = url.substring(idx + 1);
        } else {
            this.uri = url;
            this.queryString = null;
        }
    }

    public InputStream getBody() {
        if (this.body != null) {
            return new BytesInputStream(this.body, 0, this.contentLength);
        }
        return null;
    }

    public String getCharactorEncoding() {
        return this.charset;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getRemoteAddr() {
        String h = this.headers.get("X-Forwarded-For");
        if (h != null) {
            int idx = h.indexOf(44);
            if (idx == -1) {
                return h;
            }
            return h.substring(0, idx);
        }
        return this.remoteAddr.getAddress().getHostAddress();
    }

    public String getScheme() {
        return "http";
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    public void setBody(byte[] body, int count) {
        this.body = body;
        this.contentLength = count;
    }

    public void setRemoteAddr(SocketAddress addr) {
        this.remoteAddr = (InetSocketAddress)addr;
    }

    public void setWebSocketCon(WsCon con) {
        this.webSocketCon = con;
    }

    public WsCon getWebSocketCon() {
        return this.webSocketCon;
    }

    public boolean isWs() {
        return this.isWebSocket;
    }

    public void setHeaders(Map<String, String> headers) {
        String ct;
        String con;
        String h = headers.get("Host");
        if (h != null) {
            int idx = h.indexOf(58);
            if (idx != -1) {
                this.serverName = h.substring(0, idx);
                this.serverPort = Integer.valueOf(h.substring(idx + 1));
            } else {
                this.serverName = h;
            }
        }
        if ((con = headers.get("Connection")) != null) {
            con = con.toLowerCase();
        }
        if ((ct = headers.get("Content-Type")) != null) {
            int idx = ct.indexOf(";");
            if (idx != -1) {
                int cidx = ct.indexOf("charset=", idx);
                if (cidx != -1) {
                    this.contentType = ct.substring(0, idx);
                    this.charset = ct.substring(cidx + "charset=".length());
                } else {
                    this.contentType = ct;
                }
            } else {
                this.contentType = ct;
            }
        }
        this.isKeepAlive = this.version == HttpVersion.HTTP_1_1 && !"close".equals(con) || "keep-alive".equals(con);
        this.isWebSocket = "websocket".equals(headers.get("Upgrade"));
        this.headers = headers;
    }
}

