/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import me.shenfeng.http.DynamicBytes;
import me.shenfeng.http.client.HttpClient;
import me.shenfeng.http.client.HttpClientConfig;
import me.shenfeng.http.client.TextHandler2;
import me.shenfeng.http.client.TextRespListener;
import org.junit.Before;
import org.junit.Test;

public class TextClientTest {
    HttpClient client;
    TextRespListener.IFilter filter = new TextRespListener.IFilter(){

        @Override
        public boolean accept(Map<String, String> headers) {
            String ct = headers.get("Content-Type");
            if (ct != null) {
                return (ct = ct.toLowerCase()).indexOf("text") != -1 || ct.indexOf("xml") != -1;
            }
            return false;
        }

        @Override
        public boolean accept(DynamicBytes partialBody) {
            return partialBody.length() <= 0x100000;
        }
    };

    @Before
    public void setup() throws IOException {
        this.client = new HttpClient(new HttpClientConfig());
    }

    @Test
    public void testAbort() throws UnknownHostException, URISyntaxException, InterruptedException {
        String[] urls = new String[]{"http://cdn-smooth.ms-studiosmedia.com/news/mp4_mq/06182012_Surface_750k.mp4"};
        this.runIt(urls);
    }

    @Test
    public void testDecode() throws IOException, URISyntaxException, InterruptedException {
        String[] urls = new String[]{"http://feed.feedsky.com/amaze", "http://macorz.cn/feed", "http://www.ourlinux.net/feed", "http://blog.jjgod.org/feed/", "http://www.lostleon.com/blog/feed/", "http://feed.feedsky.com/hellodb"};
        this.runIt(urls);
    }

    private void runIt(String[] urls) throws URISyntaxException, UnknownHostException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(urls.length);
        String[] stringArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            TreeMap<String, String> header = new TreeMap<String, String>();
            URI uri = new URI(url);
            TextRespListener listener = new TextRespListener(new TextHandler2(latch), this.filter);
            this.client.get(uri, header, listener);
            ++n2;
        }
        latch.await();
    }
}

