/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import junit.framework.Assert;
import me.shenfeng.http.HttpStatus;
import me.shenfeng.http.HttpVersion;
import me.shenfeng.http.LineTooLargeException;
import me.shenfeng.http.ProtocolException;
import me.shenfeng.http.client.ClientDecoder;
import me.shenfeng.http.client.ClientDecoderState;
import me.shenfeng.http.client.IRespListener;
import me.shenfeng.http.codec.Utils;
import org.junit.Test;

public class HttpClientDecoderTest {
    boolean onCompleteCallded = false;

    @Test
    public void testDecodeChunkedResponse() throws IOException, LineTooLargeException, ProtocolException {
        ClientDecoder decoder = new ClientDecoder(new IRespListener(){

            @Override
            public void onThrowable(Throwable t) {
                throw new RuntimeException(t);
            }

            @Override
            public int onInitialLineReceived(HttpVersion version, HttpStatus status) {
                Assert.assertEquals((Object)((Object)HttpVersion.HTTP_1_1), (Object)((Object)version));
                Assert.assertEquals((Object)status, (Object)HttpStatus.OK);
                return 0;
            }

            @Override
            public int onHeadersReceived(Map<String, String> headers) {
                Assert.assertNotNull((Object)headers.get("Transfer-Encoding"));
                return 0;
            }

            @Override
            public void onCompleted() {
                HttpClientDecoderTest.this.onCompleteCallded = true;
            }

            @Override
            public int onBodyReceived(byte[] buf, int length) {
                Assert.assertEquals((int)2869, (int)length);
                return 0;
            }
        });
        ByteBuffer buffer = ByteBuffer.wrap(Utils.readAll("beta_shield_chunked"));
        ClientDecoderState s = decoder.decode(buffer);
        Assert.assertEquals((String)"state should be ALL_READ", (Object)((Object)s), (Object)((Object)ClientDecoderState.ALL_READ));
        Assert.assertTrue((boolean)this.onCompleteCallded);
    }
}

