/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.ws;

import java.nio.ByteBuffer;
import me.shenfeng.http.ProtocolException;
import me.shenfeng.http.ws.CloseFrame;
import me.shenfeng.http.ws.PingFrame;
import me.shenfeng.http.ws.TextFrame;
import me.shenfeng.http.ws.WSFrame;

public class WSDecoder {
    public static final byte OPCODE_CONT = 0;
    public static final byte OPCODE_TEXT = 1;
    public static final byte OPCODE_BINARY = 2;
    public static final byte OPCODE_CLOSE = 8;
    public static final byte OPCODE_PING = 9;
    public static final byte OPCODE_PONG = 10;
    private State state = State.FRAME_START;
    private byte[] content;
    private int payloadLength;
    private int payloadRead;
    private int maskingKey;
    private boolean finalFlag;
    private int opcode;

    public WSFrame decode(ByteBuffer buffer) throws ProtocolException {
        while (buffer.hasRemaining()) {
            switch (this.state) {
                case FRAME_START: {
                    byte b = buffer.get();
                    this.finalFlag = (b & 0x80) != 0;
                    this.opcode = b & 0xF;
                    b = buffer.get();
                    boolean masked = (b & 0x80) != 0;
                    this.payloadLength = b & 0x7F;
                    if (this.payloadLength == 126) {
                        this.payloadLength = buffer.getShort();
                    } else if (this.payloadLength == 127) {
                        this.payloadLength = (int)buffer.getLong();
                    }
                    this.content = new byte[this.payloadLength];
                    if (!masked) {
                        throw new ProtocolException("unmasked client to server frame");
                    }
                    this.state = State.MASKING_KEY;
                    break;
                }
                case MASKING_KEY: {
                    this.maskingKey = buffer.getInt();
                    this.state = State.PAYLOAD;
                    break;
                }
                case PAYLOAD: {
                    int toRead = Math.min(buffer.remaining(), this.payloadLength - this.payloadRead);
                    buffer.get(this.content, this.payloadRead, toRead);
                    this.payloadRead += toRead;
                    if (this.payloadRead != this.payloadLength) break;
                    byte[] mask = ByteBuffer.allocate(4).putInt(this.maskingKey).array();
                    int i = 0;
                    while (i < this.content.length) {
                        this.content[i] = (byte)(this.content[i] ^ mask[i % 4]);
                        ++i;
                    }
                    if (this.opcode == 1) {
                        return new TextFrame(this.finalFlag, this.content);
                    }
                    if (this.opcode == 9) {
                        return new PingFrame(this.finalFlag, this.content);
                    }
                    if (this.opcode == 8) {
                        return new CloseFrame(this.finalFlag, this.content);
                    }
                    throw new ProtocolException("not impl now for opcode: " + this.opcode);
                }
            }
        }
        return null;
    }

    public void reset() {
        this.state = State.FRAME_START;
        this.payloadRead = 0;
    }

    public static enum State {
        FRAME_START,
        MASKING_KEY,
        PAYLOAD,
        CORRUPT;

    }
}

