/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import me.shenfeng.http.DynamicBytes;
import me.shenfeng.http.HttpStatus;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.HttpVersion;
import me.shenfeng.http.client.IRespListener;
import me.shenfeng.http.client.ITextHandler;

public class TextRespListener
implements IRespListener {
    static final Pattern ENCODING = Pattern.compile("encoding=('|\")([\\w|-]+)('|\")", 2);
    private DynamicBytes body = new DynamicBytes(16384);
    private Map<String, String> headers;
    private HttpStatus status;
    private ITextHandler handler;
    private IFilter filter;

    private static Charset guess(String html, String patten) {
        int start;
        int end;
        int idx = html.indexOf(patten);
        if (idx != -1 && (end = html.indexOf(34, start = idx + patten.length())) != -1) {
            try {
                return Charset.forName(html.substring(start, end));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Charset detectCharset(Map<String, String> headers, DynamicBytes body) {
        Matcher matcher;
        String s;
        Charset result = TextRespListener.parseCharset(headers.get("Content-Type"));
        if (result == null && (result = TextRespListener.guess(s = new String(body.get(), 0, Math.min(512, body.length()), HttpUtils.ASCII), "charset=")) == null && (matcher = ENCODING.matcher(s)).find()) {
            try {
                result = Charset.forName(matcher.group(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result == null ? HttpUtils.UTF_8 : result;
    }

    public static Charset parseCharset(String type) {
        if (type != null) {
            try {
                type = type.toLowerCase();
                int i = type.indexOf("charset=");
                if (i != -1) {
                    String charset = type.substring(i + "charset=".length()).trim();
                    return Charset.forName(charset);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public TextRespListener(ITextHandler h) {
        this(h, null);
    }

    public TextRespListener(ITextHandler h, IFilter filter) {
        this.filter = filter;
        this.handler = h;
    }

    @Override
    public int onBodyReceived(byte[] buf, int length) {
        this.body.append(buf, 0, length);
        if (this.filter != null && !this.filter.accept(this.body)) {
            return -1;
        }
        return 1;
    }

    @Override
    public void onCompleted() {
        String encoding = this.headers.get("Content-Encoding");
        try {
            String html;
            if (encoding != null) {
                int read;
                encoding = encoding.toLowerCase();
                ByteArrayInputStream bis = new ByteArrayInputStream(this.body.get(), 0, this.body.length());
                DynamicBytes unzipped = new DynamicBytes(this.body.length() * 6);
                FilterInputStream is = "gzip".equals(encoding) || "x-gzip".equals(encoding) ? new GZIPInputStream(bis) : new DeflaterInputStream(bis);
                byte[] buffer = new byte[4096];
                while ((read = ((InputStream)is).read(buffer)) != -1) {
                    unzipped.append(buffer, 0, read);
                }
                html = new String(unzipped.get(), 0, unzipped.length(), TextRespListener.detectCharset(this.headers, unzipped));
            } else {
                html = new String(this.body.get(), 0, this.body.length(), TextRespListener.detectCharset(this.headers, this.body));
            }
            this.handler.onSuccess(this.status.getCode(), this.headers, html);
        }
        catch (Exception e) {
            this.handler.onThrowable(e);
        }
    }

    @Override
    public int onHeadersReceived(Map<String, String> headers) {
        this.headers = headers;
        if (this.filter != null && !this.filter.accept(headers)) {
            return -1;
        }
        return 1;
    }

    @Override
    public int onInitialLineReceived(HttpVersion version, HttpStatus status) {
        this.status = status;
        return 1;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.handler.onThrowable(t);
    }

    public static class AbortException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AbortException() {
            super("aborted");
        }
    }

    public static interface IFilter {
        public boolean accept(Map<String, String> var1);

        public boolean accept(DynamicBytes var1);
    }
}

