/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.dbcp;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.shenfeng.dbcp.DBCPException;
import me.shenfeng.dbcp.NoCloseConnection;

public class ThreadLocalConnection
extends ThreadLocal<Connection> {
    private final String url;
    private final String username;
    private final String password;
    private final Map<WeakReference<Thread>, Connection> connections = new HashMap<WeakReference<Thread>, Connection>();
    private final ReferenceQueue<Thread> queue = new ReferenceQueue();
    private final AtomicInteger counter = new AtomicInteger(0);

    public ThreadLocalConnection(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SQLException ex = null;
        Map<WeakReference<Thread>, Connection> map = this.connections;
        synchronized (map) {
            for (Connection c : this.connections.values()) {
                try {
                    c.close();
                }
                catch (SQLException e) {
                    ex = e;
                }
            }
            this.connections.clear();
        }
        if (ex != null) {
            throw new DBCPException("close connection error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayList<String> names;
        int active = 0;
        Map<WeakReference<Thread>, Connection> map = this.connections;
        synchronized (map) {
            active = this.connections.size();
            names = new ArrayList<String>(active);
            for (WeakReference<Thread> r : this.connections.keySet()) {
                Thread t = (Thread)r.get();
                if (t != null) {
                    names.add(t.getName());
                    continue;
                }
                names.add("null");
            }
        }
        return "opened=" + this.counter.get() + ", active=" + active + ", threads=" + names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDiedThreadConnection() {
        Reference<Thread> r;
        while ((r = this.queue.poll()) != null) {
            Map<WeakReference<Thread>, Connection> map = this.connections;
            synchronized (map) {
                Connection c = this.connections.get(r);
                this.connections.remove(r);
                try {
                    c.close();
                }
                catch (SQLException e) {
                    throw new DBCPException("closed died thread connecton", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection get() {
        Connection con;
        block6: {
            this.closeDiedThreadConnection();
            con = (Connection)super.get();
            try {
                if (!con.isClosed()) break block6;
                Map<WeakReference<Thread>, Connection> map = this.connections;
                synchronized (map) {
                    Thread c = Thread.currentThread();
                    Iterator<Map.Entry<WeakReference<Thread>, Connection>> it = this.connections.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<WeakReference<Thread>, Connection> e = it.next();
                        if (e.getKey().get() != c) continue;
                        it.remove();
                    }
                }
                this.remove();
                return (Connection)super.get();
            }
            catch (SQLException e) {
                throw new DBCPException("error when asking isClosed ??", e);
            }
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Connection initialValue() {
        this.counter.incrementAndGet();
        try {
            int timeout;
            Connection con = DriverManager.getConnection(this.url, this.username, this.password);
            Statement stat = con.createStatement();
            ResultSet rs = stat.executeQuery("show variables like 'wait_timeout'");
            if (rs.next() && (timeout = rs.getInt(2)) == 28800) {
                stat.executeUpdate("set wait_timeout = 259200");
            }
            rs.close();
            stat.close();
            Map<WeakReference<Thread>, Connection> map = this.connections;
            synchronized (map) {
                this.connections.put(new WeakReference<Thread>(Thread.currentThread(), this.queue), con);
            }
            return new NoCloseConnection(con);
        }
        catch (SQLException e) {
            throw new DBCPException("connect to mysql error", e);
        }
    }
}

