/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.dbcp;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import me.shenfeng.dbcp.NoCloseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalConnection
extends ThreadLocal<Connection> {
    private final String url;
    private final String username;
    private final String password;
    private static final Logger logger = LoggerFactory.getLogger(ThreadLocalConnection.class);
    private ConcurrentLinkedQueue<Connection> cons = new ConcurrentLinkedQueue();
    private AtomicInteger id = new AtomicInteger(0);

    public ThreadLocalConnection(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public void close() {
        logger.info("close all connections");
        Connection con = null;
        while ((con = this.cons.poll()) != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                logger.error("close all connections", (Throwable)e);
            }
        }
    }

    @Override
    public Connection get() {
        Connection con = (Connection)super.get();
        try {
            if (con.isClosed()) {
                logger.trace("a connection is closed, try to create a new one");
                this.remove();
                return (Connection)super.get();
            }
        }
        catch (SQLException e) {
            logger.error("error when asking isClosed!", (Throwable)e);
        }
        return con;
    }

    @Override
    protected Connection initialValue() {
        try {
            int timeout;
            int i = this.id.incrementAndGet();
            logger.trace("create connection " + i);
            Connection con = DriverManager.getConnection(this.url, this.username, this.password);
            Statement stat = con.createStatement();
            ResultSet rs = stat.executeQuery("show variables like 'wait_timeout'");
            if (rs.next() && (timeout = rs.getInt(2)) == 28800) {
                logger.debug("change default wait_timeout from 8 hours to 3 days");
                stat.executeUpdate("set wait_timeout = 259200");
            }
            rs.close();
            stat.close();
            this.cons.add(con);
            return new NoCloseConnection(con);
        }
        catch (SQLException e) {
            logger.error("create connection", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

