/*
 * Decompiled with CFR 0.152.
 */
package clj_json;

import clojure.lang.IMapEntry;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.ITransientMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentVector;
import clojure.lang.Seqable;
import java.math.BigInteger;
import java.util.Date;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class JsonExt {
    public static void generate(JsonGenerator jsonGenerator, Object object) throws Exception {
        if (object instanceof String) {
            jsonGenerator.writeString((String)object);
        } else if (object instanceof Number) {
            if (object instanceof Integer) {
                jsonGenerator.writeNumber(((Integer)object).intValue());
            } else if (object instanceof Long) {
                jsonGenerator.writeNumber(((Long)object).longValue());
            } else if (object instanceof BigInteger) {
                jsonGenerator.writeNumber((BigInteger)object);
            } else if (object instanceof Double) {
                jsonGenerator.writeNumber(((Double)object).doubleValue());
            } else if (object instanceof Float) {
                jsonGenerator.writeNumber(((Float)object).floatValue());
            }
        } else if (object instanceof Boolean) {
            jsonGenerator.writeBoolean(((Boolean)object).booleanValue());
        } else if (object == null) {
            jsonGenerator.writeNull();
        } else if (object instanceof Keyword) {
            jsonGenerator.writeString(((Keyword)object).getName());
        } else if (object instanceof IPersistentMap) {
            IPersistentMap iPersistentMap = (IPersistentMap)object;
            jsonGenerator.writeStartObject();
            for (ISeq iSeq = iPersistentMap.seq(); iSeq != null; iSeq = iSeq.next()) {
                IMapEntry iMapEntry = (IMapEntry)iSeq.first();
                Object object2 = iMapEntry.key();
                if (object2 instanceof Keyword) {
                    jsonGenerator.writeFieldName(((Keyword)object2).getName());
                } else if (object2 instanceof Integer) {
                    jsonGenerator.writeFieldName(((Integer)object2).toString());
                } else if (object2 instanceof BigInteger) {
                    jsonGenerator.writeFieldName(((BigInteger)object2).toString());
                } else if (object2 instanceof Long) {
                    jsonGenerator.writeFieldName(((Long)object2).toString());
                } else {
                    jsonGenerator.writeFieldName((String)object2);
                }
                JsonExt.generate(jsonGenerator, iMapEntry.val());
            }
            jsonGenerator.writeEndObject();
        } else if (object instanceof IPersistentVector) {
            IPersistentVector iPersistentVector = (IPersistentVector)object;
            jsonGenerator.writeStartArray();
            for (int i = 0; i < iPersistentVector.count(); ++i) {
                JsonExt.generate(jsonGenerator, iPersistentVector.nth(i));
            }
            jsonGenerator.writeEndArray();
        } else if (object instanceof ISeq || object instanceof IPersistentList || object instanceof IPersistentSet) {
            jsonGenerator.writeStartArray();
            for (ISeq iSeq = ((Seqable)object).seq(); iSeq != null; iSeq = iSeq.next()) {
                JsonExt.generate(jsonGenerator, iSeq.first());
            }
            jsonGenerator.writeEndArray();
        } else if (object instanceof Date) {
            jsonGenerator.writeNumber(((Date)object).getTime());
        } else {
            throw new Exception("Cannot generate " + object);
        }
    }

    public static Object parse(JsonParser jsonParser, boolean bl, boolean bl2, Object object) throws Exception {
        if (bl) {
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() == null) {
                return object;
            }
        }
        switch (jsonParser.getCurrentToken()) {
            case START_OBJECT: {
                ITransientMap iTransientMap = PersistentArrayMap.EMPTY.asTransient();
                jsonParser.nextToken();
                while (jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
                    String string = jsonParser.getText();
                    jsonParser.nextToken();
                    String string2 = bl2 ? Keyword.intern((String)string) : string;
                    iTransientMap = iTransientMap.assoc((Object)string2, JsonExt.parse(jsonParser, false, bl2, object));
                    jsonParser.nextToken();
                }
                return iTransientMap.persistent();
            }
            case START_ARRAY: {
                PersistentVector.TransientVector transientVector = PersistentVector.EMPTY.asTransient();
                jsonParser.nextToken();
                while (jsonParser.getCurrentToken() != JsonToken.END_ARRAY) {
                    transientVector = transientVector.conj(JsonExt.parse(jsonParser, false, bl2, object));
                    jsonParser.nextToken();
                }
                return transientVector.persistent();
            }
            case VALUE_STRING: {
                return jsonParser.getText();
            }
            case VALUE_NUMBER_INT: {
                return jsonParser.getNumberValue();
            }
            case VALUE_NUMBER_FLOAT: {
                return jsonParser.getDoubleValue();
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_NULL: {
                return null;
            }
        }
        throw new Exception("Cannot parse " + jsonParser.getCurrentToken());
    }
}

