(ns me.lomin.gieok
  (:require [me.lomin.sayang :refer [sdefn]]
            [clojure.spec.alpha :as spec]
            [clojure.spec.alpha :as s]
            [clojure.test.check.generators :as gen])
  (:import (clojure.lang Associative)))

(defn contains-in? [coll path]
  (let [first-path (first path)
        next-path (next path)]
    (if (and (instance? Associative coll)
             first-path
             (contains? coll first-path))
      (if (nil? next-path)
        true
        (recur (get coll first-path) next-path))
      false)))

(spec/def ::associative
  (s/with-gen #(instance? Associative %)
    #(gen/one-of [(gen/such-that map? gen/any)
                  (gen/such-that vector? gen/any)])))
(spec/def ::sequential sequential?)
(spec/def ::get-fn
  (spec/fspec :args (s/cat :coll ::associative)
              :ret ::associative))

(sdefn retrieve [[coll :- ::associative]
                 [path :- ::sequential]
                 [f :- ::get-fn]]
       (get-in coll path))

(defn walk-code [body]
  (tree-seq #(or (sequential? %) (map? %)) seq body))

(defmacro hans [& body]
  (let [f-filter# (fn my-filter [x]
                    (and (sequential? x)
                         (let [[f] x]
                           (and (symbol? f)
                                (= #'me.lomin.gieok/retrieve
                                   (ns-resolve *ns* &env f))))))
        body-seq# (walk-code body)
        result# (filterv f-filter# body-seq#)]
    (prn result#)
    (prn &form)
    `nil))