/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.kraskov.MultiInfoCalculatorKraskov;
import infodynamics.utils.EuclideanUtils;
import infodynamics.utils.FirstIndexComparatorDouble;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import java.util.Arrays;

public class MultiInfoCalculatorKraskov2
extends MultiInfoCalculatorKraskov {
    protected static final int JOINT_NORM_VAL_COLUMN = 0;
    protected static final int JOINT_NORM_TIMESTEP_COLUMN = 1;

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        if (this.miComputed) {
            return this.mi;
        }
        return this.computeAverageLocalOfObservations(null);
    }

    @Override
    public double computeAverageLocalOfObservations(int[][] nArray) throws Exception {
        int n;
        if (this.V == 1) {
            this.miComputed = true;
            return 0.0;
        }
        if (!this.tryKeepAllPairsNorms || this.data.length * this.V > MAX_DATA_SIZE_FOR_KEEP_ALL_PAIRS_NORM) {
            double[][] dArray = this.data;
            if (nArray != null) {
                this.data = MatrixUtils.reorderDataForVariables(dArray, nArray);
            }
            double d = this.computeAverageLocalOfObservationsWhileComputingDistances();
            this.data = dArray;
            return d;
        }
        if (this.norms == null) {
            this.computeNorms();
        }
        double d = 0.0;
        double[] dArray = new double[this.V];
        for (n = 0; n < this.N; ++n) {
            int n2;
            int n3;
            int n4;
            int[] nArray2;
            int[] nArray3 = this.reorderedTimeStepsForEachMarginal(nArray, n);
            double[][] dArray2 = new double[this.N][2];
            for (int i = 0; i < this.N; ++i) {
                nArray2 = this.reorderedTimeStepsForEachMarginal(nArray, i);
                dArray2[i][0] = 0.0;
                for (n4 = 0; n4 < this.V; ++n4) {
                    double d2 = this.norms[n4][nArray3[n4]][nArray2[n4]];
                    if (!(d2 > dArray2[i][0])) continue;
                    dArray2[i][0] = d2;
                }
                dArray2[i][1] = i;
            }
            double[] dArray3 = new double[this.V];
            if (this.k == 1) {
                n3 = MatrixUtils.minIndex(dArray2, 0);
                int[] nArray4 = this.reorderedTimeStepsForEachMarginal(nArray, n3);
                for (int i = 0; i < this.V; ++i) {
                    dArray3[i] = this.norms[i][nArray3[i]][nArray4[i]];
                }
            } else {
                Arrays.sort(dArray2, FirstIndexComparatorDouble.getInstance());
                for (n3 = 0; n3 < this.k; ++n3) {
                    n4 = (int)dArray2[n3][1];
                    int[] nArray5 = this.reorderedTimeStepsForEachMarginal(nArray, n4);
                    for (n2 = 0; n2 < this.V; ++n2) {
                        if (!(this.norms[n2][nArray3[n2]][nArray5[n2]] > dArray3[n2])) continue;
                        dArray3[n2] = this.norms[n2][nArray3[n2]][nArray5[n2]];
                    }
                }
            }
            nArray2 = new int[this.V];
            for (n4 = 0; n4 < this.N; ++n4) {
                int[] nArray6 = this.reorderedTimeStepsForEachMarginal(nArray, n4);
                for (n2 = 0; n2 < this.V; ++n2) {
                    if (!(this.norms[n2][nArray3[n2]][nArray6[n2]] <= dArray3[n2])) continue;
                    int n5 = n2;
                    nArray2[n5] = nArray2[n5] + 1;
                }
            }
            for (n4 = 0; n4 < this.V; ++n4) {
                int n6 = n4;
                dArray[n6] = dArray[n6] + (double)nArray2[n4];
                d += MathsUtils.digamma(nArray2[n4]);
            }
        }
        d /= (double)this.N;
        if (this.debug) {
            for (n = 0; n < this.V; ++n) {
                int n7 = n;
                dArray[n7] = dArray[n7] / (double)this.N;
                System.out.print(String.format("Average n_x[%d]=%.3f, ", n, dArray[n]));
            }
            System.out.println();
        }
        this.mi = MathsUtils.digamma(this.k) - (double)(this.V - 1) / (double)this.k - d + (double)(this.V - 1) * MathsUtils.digamma(this.N);
        this.miComputed = true;
        return this.mi;
    }

    public double computeAverageLocalOfObservationsWhileComputingDistances() throws Exception {
        int n;
        if (this.V == 1) {
            this.miComputed = true;
            return 0.0;
        }
        double d = 0.0;
        double[] dArray = new double[this.V];
        for (n = 0; n < this.N; ++n) {
            int n2;
            int n3;
            int n4;
            double[][] dArray2 = EuclideanUtils.computeNorms(this.data, n);
            double[][] dArray3 = new double[this.N][2];
            for (int i = 0; i < this.N; ++i) {
                dArray3[i][0] = MatrixUtils.max(dArray2[i]);
                dArray3[i][1] = i;
            }
            double[] dArray4 = new double[this.V];
            if (this.k == 1) {
                n4 = MatrixUtils.minIndex(dArray3, 0);
                for (n3 = 0; n3 < this.V; ++n3) {
                    dArray4[n3] = dArray2[n4][n3];
                }
            } else {
                Arrays.sort(dArray3, FirstIndexComparatorDouble.getInstance());
                for (n4 = 0; n4 < this.k; ++n4) {
                    n3 = (int)dArray3[n4][1];
                    for (n2 = 0; n2 < this.V; ++n2) {
                        if (!(dArray2[n3][n2] > dArray4[n2])) continue;
                        dArray4[n2] = dArray2[n3][n2];
                    }
                }
            }
            int[] nArray = new int[this.V];
            for (n3 = 0; n3 < this.N; ++n3) {
                for (n2 = 0; n2 < this.V; ++n2) {
                    if (!(dArray2[n3][n2] <= dArray4[n2])) continue;
                    int n5 = n2;
                    nArray[n5] = nArray[n5] + 1;
                }
            }
            for (n3 = 0; n3 < this.V; ++n3) {
                int n6 = n3;
                dArray[n6] = dArray[n6] + (double)nArray[n3];
                d += MathsUtils.digamma(nArray[n3]);
            }
        }
        d /= (double)this.N;
        if (this.debug) {
            for (n = 0; n < this.V; ++n) {
                int n7 = n;
                dArray[n7] = dArray[n7] / (double)this.N;
                System.out.print(String.format("Average n_x[%d]=%.3f, ", n, dArray[n]));
            }
            System.out.println();
        }
        this.mi = MathsUtils.digamma(this.k) - (double)(this.V - 1) / (double)this.k - d + (double)(this.V - 1) * MathsUtils.digamma(this.N);
        this.miComputed = true;
        return this.mi;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        int n;
        double[] dArray = new double[this.N];
        if (this.V == 1) {
            this.miComputed = true;
            return dArray;
        }
        double d = MathsUtils.digamma(this.k);
        double d2 = (double)(this.V - 1) * MathsUtils.digamma(this.N);
        double d3 = (double)(this.V - 1) / (double)this.k;
        double d4 = 0.0;
        double[] dArray2 = new double[this.V];
        for (n = 0; n < this.N; ++n) {
            int n2;
            int n3;
            int n4;
            double[][] dArray3 = EuclideanUtils.computeNorms(this.data, n);
            double[][] dArray4 = new double[this.N][2];
            for (int i = 0; i < this.N; ++i) {
                dArray4[i][0] = MatrixUtils.max(dArray3[i]);
                dArray4[i][1] = i;
            }
            double[] dArray5 = new double[this.V];
            if (this.k == 1) {
                n4 = MatrixUtils.minIndex(dArray4, 0);
                for (n3 = 0; n3 < this.V; ++n3) {
                    dArray5[n3] = dArray3[n4][n3];
                }
            } else {
                Arrays.sort(dArray4, FirstIndexComparatorDouble.getInstance());
                for (n4 = 0; n4 < this.k; ++n4) {
                    n3 = (int)dArray4[n4][1];
                    for (n2 = 0; n2 < this.V; ++n2) {
                        if (!(dArray3[n3][n2] > dArray5[n2])) continue;
                        dArray5[n2] = dArray3[n3][n2];
                    }
                }
            }
            int[] nArray = new int[this.V];
            for (n3 = 0; n3 < this.N; ++n3) {
                for (n2 = 0; n2 < this.V; ++n2) {
                    if (!(dArray3[n3][n2] <= dArray5[n2])) continue;
                    int n5 = n2;
                    nArray[n5] = nArray[n5] + 1;
                }
            }
            dArray[n] = d - d3 + d2;
            for (n3 = 0; n3 < this.V; ++n3) {
                double d5 = MathsUtils.digamma(nArray[n3]);
                int n6 = n;
                dArray[n6] = dArray[n6] - d5;
                int n7 = n3;
                dArray2[n7] = dArray2[n7] + (double)nArray[n3];
                d4 += d5;
            }
        }
        if (this.debug) {
            for (n = 0; n < this.V; ++n) {
                int n8 = n;
                dArray2[n8] = dArray2[n8] / (double)this.N;
                System.out.print(String.format("Average n_x[%d]=%.3f, ", n, dArray2[n]));
            }
            System.out.println();
        }
        this.mi = d - d3 - d4 + d2;
        this.miComputed = true;
        return dArray;
    }

    @Override
    public String printConstants(int n) throws Exception {
        String string = String.format("digamma(k=%d)=%.3e - 1/k=%.3e + digamma(N=%d)=%.3e => %.3e", this.k, MathsUtils.digamma(this.k), 1.0 / (double)this.k, n, MathsUtils.digamma(n), MathsUtils.digamma(this.k) - 1.0 / (double)this.k + MathsUtils.digamma(n));
        return string;
    }
}

