/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.MultiInfoCalculator;
import infodynamics.measures.continuous.kernel.KernelEstimatorMultiVariate;
import infodynamics.measures.continuous.kernel.KernelEstimatorUniVariate;
import infodynamics.utils.MatrixUtils;
import java.util.Random;
import java.util.Vector;

public class MultiInfoCalculatorKernel
implements MultiInfoCalculator {
    protected KernelEstimatorUniVariate[] svkeMarginals = null;
    protected KernelEstimatorMultiVariate mvkeJoint = new KernelEstimatorMultiVariate();
    private int dimensions = 0;
    private int totalObservations = 0;
    private boolean debug = false;
    private double[][] observations;
    private Vector<double[]> individualObservations;
    private double lastAverage;
    private boolean normalise = true;
    public static final String NORMALISE_PROP_NAME = "NORMALISE";
    private boolean dynCorrExcl = false;
    private int dynCorrExclTime = 100;
    public static final String DYN_CORR_EXCL_TIME_NAME = "DYN_CORR_EXCL";
    private boolean underSample = false;
    private double samplingFactor = 0.1;
    private Random rand;
    public static final String SAMPLING_FACTOR_PROP_NAME = "SAMPLING_FACTOR";
    public static final String KERNEL_WIDTH_PROP_NAME = "KERNEL_WIDTH";
    public static final String EPSILON_PROP_NAME = "EPSILON";
    public static final double DEFAULT_KERNEL_WIDTH = 0.25;
    private double kernelWidth = 0.25;

    @Override
    public void initialise(int n) {
        this.initialise(n, this.kernelWidth);
    }

    public void initialise(int n, double d) {
        int n2;
        this.kernelWidth = d;
        this.observations = null;
        if (this.dimensions != n) {
            this.dimensions = n;
            this.svkeMarginals = new KernelEstimatorUniVariate[n];
            for (n2 = 0; n2 < n; ++n2) {
                this.svkeMarginals[n2] = new KernelEstimatorUniVariate();
                this.svkeMarginals[n2].setNormalise(this.normalise);
                if (this.dynCorrExcl) {
                    this.svkeMarginals[n2].setDynamicCorrelationExclusion(this.dynCorrExclTime);
                    continue;
                }
                this.svkeMarginals[n2].clearDynamicCorrelationExclusion();
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.svkeMarginals[n2].initialise(d);
        }
        this.mvkeJoint.initialise(n, d);
        this.lastAverage = 0.0;
    }

    @Override
    public void setObservations(double[][] dArray) throws Exception {
        if (dArray[0].length != this.dimensions) {
            throw new Exception("Incorrect number of dimensions " + dArray[0].length + " in supplied observations (expected " + this.dimensions + ")");
        }
        for (int i = 0; i < this.dimensions; ++i) {
            this.svkeMarginals[i].setObservations(MatrixUtils.selectColumn(dArray, i));
        }
        this.mvkeJoint.setObservations(dArray);
        this.totalObservations = dArray.length;
        this.observations = dArray;
    }

    @Override
    public void startAddObservations() {
        if (this.dynCorrExcl) {
            throw new RuntimeException("Addition of multiple observation sets is not currently supported with property DYN_CORR_EXCL set");
        }
        this.individualObservations = new Vector();
    }

    @Override
    public void addObservation(double[] dArray) {
        if (this.underSample && this.rand.nextDouble() >= this.samplingFactor) {
            return;
        }
        this.individualObservations.add(dArray);
    }

    @Override
    public void addObservations(double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.addObservation(dArray[i]);
        }
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        double[][] dArrayArray = new double[this.individualObservations.size()][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = this.individualObservations.elementAt(i);
        }
        this.individualObservations = null;
        this.setObservations(dArrayArray);
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            if (this.debug) {
                System.out.print(i + ": ");
            }
            double d2 = 1.0;
            for (int j = 0; j < this.dimensions; ++j) {
                double d3 = this.svkeMarginals[j].getProbability(this.observations[i][j], i);
                if (this.debug) {
                    System.out.print(this.observations[i][j] + " p=" + d3 + ", ");
                }
                d2 *= d3;
            }
            double d4 = this.mvkeJoint.getCount(this.observations[i], i);
            double d5 = 0.0;
            double d6 = 0.0;
            if (d4 > 0.0) {
                d5 = d4 / d2;
                d6 = Math.log(d5);
            }
            d += d6;
            if (!this.debug) continue;
            System.out.println(", p(joint) = " + d4 + " -> " + d5 + " -> " + d6 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        this.lastAverage = d / (double)this.totalObservations / Math.log(2.0);
        return this.lastAverage;
    }

    public double computeAverageJointEntropy() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.mvkeJoint.getCount(this.observations[i], i);
            double d3 = 0.0;
            if (d2 > 0.0) {
                d3 = -Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        return d / (double)this.totalObservations / Math.log(2.0);
    }

    public double computeAverageMarginalEntropy(int n) {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = this.svkeMarginals[n].getProbability(this.observations[i][n], i);
            double d3 = 0.0;
            if (d2 > 0.0) {
                d3 = -Math.log(d2);
            }
            d += d3;
            if (!this.debug) continue;
            System.out.println(i + ": " + d2 + " -> " + d3 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        return d / (double)this.totalObservations / Math.log(2.0);
    }

    public double computeAverageInfoDistanceOfObservations() {
        double d = 0.0;
        for (int i = 0; i < this.totalObservations; ++i) {
            double d2 = 1.0;
            for (int j = 0; j < this.dimensions; ++j) {
                d2 *= this.svkeMarginals[j].getProbability(this.observations[i][j], i);
            }
            double d3 = this.mvkeJoint.getProbability(this.observations[i], i);
            double d4 = 0.0;
            double d5 = 0.0;
            if (d3 > 0.0) {
                d4 = d2 / (d3 * d3);
                d5 = Math.log(d4);
            }
            d += d5;
            if (!this.debug) continue;
            System.out.println(i + ": " + d4 + " -> " + d5 / Math.log(2.0) + " -> sum: " + d / Math.log(2.0));
        }
        return d / (double)this.totalObservations / Math.log(2.0);
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        return this.computeLocalUsingPreviousObservations(this.observations, true);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray) {
        return this.computeLocalUsingPreviousObservations(dArray, false);
    }

    protected double[] computeLocalUsingPreviousObservations(double[][] dArray, boolean bl) {
        double d = 0.0;
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d2 = 1.0;
            for (int j = 0; j < this.dimensions; ++j) {
                if (bl) {
                    d2 *= this.svkeMarginals[j].getProbability(dArray[i][j], i);
                    continue;
                }
                d2 *= this.svkeMarginals[j].getProbability(dArray[i][j]);
            }
            double d3 = bl ? this.mvkeJoint.getProbability(dArray[i], i) : this.mvkeJoint.getProbability(dArray[i]);
            double d4 = 0.0;
            dArray2[i] = 0.0;
            if (d3 > 0.0) {
                d4 = d3 / d2;
                dArray2[i] = Math.log(d4) / Math.log(2.0);
            }
            d += dArray2[i];
            if (!this.debug) continue;
            System.out.println(i + ": " + d4 + " -> " + dArray2[i] + " -> sum: " + d);
        }
        this.lastAverage = d / (double)this.totalObservations;
        return dArray2;
    }

    public double[] computeLocalJointEntropyOfPreviousObservations() throws Exception {
        return this.computeLocalJointEntropyUsingPreviousObservations(this.observations, true);
    }

    public double[] computeLocalJointEntropyUsingPreviousObservations(double[][] dArray) {
        return this.computeLocalJointEntropyUsingPreviousObservations(dArray, false);
    }

    protected double[] computeLocalJointEntropyUsingPreviousObservations(double[][] dArray, boolean bl) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < this.totalObservations; ++i) {
            double d = bl ? this.mvkeJoint.getProbability(dArray[i], i) : this.mvkeJoint.getProbability(dArray[i]);
            dArray2[i] = 0.0;
            if (d > 0.0) {
                dArray2[i] = -Math.log(d) / Math.log(2.0);
            }
            if (!this.debug) continue;
            System.out.println(i + ": " + d + " -> " + dArray2[i]);
        }
        return dArray2;
    }

    public double[] computeLocalMarginalEntropyOfPreviousObservations(int n) {
        return this.computeLocalMarginalEntropyUsingPreviousObservations(this.observations, n, true);
    }

    public double[] computeLocalMarginalEntropyUsingPreviousObservations(double[][] dArray, int n) {
        return this.computeLocalMarginalEntropyUsingPreviousObservations(dArray, n, false);
    }

    protected double[] computeLocalMarginalEntropyUsingPreviousObservations(double[][] dArray, int n, boolean bl) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (int i = 0; i < this.totalObservations; ++i) {
            double d = bl ? this.svkeMarginals[n].getProbability(dArray[i][n], i) : this.svkeMarginals[n].getProbability(dArray[i][n]);
            dArray2[i] = 0.0;
            if (d > 0.0) {
                dArray2[i] = -Math.log(d) / Math.log(2.0);
            }
            if (!this.debug) continue;
            System.out.println(i + ": " + d + " -> " + dArray2[i]);
        }
        return dArray2;
    }

    public double[] computeLocalInfoDistanceOfPreviousObservations() {
        return this.computeLocalInfoDistanceUsingPreviousObservations(this.observations, true);
    }

    public double[] computeLocalInfoDistanceUsingPreviousObservations(double[][] dArray) {
        return this.computeLocalInfoDistanceUsingPreviousObservations(dArray, false);
    }

    protected double[] computeLocalInfoDistanceUsingPreviousObservations(double[][] dArray, boolean bl) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = 1.0;
            for (int j = 0; j < this.dimensions; ++j) {
                if (bl) {
                    d *= this.svkeMarginals[j].getProbability(dArray[i][j], i);
                    continue;
                }
                d *= this.svkeMarginals[j].getProbability(dArray[i][j]);
            }
            double d2 = bl ? this.mvkeJoint.getProbability(dArray[i], i) : this.mvkeJoint.getProbability(dArray[i]);
            double d3 = 0.0;
            dArray2[i] = 0.0;
            if (d2 > 0.0) {
                d3 = d / (d2 * d2);
                dArray2[i] = Math.log(d3) / Math.log(2.0);
            }
            if (!this.debug) continue;
            System.out.println(i + ": " + d3 + " -> " + dArray2[i]);
        }
        return dArray2;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public double getLastAverage() {
        return this.lastAverage;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equalsIgnoreCase(KERNEL_WIDTH_PROP_NAME) || string.equalsIgnoreCase(EPSILON_PROP_NAME)) {
            this.kernelWidth = Double.parseDouble(string2);
        } else if (string.equalsIgnoreCase(NORMALISE_PROP_NAME)) {
            this.normalise = Boolean.parseBoolean(string2);
            for (int i = 0; i < this.dimensions; ++i) {
                this.svkeMarginals[i].setNormalise(this.normalise);
            }
            this.mvkeJoint.setNormalise(this.normalise);
        } else if (string.equalsIgnoreCase(DYN_CORR_EXCL_TIME_NAME)) {
            this.dynCorrExclTime = Integer.parseInt(string2);
            boolean bl = this.dynCorrExcl = this.dynCorrExclTime > 0;
            if (this.dynCorrExcl) {
                for (int i = 0; i < this.dimensions; ++i) {
                    this.svkeMarginals[i].setDynamicCorrelationExclusion(this.dynCorrExclTime);
                }
                this.mvkeJoint.setDynamicCorrelationExclusion(this.dynCorrExclTime);
            } else {
                for (int i = 0; i < this.dimensions; ++i) {
                    this.svkeMarginals[i].clearDynamicCorrelationExclusion();
                }
                this.mvkeJoint.clearDynamicCorrelationExclusion();
            }
        } else if (string.equalsIgnoreCase(SAMPLING_FACTOR_PROP_NAME)) {
            this.samplingFactor = Double.parseDouble(string2);
            this.underSample = this.samplingFactor < 1.0;
            this.rand = new Random();
        } else {
            return;
        }
        if (this.debug) {
            System.out.println("Set property " + string + " to " + string2);
        }
    }
}

