/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.gaussian;

import infodynamics.measures.continuous.ConditionalMutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.ConditionalMutualInfoMultiVariateCommon;
import infodynamics.utils.AnalyticNullDistributionComputer;
import infodynamics.utils.ChiSquareMeasurementDistribution;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.NonPositiveDefiniteMatrixException;

public class ConditionalMutualInfoCalculatorMultiVariateGaussian
extends ConditionalMutualInfoMultiVariateCommon
implements ConditionalMutualInfoCalculatorMultiVariate,
AnalyticNullDistributionComputer,
Cloneable {
    protected double[][] L;
    protected double[][] L_1c;
    protected double[][] L_2c;
    protected double[][] L_cc;
    protected double[] means;
    protected double detCovariance;
    protected double det1cCovariance;
    protected double det2cCovariance;
    protected double detccCovariance;
    protected int[] var1IndicesInCovariance;
    protected int[] var2IndicesInCovariance;
    protected int[] condIndicesInCovariance;

    public ConditionalMutualInfoCalculatorMultiVariateGaussian() {
        this.normalise = false;
    }

    @Override
    public void initialise(int n, int n2, int n3) {
        super.initialise(n, n2, n3);
        this.L = null;
        this.L_1c = null;
        this.L_2c = null;
        this.L_cc = null;
        this.means = null;
        this.detCovariance = 0.0;
        this.det1cCovariance = 0.0;
        this.det2cCovariance = 0.0;
        this.detccCovariance = 0.0;
        this.condIndicesInCovariance = null;
        this.var1IndicesInCovariance = null;
        this.var2IndicesInCovariance = null;
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        super.finaliseAddObservations();
        this.means = new double[this.dimensionsVar1 + this.dimensionsVar2 + this.dimensionsCond];
        double[] dArray = MatrixUtils.means(this.var1Observations);
        double[] dArray2 = MatrixUtils.means(this.var2Observations);
        double[] dArray3 = MatrixUtils.means(this.condObservations);
        System.arraycopy(dArray, 0, this.means, 0, this.dimensionsVar1);
        System.arraycopy(dArray2, 0, this.means, this.dimensionsVar1, this.dimensionsVar2);
        System.arraycopy(dArray3, 0, this.means, this.dimensionsVar1 + this.dimensionsVar2, this.dimensionsCond);
        this.setCovariance(MatrixUtils.covarianceMatrix(this.var1Observations, this.var2Observations, this.condObservations), true);
    }

    public void setCovariance(double[][] dArray, int n) throws Exception {
        this.setCovariance(dArray, false);
        this.totalObservations = n;
    }

    protected void setCovariance(double[][] dArray, boolean bl) throws Exception {
        double[][] dArray2;
        Object object;
        int n;
        int n2;
        if (!bl) {
            this.var1Observations = null;
            this.var2Observations = null;
            this.condObservations = null;
        }
        if ((n2 = dArray.length) != this.dimensionsVar1 + this.dimensionsVar2 + this.dimensionsCond) {
            throw new Exception("Supplied covariance matrix does not match initialised number of dimensions");
        }
        boolean bl2 = false;
        this.condIndicesInCovariance = null;
        for (n = this.dimensionsCond; n >= 1; --n) {
            this.condIndicesInCovariance = MatrixUtils.range(this.dimensionsVar1 + this.dimensionsVar2, this.dimensionsVar1 + this.dimensionsVar2 + n - 1);
            object = MatrixUtils.selectRowsAndColumns(dArray, this.condIndicesInCovariance, this.condIndicesInCovariance);
            try {
                this.L_cc = MatrixUtils.CholeskyDecomposition(object);
            }
            catch (NonPositiveDefiniteMatrixException nonPositiveDefiniteMatrixException) {
                continue;
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.L_cc = null;
            this.condIndicesInCovariance = new int[0];
        }
        this.var1IndicesInCovariance = null;
        bl2 = false;
        for (n = this.dimensionsVar1; n >= 1; --n) {
            this.var1IndicesInCovariance = MatrixUtils.range(0, n - 1);
            object = MatrixUtils.append(this.var1IndicesInCovariance, this.condIndicesInCovariance);
            dArray2 = MatrixUtils.selectRowsAndColumns(dArray, (int[])object, (int[])object);
            try {
                this.L_1c = MatrixUtils.CholeskyDecomposition(dArray2);
            }
            catch (NonPositiveDefiniteMatrixException nonPositiveDefiniteMatrixException) {
                continue;
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.L_1c = null;
        }
        this.var2IndicesInCovariance = null;
        int[] nArray = null;
        bl2 = false;
        for (int i = this.dimensionsVar2; i >= 1; --i) {
            this.var2IndicesInCovariance = MatrixUtils.range(this.dimensionsVar1, this.dimensionsVar1 + i - 1);
            nArray = MatrixUtils.append(this.var2IndicesInCovariance, this.condIndicesInCovariance);
            dArray2 = MatrixUtils.selectRowsAndColumns(dArray, nArray, nArray);
            try {
                this.L_2c = MatrixUtils.CholeskyDecomposition(dArray2);
            }
            catch (NonPositiveDefiniteMatrixException nonPositiveDefiniteMatrixException) {
                continue;
            }
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.L_2c = null;
        }
        int[] nArray2 = MatrixUtils.append(this.var1IndicesInCovariance, nArray);
        dArray2 = MatrixUtils.selectRowsAndColumns(dArray, nArray2, nArray2);
        try {
            this.L = MatrixUtils.CholeskyDecomposition(dArray2);
        }
        catch (NonPositiveDefiniteMatrixException nonPositiveDefiniteMatrixException) {
            this.L = null;
        }
    }

    public void setCovarianceAndMeans(double[][] dArray, double[] dArray2, int n) throws Exception {
        this.means = dArray2;
        this.setCovariance(dArray, n);
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        if (this.L_1c == null) {
            this.lastAverage = 0.0;
        } else {
            this.det1cCovariance = MatrixUtils.determinantViaCholeskyResult(this.L_1c);
            if (this.L_2c == null) {
                this.lastAverage = 0.0;
            } else {
                this.det2cCovariance = MatrixUtils.determinantViaCholeskyResult(this.L_2c);
                if (this.L == null) {
                    this.lastAverage = Double.POSITIVE_INFINITY;
                } else {
                    this.detCovariance = MatrixUtils.determinantViaCholeskyResult(this.L);
                    if (this.L_cc == null) {
                        this.lastAverage = 0.5 * Math.log(Math.abs(this.det1cCovariance * this.det2cCovariance / this.detCovariance));
                    } else {
                        this.detccCovariance = MatrixUtils.determinantViaCholeskyResult(this.L_cc);
                        this.lastAverage = 0.5 * Math.log(Math.abs(this.det1cCovariance * this.det2cCovariance / (this.detCovariance * this.detccCovariance)));
                    }
                }
            }
        }
        this.condMiComputed = true;
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        if (this.var2Observations == null) {
            throw new Exception("Cannot compute local values of previous observations if they have not been set!");
        }
        return this.computeLocalUsingPreviousObservations(this.var1Observations, this.var2Observations, this.condObservations, true);
    }

    @Override
    public ChiSquareMeasurementDistribution computeSignificance() throws Exception {
        if (!this.condMiComputed) {
            this.computeAverageLocalOfObservations();
        }
        return new ChiSquareMeasurementDistribution(2.0 * (double)this.totalObservations * this.lastAverage, this.var1IndicesInCovariance.length * this.var2IndicesInCovariance.length);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n, int n2) throws Exception {
        if (this.var2Observations == null) {
            throw new Exception("Cannot compute empirical statistical significance if user passed in covariance matrix rather than observations.");
        }
        return super.computeSignificance(n, n2);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n, int[][] nArray) throws Exception {
        if (this.var2Observations == null) {
            throw new Exception("Cannot compute empirical statistical significance if user passed in covariance matrix rather than observations.");
        }
        return super.computeSignificance(n, nArray);
    }

    @Override
    public int getNumObservations() throws Exception {
        if (this.var2Observations == null) {
            throw new Exception("Cannot return number of observations because either this calculator has not had observations supplied or the user supplied the covariance matrix instead of observations");
        }
        return super.getNumObservations();
    }

    @Override
    public double computeAverageLocalOfObservations(int n, int[] nArray) throws Exception {
        if (this.var1Observations == null) {
            throw new Exception("Cannot compute local values of previous observations without supplying observations");
        }
        return super.computeAverageLocalOfObservations(n, nArray);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2, double[][] dArray3) throws Exception {
        return this.computeLocalUsingPreviousObservations(dArray, dArray2, dArray3, false);
    }

    protected double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2, double[][] dArray3, boolean bl) throws Exception {
        if (this.means == null) {
            throw new Exception("Cannot compute local values without having means either supplied or computed via setObservations()");
        }
        if (this.detCovariance == 0.0) {
            this.detccCovariance = this.L_cc == null ? 0.0 : MatrixUtils.determinantViaCholeskyResult(this.L_cc);
            if (this.L_1c == null) {
                return MatrixUtils.constantArray(dArray2.length, 0.0);
            }
            this.det1cCovariance = MatrixUtils.determinantViaCholeskyResult(this.L_1c);
            if (this.L_2c == null) {
                return MatrixUtils.constantArray(dArray2.length, 0.0);
            }
            this.det2cCovariance = MatrixUtils.determinantViaCholeskyResult(this.L_2c);
            if (this.L == null) {
                return MatrixUtils.constantArray(dArray2.length, Double.POSITIVE_INFINITY);
            }
            this.detCovariance = MatrixUtils.determinantViaCholeskyResult(this.L);
        }
        double[][] dArray4 = MatrixUtils.solveViaCholeskyResult(this.L, MatrixUtils.identityMatrix(this.L.length));
        double[][] dArray5 = MatrixUtils.solveViaCholeskyResult(this.L_1c, MatrixUtils.identityMatrix(this.L_1c.length));
        double[][] dArray6 = MatrixUtils.solveViaCholeskyResult(this.L_2c, MatrixUtils.identityMatrix(this.L_2c.length));
        double[][] dArray7 = null;
        if (this.L_cc != null) {
            dArray7 = MatrixUtils.solveViaCholeskyResult(this.L_cc, MatrixUtils.identityMatrix(this.L_cc.length));
        }
        double[] dArray8 = MatrixUtils.select(this.means, this.var1IndicesInCovariance);
        double[] dArray9 = MatrixUtils.select(this.means, this.var2IndicesInCovariance);
        double[] dArray10 = MatrixUtils.select(this.means, this.condIndicesInCovariance);
        int n = dArray2.length;
        double[] dArray11 = new double[n];
        int[] nArray = MatrixUtils.subtract(this.var2IndicesInCovariance, this.dimensionsVar1);
        int[] nArray2 = MatrixUtils.subtract(this.condIndicesInCovariance, this.dimensionsVar1 + this.dimensionsVar2);
        for (int i = 0; i < dArray2.length; ++i) {
            double[] dArray12 = MatrixUtils.subtract(MatrixUtils.select(dArray[i], this.var1IndicesInCovariance), dArray8);
            double[] dArray13 = MatrixUtils.subtract(MatrixUtils.select(dArray2[i], nArray), dArray9);
            double[] dArray14 = MatrixUtils.subtract(MatrixUtils.select(dArray3[i], nArray2), dArray10);
            double[] dArray15 = MatrixUtils.append(dArray12, dArray14);
            double[] dArray16 = MatrixUtils.append(dArray13, dArray14);
            double[] dArray17 = MatrixUtils.append(dArray12, dArray13);
            double[] dArray18 = MatrixUtils.append(dArray17, dArray14);
            double d = MatrixUtils.dotProduct(MatrixUtils.matrixProduct(dArray15, dArray5), dArray15);
            double d2 = Math.exp(-0.5 * d) / Math.sqrt(this.det1cCovariance);
            double d3 = MatrixUtils.dotProduct(MatrixUtils.matrixProduct(dArray16, dArray6), dArray16);
            double d4 = Math.exp(-0.5 * d3) / Math.sqrt(this.det2cCovariance);
            double d5 = 0.0;
            double d6 = 0.0;
            if (this.L_cc != null) {
                d5 = MatrixUtils.dotProduct(MatrixUtils.matrixProduct(dArray14, dArray7), dArray14);
                d6 = Math.exp(-0.5 * d5) / Math.sqrt(this.detccCovariance);
            }
            double d7 = MatrixUtils.dotProduct(MatrixUtils.matrixProduct(dArray18, dArray4), dArray18);
            double d8 = Math.exp(-0.5 * d7) / Math.sqrt(this.detCovariance);
            dArray11[i] = this.L_cc != null ? Math.log(d8 * d6 / (d2 * d4)) : Math.log(d8 / (d2 * d4));
        }
        return dArray11;
    }
}

