/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class ArrayFileReader {
    private String filename;
    private BufferedReader br;
    private int rows;
    private int columns;
    private boolean isOpen = false;
    static final String DELIMITER = "[ \t,]";

    public ArrayFileReader(String string) {
        this.filename = string;
    }

    public ArrayFileReader(File file) {
        this.filename = file.getPath();
    }

    private void openArrayFile() throws FileNotFoundException, IOException {
        if (this.isOpen) {
            return;
        }
        this.br = new BufferedReader(new FileReader(this.filename));
        this.rows = 0;
        this.columns = 0;
        String string = this.br.readLine();
        while (string != null) {
            String[] stringArray;
            if (!(string = string.replaceFirst("^[ \t]*", "")).startsWith("#") && !string.startsWith("%") && (stringArray = string.split(DELIMITER)).length != 0) {
                int n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("")) continue;
                    ++n;
                }
                if (n != 0) {
                    if (this.columns == 0) {
                        this.columns = n;
                    }
                    if (n != this.columns) {
                        throw new IOException("Number of columns " + n + " on row " + this.rows + " does not match number on previous lines " + this.columns);
                    }
                    ++this.rows;
                }
            }
            string = this.br.readLine();
        }
        this.br.close();
        this.br = new BufferedReader(new FileReader(this.filename));
        this.isOpen = true;
    }

    private void closeArrayFile() throws IOException {
        this.br.close();
        this.isOpen = false;
    }

    public int[][] getInt2DMatrix() throws Exception {
        this.openArrayFile();
        int[][] nArray = new int[this.rows][this.columns];
        int n = 0;
        String string = this.br.readLine();
        while (string != null) {
            String[] stringArray;
            if (!(string = string.replaceFirst("^[ \t]*", "")).startsWith("#") && !string.startsWith("%") && (stringArray = string.split(DELIMITER)).length != 0) {
                int n2 = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("")) continue;
                    nArray[n][n2] = Integer.parseInt(stringArray[i]);
                    ++n2;
                }
                if (n2 != 0) {
                    if (n2 != this.columns) {
                        throw new IOException("Number of columns " + n2 + " on row " + this.rows + " does not match number on previous lines " + this.columns);
                    }
                    ++n;
                }
            }
            string = this.br.readLine();
        }
        this.closeArrayFile();
        return nArray;
    }

    public int[] getIntArray() throws Exception {
        this.openArrayFile();
        if (this.rows != 1 && this.columns != 1) {
            throw new Exception("Cannot get an int array when neither the number of rows nor columns equals 1");
        }
        boolean bl = this.rows > this.columns;
        int n = bl ? this.rows : this.columns;
        int[] nArray = new int[n];
        if (bl) {
            int n2 = 0;
            String string = this.br.readLine();
            while (string != null) {
                String[] stringArray;
                if (!(string = string.replaceFirst("^[ \t]*", "")).startsWith("#") && !string.startsWith("%") && (stringArray = string.split(DELIMITER)).length != 0) {
                    boolean bl2 = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals("")) continue;
                        if (bl2) {
                            throw new IOException("Cannot have multiple values on each line for a column vector");
                        }
                        nArray[n2] = Integer.parseInt(stringArray[i]);
                        bl2 = true;
                    }
                    if (bl2) {
                        ++n2;
                    }
                }
                string = this.br.readLine();
            }
        } else {
            boolean bl3 = false;
            String string = this.br.readLine();
            while (string != null) {
                String[] stringArray;
                if (!(string = string.replaceFirst("^[ \t]*", "")).startsWith("#") && !string.startsWith("%") && (stringArray = string.split(DELIMITER)).length != 0) {
                    int n3 = 0;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals("")) continue;
                        if (n3 == 0 && bl3) {
                            throw new IOException("Cannot have data on multiple lines for a row vector");
                        }
                        nArray[n3] = Integer.parseInt(stringArray[i]);
                        bl3 = true;
                        ++n3;
                    }
                    if (n3 != 0 && n3 != this.columns) {
                        throw new IOException("Not enough elements in the row vector");
                    }
                }
                string = this.br.readLine();
            }
        }
        this.closeArrayFile();
        return nArray;
    }

    public double[][] getDouble2DMatrix() throws Exception {
        this.openArrayFile();
        double[][] dArray = new double[this.rows][this.columns];
        int n = 0;
        String string = this.br.readLine();
        while (string != null) {
            String[] stringArray;
            if (!(string = string.replaceFirst("^[ \t]*", "")).startsWith("#") && !string.startsWith("%") && (stringArray = string.split(DELIMITER)).length != 0) {
                int n2 = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("")) continue;
                    dArray[n][n2] = Double.parseDouble(stringArray[i]);
                    ++n2;
                }
                if (n2 != 0) {
                    if (n2 != this.columns) {
                        throw new IOException("Number of columns " + n2 + " on row " + this.rows + " does not match number on previous lines " + this.columns);
                    }
                    ++n;
                }
            }
            string = this.br.readLine();
        }
        this.closeArrayFile();
        return dArray;
    }

    public double[] getDoubleArray() throws Exception {
        this.openArrayFile();
        if (this.rows != 1 && this.columns != 1) {
            throw new Exception("Cannot get an double array when neither the number of rows nor columns equals 1");
        }
        boolean bl = this.rows > this.columns;
        int n = bl ? this.rows : this.columns;
        double[] dArray = new double[n];
        if (bl) {
            int n2 = 0;
            String string = this.br.readLine();
            while (string != null) {
                String[] stringArray;
                if (!(string = string.replaceFirst("^[ \t]*", "")).startsWith("#") && !string.startsWith("%") && (stringArray = string.split(DELIMITER)).length != 0) {
                    boolean bl2 = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals("")) continue;
                        if (bl2) {
                            throw new IOException("Cannot have multiple values on each line for a column vector");
                        }
                        dArray[n2] = Double.parseDouble(stringArray[i]);
                        bl2 = true;
                    }
                    if (bl2) {
                        ++n2;
                    }
                }
                string = this.br.readLine();
            }
        } else {
            boolean bl3 = false;
            String string = this.br.readLine();
            while (string != null) {
                String[] stringArray;
                if (!(string = string.replaceFirst("^[ \t]*", "")).startsWith("#") && !string.startsWith("%") && (stringArray = string.split(DELIMITER)).length != 0) {
                    int n3 = 0;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].equals("")) continue;
                        if (n3 == 0 && bl3) {
                            throw new IOException("Cannot have data on multiple lines for a row vector");
                        }
                        dArray[n3] = Double.parseDouble(stringArray[i]);
                        bl3 = true;
                        ++n3;
                    }
                    if (n3 != 0 && n3 != this.columns) {
                        throw new IOException("Not enough elements in the row vector");
                    }
                }
                string = this.br.readLine();
            }
        }
        this.closeArrayFile();
        return dArray;
    }
}

