/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.networkinference.interregional;

import infodynamics.measures.continuous.TransferEntropyCalculatorMultiVariate;
import infodynamics.measures.continuous.kraskov.TransferEntropyCalculatorMultiVariateKraskov;
import infodynamics.networkinference.interregional.InterregionalChannelMeasure;
import infodynamics.utils.ParsedProperties;
import java.util.Vector;

public class InterregionalTransferEntropy
extends InterregionalChannelMeasure {
    protected int k;
    protected static final String PROP_K_TE = "props.interregionalChannel.te.k";

    @Override
    public void initialise(ParsedProperties parsedProperties) throws Exception {
        this.setK(parsedProperties.getIntProperty(PROP_K_TE));
        super.initialise(parsedProperties);
    }

    public void initialise(int n, int n2, int n3, int n4) throws Exception {
        this.setK(n);
        super.initialise(n2, n3, n4);
    }

    @Override
    protected void initialiseCalculator() throws Exception {
        TransferEntropyCalculatorMultiVariate transferEntropyCalculatorMultiVariate = (TransferEntropyCalculatorMultiVariate)this.channelCalc;
        transferEntropyCalculatorMultiVariate.initialise(this.k, this.jointVars1, this.jointVars2);
    }

    public void setK(int n) {
        this.k = n;
    }

    @Override
    public int[] computeTimeIndicesForLocalValues() throws Exception {
        int[] nArray;
        if (this.allValid) {
            nArray = new int[this.region1.length - this.k];
            for (int i = this.k; i < this.region1.length; ++i) {
                nArray[i - this.k] = i;
            }
        } else if (!this.validityForIndividualElements) {
            int n = this.computeNumberOfObservations(this.jointValidity1, this.jointValidity2);
            nArray = new int[n];
            TransferEntropyCalculatorMultiVariateKraskov transferEntropyCalculatorMultiVariateKraskov = new TransferEntropyCalculatorMultiVariateKraskov();
            transferEntropyCalculatorMultiVariateKraskov.initialise(this.k);
            Vector<int[]> vector = transferEntropyCalculatorMultiVariateKraskov.computeStartAndEndTimePairs(this.jointValidity1, this.jointValidity2);
            int n2 = 0;
            for (int[] nArray2 : vector) {
                int n3 = nArray2[0];
                int n4 = nArray2[1];
                int n5 = n3 + this.k;
                while (n5 <= n4) {
                    nArray[n2++] = n5++;
                }
            }
        } else {
            nArray = new int[this.region1.length - this.k];
            for (int i = this.k; i < this.region1.length; ++i) {
                nArray[i - this.k] = i;
            }
        }
        return nArray;
    }

    @Override
    protected int computeNumObservationsToReorder() throws Exception {
        if (this.allValid) {
            return this.region1.length - this.k;
        }
        if (!this.validityForIndividualElements) {
            return this.computeNumberOfObservations(this.jointValidity1, this.jointValidity2);
        }
        return this.region1.length;
    }

    private int computeNumberOfObservations(boolean[] blArray, boolean[] blArray2) throws Exception {
        TransferEntropyCalculatorMultiVariateKraskov transferEntropyCalculatorMultiVariateKraskov = new TransferEntropyCalculatorMultiVariateKraskov();
        transferEntropyCalculatorMultiVariateKraskov.initialise(this.k);
        Vector<int[]> vector = transferEntropyCalculatorMultiVariateKraskov.computeStartAndEndTimePairs(blArray, blArray2);
        int n = 0;
        for (int[] nArray : vector) {
            int n2 = nArray[0];
            int n3 = nArray[1];
            n += n3 - n2 + 1 - this.k;
        }
        return n;
    }
}

