/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.mixed.gaussian;

import infodynamics.measures.continuous.gaussian.EntropyCalculatorMultiVariateGaussian;
import infodynamics.measures.mixed.MutualInfoCalculatorMultiVariateWithDiscrete;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;

public class MutualInfoCalculatorMultiVariateWithDiscreteGaussian
implements MutualInfoCalculatorMultiVariateWithDiscrete,
Cloneable {
    protected EntropyCalculatorMultiVariateGaussian entCalc = new EntropyCalculatorMultiVariateGaussian();
    protected EntropyCalculatorMultiVariateGaussian[] entCalcForEachDiscrete = null;
    protected int[] discreteObservations;
    protected double[][] continuousObservations;
    protected int totalObservations = 0;
    protected int base = 0;
    protected boolean debug = false;
    protected double lastAverage = 0.0;

    @Override
    public void initialise(int n, int n2) throws Exception {
        this.totalObservations = 0;
        this.lastAverage = 0.0;
        this.discreteObservations = null;
        this.base = n2;
        this.entCalc.initialise(n);
        this.entCalcForEachDiscrete = new EntropyCalculatorMultiVariateGaussian[n2];
        for (int i = 0; i < n2; ++i) {
            this.entCalcForEachDiscrete[i] = new EntropyCalculatorMultiVariateGaussian();
            this.entCalcForEachDiscrete[i].initialise(n);
        }
    }

    @Override
    public void setProperty(String string, String string2) {
    }

    @Override
    public void setObservations(double[][] dArray, int[] nArray) throws Exception {
        if (dArray.length != nArray.length) {
            throw new Exception("Observations are not of the same length");
        }
        this.entCalc.setObservations(dArray);
        this.continuousObservations = dArray;
        this.setDiscreteData(dArray, nArray);
        this.totalObservations = dArray.length;
    }

    protected void setDiscreteData(double[][] dArray, int[] nArray) throws Exception {
        int n = 0;
        for (int i = 0; i < this.base; ++i) {
            double[][] dArray2 = MatrixUtils.extractSelectedPointsMatchingCondition(dArray, nArray, i);
            this.entCalcForEachDiscrete[i].setObservations(dArray2);
            n += dArray2.length;
        }
        if (n != nArray.length) {
            throw new Exception("Some values in discreteObservations were not in the range 0..base-1");
        }
        this.discreteObservations = nArray;
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        this.lastAverage = this.entCalc.computeAverageLocalOfObservations() - this.computeAverageLocalConditionalEntropyOfObservations();
        return this.lastAverage;
    }

    protected double computeAverageLocalConditionalEntropyOfObservations() throws Exception {
        double d = 0.0;
        for (int i = 0; i < this.base; ++i) {
            double d2 = (double)this.entCalcForEachDiscrete[i].getNumObservations() / (double)this.totalObservations;
            d += d2 * this.entCalcForEachDiscrete[i].computeAverageLocalOfObservations();
        }
        return d;
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray, int[] nArray) throws Exception {
        double[] dArray2 = this.entCalc.computeLocalUsingPreviousObservations(dArray);
        double[][] dArrayArray = new double[this.base][];
        for (int i = 0; i < this.base; ++i) {
            double[][] dArray3 = MatrixUtils.extractSelectedPointsMatchingCondition(dArray, nArray, i);
            dArrayArray[i] = this.entCalcForEachDiscrete[i].computeLocalUsingPreviousObservations(dArray3);
        }
        int[] nArray2 = new int[this.base];
        int n = 0;
        while (n < dArray.length) {
            int n2 = nArray[n];
            double d = dArrayArray[n2][nArray2[n2]];
            int n3 = n2;
            nArray2[n3] = nArray2[n3] + 1;
            int n4 = n++;
            dArray2[n4] = dArray2[n4] - d;
        }
        return dArray2;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) throws Exception {
        if (this.totalObservations == 0) {
            throw new Exception("Must have set observations before computing significance");
        }
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.totalObservations, n);
        return this.computeSignificance(nArray);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) throws Exception {
        int n = nArray.length;
        if (this.lastAverage == 0.0) {
            this.computeAverageLocalOfObservations();
        }
        MutualInfoCalculatorMultiVariateWithDiscreteGaussian mutualInfoCalculatorMultiVariateWithDiscreteGaussian = (MutualInfoCalculatorMultiVariateWithDiscreteGaussian)this.clone();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = MatrixUtils.extractSelectedTimePoints(this.discreteObservations, nArray[i]);
            mutualInfoCalculatorMultiVariateWithDiscreteGaussian.setDiscreteData(this.continuousObservations, nArray2);
            dArray[i] = mutualInfoCalculatorMultiVariateWithDiscreteGaussian.entCalc.computeAverageLocalOfObservations() - mutualInfoCalculatorMultiVariateWithDiscreteGaussian.computeAverageLocalConditionalEntropyOfObservations();
            if (!this.debug) continue;
            System.out.println("New MI was " + dArray[i]);
        }
        return new EmpiricalMeasurementDistribution(dArray, this.lastAverage);
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public double getLastAverage() {
        return this.lastAverage;
    }

    @Override
    public int getNumObservations() {
        return this.totalObservations;
    }

    protected Object clone() throws CloneNotSupportedException {
        MutualInfoCalculatorMultiVariateWithDiscreteGaussian mutualInfoCalculatorMultiVariateWithDiscreteGaussian = (MutualInfoCalculatorMultiVariateWithDiscreteGaussian)super.clone();
        mutualInfoCalculatorMultiVariateWithDiscreteGaussian.entCalc = (EntropyCalculatorMultiVariateGaussian)this.entCalc.clone();
        if (this.entCalcForEachDiscrete != null) {
            mutualInfoCalculatorMultiVariateWithDiscreteGaussian.entCalcForEachDiscrete = new EntropyCalculatorMultiVariateGaussian[this.base];
            for (int i = 0; i < this.base; ++i) {
                mutualInfoCalculatorMultiVariateWithDiscreteGaussian.entCalcForEachDiscrete[i] = (EntropyCalculatorMultiVariateGaussian)this.entCalcForEachDiscrete[i].clone();
            }
        }
        return mutualInfoCalculatorMultiVariateWithDiscreteGaussian;
    }
}

