/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.discrete.ActiveInformationCalculatorDiscrete;
import infodynamics.measures.discrete.SeparableInfoCalculatorDiscrete;
import infodynamics.measures.discrete.TransferEntropyCalculatorDiscrete;
import infodynamics.utils.MatrixUtils;

public class SeparableInfoCalculatorDiscreteByAddition
extends SeparableInfoCalculatorDiscrete {
    ActiveInformationCalculatorDiscrete aiCalc;
    TransferEntropyCalculatorDiscrete[] ateCalcs;
    private boolean localStatsValid = true;

    public SeparableInfoCalculatorDiscreteByAddition(int n, int n2, int n3) {
        super(n, n2, n3, true);
        this.aiCalc = ActiveInformationCalculatorDiscrete.newInstance(n, n2);
    }

    private void createAppTeCalculators() {
        this.ateCalcs = new TransferEntropyCalculatorDiscrete[this.numSources];
        for (int i = 0; i < this.numSources; ++i) {
            this.ateCalcs[i] = TransferEntropyCalculatorDiscrete.newInstance(this.base, this.k);
            this.ateCalcs[i].setPeriodicBoundaryConditions(this.periodicBoundaryConditions);
        }
    }

    @Override
    public void initialise() {
        super.initialise();
        this.aiCalc.initialise();
        if (this.ateCalcs == null) {
            this.createAppTeCalculators();
        }
        for (int i = 0; i < this.numSources; ++i) {
            this.ateCalcs[i].initialise();
        }
    }

    @Override
    public void addObservations(int[][] nArray, int n, int[] nArray2) {
        this.aiCalc.addObservations(nArray);
        int[] nArray3 = this.cleanAbsoluteSources(nArray2, n);
        for (int i = 0; i < this.numSources; ++i) {
            this.ateCalcs[i].addObservations(nArray, nArray3[i], n);
        }
    }

    @Override
    public void addObservations(int[][] nArray, int[] nArray2) {
        this.aiCalc.addObservations(nArray);
        int[] nArray3 = this.cleanOffsetOfDestFromSources(nArray2);
        for (int i = 0; i < this.numSources; ++i) {
            this.ateCalcs[i].addObservations(nArray, nArray3[i]);
        }
    }

    @Override
    public void addObservations(int[][][] nArray, int n, int n2, int[][] nArray2) {
        this.aiCalc.addObservations(nArray, n, n2);
        int[][] nArray3 = this.cleanAbsoluteSources(nArray2, n, n2);
        for (int i = 0; i < this.numSources; ++i) {
            this.ateCalcs[i].addObservations(nArray, nArray3[i][0], nArray3[i][0], n, n2);
        }
    }

    @Override
    public void addObservations(int[][][] nArray, int[][] nArray2) {
        this.aiCalc.addObservations(nArray);
        int[][] nArray3 = this.cleanOffsetOfDestFromSources(nArray2);
        for (int i = 0; i < this.numSources; ++i) {
            this.ateCalcs[i].addObservations(nArray, nArray3[i][0], nArray3[i][0]);
        }
    }

    @Override
    public synchronized double computeAverageLocalOfObservations() {
        this.average = this.aiCalc.computeAverageLocalOfObservations();
        for (int i = 0; i < this.numSources; ++i) {
            this.average += this.ateCalcs[i].computeAverageLocalOfObservations();
        }
        this.localStatsValid = false;
        return this.average;
    }

    @Override
    public double[] computeLocalFromPreviousObservations(int[][] nArray, int n, int[] nArray2) {
        double[] dArray = this.aiCalc.computeLocalFromPreviousObservations(nArray, n);
        Object object = null;
        if (this.computeMultiInfoCoherence) {
            object = new double[this.numSources + 1][];
            object[0] = dArray;
        }
        int[] nArray3 = this.cleanAbsoluteSources(nArray2, n);
        for (int i = 0; i < this.numSources; ++i) {
            double[] dArray2 = this.ateCalcs[i].computeLocalFromPreviousObservations(nArray, nArray3[i], n);
            if (this.computeMultiInfoCoherence) {
                object[1 + this.numSources] = dArray2;
            }
            try {
                dArray = MatrixUtils.add(dArray, dArray2);
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        this.setStatistics(dArray, (double[][])object);
        this.localStatsValid = true;
        return dArray;
    }

    @Override
    public double[][] computeLocalFromPreviousObservations(int[][] nArray, int[] nArray2) {
        double[][] dArray = this.aiCalc.computeLocalFromPreviousObservations(nArray);
        Object object = null;
        if (this.computeMultiInfoCoherence) {
            object = new double[this.numSources + 1][][];
            object[0] = dArray;
        }
        int[] nArray3 = this.cleanOffsetOfDestFromSources(nArray2);
        for (int i = 0; i < this.numSources; ++i) {
            double[][] dArray2 = this.ateCalcs[i].computeLocalFromPreviousObservations(nArray, nArray3[i]);
            if (this.computeMultiInfoCoherence) {
                object[1 + this.numSources] = dArray2;
            }
            try {
                dArray = MatrixUtils.add(dArray, dArray2);
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        this.setStatistics(dArray, nArray3, (double[][][])object);
        this.localStatsValid = true;
        return dArray;
    }

    @Override
    public double[] computeLocalFromPreviousObservations(int[][][] nArray, int n, int n2, int[][] nArray2) {
        double[] dArray = this.aiCalc.computeLocalFromPreviousObservations(nArray, n, n2);
        Object object = null;
        if (this.computeMultiInfoCoherence) {
            object = new double[this.numSources + 1][];
            object[0] = dArray;
        }
        int[][] nArray3 = this.cleanAbsoluteSources(nArray2, n, n2);
        for (int i = 0; i < this.numSources; ++i) {
            double[] dArray2 = this.ateCalcs[i].computeLocalFromPreviousObservations(nArray, nArray3[i][0], nArray3[i][0], n, n2);
            if (this.computeMultiInfoCoherence) {
                object[1 + this.numSources] = dArray2;
            }
            try {
                dArray = MatrixUtils.add(dArray, dArray2);
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        this.setStatistics(dArray, (double[][])object);
        this.localStatsValid = true;
        return dArray;
    }

    @Override
    public double[][][] computeLocalFromPreviousObservations(int[][][] nArray, int[][] nArray2) {
        double[][][] dArray = this.aiCalc.computeLocalFromPreviousObservations(nArray);
        Object object = null;
        if (this.computeMultiInfoCoherence) {
            object = new double[this.numSources + 1][][][];
            object[0] = dArray;
        }
        int[][] nArray3 = this.cleanOffsetOfDestFromSources(nArray2);
        for (int i = 0; i < this.numSources; ++i) {
            double[][][] dArray2 = this.ateCalcs[i].computeLocalFromPreviousObservations(nArray, nArray3[i][0], nArray3[i][0]);
            if (this.computeMultiInfoCoherence) {
                object[1 + this.numSources] = dArray2;
            }
            try {
                dArray = MatrixUtils.add(dArray, dArray2);
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        this.setStatistics(dArray, nArray3, (double[][][][])object);
        this.localStatsValid = true;
        return dArray;
    }

    @Override
    public double[][] computeLocal(int[][] nArray, int[] nArray2) {
        double[][] dArray = this.aiCalc.computeLocal(nArray);
        Object object = null;
        if (this.computeMultiInfoCoherence) {
            object = new double[this.numSources + 1][][];
            object[0] = dArray;
        }
        int[] nArray3 = this.cleanOffsetOfDestFromSources(nArray2);
        TransferEntropyCalculatorDiscrete transferEntropyCalculatorDiscrete = TransferEntropyCalculatorDiscrete.newInstance(this.base, this.k);
        transferEntropyCalculatorDiscrete.setPeriodicBoundaryConditions(this.periodicBoundaryConditions);
        for (int i = 0; i < this.numSources; ++i) {
            double[][] dArray2 = transferEntropyCalculatorDiscrete.computeLocal(nArray, nArray3[i]);
            if (this.computeMultiInfoCoherence) {
                object[1 + this.numSources] = dArray2;
            }
            try {
                dArray = MatrixUtils.add(dArray, dArray2);
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        this.setStatistics(dArray, nArray3, (double[][][])object);
        this.localStatsValid = true;
        return dArray;
    }

    @Override
    public double[][][] computeLocal(int[][][] nArray, int[][] nArray2) {
        double[][][] dArray = this.aiCalc.computeLocal(nArray);
        Object object = null;
        if (this.computeMultiInfoCoherence) {
            object = new double[this.numSources + 1][][][];
            object[0] = dArray;
        }
        int[][] nArray3 = this.cleanOffsetOfDestFromSources(nArray2);
        TransferEntropyCalculatorDiscrete transferEntropyCalculatorDiscrete = TransferEntropyCalculatorDiscrete.newInstance(this.base, this.k);
        transferEntropyCalculatorDiscrete.setPeriodicBoundaryConditions(this.periodicBoundaryConditions);
        for (int i = 0; i < this.numSources; ++i) {
            double[][][] dArray2 = transferEntropyCalculatorDiscrete.computeLocal(nArray, nArray3[i][0], nArray3[i][0]);
            if (this.computeMultiInfoCoherence) {
                object[1 + this.numSources] = dArray2;
            }
            try {
                dArray = MatrixUtils.add(dArray, dArray2);
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        this.setStatistics(dArray, nArray3, (double[][][][])object);
        this.localStatsValid = true;
        return dArray;
    }

    @Override
    public double computeAverageLocal(int[][] nArray, int[] nArray2) {
        this.average = this.aiCalc.computeAverageLocal(nArray);
        int[] nArray3 = this.cleanOffsetOfDestFromSources(nArray2);
        TransferEntropyCalculatorDiscrete transferEntropyCalculatorDiscrete = TransferEntropyCalculatorDiscrete.newInstance(this.base, this.k);
        transferEntropyCalculatorDiscrete.setPeriodicBoundaryConditions(this.periodicBoundaryConditions);
        for (int i = 0; i < this.numSources; ++i) {
            this.average += transferEntropyCalculatorDiscrete.computeAverageLocal(nArray, nArray3[i]);
        }
        this.localStatsValid = false;
        return this.average;
    }

    @Override
    public double computeAverageLocal(int[][][] nArray, int[][] nArray2) {
        this.average = this.aiCalc.computeAverageLocal(nArray);
        int[][] nArray3 = this.cleanOffsetOfDestFromSources(nArray2);
        TransferEntropyCalculatorDiscrete transferEntropyCalculatorDiscrete = TransferEntropyCalculatorDiscrete.newInstance(this.base, this.k);
        transferEntropyCalculatorDiscrete.setPeriodicBoundaryConditions(this.periodicBoundaryConditions);
        for (int i = 0; i < this.numSources; ++i) {
            this.average += transferEntropyCalculatorDiscrete.computeAverageLocal(nArray, nArray3[i][0], nArray3[i][0]);
        }
        this.localStatsValid = false;
        return this.average;
    }

    @Override
    public double[] computeLocal(int[][] nArray, int n, int[] nArray2) {
        double[] dArray = this.aiCalc.computeLocal(nArray, n);
        Object object = null;
        if (this.computeMultiInfoCoherence) {
            object = new double[this.numSources + 1][];
            object[0] = dArray;
        }
        int[] nArray3 = this.cleanAbsoluteSources(nArray2, n);
        TransferEntropyCalculatorDiscrete transferEntropyCalculatorDiscrete = TransferEntropyCalculatorDiscrete.newInstance(this.base, this.k);
        transferEntropyCalculatorDiscrete.setPeriodicBoundaryConditions(this.periodicBoundaryConditions);
        for (int i = 0; i < this.numSources; ++i) {
            double[] dArray2 = transferEntropyCalculatorDiscrete.computeLocal(nArray, nArray3[i], n);
            if (this.computeMultiInfoCoherence) {
                object[1 + this.numSources] = dArray2;
            }
            try {
                dArray = MatrixUtils.add(dArray, dArray2);
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        this.setStatistics(dArray, (double[][])object);
        this.localStatsValid = true;
        return dArray;
    }

    @Override
    public double[] computeLocal(int[][][] nArray, int n, int n2, int[][] nArray2) {
        double[] dArray = this.aiCalc.computeLocal(nArray, n, n2);
        Object object = null;
        if (this.computeMultiInfoCoherence) {
            object = new double[this.numSources + 1][];
            object[0] = dArray;
        }
        int[][] nArray3 = this.cleanAbsoluteSources(nArray2, n, n2);
        TransferEntropyCalculatorDiscrete transferEntropyCalculatorDiscrete = TransferEntropyCalculatorDiscrete.newInstance(this.base, this.k);
        transferEntropyCalculatorDiscrete.setPeriodicBoundaryConditions(this.periodicBoundaryConditions);
        for (int i = 0; i < this.numSources; ++i) {
            double[] dArray2 = transferEntropyCalculatorDiscrete.computeLocal(nArray, nArray3[i][0], nArray3[i][0], n, n2);
            if (this.computeMultiInfoCoherence) {
                object[1 + this.numSources] = dArray2;
            }
            try {
                dArray = MatrixUtils.add(dArray, dArray2);
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        this.setStatistics(dArray, (double[][])object);
        this.localStatsValid = true;
        return dArray;
    }

    @Override
    public double computeAverageLocal(int[][] nArray, int n, int[] nArray2) {
        this.average = this.aiCalc.computeAverageLocal(nArray, n);
        int[] nArray3 = this.cleanAbsoluteSources(nArray2, n);
        TransferEntropyCalculatorDiscrete transferEntropyCalculatorDiscrete = TransferEntropyCalculatorDiscrete.newInstance(this.base, this.k);
        transferEntropyCalculatorDiscrete.setPeriodicBoundaryConditions(this.periodicBoundaryConditions);
        for (int i = 0; i < this.numSources; ++i) {
            this.average += transferEntropyCalculatorDiscrete.computeAverageLocal(nArray, nArray3[i], n);
        }
        this.localStatsValid = false;
        return this.average;
    }

    @Override
    public double computeAverageLocal(int[][][] nArray, int n, int n2, int[][] nArray2) {
        this.average = this.aiCalc.computeAverageLocal(nArray);
        int[][] nArray3 = this.cleanAbsoluteSources(nArray2, n, n2);
        TransferEntropyCalculatorDiscrete transferEntropyCalculatorDiscrete = TransferEntropyCalculatorDiscrete.newInstance(this.base, this.k);
        transferEntropyCalculatorDiscrete.setPeriodicBoundaryConditions(this.periodicBoundaryConditions);
        for (int i = 0; i < this.numSources; ++i) {
            this.average += transferEntropyCalculatorDiscrete.computeAverageLocal(nArray, nArray3[i][0], nArray3[i][0]);
        }
        this.localStatsValid = false;
        return this.average;
    }

    @Override
    public void setPeriodicBoundaryConditions(boolean bl) {
        super.setPeriodicBoundaryConditions(bl);
        if (this.ateCalcs != null) {
            for (int i = 0; i < this.numSources; ++i) {
                this.ateCalcs[i].setPeriodicBoundaryConditions(bl);
            }
        }
    }

    @Override
    public double getLastMax() {
        if (this.localStatsValid) {
            return super.getLastMax();
        }
        throw new RuntimeException("Last maximum is not valid after previous computation by SeparableInfoCalculatorByAddition");
    }

    @Override
    public double getLastMin() {
        if (this.localStatsValid) {
            return super.getLastMin();
        }
        throw new RuntimeException("Last minimum is not valid after previous computation by SeparableInfoCalculatorByAddition");
    }

    @Override
    public double getLastAverageNegative() {
        if (this.localStatsValid) {
            return super.getLastAverageNegative();
        }
        throw new RuntimeException("Last average negative sep is not valid after previous computation by SeparableInfoCalculatorByAddition");
    }

    @Override
    public double getLastAveragePositive() {
        if (this.localStatsValid) {
            return super.getLastAveragePositive();
        }
        throw new RuntimeException("Last average positive sep is not valid after previous computation by SeparableInfoCalculatorByAddition");
    }

    private void setStatistics(double[] dArray, double[][] dArray2) {
        int n = dArray.length;
        this.average = 0.0;
        this.max = dArray[this.k];
        this.min = dArray[this.k];
        this.avPositiveLocal = 0.0;
        this.avNegativeLocal = 0.0;
        for (int i = this.k; i < n; ++i) {
            this.average += dArray[i];
            if (dArray[i] > 0.0) {
                this.avPositiveLocal += dArray[i];
            } else {
                this.avNegativeLocal += dArray[i];
            }
            if (dArray[i] > this.max) {
                this.max = dArray[i];
                continue;
            }
            if (!(dArray[i] < this.min)) continue;
            this.min = dArray[i];
        }
        this.average /= (double)(n - this.k);
        this.avPositiveLocal /= (double)(n - this.k);
        this.avNegativeLocal /= (double)(n - this.k);
        if (this.computeMultiInfoCoherence) {
            this.miCalc.startAddObservations();
            double[] dArray3 = new double[this.numSources + 1];
            for (int i = this.k; i < n; ++i) {
                for (int j = 0; j < this.numSources + 1; ++j) {
                    dArray3[j] = dArray2[j][i];
                }
                this.miCalc.addObservation(dArray3);
            }
            try {
                this.miCalc.finaliseAddObservations();
            }
            catch (Exception exception) {
                throw new RuntimeException("Number of causal contributors changed from intialisation to calculation!");
            }
        }
    }

    private void setStatistics(double[][] dArray, int[] nArray, double[][][] dArray2) {
        int n;
        int n2;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        int n5 = MatrixUtils.min(nArray);
        int n6 = MatrixUtils.max(nArray);
        int n7 = Math.max(0, n6);
        int n8 = n4 - 1 + Math.min(0, n5);
        if (!this.periodicBoundaryConditions) {
            for (n2 = this.k; n2 < n3; ++n2) {
                for (n = 0; n < n7; ++n) {
                    dArray[n2][n] = 0.0;
                }
                for (n = n8 + 1; n < n4; ++n) {
                    dArray[n2][n] = 0.0;
                }
            }
        }
        this.average = 0.0;
        this.max = dArray[this.k][0];
        this.min = dArray[this.k][0];
        this.avPositiveLocal = 0.0;
        this.avNegativeLocal = 0.0;
        for (n2 = this.k; n2 < n3; ++n2) {
            for (n = this.periodicBoundaryConditions ? 0 : n7; n < (this.periodicBoundaryConditions ? n4 : n8 + 1); ++n) {
                this.average += dArray[n2][n];
                if (dArray[n2][n] > 0.0) {
                    this.avPositiveLocal += dArray[n2][n];
                } else {
                    this.avNegativeLocal += dArray[n2][n];
                }
                if (dArray[n2][n] > this.max) {
                    this.max = dArray[n2][n];
                    continue;
                }
                if (!(dArray[n2][n] < this.min)) continue;
                this.min = dArray[n2][n];
            }
        }
        if (this.periodicBoundaryConditions) {
            this.average /= (double)((n3 - this.k) * n4);
            this.avPositiveLocal /= (double)((n3 - this.k) * n4);
            this.avNegativeLocal /= (double)((n3 - this.k) * n4);
        } else {
            this.average /= (double)((n3 - this.k) * (n8 - n7 + 1));
            this.avPositiveLocal /= (double)((n3 - this.k) * (n8 - n7 + 1));
            this.avNegativeLocal /= (double)((n3 - this.k) * (n8 - n7 + 1));
        }
        if (this.computeMultiInfoCoherence) {
            this.miCalc.startAddObservations();
            double[] dArray3 = new double[this.numSources + 1];
            for (n = this.k; n < n3; ++n) {
                for (int i = this.periodicBoundaryConditions ? 0 : n7; i < (this.periodicBoundaryConditions ? n4 : n8 + 1); ++i) {
                    for (int j = 0; j < this.numSources + 1; ++j) {
                        dArray3[j] = dArray2[j][n][i];
                    }
                    this.miCalc.addObservation(dArray3);
                }
            }
            try {
                this.miCalc.finaliseAddObservations();
            }
            catch (Exception exception) {
                throw new RuntimeException("Number of causal contributors changed from intialisation to calculation!");
            }
        }
    }

    private void setStatistics(double[][][] dArray, int[][] nArray, double[][][][] dArray2) {
        int n;
        int n2;
        int n3;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        int n6 = dArray[0][0].length;
        int n7 = MatrixUtils.min(nArray, 0);
        int n8 = MatrixUtils.max(nArray, 0);
        int n9 = Math.max(0, n8);
        int n10 = n5 - 1 + Math.min(0, n7);
        int n11 = MatrixUtils.min(nArray, 0);
        int n12 = MatrixUtils.max(nArray, 0);
        int n13 = Math.max(0, n12);
        int n14 = n6 - 1 + Math.min(0, n11);
        System.out.println(this.periodicBoundaryConditions + " " + n9 + " " + n10 + " " + n13 + " " + n14);
        if (!this.periodicBoundaryConditions) {
            for (n3 = this.k; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n9; ++n2) {
                    for (n = 0; n < n13; ++n) {
                        dArray[n3][n2][n] = 0.0;
                    }
                    for (n = n14 + 1; n < n6; ++n) {
                        dArray[n3][n2][n] = 0.0;
                    }
                }
                for (n2 = n10 + 1; n2 < n5; ++n2) {
                    for (n = 0; n < n13; ++n) {
                        dArray[n3][n2][n] = 0.0;
                    }
                    for (n = n14 + 1; n < n6; ++n) {
                        dArray[n3][n2][n] = 0.0;
                    }
                }
            }
        }
        this.average = 0.0;
        this.max = dArray[this.k][0][0];
        this.min = dArray[this.k][0][0];
        this.avPositiveLocal = 0.0;
        this.avNegativeLocal = 0.0;
        for (n3 = this.k; n3 < n4; ++n3) {
            for (n2 = this.periodicBoundaryConditions ? 0 : n9; n2 < (this.periodicBoundaryConditions ? n5 : n10 + 1); ++n2) {
                for (n = this.periodicBoundaryConditions ? 0 : n13; n < (this.periodicBoundaryConditions ? n6 : n14 + 1); ++n) {
                    this.average += dArray[n3][n2][n];
                    if (dArray[n3][n2][n] > 0.0) {
                        this.avPositiveLocal += dArray[n3][n2][n];
                    } else {
                        this.avNegativeLocal += dArray[n3][n2][n];
                    }
                    if (dArray[n3][n2][n] > this.max) {
                        this.max = dArray[n3][n2][n];
                        continue;
                    }
                    if (!(dArray[n3][n2][n] < this.min)) continue;
                    this.min = dArray[n3][n2][n];
                }
            }
        }
        if (this.periodicBoundaryConditions) {
            this.average /= (double)((n4 - this.k) * n5 * n6);
            this.avPositiveLocal /= (double)((n4 - this.k) * n5 * n6);
            this.avNegativeLocal /= (double)((n4 - this.k) * n5 * n6);
        } else {
            this.average /= (double)((n4 - this.k) * (n10 - n9 + 1) * (n14 - n13 + 1));
            this.avPositiveLocal /= (double)((n4 - this.k) * (n10 - n9 + 1) * (n14 - n13 + 1));
            this.avNegativeLocal /= (double)((n4 - this.k) * (n10 - n9 + 1) * (n14 - n13 + 1));
        }
        if (this.computeMultiInfoCoherence) {
            this.miCalc.startAddObservations();
            double[] dArray3 = new double[this.numSources + 1];
            for (n2 = this.k; n2 < n4; ++n2) {
                for (n = this.periodicBoundaryConditions ? 0 : n9; n < (this.periodicBoundaryConditions ? n5 : n10 + 1); ++n) {
                    for (int i = this.periodicBoundaryConditions ? 0 : n13; i < (this.periodicBoundaryConditions ? n6 : n14 + 1); ++i) {
                        for (int j = 0; j < this.numSources + 1; ++j) {
                            dArray3[j] = dArray2[j][n2][n][i];
                        }
                        this.miCalc.addObservation(dArray3);
                    }
                }
            }
            try {
                this.miCalc.finaliseAddObservations();
            }
            catch (Exception exception) {
                throw new RuntimeException("Number of causal contributors changed from intialisation to calculation!");
            }
        }
    }

    @Override
    public boolean canComputeMultiInfoCoherenceFromAverageOfObservations() {
        return false;
    }
}

