/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.ConditionalMutualInfoMultiVariateCommon;
import infodynamics.utils.EuclideanUtils;

public abstract class ConditionalMutualInfoCalculatorMultiVariateKraskov
extends ConditionalMutualInfoMultiVariateCommon
implements Cloneable {
    protected int k = 4;
    protected EuclideanUtils normCalculator = new EuclideanUtils(2);
    protected double[][] xNorms;
    protected double[][] yNorms;
    protected double[][] zNorms;
    public static boolean tryKeepAllPairsNorms = true;
    public static int MAX_DATA_SIZE_FOR_KEEP_ALL_PAIRS_NORM = 2000;
    public static final String PROP_K = "k";
    public static final String PROP_NORM_TYPE = "NORM_TYPE";

    @Override
    public void initialise(int n, int n2, int n3) {
        super.initialise(n, n2, n3);
        this.xNorms = null;
        this.yNorms = null;
        this.zNorms = null;
    }

    @Override
    public void setProperty(String string, String string2) {
        if (string.equalsIgnoreCase(PROP_K)) {
            this.k = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase(PROP_NORM_TYPE)) {
            this.normCalculator.setNormToUse(string2);
        } else {
            super.setProperty(string, string2);
        }
    }

    protected void computeNorms() {
        int n = this.var1Observations.length;
        this.xNorms = new double[n][n];
        this.yNorms = new double[n][n];
        this.zNorms = new double[n][n];
        for (int i = 0; i < n; ++i) {
            double[][] dArray = this.normCalculator.computeNorms(this.var1Observations, this.var2Observations, this.condObservations, i);
            for (int j = 0; j < n; ++j) {
                this.xNorms[i][j] = dArray[j][0];
                this.yNorms[i][j] = dArray[j][1];
                this.zNorms[i][j] = dArray[j][2];
            }
        }
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2, double[][] dArray3) throws Exception {
        throw new Exception("Local method not implemented yet");
    }

    public abstract String printConstants(int var1) throws Exception;
}

