/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous;

import infodynamics.measures.continuous.ConditionalMutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.TransferEntropyCalculatorMultiVariate;
import infodynamics.measures.continuous.TransferEntropyCalculatorViaCondMutualInfo;
import infodynamics.utils.MatrixUtils;
import java.util.Vector;

public class TransferEntropyCalculatorMultiVariateViaCondMutualInfo
extends TransferEntropyCalculatorViaCondMutualInfo
implements TransferEntropyCalculatorMultiVariate {
    protected int destDimensions = 1;
    protected int sourceDimensions = 1;

    public TransferEntropyCalculatorMultiVariateViaCondMutualInfo(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(string);
    }

    public TransferEntropyCalculatorMultiVariateViaCondMutualInfo(Class<ConditionalMutualInfoCalculatorMultiVariate> clazz) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        super(clazz);
    }

    public TransferEntropyCalculatorMultiVariateViaCondMutualInfo(ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate) throws Exception {
        super(conditionalMutualInfoCalculatorMultiVariate);
    }

    @Override
    public void initialise(int n, int n2) throws Exception {
        this.initialise(n, n2, this.k, this.k_tau, this.l, this.l_tau, this.delay);
    }

    @Override
    public void initialise(int n, int n2, int n3) throws Exception {
        this.initialise(n2, n3, n, this.k_tau, this.l, this.l_tau, this.delay);
    }

    @Override
    public void initialise(int n, int n2, int n3, int n4, int n5) throws Exception {
        this.initialise(this.sourceDimensions, this.destDimensions, n, n2, n3, n4, n5);
    }

    public void initialise(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws Exception {
        if (n7 < 0) {
            throw new Exception("Cannot compute TE with source-destination delay < 0");
        }
        this.sourceDimensions = n;
        this.destDimensions = n2;
        this.k = n3;
        this.k_tau = n4;
        this.l = n5;
        this.l_tau = n6;
        this.delay = n7;
        int n8 = (n3 - 1) * n4;
        int n9 = (n5 - 1) * n6 + n7 - 1;
        this.startTimeForFirstDestEmbedding = Math.max(n8, n9);
        this.condMiCalc.initialise(n5 * n, n2, n3 * n2);
    }

    @Override
    public void setObservations(double[] dArray, double[] dArray2) throws Exception {
        if (this.sourceDimensions != 1 || this.destDimensions != 1) {
            throw new Exception("Cannot call the univariate setObservations if you have initialised with dimension > 1 for either source or destination");
        }
        super.setObservations(dArray, dArray2);
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray.length < this.startTimeForFirstDestEmbedding + 2) {
            throw new Exception("Not enough observations to set here given k, k_tau, l, l_tau and delay parameters");
        }
        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray2, this.k, this.k_tau, this.startTimeForFirstDestEmbedding, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray4 = MatrixUtils.makeDelayEmbeddingVector(dArray2, 1, this.startTimeForFirstDestEmbedding + 1, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray5 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.l, this.l_tau, this.startTimeForFirstDestEmbedding + 1 - this.delay, dArray.length - this.startTimeForFirstDestEmbedding - 1);
        this.condMiCalc.setObservations(dArray5, dArray4, dArray3);
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2) throws Exception {
        if (this.sourceDimensions != 1 || this.destDimensions != 1) {
            throw new Exception("Cannot call the univariate addObservations if you have initialised with dimension > 1 for either source or destination");
        }
        super.addObservations(dArray, dArray2);
    }

    @Override
    public void addObservations(double[][] dArray, double[][] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray.length < this.startTimeForFirstDestEmbedding + 2) {
            return;
        }
        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray2, this.k, this.k_tau, this.startTimeForFirstDestEmbedding, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray4 = MatrixUtils.makeDelayEmbeddingVector(dArray2, 1, this.startTimeForFirstDestEmbedding + 1, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray5 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.l, this.l_tau, this.startTimeForFirstDestEmbedding + 1 - this.delay, dArray.length - this.startTimeForFirstDestEmbedding - 1);
        this.condMiCalc.addObservations(dArray5, dArray4, dArray3);
    }

    @Override
    public void addObservations(double[] dArray, double[] dArray2, int n, int n2) throws Exception {
        if (this.sourceDimensions != 1 || this.destDimensions != 1) {
            throw new Exception("Cannot call the univariate addObservations if you have initialised with dimension > 1 for either source or destination");
        }
        super.addObservations(dArray, dArray2, n, n2);
    }

    @Override
    public void addObservations(double[][] dArray, double[][] dArray2, int n, int n2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray.length < n + n2) {
            throw new Exception("Not enough observations to set here given startTime and numTimeSteps parameters");
        }
        this.addObservations(MatrixUtils.selectRows(dArray, n, n2), MatrixUtils.selectRows(dArray2, n, n2));
    }

    @Override
    public void setObservations(double[] dArray, double[] dArray2, boolean[] blArray, boolean[] blArray2) throws Exception {
        if (this.sourceDimensions != 1 || this.destDimensions != 1) {
            throw new Exception("Cannot call the univariate setObservations if you have initialised with dimension > 1 for either source or destination");
        }
        super.setObservations(dArray, dArray2, blArray, blArray2);
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2, boolean[] blArray, boolean[] blArray2) throws Exception {
        Vector<int[]> vector = this.computeStartAndEndTimePairs(blArray, blArray2);
        this.startAddObservations();
        for (int[] nArray : vector) {
            int n = nArray[0];
            int n2 = nArray[1];
            this.addObservations(dArray, dArray2, n, n2 - n + 1);
        }
        this.finaliseAddObservations();
    }

    @Override
    public void setObservations(double[][] dArray, double[][] dArray2, boolean[][] blArray, boolean[][] blArray2) throws Exception {
        boolean[] blArray3 = MatrixUtils.andRows(blArray);
        boolean[] blArray4 = MatrixUtils.andRows(blArray2);
        this.setObservations(dArray, dArray2, blArray3, blArray4);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[] dArray, double[] dArray2) throws Exception {
        if (this.sourceDimensions != 1 || this.destDimensions != 1) {
            throw new Exception("Cannot call the univariate computeLocalUsingPreviousObservations if you have initialised with dimension > 1 for either source or destination");
        }
        return super.computeLocalUsingPreviousObservations(dArray, dArray2);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2) throws Exception {
        if (dArray.length != dArray2.length) {
            throw new Exception(String.format("Source and destination lengths (%d and %d) must match!", dArray.length, dArray2.length));
        }
        if (dArray2.length < this.startTimeForFirstDestEmbedding + 2) {
            return new double[dArray2.length];
        }
        double[][] dArray3 = MatrixUtils.makeDelayEmbeddingVector(dArray2, this.k, this.k_tau, this.startTimeForFirstDestEmbedding, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray4 = MatrixUtils.makeDelayEmbeddingVector(dArray2, 1, this.startTimeForFirstDestEmbedding + 1, dArray2.length - this.startTimeForFirstDestEmbedding - 1);
        double[][] dArray5 = MatrixUtils.makeDelayEmbeddingVector(dArray, this.l, this.l_tau, this.startTimeForFirstDestEmbedding + 1 - this.delay, dArray.length - this.startTimeForFirstDestEmbedding - 1);
        double[] dArray6 = this.condMiCalc.computeLocalUsingPreviousObservations(dArray5, dArray4, dArray3);
        double[] dArray7 = new double[dArray6.length + this.startTimeForFirstDestEmbedding + 1];
        System.arraycopy(dArray6, 0, dArray7, this.startTimeForFirstDestEmbedding + 1, dArray6.length);
        return dArray7;
    }
}

