/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.discrete.ChannelCalculatorDiscrete;
import infodynamics.measures.discrete.ContextOfPastMeasureCalculatorDiscrete;
import infodynamics.utils.AnalyticMeasurementDistribution;
import infodynamics.utils.AnalyticNullDistributionComputer;
import infodynamics.utils.ChiSquareMeasurementDistribution;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;

public class TransferEntropyCalculatorDiscrete
extends ContextOfPastMeasureCalculatorDiscrete
implements ChannelCalculatorDiscrete,
AnalyticNullDistributionComputer {
    protected int[][][] sourceNextPastCount = null;
    protected int[][] sourcePastCount = null;
    protected boolean periodicBoundaryConditions = true;
    protected int sourceHistoryEmbedLength = 1;
    protected int base_power_l = 1;
    protected int[] maxShiftedSourceValue = null;
    protected int startObservationTime = 1;
    protected boolean estimateComputed = false;

    public static TransferEntropyCalculatorDiscrete newInstance(int n, int n2) {
        return new TransferEntropyCalculatorDiscrete(n, n2);
    }

    public TransferEntropyCalculatorDiscrete(int n, int n2) {
        super(n, n2);
        this.base_power_l = MathsUtils.power(n, this.sourceHistoryEmbedLength);
        this.maxShiftedSourceValue = new int[n];
        for (int i = 0; i < n; ++i) {
            this.maxShiftedSourceValue[i] = i;
        }
        this.sourceNextPastCount = new int[this.base_power_l][n][this.base_power_k];
        this.sourcePastCount = new int[this.base_power_l][this.base_power_k];
        this.startObservationTime = Math.max(this.k, 1);
    }

    public TransferEntropyCalculatorDiscrete(int n, int n2, int n3) {
        super(n, n2);
        this.sourceHistoryEmbedLength = n3;
        this.base_power_l = MathsUtils.power(n, this.sourceHistoryEmbedLength);
        if ((double)this.sourceHistoryEmbedLength > Math.log(2.147483647E9) / this.log_base) {
            throw new RuntimeException("Base and source history combination too large");
        }
        this.maxShiftedSourceValue = new int[n];
        for (int i = 0; i < n; ++i) {
            this.maxShiftedSourceValue[i] = i * MathsUtils.power(n, this.sourceHistoryEmbedLength - 1);
        }
        this.sourceNextPastCount = new int[this.base_power_l][n][this.base_power_k];
        this.sourcePastCount = new int[this.base_power_l][this.base_power_k];
        this.startObservationTime = Math.max(Math.max(this.k, this.sourceHistoryEmbedLength), 1);
    }

    @Override
    public void initialise() {
        super.initialise();
        this.estimateComputed = false;
        MatrixUtils.fill(this.sourceNextPastCount, 0);
        MatrixUtils.fill(this.sourcePastCount, 0);
    }

    @Override
    public void addObservations(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3 = nArray2.length;
        this.observations += n3 - this.startObservationTime;
        int n4 = 0;
        for (n2 = 0; n2 < this.k; ++n2) {
            n4 *= this.base;
            n4 += nArray2[this.startObservationTime - this.k + n2];
        }
        n2 = 0;
        for (n = 0; n < this.sourceHistoryEmbedLength; ++n) {
            n2 *= this.base;
            n2 += nArray[this.startObservationTime - this.sourceHistoryEmbedLength + n];
        }
        for (int i = this.startObservationTime; i < n3; ++i) {
            n = nArray2[i];
            int[] nArray3 = this.sourceNextPastCount[n2][n];
            int n5 = n4;
            nArray3[n5] = nArray3[n5] + 1;
            int[] nArray4 = this.sourcePastCount[n2];
            int n6 = n4;
            nArray4[n6] = nArray4[n6] + 1;
            int[] nArray5 = this.nextPastCount[n];
            int n7 = n4;
            nArray5[n7] = nArray5[n7] + 1;
            int n8 = n4;
            this.pastCount[n8] = this.pastCount[n8] + 1;
            int n9 = n;
            this.nextCount[n9] = this.nextCount[n9] + 1;
            if (this.k > 0) {
                n4 -= this.maxShiftedValue[nArray2[i - this.k]];
                n4 *= this.base;
                n4 += nArray2[i];
            }
            n2 -= this.maxShiftedSourceValue[nArray[i - this.sourceHistoryEmbedLength]];
            n2 *= this.base;
            n2 += nArray[i];
        }
    }

    public void addObservations(int[] nArray, int[] nArray2, boolean[] blArray) {
        int n;
        int n2;
        int n3 = nArray2.length;
        int n4 = 0;
        int n5 = this.k;
        int n6 = this.sourceHistoryEmbedLength;
        for (n2 = 0; n2 < this.k; ++n2) {
            n4 *= this.base;
            n4 += nArray2[this.startObservationTime - this.k + n2];
            if (blArray[this.startObservationTime - this.k + n2]) continue;
            n5 = this.k - n2 - 1;
        }
        n2 = 0;
        for (n = 0; n < this.sourceHistoryEmbedLength; ++n) {
            n2 *= this.base;
            n2 += nArray[this.startObservationTime - this.sourceHistoryEmbedLength + n];
            if (blArray[this.startObservationTime - this.sourceHistoryEmbedLength + n]) continue;
            n6 = this.sourceHistoryEmbedLength - n - 1;
        }
        for (int i = this.startObservationTime; i < n3; ++i) {
            ++n5;
            ++n6;
            if (!blArray[i]) {
                n5 = 0;
            } else if (n5 > this.k && n6 > this.sourceHistoryEmbedLength) {
                n = nArray2[i];
                int[] nArray3 = this.sourceNextPastCount[n2][n];
                int n7 = n4;
                nArray3[n7] = nArray3[n7] + 1;
                int[] nArray4 = this.sourcePastCount[n2];
                int n8 = n4;
                nArray4[n8] = nArray4[n8] + 1;
                int[] nArray5 = this.nextPastCount[n];
                int n9 = n4;
                nArray5[n9] = nArray5[n9] + 1;
                int n10 = n4;
                this.pastCount[n10] = this.pastCount[n10] + 1;
                int n11 = n;
                this.nextCount[n11] = this.nextCount[n11] + 1;
                ++this.observations;
            }
            if (this.k > 0) {
                n4 -= this.maxShiftedValue[nArray2[i - this.k]];
                n4 *= this.base;
                n4 += nArray2[i];
            }
            n2 -= this.maxShiftedSourceValue[nArray[i - this.sourceHistoryEmbedLength]];
            n2 *= this.base;
            n2 += nArray[i];
            if (blArray[i]) continue;
            n6 = 0;
        }
    }

    public void addObservations(int[] nArray, int[] nArray2, int n, int n2) {
        int n3;
        int n4;
        this.observations += n2 - n - this.startObservationTime + 1;
        int n5 = 0;
        for (n4 = 0; n4 < this.k; ++n4) {
            n5 *= this.base;
            n5 += nArray2[n + this.startObservationTime - this.k + n4];
        }
        n4 = 0;
        for (n3 = 0; n3 < this.sourceHistoryEmbedLength; ++n3) {
            n4 *= this.base;
            n4 += nArray[n + this.startObservationTime - this.sourceHistoryEmbedLength + n3];
        }
        for (int i = n + this.startObservationTime; i <= n2; ++i) {
            n3 = nArray2[i];
            int[] nArray3 = this.sourceNextPastCount[n4][n3];
            int n6 = n5;
            nArray3[n6] = nArray3[n6] + 1;
            int[] nArray4 = this.sourcePastCount[n4];
            int n7 = n5;
            nArray4[n7] = nArray4[n7] + 1;
            int[] nArray5 = this.nextPastCount[n3];
            int n8 = n5;
            nArray5[n8] = nArray5[n8] + 1;
            int n9 = n5;
            this.pastCount[n9] = this.pastCount[n9] + 1;
            int n10 = n3;
            this.nextCount[n10] = this.nextCount[n10] + 1;
            if (this.k > 0) {
                n5 -= this.maxShiftedValue[nArray2[i - this.k]];
                n5 *= this.base;
                n5 += nArray2[i];
            }
            n4 -= this.maxShiftedSourceValue[nArray[i - this.sourceHistoryEmbedLength]];
            n4 *= this.base;
            n4 += nArray[i];
        }
    }

    public void addObservations(int[][] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = nArray.length;
        int n6 = nArray[0].length;
        this.observations = this.periodicBoundaryConditions ? (this.observations += (n5 - this.startObservationTime) * n6) : (this.observations += (n5 - this.startObservationTime) * (n6 - Math.abs(n)));
        int[] nArray2 = new int[n6];
        for (int i = 0; i < n6; ++i) {
            nArray2[i] = 0;
            for (n4 = 0; n4 < this.k; ++n4) {
                int n7 = i;
                nArray2[n7] = nArray2[n7] * this.base;
                int n8 = i;
                nArray2[n8] = nArray2[n8] + nArray[this.startObservationTime - this.k + n4][i];
            }
        }
        int[] nArray3 = new int[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            nArray3[n4] = 0;
            n3 = n4 - n;
            if (n3 < 0 || n3 >= n6) {
                if (!this.periodicBoundaryConditions) continue;
                n3 = (n3 + n6) % n6;
            }
            for (n2 = 0; n2 < this.sourceHistoryEmbedLength; ++n2) {
                int n9 = n4;
                nArray3[n9] = nArray3[n9] * this.base;
                int n10 = n4;
                nArray3[n10] = nArray3[n10] + nArray[this.startObservationTime - this.sourceHistoryEmbedLength + n2][n3];
            }
        }
        for (n3 = this.startObservationTime; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                int n11 = n2 - n;
                if (n11 < 0 || n11 >= n6) {
                    if (!this.periodicBoundaryConditions) continue;
                    n11 = (n11 + n6) % n6;
                }
                n4 = nArray[n3][n2];
                int[] nArray4 = this.sourceNextPastCount[nArray3[n2]][n4];
                int n12 = nArray2[n2];
                nArray4[n12] = nArray4[n12] + 1;
                int[] nArray5 = this.sourcePastCount[nArray3[n2]];
                int n13 = nArray2[n2];
                nArray5[n13] = nArray5[n13] + 1;
                int[] nArray6 = this.nextPastCount[n4];
                int n14 = nArray2[n2];
                nArray6[n14] = nArray6[n14] + 1;
                int n15 = nArray2[n2];
                this.pastCount[n15] = this.pastCount[n15] + 1;
                int n16 = n4;
                this.nextCount[n16] = this.nextCount[n16] + 1;
                if (this.k > 0) {
                    int n17 = n2;
                    nArray2[n17] = nArray2[n17] - this.maxShiftedValue[nArray[n3 - this.k][n2]];
                    int n18 = n2;
                    nArray2[n18] = nArray2[n18] * this.base;
                    int n19 = n2;
                    nArray2[n19] = nArray2[n19] + nArray[n3][n2];
                }
                int n20 = n2;
                nArray3[n20] = nArray3[n20] - this.maxShiftedSourceValue[nArray[n3 - this.sourceHistoryEmbedLength][n11]];
                int n21 = n2;
                nArray3[n21] = nArray3[n21] * this.base;
                int n22 = n2;
                nArray3[n22] = nArray3[n22] + nArray[n3][n11];
            }
        }
    }

    public void addObservations(int[][][] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = nArray.length;
        if (n8 == 0) {
            return;
        }
        int n9 = nArray[0].length;
        if (n9 == 0) {
            return;
        }
        int n10 = nArray[0][0].length;
        this.observations = this.periodicBoundaryConditions ? (this.observations += (n8 - this.startObservationTime) * n9 * n10) : (this.observations += (n8 - this.startObservationTime) * (n9 - Math.abs(n)) * (n10 - Math.abs(n2)));
        int[][] nArray2 = new int[n9][n10];
        for (int i = 0; i < n9; ++i) {
            for (n7 = 0; n7 < n10; ++n7) {
                nArray2[i][n7] = 0;
                for (n6 = 0; n6 < this.k; ++n6) {
                    int[] nArray3 = nArray2[i];
                    int n11 = n7;
                    nArray3[n11] = nArray3[n11] * this.base;
                    int[] nArray4 = nArray2[i];
                    int n12 = n7;
                    nArray4[n12] = nArray4[n12] + nArray[this.startObservationTime - this.k + n6][i][n7];
                }
            }
        }
        int[][] nArray5 = new int[n9][n10];
        for (n7 = 0; n7 < n9; ++n7) {
            for (n6 = 0; n6 < n10; ++n6) {
                nArray5[n7][n6] = 0;
                n5 = n7 - n;
                if (n5 < 0 || n5 >= n9) {
                    if (!this.periodicBoundaryConditions) continue;
                    n5 = (n5 + n9) % n9;
                }
                if ((n4 = n6 - n2) < 0 || n4 >= n10) {
                    if (!this.periodicBoundaryConditions) continue;
                    n4 = (n4 + n10) % n10;
                }
                for (n3 = 0; n3 < this.sourceHistoryEmbedLength; ++n3) {
                    int[] nArray6 = nArray5[n7];
                    int n13 = n6;
                    nArray6[n13] = nArray6[n13] * this.base;
                    int[] nArray7 = nArray5[n7];
                    int n14 = n6;
                    nArray7[n14] = nArray7[n14] + nArray[this.startObservationTime - this.sourceHistoryEmbedLength + n3][n5][n4];
                }
            }
        }
        for (n6 = this.startObservationTime; n6 < n8; ++n6) {
            for (n5 = 0; n5 < n9; ++n5) {
                for (n4 = 0; n4 < n10; ++n4) {
                    int n15;
                    n3 = n5 - n;
                    if (n3 < 0 || n3 >= n9) {
                        if (!this.periodicBoundaryConditions) continue;
                        n3 = (n3 + n9) % n9;
                    }
                    if ((n15 = n4 - n2) < 0 || n15 >= n10) {
                        if (!this.periodicBoundaryConditions) continue;
                        n15 = (n15 + n10) % n10;
                    }
                    n7 = nArray[n6][n5][n4];
                    int[] nArray8 = this.sourceNextPastCount[nArray5[n5][n4]][n7];
                    int n16 = nArray2[n5][n4];
                    nArray8[n16] = nArray8[n16] + 1;
                    int[] nArray9 = this.sourcePastCount[nArray5[n5][n4]];
                    int n17 = nArray2[n5][n4];
                    nArray9[n17] = nArray9[n17] + 1;
                    int[] nArray10 = this.nextPastCount[n7];
                    int n18 = nArray2[n5][n4];
                    nArray10[n18] = nArray10[n18] + 1;
                    int n19 = nArray2[n5][n4];
                    this.pastCount[n19] = this.pastCount[n19] + 1;
                    int n20 = n7;
                    this.nextCount[n20] = this.nextCount[n20] + 1;
                    if (this.k > 0) {
                        int[] nArray11 = nArray2[n5];
                        int n21 = n4;
                        nArray11[n21] = nArray11[n21] - this.maxShiftedValue[nArray[n6 - this.k][n5][n4]];
                        int[] nArray12 = nArray2[n5];
                        int n22 = n4;
                        nArray12[n22] = nArray12[n22] * this.base;
                        int[] nArray13 = nArray2[n5];
                        int n23 = n4;
                        nArray13[n23] = nArray13[n23] + nArray[n6][n5][n4];
                    }
                    int[] nArray14 = nArray5[n5];
                    int n24 = n4;
                    nArray14[n24] = nArray14[n24] - this.maxShiftedSourceValue[nArray[n6 - this.sourceHistoryEmbedLength][n3][n15]];
                    int[] nArray15 = nArray5[n5];
                    int n25 = n4;
                    nArray15[n25] = nArray15[n25] * this.base;
                    int[] nArray16 = nArray5[n5];
                    int n26 = n4;
                    nArray16[n26] = nArray16[n26] + nArray[n6][n3][n15];
                }
            }
        }
    }

    @Override
    public void addObservations(int[][] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = nArray.length;
        this.observations += n5 - this.startObservationTime;
        int n6 = 0;
        for (n4 = 0; n4 < this.k; ++n4) {
            n6 *= this.base;
            n6 += nArray[this.startObservationTime - this.k + n4][n2];
        }
        n4 = 0;
        for (n3 = 0; n3 < this.sourceHistoryEmbedLength; ++n3) {
            n4 *= this.base;
            n4 += nArray[this.startObservationTime - this.sourceHistoryEmbedLength + n3][n];
        }
        for (int i = this.startObservationTime; i < n5; ++i) {
            n3 = nArray[i][n2];
            int[] nArray2 = this.sourceNextPastCount[n4][n3];
            int n7 = n6;
            nArray2[n7] = nArray2[n7] + 1;
            int[] nArray3 = this.sourcePastCount[n4];
            int n8 = n6;
            nArray3[n8] = nArray3[n8] + 1;
            int[] nArray4 = this.nextPastCount[n3];
            int n9 = n6;
            nArray4[n9] = nArray4[n9] + 1;
            int n10 = n6;
            this.pastCount[n10] = this.pastCount[n10] + 1;
            int n11 = n3;
            this.nextCount[n11] = this.nextCount[n11] + 1;
            if (this.k > 0) {
                n6 -= this.maxShiftedValue[nArray[i - this.k][n2]];
                n6 *= this.base;
                n6 += nArray[i][n2];
            }
            n4 -= this.maxShiftedSourceValue[nArray[i - this.sourceHistoryEmbedLength][n]];
            n4 *= this.base;
            n4 += nArray[i][n];
        }
    }

    public void addObservations(int[][][] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = nArray.length;
        this.observations += n7 - this.startObservationTime;
        int n8 = 0;
        for (n6 = 0; n6 < this.k; ++n6) {
            n8 *= this.base;
            n8 += nArray[this.startObservationTime - this.k + n6][n3][n4];
        }
        n6 = 0;
        for (n5 = 0; n5 < this.sourceHistoryEmbedLength; ++n5) {
            n6 *= this.base;
            n6 += nArray[this.startObservationTime - this.sourceHistoryEmbedLength + n5][n][n2];
        }
        for (int i = this.startObservationTime; i < n7; ++i) {
            n5 = nArray[i][n3][n4];
            int[] nArray2 = this.sourceNextPastCount[n6][n5];
            int n9 = n8;
            nArray2[n9] = nArray2[n9] + 1;
            int[] nArray3 = this.sourcePastCount[n6];
            int n10 = n8;
            nArray3[n10] = nArray3[n10] + 1;
            int[] nArray4 = this.nextPastCount[n5];
            int n11 = n8;
            nArray4[n11] = nArray4[n11] + 1;
            int n12 = n8;
            this.pastCount[n12] = this.pastCount[n12] + 1;
            int n13 = n5;
            this.nextCount[n13] = this.nextCount[n13] + 1;
            if (this.k > 0) {
                n8 -= this.maxShiftedValue[nArray[i - this.k][n3][n4]];
                n8 *= this.base;
                n8 += nArray[i][n3][n4];
            }
            n6 -= this.maxShiftedSourceValue[nArray[i - this.sourceHistoryEmbedLength][n][n2]];
            n6 *= this.base;
            n6 += nArray[i][n][n2];
        }
    }

    public int getPastCount(int n) {
        return this.pastCount[n];
    }

    public double getPastProbability(int n) {
        return (double)this.pastCount[n] / (double)this.observations;
    }

    public int getNextPastCount(int n, int n2) {
        return this.nextPastCount[n][n2];
    }

    public double getNextPastProbability(int n, int n2) {
        return (double)this.nextPastCount[n][n2] / (double)this.observations;
    }

    public int getSourcePastCount(int n, int n2) {
        return this.sourcePastCount[n][n2];
    }

    public double getSourcePastProbability(int n, int n2) {
        return (double)this.sourcePastCount[n][n2] / (double)this.observations;
    }

    public int getSourceNextPastCount(int n, int n2, int n3) {
        return this.sourceNextPastCount[n][n2][n3];
    }

    public double getSourceNextPastProbability(int n, int n2, int n3) {
        return (double)this.sourceNextPastCount[n][n2][n3] / (double)this.observations;
    }

    public int getNextCount(int n) {
        return this.nextCount[n];
    }

    public double getNextProbability(int n) {
        return (double)this.nextCount[n] / (double)this.observations;
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.base_power_k; ++i) {
            for (int j = 0; j < this.base; ++j) {
                for (int k = 0; k < this.base_power_l; ++k) {
                    double d4 = (double)this.sourceNextPastCount[k][j][i] / (double)this.observations;
                    if (this.sourceNextPastCount[k][j][i] != 0) {
                        double d5 = (double)this.sourceNextPastCount[k][j][i] / (double)this.sourcePastCount[k][i] / ((double)this.nextPastCount[j][i] / (double)this.pastCount[i]);
                        double d6 = Math.log(d5) / this.log_2;
                        d2 = d4 * d6;
                        if (d6 > this.max) {
                            this.max = d6;
                        } else if (d6 < this.min) {
                            this.min = d6;
                        }
                        d3 += d2 * d6;
                    } else {
                        d2 = 0.0;
                    }
                    d += d2;
                }
            }
        }
        this.average = d;
        this.std = Math.sqrt(d3 - this.average * this.average);
        this.estimateComputed = true;
        return d;
    }

    public double computeAverageActiveInfoStorageOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.base; ++i) {
            double d3 = (double)this.nextCount[i] / (double)this.observations;
            for (int j = 0; j < this.base_power_k; ++j) {
                if (this.nextPastCount[i][j] != 0) {
                    double d4 = (double)this.nextPastCount[i][j] / (double)this.pastCount[j] / d3;
                    double d5 = Math.log(d4) / this.log_2;
                    d2 = (double)this.nextPastCount[i][j] / (double)this.observations * d5;
                } else {
                    d2 = 0.0;
                }
                d += d2;
            }
        }
        return d;
    }

    public void debugPrintObservations() {
        System.out.println("Src\tDst\tPast\tc(s,d,p)\tc(s,p)\tc(d,p)\tc(p)");
        for (int i = 0; i < this.base_power_k; ++i) {
            for (int j = 0; j < this.base; ++j) {
                for (int k = 0; k < this.base_power_l; ++k) {
                    System.out.println(k + "\t" + j + "\t" + i + "\t" + this.sourceNextPastCount[k][j][i] + "\t\t" + this.sourcePastCount[k][i] + "\t" + this.nextPastCount[j][i] + "\t" + this.pastCount[i]);
                }
            }
        }
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) {
        int n2;
        double d = this.computeAverageLocalOfObservations();
        int[] nArray = new int[this.observations];
        int n3 = 0;
        for (int i = 0; i < this.base_power_l; ++i) {
            int n4 = 0;
            for (n2 = 0; n2 < this.base_power_k; ++n2) {
                n4 += this.sourcePastCount[i][n2];
            }
            MatrixUtils.fill(nArray, i, n3, n4);
            n3 += n4;
        }
        int[] nArray2 = new int[this.observations];
        int[] nArray3 = new int[this.observations];
        n2 = 0;
        int n5 = 0;
        for (int i = 0; i < this.base_power_k; ++i) {
            MatrixUtils.fill(nArray3, i, n5, this.pastCount[i]);
            n5 += this.pastCount[i];
            for (int j = 0; j < this.base; ++j) {
                MatrixUtils.fill(nArray2, j, n2, this.nextPastCount[j][i]);
                n2 += this.nextPastCount[j][i];
            }
        }
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray4 = randomGenerator.generateRandomPerturbations(this.observations, n);
        TransferEntropyCalculatorDiscrete transferEntropyCalculatorDiscrete = new TransferEntropyCalculatorDiscrete(this.base_power_l, this.k, 1);
        transferEntropyCalculatorDiscrete.initialise();
        transferEntropyCalculatorDiscrete.observations = this.observations;
        transferEntropyCalculatorDiscrete.pastCount = this.pastCount;
        transferEntropyCalculatorDiscrete.nextPastCount = this.nextPastCount;
        int n6 = 0;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n);
        for (int i = 0; i < n; ++i) {
            double d2;
            int[] nArray5 = MatrixUtils.extractSelectedTimePoints(nArray, nArray4[i]);
            MatrixUtils.fill(transferEntropyCalculatorDiscrete.sourceNextPastCount, 0);
            MatrixUtils.fill(transferEntropyCalculatorDiscrete.sourcePastCount, 0);
            for (int j = 0; j < this.observations; ++j) {
                int[] nArray6 = transferEntropyCalculatorDiscrete.sourcePastCount[nArray5[j]];
                int n7 = nArray3[j];
                nArray6[n7] = nArray6[n7] + 1;
                int[] nArray7 = transferEntropyCalculatorDiscrete.sourceNextPastCount[nArray5[j]][nArray2[j]];
                int n8 = nArray3[j];
                nArray7[n8] = nArray7[n8] + 1;
            }
            empiricalMeasurementDistribution.distribution[i] = d2 = transferEntropyCalculatorDiscrete.computeAverageLocalOfObservations();
            if (!(d2 >= d)) continue;
            ++n6;
        }
        empiricalMeasurementDistribution.pValue = (double)n6 / (double)n;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    @Override
    public AnalyticMeasurementDistribution computeSignificance() throws Exception {
        if (!this.estimateComputed) {
            this.computeAverageLocalOfObservations();
        }
        return new ChiSquareMeasurementDistribution(2.0 * (double)this.observations * this.average, (this.sourceHistoryEmbedLength * this.base - 1) * (this.base - 1) * (this.k * this.base));
    }

    public double computeLocalFromPreviousObservations(int n, int n2, int n3) {
        double d = (double)this.sourceNextPastCount[n][n2][n3] / (double)this.sourcePastCount[n][n3] / ((double)this.nextPastCount[n2][n3] / (double)this.pastCount[n3]);
        return Math.log(d) / this.log_2;
    }

    public double[] computeLocalFromPreviousObservations(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3 = nArray2.length;
        double[] dArray = new double[n3];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n4 = 0;
        for (n2 = 0; n2 < this.k; ++n2) {
            n4 *= this.base;
            n4 += nArray2[this.startObservationTime - this.k + n2];
        }
        n2 = 0;
        for (n = 0; n < this.sourceHistoryEmbedLength; ++n) {
            n2 *= this.base;
            n2 += nArray[this.startObservationTime - this.sourceHistoryEmbedLength + n];
        }
        for (int i = this.startObservationTime; i < n3; ++i) {
            n = nArray2[i];
            double d = (double)this.sourceNextPastCount[n2][n][n4] / (double)this.sourcePastCount[n2][n4] / ((double)this.nextPastCount[n][n4] / (double)this.pastCount[n4]);
            dArray[i] = Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            if (this.k > 0) {
                n4 -= this.maxShiftedValue[nArray2[i - this.k]];
                n4 *= this.base;
                n4 += nArray2[i];
            }
            n2 -= this.maxShiftedSourceValue[nArray[i - this.sourceHistoryEmbedLength]];
            n2 *= this.base;
            n2 += nArray[i];
        }
        this.average /= (double)(n3 - this.startObservationTime);
        return dArray;
    }

    public double[][] computeLocalFromPreviousObservations(int[][] nArray, int n) {
        int n2;
        int n3 = nArray.length;
        int n4 = nArray[0].length;
        double[][] dArray = new double[n3][n4];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray2[i] = 0;
            for (n2 = 0; n2 < this.k; ++n2) {
                int n5 = i;
                nArray2[n5] = nArray2[n5] * this.base;
                int n6 = i;
                nArray2[n6] = nArray2[n6] + nArray[this.startObservationTime - this.k + n2][i];
            }
        }
        int[] nArray3 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray3[n2] = 0;
            int n7 = n2 - n;
            if (n7 < 0 || n7 >= n4) {
                if (!this.periodicBoundaryConditions) continue;
                n7 = (n7 + n4) % n4;
            }
            for (int i = 0; i < this.sourceHistoryEmbedLength; ++i) {
                int n8 = n2;
                nArray3[n8] = nArray3[n8] * this.base;
                int n9 = n2;
                nArray3[n9] = nArray3[n9] + nArray[this.startObservationTime - this.sourceHistoryEmbedLength + i][n7];
            }
        }
        for (int i = this.startObservationTime; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n10 = j - n;
                if (n10 < 0 || n10 >= n4) {
                    if (!this.periodicBoundaryConditions) continue;
                    n10 = (n10 + n4) % n4;
                }
                n2 = nArray[i][j];
                double d = (double)this.sourceNextPastCount[nArray3[j]][n2][nArray2[j]] / (double)this.sourcePastCount[nArray3[j]][nArray2[j]] / ((double)this.nextPastCount[n2][nArray2[j]] / (double)this.pastCount[nArray2[j]]);
                dArray[i][j] = Math.log(d) / this.log_2;
                this.average += dArray[i][j];
                if (dArray[i][j] > this.max) {
                    this.max = dArray[i][j];
                } else if (dArray[i][j] < this.min) {
                    this.min = dArray[i][j];
                }
                if (this.k > 0) {
                    int n11 = j;
                    nArray2[n11] = nArray2[n11] - this.maxShiftedValue[nArray[i - this.k][j]];
                    int n12 = j;
                    nArray2[n12] = nArray2[n12] * this.base;
                    int n13 = j;
                    nArray2[n13] = nArray2[n13] + nArray[i][j];
                }
                int n14 = j;
                nArray3[n14] = nArray3[n14] - this.maxShiftedSourceValue[nArray[i - this.sourceHistoryEmbedLength][n10]];
                int n15 = j;
                nArray3[n15] = nArray3[n15] * this.base;
                int n16 = j;
                nArray3[n16] = nArray3[n16] + nArray[i][n10];
            }
        }
        this.average = this.periodicBoundaryConditions ? (this.average /= (double)((n3 - this.startObservationTime) * n4)) : (this.average /= (double)((n3 - this.startObservationTime) * (n4 - Math.abs(n))));
        return dArray;
    }

    public double[][][] computeLocalFromPreviousObservations(int[][][] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = nArray.length;
        int n8 = nArray[0].length;
        int n9 = nArray[0][0].length;
        double[][][] dArray = new double[n7][n8][n9];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int[][] nArray2 = new int[n8][n9];
        for (int i = 0; i < n8; ++i) {
            for (n6 = 0; n6 < n9; ++n6) {
                nArray2[i][n6] = 0;
                for (n5 = 0; n5 < this.k; ++n5) {
                    int[] nArray3 = nArray2[i];
                    int n10 = n6;
                    nArray3[n10] = nArray3[n10] * this.base;
                    int[] nArray4 = nArray2[i];
                    int n11 = n6;
                    nArray4[n11] = nArray4[n11] + nArray[this.startObservationTime - this.k + n5][i][n6];
                }
            }
        }
        int[][] nArray5 = new int[n8][n9];
        for (n6 = 0; n6 < n8; ++n6) {
            for (n5 = 0; n5 < n9; ++n5) {
                nArray5[n6][n5] = 0;
                int n12 = n6 - n;
                if (n12 < 0 || n12 >= n8) {
                    if (!this.periodicBoundaryConditions) continue;
                    n12 = (n12 + n8) % n8;
                }
                if ((n4 = n5 - n2) < 0 || n4 >= n9) {
                    if (!this.periodicBoundaryConditions) continue;
                    n4 = (n4 + n9) % n9;
                }
                for (n3 = 0; n3 < this.sourceHistoryEmbedLength; ++n3) {
                    int[] nArray6 = nArray5[n6];
                    int n13 = n5;
                    nArray6[n13] = nArray6[n13] * this.base;
                    int[] nArray7 = nArray5[n6];
                    int n14 = n5;
                    nArray7[n14] = nArray7[n14] + nArray[this.startObservationTime - this.sourceHistoryEmbedLength + n3][n12][n4];
                }
            }
        }
        for (n4 = this.startObservationTime; n4 < n7; ++n4) {
            for (n3 = 0; n3 < n8; ++n3) {
                for (int i = 0; i < n9; ++i) {
                    int n15;
                    int n16 = n3 - n;
                    if (n16 < 0 || n16 >= n8) {
                        if (!this.periodicBoundaryConditions) continue;
                        n16 = (n16 + n8) % n8;
                    }
                    if ((n15 = i - n2) < 0 || n15 >= n9) {
                        if (!this.periodicBoundaryConditions) continue;
                        n15 = (n15 + n9) % n9;
                    }
                    n6 = nArray[n4][n3][i];
                    double d = (double)this.sourceNextPastCount[nArray5[n3][i]][n6][nArray2[n3][i]] / (double)this.sourcePastCount[nArray5[n3][i]][nArray2[n3][i]] / ((double)this.nextPastCount[n6][nArray2[n3][i]] / (double)this.pastCount[nArray2[n3][i]]);
                    dArray[n4][n3][i] = Math.log(d) / this.log_2;
                    this.average += dArray[n4][n3][i];
                    if (dArray[n4][n3][i] > this.max) {
                        this.max = dArray[n4][n3][i];
                    } else if (dArray[n4][n3][i] < this.min) {
                        this.min = dArray[n4][n3][i];
                    }
                    if (this.k > 0) {
                        int[] nArray8 = nArray2[n3];
                        int n17 = i;
                        nArray8[n17] = nArray8[n17] - this.maxShiftedValue[nArray[n4 - this.k][n3][i]];
                        int[] nArray9 = nArray2[n3];
                        int n18 = i;
                        nArray9[n18] = nArray9[n18] * this.base;
                        int[] nArray10 = nArray2[n3];
                        int n19 = i;
                        nArray10[n19] = nArray10[n19] + nArray[n4][n3][i];
                    }
                    int[] nArray11 = nArray5[n3];
                    int n20 = i;
                    nArray11[n20] = nArray11[n20] - this.maxShiftedSourceValue[nArray[n4 - this.sourceHistoryEmbedLength][n16][n15]];
                    int[] nArray12 = nArray5[n3];
                    int n21 = i;
                    nArray12[n21] = nArray12[n21] * this.base;
                    int[] nArray13 = nArray5[n3];
                    int n22 = i;
                    nArray13[n22] = nArray13[n22] + nArray[n4][n16][n15];
                }
            }
        }
        this.average = this.periodicBoundaryConditions ? (this.average /= (double)((n7 - this.startObservationTime) * n8 * n9)) : (this.average /= (double)((n7 - this.startObservationTime) * (n8 - Math.abs(n)) * (n9 - Math.abs(n2))));
        return dArray;
    }

    public double[] computeLocalFromPreviousObservations(int[][] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = nArray.length;
        double[] dArray = new double[n5];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n6 = 0;
        n6 = 0;
        for (n4 = 0; n4 < this.k; ++n4) {
            n6 *= this.base;
            n6 += nArray[this.startObservationTime - this.k + n4][n2];
        }
        n4 = 0;
        for (n3 = 0; n3 < this.sourceHistoryEmbedLength; ++n3) {
            n4 *= this.base;
            n4 += nArray[this.startObservationTime - this.sourceHistoryEmbedLength + n3][n];
        }
        for (int i = this.startObservationTime; i < n5; ++i) {
            n3 = nArray[i][n2];
            double d = (double)this.sourceNextPastCount[n4][n3][n6] / (double)this.sourcePastCount[n4][n6] / ((double)this.nextPastCount[n3][n6] / (double)this.pastCount[n6]);
            dArray[i] = Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            if (this.k > 0) {
                n6 -= this.maxShiftedValue[nArray[i - this.k][n2]];
                n6 *= this.base;
                n6 += nArray[i][n2];
            }
            n4 -= this.maxShiftedSourceValue[nArray[i - this.sourceHistoryEmbedLength][n]];
            n4 *= this.base;
            n4 += nArray[i][n];
        }
        this.average /= (double)(n5 - this.startObservationTime);
        return dArray;
    }

    public double[] computeLocalFromPreviousObservations(int[][][] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = nArray.length;
        double[] dArray = new double[n7];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        int n8 = 0;
        n8 = 0;
        for (n6 = 0; n6 < this.k; ++n6) {
            n8 *= this.base;
            n8 += nArray[this.startObservationTime - this.k + n6][n3][n4];
        }
        n6 = 0;
        for (n5 = 0; n5 < this.sourceHistoryEmbedLength; ++n5) {
            n6 *= this.base;
            n6 += nArray[this.startObservationTime - this.sourceHistoryEmbedLength + n5][n][n2];
        }
        for (int i = this.startObservationTime; i < n7; ++i) {
            n5 = nArray[i][n3][n4];
            double d = (double)this.sourceNextPastCount[n6][n5][n8] / (double)this.sourcePastCount[n6][n8] / ((double)this.nextPastCount[n5][n8] / (double)this.pastCount[n8]);
            dArray[i] = Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
            } else if (dArray[i] < this.min) {
                this.min = dArray[i];
            }
            if (this.k > 0) {
                n8 -= this.maxShiftedValue[nArray[i - this.k][n3][n4]];
                n8 *= this.base;
                n8 += nArray[i][n3][n4];
            }
            n6 -= this.maxShiftedSourceValue[nArray[i - this.sourceHistoryEmbedLength][n][n2]];
            n6 *= this.base;
            n6 += nArray[i][n][n2];
        }
        this.average /= (double)(n7 - this.startObservationTime);
        return dArray;
    }

    public double[] computeLocal(int[] nArray, int[] nArray2) {
        this.initialise();
        this.addObservations(nArray, nArray2);
        return this.computeLocalFromPreviousObservations(nArray, nArray2);
    }

    public double[][] computeLocal(int[][] nArray, int n) {
        this.initialise();
        this.addObservations(nArray, n);
        return this.computeLocalFromPreviousObservations(nArray, n);
    }

    public double[][][] computeLocal(int[][][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeLocalFromPreviousObservations(nArray, n, n2);
    }

    public double computeAverageLocal(int[][] nArray, int n) {
        this.initialise();
        this.addObservations(nArray, n);
        return this.computeAverageLocalOfObservations();
    }

    public double computeAverageLocal(int[][][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeAverageLocalOfObservations();
    }

    public double[] computeLocal(int[][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeLocalFromPreviousObservations(nArray, n, n2);
    }

    public double[] computeLocal(int[][][] nArray, int n, int n2, int n3, int n4) {
        this.initialise();
        this.addObservations(nArray, n, n2, n3, n4);
        return this.computeLocalFromPreviousObservations(nArray, n, n2, n3, n4);
    }

    public double computeAverageLocal(int[][] nArray, int n, int n2) {
        this.initialise();
        this.addObservations(nArray, n, n2);
        return this.computeAverageLocalOfObservations();
    }

    public double computeAverageLocal(int[][][] nArray, int n, int n2, int n3, int n4) {
        this.initialise();
        this.addObservations(nArray, n, n2, n3, n4);
        return this.computeAverageLocalOfObservations();
    }

    public boolean isPeriodicBoundaryConditions() {
        return this.periodicBoundaryConditions;
    }

    public void setPeriodicBoundaryConditions(boolean bl) {
        this.periodicBoundaryConditions = bl;
    }
}

