/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kernel;

import infodynamics.measures.continuous.kernel.KernelCount;
import infodynamics.utils.MatrixUtils;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class KernelEstimatorMultiVariate
implements Cloneable {
    protected double[] suppliedKernelWidths = null;
    protected double[] kernelWidthsInUse = null;
    protected int dimensions = 1;
    private int[] bins = null;
    private boolean usingIntegerIndexBins = true;
    private boolean useBins = true;
    private double[] mins = null;
    private int[] multipliers = null;
    private int totalObservations = 0;
    private Vector<TimeStampedObservation>[] observations = null;
    private Hashtable<IntArray, Vector<TimeStampedObservation>> observationsByHash = null;
    protected double[][] rawData = null;
    private boolean debug;
    protected boolean makeCorrelatedPointAddedCallback = false;
    protected boolean normalise = true;
    private boolean excludeDynamicCorrelations = false;
    private int timeProximityForDynamicCorrelationExclusion = 100;
    private boolean forceCompareToAll = false;
    private static final int MAX_NUMBER_INTEGER_BINS = 1000000;

    public void initialise(int n, double d) {
        this.dimensions = n;
        this.suppliedKernelWidths = new double[n];
        for (int i = 0; i < n; ++i) {
            this.suppliedKernelWidths[i] = d;
        }
        this.finishInitialisation();
    }

    public void initialise(double[] dArray) {
        this.dimensions = dArray.length;
        this.suppliedKernelWidths = new double[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            this.suppliedKernelWidths[i] = dArray[i];
        }
        this.finishInitialisation();
    }

    private void finishInitialisation() {
        this.observations = null;
        this.observationsByHash = null;
        this.bins = null;
        this.useBins = true;
        this.usingIntegerIndexBins = true;
        this.mins = null;
        this.multipliers = null;
        this.rawData = null;
        this.totalObservations = 0;
        this.kernelWidthsInUse = new double[this.dimensions];
    }

    public void setObservations(double[][] dArray) {
        int n;
        this.totalObservations = dArray.length;
        this.bins = new int[this.dimensions];
        this.mins = new double[this.dimensions];
        this.multipliers = new int[this.dimensions];
        int n2 = 1;
        this.usingIntegerIndexBins = !this.forceCompareToAll;
        this.useBins = true;
        for (n = 0; n < this.dimensions; ++n) {
            this.mins[n] = MatrixUtils.min(dArray, n);
            double d = MatrixUtils.max(dArray, n);
            double d2 = 0.0;
            if (this.normalise) {
                d2 = MatrixUtils.stdDev(dArray, n);
                this.kernelWidthsInUse[n] = this.suppliedKernelWidths[n] * d2;
            } else {
                this.kernelWidthsInUse[n] = this.suppliedKernelWidths[n];
            }
            this.bins[n] = (int)Math.ceil((d - this.mins[n]) / this.kernelWidthsInUse[n]);
            if (this.bins[n] == 0) {
                this.bins[n] = 1;
            }
            this.multipliers[n] = n2;
            if (this.usingIntegerIndexBins && (n2 *= this.bins[n]) > 1000000) {
                this.usingIntegerIndexBins = false;
            }
            if (!this.debug) continue;
            System.out.println("Dim: " + n + " => Max: " + d + ", min: " + this.mins[n] + ", bins: " + this.bins[n] + (this.normalise ? ", std: " + d2 : "") + ", eps: " + this.kernelWidthsInUse[n]);
        }
        this.observations = null;
        this.observationsByHash = null;
        this.rawData = dArray;
        if (this.usingIntegerIndexBins) {
            if (this.debug) {
                System.out.println("Multidimensional bins: " + n2);
            }
            this.observations = new Vector[n2];
            for (n = 0; n < n2; ++n) {
                this.observations[n] = new Vector();
            }
            for (n = 0; n < dArray.length; ++n) {
                int n3 = this.getMultiDimBinIndex(dArray[n]);
                TimeStampedObservation timeStampedObservation = new TimeStampedObservation(n, dArray[n]);
                this.observations[n3].add(timeStampedObservation);
            }
        } else {
            int n4;
            n = 1;
            for (n4 = 0; n4 < this.dimensions; ++n4) {
                if (n > 0x2AAAAAAA) {
                    n = Integer.MAX_VALUE;
                    break;
                }
                n *= 3;
            }
            if (this.forceCompareToAll || this.totalObservations < n) {
                this.useBins = false;
            } else {
                this.useBins = true;
                if (this.debug) {
                    System.out.println("Using array hash index bins");
                }
                this.observationsByHash = new Hashtable();
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    int[] nArray = this.getMultiDimBinArray(dArray[n4]);
                    IntArray intArray = new IntArray(nArray);
                    Vector<TimeStampedObservation> vector = this.observationsByHash.get(intArray);
                    if (vector == null) {
                        vector = new Vector();
                    }
                    TimeStampedObservation timeStampedObservation = new TimeStampedObservation(n4, dArray[n4]);
                    vector.add(timeStampedObservation);
                    this.observationsByHash.put(intArray, vector);
                }
            }
        }
    }

    public void setObservations(double[][] dArray, double[][] dArray2) throws Exception {
        int n = dArray.length;
        if (dArray == null || dArray2 == null) {
            throw new Exception("Cannot have null data arguments");
        }
        if (dArray.length != dArray2.length) {
            throw new Exception("Length of data1 (" + dArray.length + ") is not equal to the length of data2 (" + dArray2.length + ")");
        }
        int n2 = dArray[0].length;
        int n3 = dArray2[0].length;
        double[][] dArray3 = new double[n][n2 + n3];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(dArray[i], 0, dArray3[i], 0, n2);
            System.arraycopy(dArray2[i], 0, dArray3[i], n2, n3);
        }
        this.setObservations(dArray3);
    }

    public void setObservations(double[] dArray, double[] dArray2) throws Exception {
        int n = dArray.length;
        if (dArray == null || dArray2 == null) {
            throw new Exception("Cannot have null data arguments");
        }
        if (dArray.length != dArray2.length) {
            throw new Exception("Length of data1 (" + dArray.length + ") is not equal to the length of data2 (" + dArray2.length + ")");
        }
        double[][] dArray3 = new double[n][2];
        MatrixUtils.copyIntoColumn(dArray3, 0, dArray);
        MatrixUtils.copyIntoColumn(dArray3, 1, dArray2);
        this.setObservations(dArray3);
    }

    public double getProbability(double[] dArray) {
        if (this.useBins) {
            return this.getProbabilityFromBins(dArray, 0, false);
        }
        return this.getProbabilityComparingToAll(dArray, 0, false);
    }

    public double getProbability(double[] dArray, int n) {
        if (this.useBins) {
            return this.getProbabilityFromBins(dArray, n, this.excludeDynamicCorrelations);
        }
        return this.getProbabilityComparingToAll(dArray, n, this.excludeDynamicCorrelations);
    }

    public double getProbability(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return this.getProbability(dArray3);
    }

    public double getProbability(double[] dArray, double[] dArray2, int n) {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return this.getProbability(dArray3, n);
    }

    public int getCount(double[] dArray) {
        KernelCount kernelCount = this.useBins ? this.getCountFromBins(dArray, 0, false) : this.getCountComparingToAll(dArray, 0, false);
        return kernelCount.count;
    }

    public int getCount(double[] dArray, int n) {
        KernelCount kernelCount = this.useBins ? this.getCountFromBins(dArray, n, this.excludeDynamicCorrelations) : this.getCountComparingToAll(dArray, n, this.excludeDynamicCorrelations);
        return kernelCount.count;
    }

    public KernelCount getCompleteKernelCount(double[] dArray, int n, boolean bl) {
        KernelCount kernelCount = this.useBins ? this.getCountFromBins(dArray, n, this.excludeDynamicCorrelations, bl) : this.getCountComparingToAll(dArray, n, this.excludeDynamicCorrelations, bl);
        return kernelCount;
    }

    public int getCount(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return this.getCount(dArray3);
    }

    public int getCount(double[] dArray, double[] dArray2, int n) {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return this.getCount(dArray3, n);
    }

    public KernelCount getCompleteKernelCount(double[] dArray, double[] dArray2, int n, boolean bl) {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return this.getCompleteKernelCount(dArray3, n, bl);
    }

    private KernelCount getCountFromBins(double[] dArray, int n, boolean bl) {
        return this.getCountFromBins(dArray, n, bl, false);
    }

    protected KernelCount getCountFromBins(double[] dArray, int n, boolean bl, boolean bl2) {
        Vector<TimeStampedObservation> vector;
        int n2;
        Object object;
        int n3;
        int n4;
        boolean[] blArray = null;
        if (bl2) {
            blArray = new boolean[this.totalObservations];
        }
        int n5 = 0;
        int[] nArray = null;
        if (this.usingIntegerIndexBins) {
            n5 = this.getMultiDimBinIndex(dArray);
            n4 = this.observations[n5].size();
            if (bl2 || this.makeCorrelatedPointAddedCallback) {
                for (n3 = 0; n3 < this.observations[n5].size(); ++n3) {
                    object = this.observations[n5].elementAt(n3);
                    if (bl2) {
                        blArray[((TimeStampedObservation)object).timeStep] = true;
                    }
                    if (!this.makeCorrelatedPointAddedCallback) continue;
                    this.correlatedPointAddedCallback(((TimeStampedObservation)object).timeStep);
                }
            }
        } else {
            nArray = this.getMultiDimBinArray(dArray);
            IntArray intArray = new IntArray(nArray);
            object = this.observationsByHash.get(intArray);
            n4 = ((Vector)object).size();
            if (bl2 || this.makeCorrelatedPointAddedCallback) {
                for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
                    vector = ((Vector)object).elementAt(n2);
                    if (bl2) {
                        blArray[((TimeStampedObservation)((Object)vector)).timeStep] = true;
                    }
                    if (!this.makeCorrelatedPointAddedCallback) continue;
                    this.correlatedPointAddedCallback(((TimeStampedObservation)((Object)vector)).timeStep);
                }
            }
        }
        n3 = this.totalObservations;
        if (bl) {
            int n6 = n >= this.timeProximityForDynamicCorrelationExclusion ? this.timeProximityForDynamicCorrelationExclusion - 1 : n;
            n6 += this.totalObservations - n >= this.timeProximityForDynamicCorrelationExclusion ? this.timeProximityForDynamicCorrelationExclusion - 1 : this.totalObservations - n - 1;
            n3 -= ++n6;
            n2 = 0;
            if (n6 * this.dimensions < n4) {
                for (int i = Math.max(0, n - this.timeProximityForDynamicCorrelationExclusion + 1); i < Math.min(this.totalObservations, n + this.timeProximityForDynamicCorrelationExclusion); ++i) {
                    int n7 = this.getMultiDimBinIndex(this.rawData[i]);
                    if (n7 != n5) continue;
                    ++n2;
                    if (bl2) {
                        blArray[i] = false;
                    }
                    if (!this.makeCorrelatedPointAddedCallback) continue;
                    this.correlatedPointRemovedCallback(i);
                }
            } else if (this.usingIntegerIndexBins) {
                for (int i = 0; i < this.observations[n5].size(); ++i) {
                    TimeStampedObservation timeStampedObservation = this.observations[n5].elementAt(i);
                    if (Math.abs(timeStampedObservation.timeStep - n) >= this.timeProximityForDynamicCorrelationExclusion) continue;
                    ++n2;
                    if (bl2) {
                        blArray[timeStampedObservation.timeStep] = false;
                    }
                    if (!this.makeCorrelatedPointAddedCallback) continue;
                    this.correlatedPointRemovedCallback(timeStampedObservation.timeStep);
                }
            } else {
                vector = this.observationsByHash.get(nArray);
                if (vector != null) {
                    for (int i = 0; i < vector.size(); ++i) {
                        TimeStampedObservation timeStampedObservation = (TimeStampedObservation)vector.elementAt(i);
                        if (Math.abs(timeStampedObservation.timeStep - n) >= this.timeProximityForDynamicCorrelationExclusion) continue;
                        ++n2;
                        if (bl2) {
                            blArray[timeStampedObservation.timeStep] = false;
                        }
                        if (!this.makeCorrelatedPointAddedCallback) continue;
                        this.correlatedPointRemovedCallback(timeStampedObservation.timeStep);
                    }
                }
            }
            n4 -= n2;
        }
        int[] nArray2 = new int[this.dimensions];
        n4 += this.addCount(dArray, nArray2, 0, this.getBinIndex(dArray[0], 0) - 1, false, bl, n, blArray);
        n4 += this.addCount(dArray, nArray2, 0, this.getBinIndex(dArray[0], 0), true, bl, n, blArray);
        KernelCount kernelCount = new KernelCount(n4 += this.addCount(dArray, nArray2, 0, this.getBinIndex(dArray[0], 0) + 1, false, bl, n, blArray), n3, blArray);
        return kernelCount;
    }

    private double getProbabilityFromBins(double[] dArray, int n, boolean bl) {
        KernelCount kernelCount = this.getCountFromBins(dArray, n, bl);
        return (double)kernelCount.count / (double)kernelCount.totalObservationsForCount;
    }

    private KernelCount getCountComparingToAll(double[] dArray, int n, boolean bl) {
        return this.getCountComparingToAll(dArray, n, bl, false);
    }

    protected KernelCount getCountComparingToAll(double[] dArray, int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4 = 0;
        boolean[] blArray = null;
        if (bl2) {
            blArray = new boolean[this.totalObservations];
        }
        for (n3 = 0; n3 < this.totalObservations; ++n3) {
            if (bl && Math.abs(n3 - n) < this.timeProximityForDynamicCorrelationExclusion) continue;
            n2 = this.stepKernel(dArray, this.rawData[n3]);
            n4 += n2;
            if (bl2) {
                boolean bl3 = blArray[n3] = n2 > 0;
            }
            if (!this.makeCorrelatedPointAddedCallback || n2 <= 0) continue;
            this.correlatedPointAddedCallback(n3);
        }
        n3 = this.totalObservations;
        if (bl) {
            n2 = n >= this.timeProximityForDynamicCorrelationExclusion ? this.timeProximityForDynamicCorrelationExclusion - 1 : n;
            n2 += this.totalObservations - n >= this.timeProximityForDynamicCorrelationExclusion ? this.timeProximityForDynamicCorrelationExclusion - 1 : this.totalObservations - n - 1;
            n3 -= ++n2;
        }
        KernelCount kernelCount = new KernelCount(n4, n3, blArray);
        return kernelCount;
    }

    private double getProbabilityComparingToAll(double[] dArray, int n, boolean bl) {
        KernelCount kernelCount = this.getCountComparingToAll(dArray, n, bl);
        return (double)kernelCount.count / (double)kernelCount.totalObservationsForCount;
    }

    private int getBinIndex(double d, int n) {
        int n2 = (int)Math.floor((d - this.mins[n]) / this.kernelWidthsInUse[n]);
        if (n2 >= this.bins[n]) {
            n2 = this.bins[n] - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    public int getMultiDimBinIndex(double[] dArray) {
        int n = 0;
        for (int i = 0; i < this.dimensions; ++i) {
            n += this.getBinIndex(dArray[i], i) * this.multipliers[i];
        }
        return n;
    }

    public int[] getMultiDimBinArray(double[] dArray) {
        int[] nArray = new int[this.dimensions];
        for (int i = 0; i < this.dimensions; ++i) {
            nArray[i] = this.getBinIndex(dArray[i], i);
        }
        return nArray;
    }

    public int getMultiDimBinIndexFromSingles(int[] nArray) {
        int n = 0;
        for (int i = 0; i < this.dimensions; ++i) {
            n += nArray[i] * this.multipliers[i];
        }
        return n;
    }

    private int addCount(double[] dArray, int[] nArray, int n, int n2, boolean bl, boolean bl2, int n3, boolean[] blArray) {
        int n4 = 0;
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= this.bins[n]) {
            return 0;
        }
        nArray[n] = n2;
        if (n == this.dimensions - 1) {
            if (bl) {
                return 0;
            }
            if (this.usingIntegerIndexBins) {
                int n5 = this.getMultiDimBinIndexFromSingles(nArray);
                for (int i = 0; i < this.observations[n5].size(); ++i) {
                    TimeStampedObservation timeStampedObservation = this.observations[n5].elementAt(i);
                    if (bl2 && Math.abs(timeStampedObservation.timeStep - n3) < this.timeProximityForDynamicCorrelationExclusion) continue;
                    int n6 = this.stepKernel(dArray, timeStampedObservation.observation);
                    n4 += n6;
                    if (blArray != null) {
                        boolean bl3 = blArray[timeStampedObservation.timeStep] = n6 > 0;
                    }
                    if (!this.makeCorrelatedPointAddedCallback || n6 <= 0) continue;
                    this.correlatedPointAddedCallback(timeStampedObservation.timeStep);
                }
            } else {
                IntArray intArray = new IntArray(nArray);
                Vector<TimeStampedObservation> vector = this.observationsByHash.get(intArray);
                if (vector != null) {
                    for (int i = 0; i < vector.size(); ++i) {
                        TimeStampedObservation timeStampedObservation = vector.elementAt(i);
                        if (bl2 && Math.abs(timeStampedObservation.timeStep - n3) < this.timeProximityForDynamicCorrelationExclusion) continue;
                        int n7 = this.stepKernel(dArray, timeStampedObservation.observation);
                        n4 += n7;
                        if (blArray != null) {
                            boolean bl4 = blArray[timeStampedObservation.timeStep] = n7 > 0;
                        }
                        if (!this.makeCorrelatedPointAddedCallback || n7 <= 0) continue;
                        this.correlatedPointAddedCallback(timeStampedObservation.timeStep);
                    }
                }
            }
        } else {
            n4 += this.addCount(dArray, nArray, n + 1, this.getBinIndex(dArray[n + 1], n + 1) - 1, false, bl2, n3, blArray);
            n4 += this.addCount(dArray, nArray, n + 1, this.getBinIndex(dArray[n + 1], n + 1), bl, bl2, n3, blArray);
            n4 += this.addCount(dArray, nArray, n + 1, this.getBinIndex(dArray[n + 1], n + 1) + 1, false, bl2, n3, blArray);
        }
        return n4;
    }

    public int stepKernel(double[] dArray, double[] dArray2) {
        for (int i = 0; i < this.dimensions; ++i) {
            if (!(Math.abs(dArray[i] - dArray2[i]) > this.kernelWidthsInUse[i])) continue;
            return 0;
        }
        return 1;
    }

    public double[] getKernelWidthsInUse() {
        return this.kernelWidthsInUse;
    }

    public void setNormalise(boolean bl) {
        this.normalise = bl;
    }

    public boolean isNormalise() {
        return this.normalise;
    }

    public void setDynamicCorrelationExclusion(int n) {
        this.excludeDynamicCorrelations = true;
        this.timeProximityForDynamicCorrelationExclusion = n;
    }

    public void clearDynamicCorrelationExclusion() {
        this.excludeDynamicCorrelations = false;
    }

    public boolean isExcludeDynamicCorrelations() {
        return this.excludeDynamicCorrelations;
    }

    public boolean isForceCompareToAll() {
        return this.forceCompareToAll;
    }

    public void setForceCompareToAll(boolean bl) {
        this.forceCompareToAll = bl;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    protected void correlatedPointAddedCallback(int n) {
    }

    protected void correlatedPointRemovedCallback(int n) {
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private class IntArray {
        public int[] array;

        public IntArray(int[] nArray) {
            this.array = nArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public boolean equals(Object object) {
            if (!IntArray.class.isInstance(object)) {
                return false;
            }
            IntArray intArray = (IntArray)object;
            return Arrays.equals(this.array, intArray.array);
        }
    }

    private class TimeStampedObservation {
        public int timeStep;
        public double[] observation;

        TimeStampedObservation(int n, double[] dArray) {
            this.timeStep = n;
            this.observation = dArray;
        }
    }
}

