/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.gaussian;

import infodynamics.measures.continuous.MutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.MutualInfoMultiVariateCommon;
import infodynamics.utils.AnalyticNullDistributionComputer;
import infodynamics.utils.ChiSquareMeasurementDistribution;
import infodynamics.utils.MatrixUtils;

public class MutualInfoCalculatorMultiVariateGaussian
extends MutualInfoMultiVariateCommon
implements MutualInfoCalculatorMultiVariate,
AnalyticNullDistributionComputer,
Cloneable {
    protected double[][] L;
    protected double[][] Lsource;
    protected double[][] Ldest;
    protected double[] means;
    protected double detCovariance;
    protected double detSourceCovariance;
    protected double detDestCovariance;

    @Override
    public void initialise(int n, int n2) {
        super.initialise(n, n2);
        this.L = null;
        this.Lsource = null;
        this.Ldest = null;
        this.means = null;
        this.detCovariance = 0.0;
        this.detSourceCovariance = 0.0;
        this.detDestCovariance = 0.0;
    }

    @Override
    public void finaliseAddObservations() throws Exception {
        super.finaliseAddObservations();
        this.means = new double[this.dimensionsSource + this.dimensionsDest];
        double[] dArray = MatrixUtils.means(this.sourceObservations);
        double[] dArray2 = MatrixUtils.means(this.destObservations);
        System.arraycopy(dArray, 0, this.means, 0, this.dimensionsSource);
        System.arraycopy(dArray2, 0, this.means, this.dimensionsSource, this.dimensionsDest);
        this.setCovariance(MatrixUtils.covarianceMatrix(this.sourceObservations, this.destObservations), true);
    }

    public void setCovariance(double[][] dArray, int n) throws Exception {
        this.setCovariance(dArray, false);
        this.totalObservations = n;
    }

    protected void setCovariance(double[][] dArray, boolean bl) throws Exception {
        int n;
        if (!bl) {
            this.sourceObservations = null;
            this.destObservations = null;
        }
        if ((n = dArray.length) != this.dimensionsSource + this.dimensionsDest) {
            throw new Exception("Supplied covariance matrix does not match initialised number of dimensions");
        }
        this.L = MatrixUtils.CholeskyDecomposition(dArray);
        int[] nArray = MatrixUtils.range(0, this.dimensionsSource - 1);
        double[][] dArray2 = MatrixUtils.selectRowsAndColumns(dArray, nArray, nArray);
        this.Lsource = MatrixUtils.CholeskyDecomposition(dArray2);
        int[] nArray2 = MatrixUtils.range(this.dimensionsSource, this.dimensionsSource + this.dimensionsDest - 1);
        double[][] dArray3 = MatrixUtils.selectRowsAndColumns(dArray, nArray2, nArray2);
        this.Ldest = MatrixUtils.CholeskyDecomposition(dArray3);
    }

    public void setCovarianceAndMeans(double[][] dArray, double[] dArray2, int n) throws Exception {
        this.means = dArray2;
        this.setCovariance(dArray, n);
    }

    @Override
    public double computeAverageLocalOfObservations() throws Exception {
        this.detCovariance = MatrixUtils.determinantViaCholeskyResult(this.L);
        this.detSourceCovariance = MatrixUtils.determinantViaCholeskyResult(this.Lsource);
        this.detDestCovariance = MatrixUtils.determinantViaCholeskyResult(this.Ldest);
        this.lastAverage = 0.5 * Math.log(Math.abs(this.detSourceCovariance * this.detDestCovariance / this.detCovariance));
        this.miComputed = true;
        return this.lastAverage;
    }

    @Override
    public double[] computeLocalOfPreviousObservations() throws Exception {
        if (this.destObservations == null) {
            throw new Exception("Cannot compute local values of previous observations if they have not been set!");
        }
        return this.computeLocalUsingPreviousObservations(this.sourceObservations, this.destObservations, true);
    }

    @Override
    public ChiSquareMeasurementDistribution computeSignificance() {
        return new ChiSquareMeasurementDistribution((double)(2 * this.totalObservations) * this.lastAverage, this.dimensionsSource * this.dimensionsDest);
    }

    @Override
    public int getNumObservations() throws Exception {
        if (this.destObservations == null) {
            throw new Exception("Cannot return number of observations because either this calculator has not had observations supplied or the user supplied the covariance matrix instead of observations");
        }
        return super.getNumObservations();
    }

    @Override
    public double computeAverageLocalOfObservations(int[] nArray) throws Exception {
        if (this.destObservations == null) {
            throw new Exception("Cannot compute local values of previous observations without supplying observations");
        }
        return super.computeAverageLocalOfObservations(nArray);
    }

    @Override
    public double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2) throws Exception {
        return this.computeLocalUsingPreviousObservations(dArray, dArray2, false);
    }

    protected double[] computeLocalUsingPreviousObservations(double[][] dArray, double[][] dArray2, boolean bl) throws Exception {
        int n;
        int n2;
        if (this.means == null) {
            throw new Exception("Cannot compute local values without having means either supplied or computed via setObservations()");
        }
        if (this.detCovariance == 0.0) {
            this.detCovariance = MatrixUtils.determinantViaCholeskyResult(this.L);
            if (this.detCovariance == 0.0) {
                throw new Exception("Covariance matrix is not positive definite");
            }
            this.detSourceCovariance = MatrixUtils.determinantViaCholeskyResult(this.Lsource);
            this.detDestCovariance = MatrixUtils.determinantViaCholeskyResult(this.Ldest);
        }
        double[][] dArray3 = MatrixUtils.solveViaCholeskyResult(this.L, MatrixUtils.identityMatrix(this.L.length));
        double[][] dArray4 = MatrixUtils.solveViaCholeskyResult(this.Lsource, MatrixUtils.identityMatrix(this.Lsource.length));
        double[][] dArray5 = MatrixUtils.solveViaCholeskyResult(this.Ldest, MatrixUtils.identityMatrix(this.Ldest.length));
        double[] dArray6 = MatrixUtils.select(this.means, 0, this.dimensionsSource);
        double[] dArray7 = MatrixUtils.select(this.means, this.dimensionsSource, this.dimensionsDest);
        if (bl && this.addedMoreThanOneObservationSet) {
            n2 = dArray2.length;
            n = 0;
        } else {
            n2 = dArray2.length + this.timeDiff;
            n = this.timeDiff;
        }
        double[] dArray8 = new double[n2];
        for (int i = n; i < dArray2.length; ++i) {
            double d;
            double[] dArray9 = MatrixUtils.subtract(dArray[i - n], dArray6);
            double[] dArray10 = MatrixUtils.subtract(dArray2[i], dArray7);
            double[] dArray11 = MatrixUtils.append(dArray9, dArray10);
            double d2 = MatrixUtils.dotProduct(MatrixUtils.matrixProduct(dArray9, dArray4), dArray9);
            double d3 = Math.exp(-0.5 * d2) / Math.sqrt(this.detSourceCovariance);
            double d4 = MatrixUtils.dotProduct(MatrixUtils.matrixProduct(dArray10, dArray5), dArray10);
            double d5 = Math.exp(-0.5 * d4) / Math.sqrt(this.detDestCovariance);
            double d6 = MatrixUtils.dotProduct(MatrixUtils.matrixProduct(dArray11, dArray3), dArray11);
            double d7 = Math.exp(-0.5 * d6) / Math.sqrt(this.detCovariance);
            dArray8[i] = d = Math.log(d7 / (d3 * d5));
        }
        return dArray8;
    }
}

