(ns clj-slack.chat
  (:use [clj-slack.core :only [slack-request]]))

(defn- parse-extras
  "Takes a sequence and turns it into a hashmap whose keys are strings"
  [extras]
  (let [extras-map (apply hash-map extras)]
    (into {} (for [[k v] extras-map]
               (if (string? k)
                 [k v]
                 [(name k) v])))))

(defn delete
  "Deletes a message."
  [connection timestamp channel-id]
  (slack-request connection "chat.delete" {"ts" timestamp "channel" channel-id}))

(defn post-message
  "Sends a message to a channel."
  [connection channel-id text & extras]
  (let [extras-map (parse-extras extras)]
    (slack-request connection "chat.postMessage" (merge {"channel" channel-id "text" text} extras-map))))

(defn update
  "Sends a message to a channel."
  [connection timestamp channel-id text]
  (slack-request connection "chat.update" {"ts" timestamp "channel" channel-id "text" text}))
