# ring-middleware-mime-versioned
A Clojure library designed to support API versioning in the HTTP `Accept` request header via Vendor MIME Types.

## Rationale
In his post [Nobody Understands REST or HTTP](http://blog.steveklabnik.com/posts/2011-07-03-nobody-understands-rest-or-http#i_want_my_api_to_be_versioned), Steve Klabnik argues for custom MIME types in the HTTP `Accept` request header as a way to version an API.

Using this header, as opposed to coding in the URL, is analogous to asking for a representation of a resource, rather than naming the resource after the version number.

The example request he provides is:

```
GET /accounts/1 HTTP/1.1
Accept: application/vnd.steveklabnik-v2+json
```

As you can see, this keeps the concept of a particular account (`/accounts/1`) separate from the representation of it (`application/vnd.steveklabnik-v2+json`).

This library is meant to be a drop-in way of passing in this version info to a [Ring](https://github.com/ring-clojure/ring) request handler.

**Note:** Vendor MIME Types are documented in [RFC4288](http://tools.ietf.org/html/rfc4288#section-3.2).

## Installation
TODO.

## Usage
`ring-middleware-mime-versioned` is designed to be injected as a standard Ring middleware layer:

```clojure
(use 'ring.middleware.mime-versioned)

(def app (-> wrap-mime-versioned
             ;; ...additional middleware...
             handler))
```

For requests with a properly formatted `Accept` header (for example, `application/vnd.colindrake-v1+json`), three keys will be added to the request map:

- `bare-mime-type`: the MIME type without vendor information (i.e. `application/json`)
- `mime-vendor`: the custom vendor name (i.e. `colindrake`)
- `version`: the API version (i.e. `v1`)

If no such `Accept` header is provided (or if it is not of the correct format), the request will be passed through unchanged.

When it comes to handler code, `ring-mime-versioned-middleware` is a non-prescriptive library. Issues such as calling out to the proper versions, and rejecting or redirecting clients without versions are left to the handler layer to solve.

## Testing
Run `lein test` to execute the test suite.

## License
Copyright © 2015 [Colin Drake](mailto:colin.f.drake@gmail.com)

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
