<p align="center"><img src="https://raw.github.com/cfdrake/hiro/master/sword.png" /></p>

# hiro
A Clojure wrapper around the [Snowcrash](https://github.com/apiaryio/snowcrash) API Blueprint parser.

## Requirements
Begin by installing [Drafter](https://github.com/apiaryio/drafter), the Snowcrash parser harness.

As of the current date, [Homebrew](http://brew.sh) is the preferred method of installation:

    $ brew install --HEAD \
      https://raw.github.com/apiaryio/drafter/master/tools/homebrew/drafter.rb

## Installation
TODO.

## Usage
hiro exposes a very simple API:

```clojure
(use 'me.colindrake.hiro)

(def blueprint-str (slurp "path/to/blueprint.apib"))
;; FORMAT: 1A9
;; # API Title

(def parsed-blueprint (parse-blueprint blueprint-str))

(:title parsed-blueprint)
;; => "API Title"

(:attributes parsed-blueprint)
;; => {"FORMAT" "1A9"}
```

From here on, the possibilities are endless! You could:

- Generate skeleton code for a **Liberator**/**Compojure** implementation
- Generate API client code using **http-kit**
- Build swanky HTML documentation as a client deliverable
- Or any number of other exciting things!

## License
Copyright © 2015 [Colin Drake](mailto:colin.f.drake@gmail.com)

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.

[Samurai Sword by Adam Zubin from the Noun Project](https://thenounproject.com/term/samurai-sword/145741/)
