(ns clj-infra.shell
  (:require [clojure.java.shell :as sh]
            [clj-infra.core :as infra]))

(defn exec [& args]
  (infra/echo (format "EXEC: '%s'" args))
  (let [{:keys [out err exit]} (apply sh/sh args)]
    (if (= 0 exit)
      out
      (throw (IllegalStateException. (format "Failed to execute '%s': %s/'%s'"
                                             args
                                             exit
                                             err))))))