/*
 * Decompiled with CFR 0.152.
 */
package clojure.asm.commons;

import clojure.asm.Handle;
import clojure.asm.Type;
import clojure.asm.commons.SignatureRemapper;
import clojure.asm.signature.SignatureReader;
import clojure.asm.signature.SignatureVisitor;
import clojure.asm.signature.SignatureWriter;

public abstract class Remapper {
    public String mapDesc(String descriptor2) {
        return this.mapType(Type.getType(descriptor2)).getDescriptor();
    }

    private Type mapType(Type type2) {
        switch (type2.getSort()) {
            case 9: {
                StringBuilder remappedDescriptor = new StringBuilder();
                for (int i = 0; i < type2.getDimensions(); ++i) {
                    remappedDescriptor.append('[');
                }
                remappedDescriptor.append(this.mapType(type2.getElementType()).getDescriptor());
                return Type.getType(remappedDescriptor.toString());
            }
            case 10: {
                String remappedInternalName = this.map(type2.getInternalName());
                return remappedInternalName != null ? Type.getObjectType(remappedInternalName) : type2;
            }
            case 11: {
                return Type.getMethodType(this.mapMethodDesc(type2.getDescriptor()));
            }
        }
        return type2;
    }

    public String mapType(String internalName) {
        if (internalName == null) {
            return null;
        }
        return this.mapType(Type.getObjectType(internalName)).getInternalName();
    }

    public String[] mapTypes(String[] internalNames) {
        String[] remappedInternalNames = null;
        for (int i = 0; i < internalNames.length; ++i) {
            String internalName = internalNames[i];
            String remappedInternalName = this.mapType(internalName);
            if (remappedInternalName == null) continue;
            if (remappedInternalNames == null) {
                remappedInternalNames = new String[internalNames.length];
                System.arraycopy(internalNames, 0, remappedInternalNames, 0, internalNames.length);
            }
            remappedInternalNames[i] = remappedInternalName;
        }
        return remappedInternalNames != null ? remappedInternalNames : internalNames;
    }

    public String mapMethodDesc(String methodDescriptor) {
        if ("()V".equals(methodDescriptor)) {
            return methodDescriptor;
        }
        StringBuilder stringBuilder = new StringBuilder("(");
        for (Type argumentType : Type.getArgumentTypes(methodDescriptor)) {
            stringBuilder.append(this.mapType(argumentType).getDescriptor());
        }
        Type returnType = Type.getReturnType(methodDescriptor);
        if (returnType == Type.VOID_TYPE) {
            stringBuilder.append(")V");
        } else {
            stringBuilder.append(')').append(this.mapType(returnType).getDescriptor());
        }
        return stringBuilder.toString();
    }

    public Object mapValue(Object value) {
        if (value instanceof Type) {
            return this.mapType((Type)value);
        }
        if (value instanceof Handle) {
            Handle handle = (Handle)value;
            return new Handle(handle.getTag(), this.mapType(handle.getOwner()), this.mapMethodName(handle.getOwner(), handle.getName(), handle.getDesc()), this.mapMethodDesc(handle.getDesc()), handle.isInterface());
        }
        return value;
    }

    public String mapSignature(String signature, boolean typeSignature) {
        if (signature == null) {
            return null;
        }
        SignatureReader signatureReader = new SignatureReader(signature);
        SignatureWriter signatureWriter = new SignatureWriter();
        SignatureVisitor signatureRemapper = this.createSignatureRemapper(signatureWriter);
        if (typeSignature) {
            signatureReader.acceptType(signatureRemapper);
        } else {
            signatureReader.accept(signatureRemapper);
        }
        return signatureWriter.toString();
    }

    @Deprecated
    protected SignatureVisitor createRemappingSignatureAdapter(SignatureVisitor signatureVisitor) {
        return this.createSignatureRemapper(signatureVisitor);
    }

    protected SignatureVisitor createSignatureRemapper(SignatureVisitor signatureVisitor) {
        return new SignatureRemapper(signatureVisitor, this);
    }

    public String mapMethodName(String owner, String name2, String descriptor2) {
        return name2;
    }

    public String mapInvokeDynamicMethodName(String name2, String descriptor2) {
        return name2;
    }

    public String mapFieldName(String owner, String name2, String descriptor2) {
        return name2;
    }

    public String mapPackageName(String name2) {
        return name2;
    }

    public String mapModuleName(String name2) {
        return name2;
    }

    public String map(String internalName) {
        return internalName;
    }
}

