/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AReference;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class Namespace
extends AReference
implements Serializable {
    public final Symbol name;
    final transient AtomicReference<IPersistentMap> mappings = new AtomicReference();
    final transient AtomicReference<IPersistentMap> aliases = new AtomicReference();
    static final ConcurrentHashMap<Symbol, Namespace> namespaces = new ConcurrentHashMap();

    public String toString() {
        return this.name.toString();
    }

    Namespace(Symbol name) {
        super(name.meta());
        this.name = name;
        this.mappings.set(RT.DEFAULT_IMPORTS);
        this.aliases.set(RT.map(new Object[0]));
    }

    public static ISeq all() {
        return RT.seq(namespaces.values());
    }

    public Symbol getName() {
        return this.name;
    }

    public IPersistentMap getMappings() {
        return this.mappings.get();
    }

    public Var intern(Symbol sym) {
        Object o;
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't intern namespace-qualified symbol");
        }
        IPersistentMap map = this.getMappings();
        Var v = null;
        while ((o = map.valAt(sym)) == null) {
            if (v == null) {
                v = new Var(this, sym);
            }
            IPersistentMap newMap = map.assoc(sym, v);
            this.mappings.compareAndSet(map, newMap);
            map = this.getMappings();
        }
        if (o instanceof Var && ((Var)o).ns == this) {
            return (Var)o;
        }
        if (v == null) {
            v = new Var(this, sym);
        }
        this.warnOrFailOnReplace(sym, o, v);
        while (!this.mappings.compareAndSet(map, map.assoc(sym, v))) {
            map = this.getMappings();
        }
        return v;
    }

    private void warnOrFailOnReplace(Symbol sym, Object o, Object v) {
        if (o instanceof Var) {
            Namespace ns = ((Var)o).ns;
            if (ns == this || v instanceof Var && ((Var)v).ns == RT.CLOJURE_NS) {
                return;
            }
            if (ns != RT.CLOJURE_NS) {
                throw new IllegalStateException(sym + " already refers to: " + o + " in namespace: " + this.name);
            }
        }
        RT.errPrintWriter().println("WARNING: " + sym + " already refers to: " + o + " in namespace: " + this.name + ", being replaced by: " + v);
    }

    Object reference(Symbol sym, Object val) {
        Object o;
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't intern namespace-qualified symbol");
        }
        IPersistentMap map = this.getMappings();
        while ((o = map.valAt(sym)) == null) {
            IPersistentMap newMap = map.assoc(sym, val);
            this.mappings.compareAndSet(map, newMap);
            map = this.getMappings();
        }
        if (o == val) {
            return o;
        }
        this.warnOrFailOnReplace(sym, o, val);
        while (!this.mappings.compareAndSet(map, map.assoc(sym, val))) {
            map = this.getMappings();
        }
        return val;
    }

    public static boolean areDifferentInstancesOfSameClassName(Class cls1, Class cls2) {
        return cls1 != cls2 && cls1.getName().equals(cls2.getName());
    }

    Class referenceClass(Symbol sym, Class val) {
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't intern namespace-qualified symbol");
        }
        IPersistentMap map = this.getMappings();
        Class c = (Class)map.valAt(sym);
        while (c == null || Namespace.areDifferentInstancesOfSameClassName(c, val)) {
            IPersistentMap newMap = map.assoc(sym, val);
            this.mappings.compareAndSet(map, newMap);
            map = this.getMappings();
            c = (Class)map.valAt(sym);
        }
        if (c == val) {
            return c;
        }
        throw new IllegalStateException(sym + " already refers to: " + c + " in namespace: " + this.name);
    }

    public void unmap(Symbol sym) {
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't unintern namespace-qualified symbol");
        }
        IPersistentMap map = this.getMappings();
        while (map.containsKey(sym)) {
            IPersistentMap newMap = map.without(sym);
            this.mappings.compareAndSet(map, newMap);
            map = this.getMappings();
        }
    }

    public Class importClass(Symbol sym, Class c) {
        return this.referenceClass(sym, c);
    }

    public Class importClass(Class c) {
        String n = c.getName();
        return this.importClass(Symbol.intern(n.substring(n.lastIndexOf(46) + 1)), c);
    }

    public Var refer(Symbol sym, Var var) {
        return (Var)this.reference(sym, var);
    }

    public static Namespace findOrCreate(Symbol name) {
        Namespace ns = namespaces.get(name);
        if (ns != null) {
            return ns;
        }
        Namespace newns = new Namespace(name);
        ns = namespaces.putIfAbsent(name, newns);
        return ns == null ? newns : ns;
    }

    public static Namespace remove(Symbol name) {
        if (name.equals(RT.CLOJURE_NS.name)) {
            throw new IllegalArgumentException("Cannot remove clojure namespace");
        }
        return namespaces.remove(name);
    }

    public static Namespace find(Symbol name) {
        return namespaces.get(name);
    }

    public Object getMapping(Symbol name) {
        return this.mappings.get().valAt(name);
    }

    public Var findInternedVar(Symbol symbol) {
        Object o = this.mappings.get().valAt(symbol);
        if (o != null && o instanceof Var && ((Var)o).ns == this) {
            return (Var)o;
        }
        return null;
    }

    public IPersistentMap getAliases() {
        return this.aliases.get();
    }

    public Namespace lookupAlias(Symbol alias) {
        IPersistentMap map = this.getAliases();
        return (Namespace)map.valAt(alias);
    }

    public void addAlias(Symbol alias, Namespace ns) {
        if (alias == null || ns == null) {
            throw new NullPointerException("Expecting Symbol + Namespace");
        }
        IPersistentMap map = this.getAliases();
        while (!map.containsKey(alias)) {
            IPersistentMap newMap = map.assoc(alias, ns);
            this.aliases.compareAndSet(map, newMap);
            map = this.getAliases();
        }
        if (!map.valAt(alias).equals(ns)) {
            throw new IllegalStateException("Alias " + alias + " already exists in namespace " + this.name + ", aliasing " + map.valAt(alias));
        }
    }

    public void removeAlias(Symbol alias) {
        IPersistentMap map = this.getAliases();
        while (map.containsKey(alias)) {
            IPersistentMap newMap = map.without(alias);
            this.aliases.compareAndSet(map, newMap);
            map = this.getAliases();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return Namespace.findOrCreate(this.name);
    }
}

