/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIter
implements Iterator {
    final Object[] array;
    int i;
    public static Iterator EMPTY_ITERATOR = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    };

    public static Iterator create() {
        return EMPTY_ITERATOR;
    }

    public static Iterator create(Object ... array) {
        if (array == null || array.length == 0) {
            return EMPTY_ITERATOR;
        }
        return new ArrayIter(array, 0);
    }

    public static Iterator createFromObject(Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return EMPTY_ITERATOR;
        }
        Class<?> aclass = array.getClass();
        if (aclass == int[].class) {
            return new ArrayIter_int((int[])array, 0);
        }
        if (aclass == float[].class) {
            return new ArrayIter_float((float[])array, 0);
        }
        if (aclass == double[].class) {
            return new ArrayIter_double((double[])array, 0);
        }
        if (aclass == long[].class) {
            return new ArrayIter_long((long[])array, 0);
        }
        if (aclass == byte[].class) {
            return new ArrayIter_byte((byte[])array, 0);
        }
        if (aclass == char[].class) {
            return new ArrayIter_char((char[])array, 0);
        }
        if (aclass == short[].class) {
            return new ArrayIter_short((short[])array, 0);
        }
        if (aclass == boolean[].class) {
            return new ArrayIter_boolean((boolean[])array, 0);
        }
        return new ArrayIter(array, 0);
    }

    ArrayIter(Object array, int i) {
        this.i = i;
        this.array = (Object[])array;
    }

    @Override
    public boolean hasNext() {
        return this.array != null && this.i < this.array.length;
    }

    public Object next() {
        if (this.array != null && this.i < this.array.length) {
            return this.array[this.i++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported");
    }

    public static class ArrayIter_boolean
    implements Iterator<Boolean> {
        final boolean[] array;
        int i;

        ArrayIter_boolean(boolean[] array, int i) {
            this.array = array;
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.i < this.array.length;
        }

        @Override
        public Boolean next() {
            if (this.array != null && this.i < this.array.length) {
                return this.array[this.i++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }

    public static class ArrayIter_short
    implements Iterator<Long> {
        final short[] array;
        int i;

        ArrayIter_short(short[] array, int i) {
            this.array = array;
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.i < this.array.length;
        }

        @Override
        public Long next() {
            if (this.array != null && this.i < this.array.length) {
                return this.array[this.i++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }

    public static class ArrayIter_char
    implements Iterator<Character> {
        final char[] array;
        int i;

        ArrayIter_char(char[] array, int i) {
            this.array = array;
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.i < this.array.length;
        }

        @Override
        public Character next() {
            if (this.array != null && this.i < this.array.length) {
                return Character.valueOf(this.array[this.i++]);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }

    public static class ArrayIter_byte
    implements Iterator<Byte> {
        final byte[] array;
        int i;

        ArrayIter_byte(byte[] array, int i) {
            this.array = array;
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.i < this.array.length;
        }

        @Override
        public Byte next() {
            if (this.array != null && this.i < this.array.length) {
                return this.array[this.i++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }

    public static class ArrayIter_long
    implements Iterator<Long> {
        final long[] array;
        int i;

        ArrayIter_long(long[] array, int i) {
            this.array = array;
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.i < this.array.length;
        }

        @Override
        public Long next() {
            if (this.array != null && this.i < this.array.length) {
                return this.array[this.i++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }

    public static class ArrayIter_double
    implements Iterator<Double> {
        final double[] array;
        int i;

        ArrayIter_double(double[] array, int i) {
            this.array = array;
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.i < this.array.length;
        }

        @Override
        public Double next() {
            if (this.array != null && this.i < this.array.length) {
                return this.array[this.i++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }

    public static class ArrayIter_float
    implements Iterator<Double> {
        final float[] array;
        int i;

        ArrayIter_float(float[] array, int i) {
            this.array = array;
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.i < this.array.length;
        }

        @Override
        public Double next() {
            if (this.array != null && this.i < this.array.length) {
                return this.array[this.i++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }

    public static class ArrayIter_int
    implements Iterator<Long> {
        final int[] array;
        int i;

        ArrayIter_int(int[] array, int i) {
            this.array = array;
            this.i = i;
        }

        @Override
        public boolean hasNext() {
            return this.array != null && this.i < this.array.length;
        }

        @Override
        public Long next() {
            if (this.array != null && this.i < this.array.length) {
                return this.array[this.i++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }
    }
}

