/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.APersistentMap;
import clojure.lang.ASeq;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.MapEntry;
import clojure.lang.Obj;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PersistentStructMap
extends APersistentMap
implements IObj {
    final Def def;
    final Object[] vals;
    final IPersistentMap ext;
    final IPersistentMap _meta;

    public static Def createSlotMap(ISeq keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Must supply keys");
        }
        int c = RT.count(keys);
        Object[] v = new Object[2 * c];
        int i = 0;
        ISeq s = keys;
        while (s != null) {
            v[2 * i] = s.first();
            v[2 * i + 1] = i;
            s = s.next();
            ++i;
        }
        return new Def(keys, RT.map(v));
    }

    public static PersistentStructMap create(Def def, ISeq keyvals) {
        Object[] vals = new Object[def.keyslots.count()];
        IPersistentMap ext = PersistentHashMap.EMPTY;
        while (keyvals != null) {
            if (keyvals.next() == null) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", keyvals.first()));
            }
            Object k = keyvals.first();
            Object v = RT.second(keyvals);
            IMapEntry e = def.keyslots.entryAt(k);
            if (e != null) {
                vals[((Integer)e.getValue()).intValue()] = v;
            } else {
                ext = ext.assoc(k, v);
            }
            keyvals = keyvals.next().next();
        }
        return new PersistentStructMap(null, def, vals, ext);
    }

    public static PersistentStructMap construct(Def def, ISeq valseq) {
        Object[] vals = new Object[def.keyslots.count()];
        PersistentHashMap ext = PersistentHashMap.EMPTY;
        for (int i = 0; i < vals.length && valseq != null; valseq = valseq.next(), ++i) {
            vals[i] = valseq.first();
        }
        if (valseq != null) {
            throw new IllegalArgumentException("Too many arguments to struct constructor");
        }
        return new PersistentStructMap(null, def, vals, ext);
    }

    public static IFn getAccessor(final Def def, Object key) {
        IMapEntry e = def.keyslots.entryAt(key);
        if (e != null) {
            final int i = (Integer)e.getValue();
            return new AFn(){

                @Override
                public Object invoke(Object arg1) {
                    PersistentStructMap m = (PersistentStructMap)arg1;
                    if (m.def != def) {
                        throw Util.runtimeException("Accessor/struct mismatch");
                    }
                    return m.vals[i];
                }
            };
        }
        throw new IllegalArgumentException("Not a key of struct");
    }

    protected PersistentStructMap(IPersistentMap meta, Def def, Object[] vals, IPersistentMap ext) {
        this._meta = meta;
        this.ext = ext;
        this.def = def;
        this.vals = vals;
    }

    protected PersistentStructMap makeNew(IPersistentMap meta, Def def, Object[] vals, IPersistentMap ext) {
        return new PersistentStructMap(meta, def, vals, ext);
    }

    @Override
    public IObj withMeta(IPersistentMap meta) {
        if (meta == this._meta) {
            return this;
        }
        return this.makeNew(meta, this.def, this.vals, this.ext);
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.def.keyslots.containsKey(key) || this.ext.containsKey(key);
    }

    @Override
    public IMapEntry entryAt(Object key) {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            return MapEntry.create(e.getKey(), this.vals[(Integer)e.getValue()]);
        }
        return this.ext.entryAt(key);
    }

    @Override
    public IPersistentMap assoc(Object key, Object val) {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            int i = (Integer)e.getValue();
            Object[] newVals = (Object[])this.vals.clone();
            newVals[i] = val;
            return this.makeNew(this._meta, this.def, newVals, this.ext);
        }
        return this.makeNew(this._meta, this.def, this.vals, this.ext.assoc(key, val));
    }

    @Override
    public Object valAt(Object key) {
        Integer i = (Integer)this.def.keyslots.valAt(key);
        if (i != null) {
            return this.vals[i];
        }
        return this.ext.valAt(key);
    }

    @Override
    public Object valAt(Object key, Object notFound) {
        Integer i = (Integer)this.def.keyslots.valAt(key);
        if (i != null) {
            return this.vals[i];
        }
        return this.ext.valAt(key, notFound);
    }

    @Override
    public IPersistentMap assocEx(Object key, Object val) {
        if (this.containsKey(key)) {
            throw Util.runtimeException("Key already present");
        }
        return this.assoc(key, val);
    }

    @Override
    public IPersistentMap without(Object key) {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            throw Util.runtimeException("Can't remove struct key");
        }
        IPersistentMap newExt = this.ext.without(key);
        if (newExt == this.ext) {
            return this;
        }
        return this.makeNew(this._meta, this.def, this.vals, newExt);
    }

    public Iterator iterator() {
        return new Iterator(){
            private ISeq ks;
            private Iterator extIter;
            {
                this.ks = PersistentStructMap.this.def.keys;
                this.extIter = PersistentStructMap.this.ext == null ? null : PersistentStructMap.this.ext.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.ks != null && this.ks.seq() != null || this.extIter != null && this.extIter.hasNext();
            }

            public Object next() {
                if (this.ks != null) {
                    Object key = this.ks.first();
                    this.ks = this.ks.next();
                    return PersistentStructMap.this.entryAt(key);
                }
                if (this.extIter != null && this.extIter.hasNext()) {
                    return this.extIter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int count() {
        return this.vals.length + RT.count(this.ext);
    }

    @Override
    public ISeq seq() {
        return new Seq(null, this.def.keys, this.vals, 0, this.ext);
    }

    @Override
    public IPersistentCollection empty() {
        return PersistentStructMap.construct(this.def, null);
    }

    static class Seq
    extends ASeq {
        final int i;
        final ISeq keys;
        final Object[] vals;
        final IPersistentMap ext;

        public Seq(IPersistentMap meta, ISeq keys, Object[] vals, int i, IPersistentMap ext) {
            super(meta);
            this.i = i;
            this.keys = keys;
            this.vals = vals;
            this.ext = ext;
        }

        @Override
        public Obj withMeta(IPersistentMap meta) {
            if (meta != this._meta) {
                return new Seq(meta, this.keys, this.vals, this.i, this.ext);
            }
            return this;
        }

        @Override
        public Object first() {
            return MapEntry.create(this.keys.first(), this.vals[this.i]);
        }

        @Override
        public ISeq next() {
            if (this.i + 1 < this.vals.length) {
                return new Seq(this._meta, this.keys.next(), this.vals, this.i + 1, this.ext);
            }
            return this.ext.seq();
        }
    }

    public static class Def
    implements Serializable {
        final ISeq keys;
        final IPersistentMap keyslots;

        Def(ISeq keys, IPersistentMap keyslots) {
            this.keys = keys;
            this.keyslots = keyslots;
        }
    }
}

