/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.util.LangProfile;
import com.cybozu.labs.langdetect.util.TagExtractor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class GenProfile {
    public static LangProfile loadFromWikipediaAbstract(String lang, File file) throws IOException {
        LangProfile profile = new LangProfile(lang);
        BufferedReader br = null;
        try {
            InputStream is = new FileInputStream(file);
            if (file.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            br = new BufferedReader(new InputStreamReader(is, "utf-8"));
            TagExtractor tagextractor = new TagExtractor("abstract", 100);
            XMLStreamReader reader = null;
            try {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                reader = factory.createXMLStreamReader(br);
                while (reader.hasNext()) {
                    switch (reader.next()) {
                        case 1: {
                            tagextractor.setTag(reader.getName().toString());
                            break;
                        }
                        case 4: {
                            tagextractor.add(reader.getText());
                            break;
                        }
                        case 2: {
                            String text = tagextractor.closeTag();
                            if (text == null) break;
                            profile.update(text);
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                throw new IOException("Training database file '" + file.getName() + "' is an invalid XML.");
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            System.out.println(lang + ":" + tagextractor.count());
        }
        catch (IOException e) {
            throw new IOException("Can't open or read training database file '" + file.getName() + "' " + e.getMessage(), e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return profile;
    }

    public static LangProfile loadFromText(String lang, File file) throws IOException {
        LangProfile profile = new LangProfile(lang);
        BufferedReader is = null;
        try {
            is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
            int count = 0;
            while (is.ready()) {
                String line = is.readLine();
                profile.update(line);
                ++count;
            }
            System.out.println(lang + ":" + count);
        }
        catch (IOException e) {
            throw new IOException("Can't open training database file '" + file.getName() + "' " + e.getMessage(), e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return profile;
    }
}

