/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.cql.jdbc.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class JdbcAscii
extends AbstractJdbcType<String> {
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final JdbcAscii instance = new JdbcAscii();

    JdbcAscii() {
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public int getScale(String obj) {
        return -1;
    }

    @Override
    public int getPrecision(String obj) {
        return -1;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public String toString(String obj) {
        return obj;
    }

    @Override
    public boolean needsQuotes() {
        return true;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        try {
            return ByteBufferUtil.string(bytes, US_ASCII);
        }
        catch (CharacterCodingException e) {
            throw new MarshalException("Invalid ascii bytes " + ByteBufferUtil.bytesToHex(bytes));
        }
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    @Override
    public int getJdbcType() {
        return 12;
    }

    @Override
    public String compose(ByteBuffer bytes) {
        return this.getString(bytes);
    }

    @Override
    public ByteBuffer decompose(String value) {
        return ByteBufferUtil.bytes(value, US_ASCII);
    }
}

