/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Collections;
import java.util.HashMap;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateIndexStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(CreateIndexStatement.class);
    private final String indexName;
    private final ColumnIdentifier columnName;
    private final boolean isCustom;
    private final String indexClass;

    public CreateIndexStatement(CFName name, String indexName, ColumnIdentifier columnName, boolean isCustom, String indexClass) {
        super(name);
        this.indexName = indexName;
        this.columnName = columnName;
        this.isCustom = isCustom;
        this.indexClass = indexClass;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        CFMetaData cfm = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        CFDefinition.Name name = cfm.getCfDef().get(this.columnName);
        if (name == null) {
            throw new InvalidRequestException("No column definition found for column " + this.columnName);
        }
        switch (name.kind) {
            case KEY_ALIAS: 
            case COLUMN_ALIAS: {
                throw new InvalidRequestException(String.format("Cannot create index on PRIMARY KEY part %s", this.columnName));
            }
            case VALUE_ALIAS: {
                throw new InvalidRequestException(String.format("Cannot create index on column %s of compact CF", this.columnName));
            }
            case COLUMN_METADATA: {
                ColumnDefinition cd = cfm.getColumnDefinition(this.columnName.key);
                if (cd.getIndexType() != null) {
                    throw new InvalidRequestException("Index already exists");
                }
                if (this.isCustom && this.indexClass == null) {
                    throw new InvalidRequestException("CUSTOM index requires specifiying the index class");
                }
                if (!this.isCustom && this.indexClass != null) {
                    throw new InvalidRequestException("Cannot specify index class for a non-CUSTOM index");
                }
                if (!cd.getValidator().isCollection() || this.isCustom) break;
                throw new InvalidRequestException("Indexes on collections are no yet supported");
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        logger.debug("Updating column {} definition for index {}", (Object)this.columnName, (Object)this.indexName);
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily()).clone();
        CFDefinition cfDef = cfm.getCfDef();
        ColumnDefinition cd = cfm.getColumnDefinition(this.columnName.key);
        if (this.isCustom) {
            cd.setIndexType(IndexType.CUSTOM, Collections.singletonMap("class_name", this.indexClass));
        } else if (cfDef.isComposite) {
            CompositeType composite = (CompositeType)cfm.comparator;
            HashMap<String, String> opts = new HashMap<String, String>();
            opts.put("prefix_size", String.valueOf(composite.types.size() - (cfDef.hasCollections ? 2 : 1)));
            cd.setIndexType(IndexType.COMPOSITES, opts);
        } else {
            cd.setIndexType(IndexType.KEYS, Collections.<String, String>emptyMap());
        }
        cd.setIndexName(this.indexName);
        cfm.addDefaultIndexNames();
        MigrationManager.announceColumnFamilyUpdate(cfm);
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }
}

