/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.ByteBufferUtil;

public class WriteResponse {
    public static final WriteResponseSerializer serializer = new WriteResponseSerializer();

    public MessageOut<WriteResponse> createMessage() {
        return new MessageOut<WriteResponse>(MessagingService.Verb.REQUEST_RESPONSE, this, serializer);
    }

    public static class WriteResponseSerializer
    implements IVersionedSerializer<WriteResponse> {
        @Override
        public void serialize(WriteResponse wm, DataOutput dos, int version) throws IOException {
            if (version < 6) {
                dos.writeUTF("");
                ByteBufferUtil.writeWithShortLength(ByteBufferUtil.EMPTY_BYTE_BUFFER, dos);
                dos.writeBoolean(true);
            }
        }

        @Override
        public WriteResponse deserialize(DataInput dis, int version) throws IOException {
            if (version < 6) {
                dis.readUTF();
                ByteBufferUtil.readWithShortLength(dis);
                dis.readBoolean();
            }
            return new WriteResponse();
        }

        @Override
        public long serializedSize(WriteResponse response, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            if (version < 6) {
                return sizes.sizeof("") + sizes.sizeof((short)0) + sizes.sizeof(true);
            }
            return 0L;
        }
    }
}

