(ns
 com.palletops.awaze.storagegateway
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.storagegateway :as storagegateway]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :storagegateway
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.storagegateway.AWSStorageGatewayClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest}
describe-maintenance-start-time-request
  [m5455]
  (clojure.core/let
   [bean5454
    (new
     com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest)]
   (clojure.core/when-let
    [v5456 (:gateway-arn m5455)]
    (. bean5454 setGatewayARN (clojure.core/str v5456)))
   bean5454))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest}
update-bandwidth-rate-limit-request
  [m5458]
  (clojure.core/let
   [bean5457
    (new
     com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v5459 (:gateway-arn m5458)]
    (. bean5457 setGatewayARN (clojure.core/str v5459)))
   (clojure.core/when-let
    [v5459 (:average-upload-rate-limit-in-bits-per-sec m5458)]
    (.
     bean5457
     setAverageUploadRateLimitInBitsPerSec
     (clojure.core/long v5459)))
   (clojure.core/when-let
    [v5459 (:average-download-rate-limit-in-bits-per-sec m5458)]
    (.
     bean5457
     setAverageDownloadRateLimitInBitsPerSec
     (clojure.core/long v5459)))
   bean5457))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest}
describe-working-storage-request
  [m5461]
  (clojure.core/let
   [bean5460
    (new
     com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest)]
   (clojure.core/when-let
    [v5462 (:gateway-arn m5461)]
    (. bean5460 setGatewayARN (clojure.core/str v5462)))
   bean5460))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest}
delete-tape-archive-request
  [m5464]
  (clojure.core/let
   [bean5463
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest)]
   (clojure.core/when-let
    [v5465 (:tape-arn m5464)]
    (. bean5463 setTapeARN (clojure.core/str v5465)))
   bean5463))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest}
delete-snapshot-schedule-request
  [m5467]
  (clojure.core/let
   [bean5466
    (new
     com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v5468 (:volume-arn m5467)]
    (. bean5466 setVolumeARN (clojure.core/str v5468)))
   bean5466))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DisableGatewayRequest}
disable-gateway-request
  [m5470]
  (clojure.core/let
   [bean5469
    (new
     com.amazonaws.services.storagegateway.model.DisableGatewayRequest)]
   (clojure.core/when-let
    [v5471 (:gateway-arn m5470)]
    (. bean5469 setGatewayARN (clojure.core/str v5471)))
   bean5469))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest}
describe-chap-credentials-request
  [m5473]
  (clojure.core/let
   [bean5472
    (new
     com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest)]
   (clojure.core/when-let
    [v5474 (:target-arn m5473)]
    (. bean5472 setTargetARN (clojure.core/str v5474)))
   bean5472))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest}
delete-bandwidth-rate-limit-request
  [m5476]
  (clojure.core/let
   [bean5475
    (new
     com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v5477 (:gateway-arn m5476)]
    (. bean5475 setGatewayARN (clojure.core/str v5477)))
   (clojure.core/when-let
    [v5477 (:bandwidth-type m5476)]
    (. bean5475 setBandwidthType (clojure.core/str v5477)))
   bean5475))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelArchivalRequest}
cancel-archival-request
  [m5479]
  (clojure.core/let
   [bean5478
    (new
     com.amazonaws.services.storagegateway.model.CancelArchivalRequest)]
   (clojure.core/when-let
    [v5480 (:gateway-arn m5479)]
    (. bean5478 setGatewayARN (clojure.core/str v5480)))
   (clojure.core/when-let
    [v5480 (:tape-arn m5479)]
    (. bean5478 setTapeARN (clojure.core/str v5480)))
   bean5478))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest}
create-cachedi-scsivolume-request
  [m5482]
  (clojure.core/let
   [bean5481
    (new
     com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest)]
   (clojure.core/when-let
    [v5483 (:snapshot-id m5482)]
    (. bean5481 setSnapshotId (clojure.core/str v5483)))
   (clojure.core/when-let
    [v5483 (:gateway-arn m5482)]
    (. bean5481 setGatewayARN (clojure.core/str v5483)))
   (clojure.core/when-let
    [v5483 (:target-name m5482)]
    (. bean5481 setTargetName (clojure.core/str v5483)))
   (clojure.core/when-let
    [v5483 (:network-interface-id m5482)]
    (. bean5481 setNetworkInterfaceId (clojure.core/str v5483)))
   (clojure.core/when-let
    [v5483 (:client-token m5482)]
    (. bean5481 setClientToken (clojure.core/str v5483)))
   (clojure.core/when-let
    [v5483 (:volume-size-in-bytes m5482)]
    (. bean5481 setVolumeSizeInBytes (clojure.core/long v5483)))
   bean5481))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest}
create-snapshot-from-volume-recovery-point-request
  [m5485]
  (clojure.core/let
   [bean5484
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest)]
   (clojure.core/when-let
    [v5486 (:volume-arn m5485)]
    (. bean5484 setVolumeARN (clojure.core/str v5486)))
   (clojure.core/when-let
    [v5486 (:snapshot-description m5485)]
    (. bean5484 setSnapshotDescription (clojure.core/str v5486)))
   bean5484))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest}
describe-storedi-scsivolumes-request
  [m5488]
  (clojure.core/let
   [bean5487
    (new
     com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest)]
   (clojure.core/when-let
    [v5489 (:volume-arns m5488)]
    (.
     bean5487
     setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5595] (clojure.core/str arg5595))
 v5489)))
   bean5487))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest}
describe-upload-buffer-request
  [m5491]
  (clojure.core/let
   [bean5490
    (new
     com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest)]
   (clojure.core/when-let
    [v5492 (:gateway-arn m5491)]
    (. bean5490 setGatewayARN (clojure.core/str v5492)))
   bean5490))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddUploadBufferRequest}
add-upload-buffer-request
  [m5494]
  (clojure.core/let
   [bean5493
    (new
     com.amazonaws.services.storagegateway.model.AddUploadBufferRequest)]
   (clojure.core/when-let
    [v5495 (:gateway-arn m5494)]
    (. bean5493 setGatewayARN (clojure.core/str v5495)))
   (clojure.core/when-let
    [v5495 (:disk-ids m5494)]
    (.
     bean5493
     setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5596] (clojure.core/str arg5596))
 v5495)))
   bean5493))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest}
retrieve-tape-archive-request
  [m5497]
  (clojure.core/let
   [bean5496
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest)]
   (clojure.core/when-let
    [v5498 (:gateway-arn m5497)]
    (. bean5496 setGatewayARN (clojure.core/str v5498)))
   (clojure.core/when-let
    [v5498 (:tape-arn m5497)]
    (. bean5496 setTapeARN (clojure.core/str v5498)))
   bean5496))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapesRequest}
describe-tapes-request
  [m5500]
  (clojure.core/let
   [bean5499
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapesRequest)]
   (clojure.core/when-let
    [v5501 (:marker m5500)]
    (. bean5499 setMarker (clojure.core/str v5501)))
   (clojure.core/when-let
    [v5501 (:limit m5500)]
    (. bean5499 setLimit (clojure.core/int v5501)))
   (clojure.core/when-let
    [v5501 (:gateway-arn m5500)]
    (. bean5499 setGatewayARN (clojure.core/str v5501)))
   (clojure.core/when-let
    [v5501 (:tape-arns m5500)]
    (.
     bean5499
     setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5597] (clojure.core/str arg5597))
 v5501)))
   bean5499))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest}
add-working-storage-request
  [m5503]
  (clojure.core/let
   [bean5502
    (new
     com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest)]
   (clojure.core/when-let
    [v5504 (:gateway-arn m5503)]
    (. bean5502 setGatewayARN (clojure.core/str v5504)))
   (clojure.core/when-let
    [v5504 (:disk-ids m5503)]
    (.
     bean5502
     setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5598] (clojure.core/str arg5598))
 v5504)))
   bean5502))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.StartGatewayRequest}
start-gateway-request
  [m5506]
  (clojure.core/let
   [bean5505
    (new
     com.amazonaws.services.storagegateway.model.StartGatewayRequest)]
   (clojure.core/when-let
    [v5507 (:gateway-arn m5506)]
    (. bean5505 setGatewayARN (clojure.core/str v5507)))
   bean5505))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest}
describe-tape-recovery-points-request
  [m5509]
  (clojure.core/let
   [bean5508
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)]
   (clojure.core/when-let
    [v5510 (:marker m5509)]
    (. bean5508 setMarker (clojure.core/str v5510)))
   (clojure.core/when-let
    [v5510 (:limit m5509)]
    (. bean5508 setLimit (clojure.core/int v5510)))
   (clojure.core/when-let
    [v5510 (:gateway-arn m5509)]
    (. bean5508 setGatewayARN (clojure.core/str v5510)))
   bean5508))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListLocalDisksRequest}
list-local-disks-request
  [m5512]
  (clojure.core/let
   [bean5511
    (new
     com.amazonaws.services.storagegateway.model.ListLocalDisksRequest)]
   (clojure.core/when-let
    [v5513 (:gateway-arn m5512)]
    (. bean5511 setGatewayARN (clojure.core/str v5513)))
   bean5511))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest}
delete-chap-credentials-request
  [m5515]
  (clojure.core/let
   [bean5514
    (new
     com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest)]
   (clojure.core/when-let
    [v5516 (:target-arn m5515)]
    (. bean5514 setTargetARN (clojure.core/str v5516)))
   (clojure.core/when-let
    [v5516 (:initiator-name m5515)]
    (. bean5514 setInitiatorName (clojure.core/str v5516)))
   bean5514))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest}
update-maintenance-start-time-request
  [m5518]
  (clojure.core/let
   [bean5517
    (new
     com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest)]
   (clojure.core/when-let
    [v5519 (:day-of-week m5518)]
    (. bean5517 setDayOfWeek (clojure.core/int v5519)))
   (clojure.core/when-let
    [v5519 (:hour-of-day m5518)]
    (. bean5517 setHourOfDay (clojure.core/int v5519)))
   (clojure.core/when-let
    [v5519 (:minute-of-hour m5518)]
    (. bean5517 setMinuteOfHour (clojure.core/int v5519)))
   (clojure.core/when-let
    [v5519 (:gateway-arn m5518)]
    (. bean5517 setGatewayARN (clojure.core/str v5519)))
   bean5517))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddCacheRequest}
add-cache-request
  [m5521]
  (clojure.core/let
   [bean5520
    (new com.amazonaws.services.storagegateway.model.AddCacheRequest)]
   (clojure.core/when-let
    [v5522 (:gateway-arn m5521)]
    (. bean5520 setGatewayARN (clojure.core/str v5522)))
   (clojure.core/when-let
    [v5522 (:disk-ids m5521)]
    (.
     bean5520
     setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5599] (clojure.core/str arg5599))
 v5522)))
   bean5520))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest}
describe-cachedi-scsivolumes-request
  [m5524]
  (clojure.core/let
   [bean5523
    (new
     com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest)]
   (clojure.core/when-let
    [v5525 (:volume-arns m5524)]
    (.
     bean5523
     setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5600] (clojure.core/str arg5600))
 v5525)))
   bean5523))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest}
describe-bandwidth-rate-limit-request
  [m5527]
  (clojure.core/let
   [bean5526
    (new
     com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v5528 (:gateway-arn m5527)]
    (. bean5526 setGatewayARN (clojure.core/str v5528)))
   bean5526))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumesRequest}
list-volumes-request
  [m5530]
  (clojure.core/let
   [bean5529
    (new
     com.amazonaws.services.storagegateway.model.ListVolumesRequest)]
   (clojure.core/when-let
    [v5531 (:marker m5530)]
    (. bean5529 setMarker (clojure.core/str v5531)))
   (clojure.core/when-let
    [v5531 (:limit m5530)]
    (. bean5529 setLimit (clojure.core/int v5531)))
   (clojure.core/when-let
    [v5531 (:gateway-arn m5530)]
    (. bean5529 setGatewayARN (clojure.core/str v5531)))
   bean5529))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateTapesRequest}
create-tapes-request
  [m5533]
  (clojure.core/let
   [bean5532
    (new
     com.amazonaws.services.storagegateway.model.CreateTapesRequest)]
   (clojure.core/when-let
    [v5534 (:gateway-arn m5533)]
    (. bean5532 setGatewayARN (clojure.core/str v5534)))
   (clojure.core/when-let
    [v5534 (:tape-size-in-bytes m5533)]
    (. bean5532 setTapeSizeInBytes (clojure.core/long v5534)))
   (clojure.core/when-let
    [v5534 (:client-token m5533)]
    (. bean5532 setClientToken (clojure.core/str v5534)))
   (clojure.core/when-let
    [v5534 (:num-tapes-to-create m5533)]
    (. bean5532 setNumTapesToCreate (clojure.core/int v5534)))
   (clojure.core/when-let
    [v5534 (:tape-barcode-prefix m5533)]
    (. bean5532 setTapeBarcodePrefix (clojure.core/str v5534)))
   bean5532))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ActivateGatewayRequest}
activate-gateway-request
  [m5536]
  (clojure.core/let
   [bean5535
    (new
     com.amazonaws.services.storagegateway.model.ActivateGatewayRequest)]
   (clojure.core/when-let
    [v5537 (:activation-key m5536)]
    (. bean5535 setActivationKey (clojure.core/str v5537)))
   (clojure.core/when-let
    [v5537 (:gateway-name m5536)]
    (. bean5535 setGatewayName (clojure.core/str v5537)))
   (clojure.core/when-let
    [v5537 (:gateway-timezone m5536)]
    (. bean5535 setGatewayTimezone (clojure.core/str v5537)))
   (clojure.core/when-let
    [v5537 (:gateway-region m5536)]
    (. bean5535 setGatewayRegion (clojure.core/str v5537)))
   (clojure.core/when-let
    [v5537 (:gateway-type m5536)]
    (. bean5535 setGatewayType (clojure.core/str v5537)))
   (clojure.core/when-let
    [v5537 (:tape-drive-type m5536)]
    (. bean5535 setTapeDriveType (clojure.core/str v5537)))
   (clojure.core/when-let
    [v5537 (:medium-changer-type m5536)]
    (. bean5535 setMediumChangerType (clojure.core/str v5537)))
   bean5535))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCacheRequest}
describe-cache-request
  [m5539]
  (clojure.core/let
   [bean5538
    (new
     com.amazonaws.services.storagegateway.model.DescribeCacheRequest)]
   (clojure.core/when-let
    [v5540 (:gateway-arn m5539)]
    (. bean5538 setGatewayARN (clojure.core/str v5540)))
   bean5538))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest}
update-gateway-software-now-request
  [m5542]
  (clojure.core/let
   [bean5541
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest)]
   (clojure.core/when-let
    [v5543 (:gateway-arn m5542)]
    (. bean5541 setGatewayARN (clojure.core/str v5543)))
   bean5541))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest}
update-chap-credentials-request
  [m5545]
  (clojure.core/let
   [bean5544
    (new
     com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest)]
   (clojure.core/when-let
    [v5546 (:target-arn m5545)]
    (. bean5544 setTargetARN (clojure.core/str v5546)))
   (clojure.core/when-let
    [v5546 (:secret-to-authenticate-initiator m5545)]
    (.
     bean5544
     setSecretToAuthenticateInitiator
     (clojure.core/str v5546)))
   (clojure.core/when-let
    [v5546 (:initiator-name m5545)]
    (. bean5544 setInitiatorName (clojure.core/str v5546)))
   (clojure.core/when-let
    [v5546 (:secret-to-authenticate-target m5545)]
    (.
     bean5544
     setSecretToAuthenticateTarget
     (clojure.core/str v5546)))
   bean5544))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest}
describe-tape-archives-request
  [m5548]
  (clojure.core/let
   [bean5547
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest)]
   (clojure.core/when-let
    [v5549 (:marker m5548)]
    (. bean5547 setMarker (clojure.core/str v5549)))
   (clojure.core/when-let
    [v5549 (:limit m5548)]
    (. bean5547 setLimit (clojure.core/int v5549)))
   (clojure.core/when-let
    [v5549 (:tape-arns m5548)]
    (.
     bean5547
     setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5601] (clojure.core/str arg5601))
 v5549)))
   bean5547))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeRequest}
delete-tape-request
  [m5551]
  (clojure.core/let
   [bean5550
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeRequest)]
   (clojure.core/when-let
    [v5552 (:gateway-arn m5551)]
    (. bean5550 setGatewayARN (clojure.core/str v5552)))
   (clojure.core/when-let
    [v5552 (:tape-arn m5551)]
    (. bean5550 setTapeARN (clojure.core/str v5552)))
   bean5550))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest}
retrieve-tape-recovery-point-request
  [m5554]
  (clojure.core/let
   [bean5553
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest)]
   (clojure.core/when-let
    [v5555 (:gateway-arn m5554)]
    (. bean5553 setGatewayARN (clojure.core/str v5555)))
   (clojure.core/when-let
    [v5555 (:tape-arn m5554)]
    (. bean5553 setTapeARN (clojure.core/str v5555)))
   bean5553))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest}
create-storedi-scsivolume-request
  [m5557]
  (clojure.core/let
   [bean5556
    (new
     com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest)]
   (clojure.core/when-let
    [v5558 (:snapshot-id m5557)]
    (. bean5556 setSnapshotId (clojure.core/str v5558)))
   (clojure.core/when-let
    [v5558 (:gateway-arn m5557)]
    (. bean5556 setGatewayARN (clojure.core/str v5558)))
   (clojure.core/when-let
    [v5558 (:disk-id m5557)]
    (. bean5556 setDiskId (clojure.core/str v5558)))
   (clojure.core/when-let
    [v5558 (:preserve-existing-data m5557)]
    (. bean5556 setPreserveExistingData (clojure.core/boolean v5558)))
   (clojure.core/when-let
    [v5558 (:target-name m5557)]
    (. bean5556 setTargetName (clojure.core/str v5558)))
   (clojure.core/when-let
    [v5558 (:network-interface-id m5557)]
    (. bean5556 setNetworkInterfaceId (clojure.core/str v5558)))
   bean5556))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest}
update-gateway-information-request
  [m5560]
  (clojure.core/let
   [bean5559
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest)]
   (clojure.core/when-let
    [v5561 (:gateway-arn m5560)]
    (. bean5559 setGatewayARN (clojure.core/str v5561)))
   (clojure.core/when-let
    [v5561 (:gateway-name m5560)]
    (. bean5559 setGatewayName (clojure.core/str v5561)))
   (clojure.core/when-let
    [v5561 (:gateway-timezone m5560)]
    (. bean5559 setGatewayTimezone (clojure.core/str v5561)))
   bean5559))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelRetrievalRequest}
cancel-retrieval-request
  [m5563]
  (clojure.core/let
   [bean5562
    (new
     com.amazonaws.services.storagegateway.model.CancelRetrievalRequest)]
   (clojure.core/when-let
    [v5564 (:gateway-arn m5563)]
    (. bean5562 setGatewayARN (clojure.core/str v5564)))
   (clojure.core/when-let
    [v5564 (:tape-arn m5563)]
    (. bean5562 setTapeARN (clojure.core/str v5564)))
   bean5562))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest}
describe-gateway-information-request
  [m5566]
  (clojure.core/let
   [bean5565
    (new
     com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest)]
   (clojure.core/when-let
    [v5567 (:gateway-arn m5566)]
    (. bean5565 setGatewayARN (clojure.core/str v5567)))
   bean5565))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest}
shutdown-gateway-request
  [m5569]
  (clojure.core/let
   [bean5568
    (new
     com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest)]
   (clojure.core/when-let
    [v5570 (:gateway-arn m5569)]
    (. bean5568 setGatewayARN (clojure.core/str v5570)))
   bean5568))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest}
list-volume-recovery-points-request
  [m5572]
  (clojure.core/let
   [bean5571
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest)]
   (clojure.core/when-let
    [v5573 (:gateway-arn m5572)]
    (. bean5571 setGatewayARN (clojure.core/str v5573)))
   bean5571))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteGatewayRequest}
delete-gateway-request
  [m5575]
  (clojure.core/let
   [bean5574
    (new
     com.amazonaws.services.storagegateway.model.DeleteGatewayRequest)]
   (clojure.core/when-let
    [v5576 (:gateway-arn m5575)]
    (. bean5574 setGatewayARN (clojure.core/str v5576)))
   bean5574))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotRequest}
create-snapshot-request
  [m5578]
  (clojure.core/let
   [bean5577
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotRequest)]
   (clojure.core/when-let
    [v5579 (:volume-arn m5578)]
    (. bean5577 setVolumeARN (clojure.core/str v5579)))
   (clojure.core/when-let
    [v5579 (:snapshot-description m5578)]
    (. bean5577 setSnapshotDescription (clojure.core/str v5579)))
   bean5577))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteVolumeRequest}
delete-volume-request
  [m5581]
  (clojure.core/let
   [bean5580
    (new
     com.amazonaws.services.storagegateway.model.DeleteVolumeRequest)]
   (clojure.core/when-let
    [v5582 (:volume-arn m5581)]
    (. bean5580 setVolumeARN (clojure.core/str v5582)))
   bean5580))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest}
describe-vtldevices-request
  [m5584]
  (clojure.core/let
   [bean5583
    (new
     com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest)]
   (clojure.core/when-let
    [v5585 (:marker m5584)]
    (. bean5583 setMarker (clojure.core/str v5585)))
   (clojure.core/when-let
    [v5585 (:limit m5584)]
    (. bean5583 setLimit (clojure.core/int v5585)))
   (clojure.core/when-let
    [v5585 (:gateway-arn m5584)]
    (. bean5583 setGatewayARN (clojure.core/str v5585)))
   (clojure.core/when-let
    [v5585 (:vtldevice-arns m5584)]
    (.
     bean5583
     setVTLDeviceARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5602] (clojure.core/str arg5602))
 v5585)))
   bean5583))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest}
update-snapshot-schedule-request
  [m5587]
  (clojure.core/let
   [bean5586
    (new
     com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v5588 (:description m5587)]
    (. bean5586 setDescription (clojure.core/str v5588)))
   (clojure.core/when-let
    [v5588 (:volume-arn m5587)]
    (. bean5586 setVolumeARN (clojure.core/str v5588)))
   (clojure.core/when-let
    [v5588 (:start-at m5587)]
    (. bean5586 setStartAt (clojure.core/int v5588)))
   (clojure.core/when-let
    [v5588 (:recurrence-in-hours m5587)]
    (. bean5586 setRecurrenceInHours (clojure.core/int v5588)))
   bean5586))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest}
describe-snapshot-schedule-request
  [m5590]
  (clojure.core/let
   [bean5589
    (new
     com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v5591 (:volume-arn m5590)]
    (. bean5589 setVolumeARN (clojure.core/str v5591)))
   bean5589))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListGatewaysRequest}
list-gateways-request
  [m5593]
  (clojure.core/let
   [bean5592
    (new
     com.amazonaws.services.storagegateway.model.ListGatewaysRequest)]
   (clojure.core/when-let
    [v5594 (:marker m5593)]
    (. bean5592 setMarker (clojure.core/str v5594)))
   (clojure.core/when-let
    [v5594 (:limit m5593)]
    (. bean5592 setLimit (clojure.core/int v5594)))
   bean5592))
 (clojure.core/defmulti
  storagegateway
  (clojure.core/fn
   storagegateway
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-maintenance-start-time
   [m5603]
   (clojure.core/let
    [credentials5604 (:credentials m5603) args5605 (:args m5603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5606
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5604)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5606
       describeMaintenanceStartTime
       (storagegateway/describe-maintenance-start-time-request
        (clojure.core/nth args5605 0)))))))
  (clojure.core/defn
   describe-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeMaintenanceStartTime"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-maintenance-start-time,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeMaintenanceStartTime"}
   [credentials5608 & args5609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5610
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5608)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5610
      describeMaintenanceStartTime
      (storagegateway/describe-maintenance-start-time-request
       (clojure.core/nth args5609 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-bandwidth-rate-limit
   [m5611]
   (clojure.core/let
    [credentials5612 (:credentials m5611) args5613 (:args m5611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5614
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5612)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5614
       updateBandwidthRateLimit
       (storagegateway/update-bandwidth-rate-limit-request
        (clojure.core/nth args5613 0)))))))
  (clojure.core/defn
   update-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         average-upload-rate-limit-in-bits-per-sec
                         average-download-rate-limit-in-bits-per-sec]}]]),
    :doc "Generate map for updateBandwidthRateLimit"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-bandwidth-rate-limit,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         average-upload-rate-limit-in-bits-per-sec
                         average-download-rate-limit-in-bits-per-sec]}]]),
    :doc "Call updateBandwidthRateLimit"}
   [credentials5616 & args5617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5618
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5616)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5618
      updateBandwidthRateLimit
      (storagegateway/update-bandwidth-rate-limit-request
       (clojure.core/nth args5617 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-working-storage
   [m5619]
   (clojure.core/let
    [credentials5620 (:credentials m5619) args5621 (:args m5619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5622
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5620)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5622
       describeWorkingStorage
       (storagegateway/describe-working-storage-request
        (clojure.core/nth args5621 0)))))))
  (clojure.core/defn
   describe-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeWorkingStorage"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-working-storage,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeWorkingStorage"}
   [credentials5624 & args5625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5626
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5624)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5626
      describeWorkingStorage
      (storagegateway/describe-working-storage-request
       (clojure.core/nth args5625 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape-archive
   [m5627]
   (clojure.core/let
    [credentials5628 (:credentials m5627) args5629 (:args m5627)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5630
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5628)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5630
       deleteTapeArchive
       (storagegateway/delete-tape-archive-request
        (clojure.core/nth args5629 0)))))))
  (clojure.core/defn
   delete-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn general-progress-listener]}]]),
    :doc "Generate map for deleteTapeArchive"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-tape-archive,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn general-progress-listener]}]]),
    :doc "Call deleteTapeArchive"}
   [credentials5632 & args5633]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5634
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5632)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5634
      deleteTapeArchive
      (storagegateway/delete-tape-archive-request
       (clojure.core/nth args5633 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-snapshot-schedule
   [m5635]
   (clojure.core/let
    [credentials5636 (:credentials m5635) args5637 (:args m5635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5638
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5636)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5638
       deleteSnapshotSchedule
       (storagegateway/delete-snapshot-schedule-request
        (clojure.core/nth args5637 0)))))))
  (clojure.core/defn
   delete-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Generate map for deleteSnapshotSchedule"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-snapshot-schedule,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Call deleteSnapshotSchedule"}
   [credentials5640 & args5641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5642
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5640)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5642
      deleteSnapshotSchedule
      (storagegateway/delete-snapshot-schedule-request
       (clojure.core/nth args5641 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :disable-gateway
   [m5643]
   (clojure.core/let
    [credentials5644 (:credentials m5643) args5645 (:args m5643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5646
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5644)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5646
       disableGateway
       (storagegateway/disable-gateway-request
        (clojure.core/nth args5645 0)))))))
  (clojure.core/defn
   disable-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for disableGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :disable-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   disable-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call disableGateway"}
   [credentials5648 & args5649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5650
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5648)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5650
      disableGateway
      (storagegateway/disable-gateway-request
       (clojure.core/nth args5649 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-chap-credentials
   [m5651]
   (clojure.core/let
    [credentials5652 (:credentials m5651) args5653 (:args m5651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5654
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5652)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5654
       describeChapCredentials
       (storagegateway/describe-chap-credentials-request
        (clojure.core/nth args5653 0)))))))
  (clojure.core/defn
   describe-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn general-progress-listener]}]]),
    :doc "Generate map for describeChapCredentials"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-chap-credentials,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn general-progress-listener]}]]),
    :doc "Call describeChapCredentials"}
   [credentials5656 & args5657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5658
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5656)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5658
      describeChapCredentials
      (storagegateway/describe-chap-credentials-request
       (clojure.core/nth args5657 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-bandwidth-rate-limit
   [m5659]
   (clojure.core/let
    [credentials5660 (:credentials m5659) args5661 (:args m5659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5662
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5660)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5662
       deleteBandwidthRateLimit
       (storagegateway/delete-bandwidth-rate-limit-request
        (clojure.core/nth args5661 0)))))))
  (clojure.core/defn
   delete-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         bandwidth-type]}]]),
    :doc "Generate map for deleteBandwidthRateLimit"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-bandwidth-rate-limit,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         bandwidth-type]}]]),
    :doc "Call deleteBandwidthRateLimit"}
   [credentials5664 & args5665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5666
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5664)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5666
      deleteBandwidthRateLimit
      (storagegateway/delete-bandwidth-rate-limit-request
       (clojure.core/nth args5665 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-archival
   [m5667]
   (clojure.core/let
    [credentials5668 (:credentials m5667) args5669 (:args m5667)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5670
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5668)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5670
       cancelArchival
       (storagegateway/cancel-archival-request
        (clojure.core/nth args5669 0)))))))
  (clojure.core/defn
   cancel-archival-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for cancelArchival"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :cancel-archival,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   cancel-archival
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call cancelArchival"}
   [credentials5672 & args5673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5674
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5672)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5674
      cancelArchival
      (storagegateway/cancel-archival-request
       (clojure.core/nth args5673 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-cachedi-scsivolume
   [m5675]
   (clojure.core/let
    [credentials5676 (:credentials m5675) args5677 (:args m5675)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5678
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5676)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5678
       createCachediSCSIVolume
       (storagegateway/create-cachedi-scsivolume-request
        (clojure.core/nth args5677 0)))))))
  (clojure.core/defn
   create-cachedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         network-interface-id
                         gateway-arn
                         volume-size-in-bytes
                         client-token]}]]),
    :doc "Generate map for createCachediSCSIVolume"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-cachedi-scsivolume,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-cachedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         network-interface-id
                         gateway-arn
                         volume-size-in-bytes
                         client-token]}]]),
    :doc "Call createCachediSCSIVolume"}
   [credentials5680 & args5681]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5682
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5680)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5682
      createCachediSCSIVolume
      (storagegateway/create-cachedi-scsivolume-request
       (clojure.core/nth args5681 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot-from-volume-recovery-point
   [m5683]
   (clojure.core/let
    [credentials5684 (:credentials m5683) args5685 (:args m5683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5686
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5684)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5686
       createSnapshotFromVolumeRecoveryPoint
       (storagegateway/create-snapshot-from-volume-recovery-point-request
        (clojure.core/nth args5685 0)))))))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Generate map for createSnapshotFromVolumeRecoveryPoint"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-snapshot-from-volume-recovery-point,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Call createSnapshotFromVolumeRecoveryPoint"}
   [credentials5688 & args5689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5690
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5688)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5690
      createSnapshotFromVolumeRecoveryPoint
      (storagegateway/create-snapshot-from-volume-recovery-point-request
       (clojure.core/nth args5689 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-storedi-scsivolumes
   [m5691]
   (clojure.core/let
    [credentials5692 (:credentials m5691) args5693 (:args m5691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5694
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5694
       describeStorediSCSIVolumes
       (storagegateway/describe-storedi-scsivolumes-request
        (clojure.core/nth args5693 0)))))))
  (clojure.core/defn
   describe-storedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Generate map for describeStorediSCSIVolumes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-storedi-scsivolumes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-storedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Call describeStorediSCSIVolumes"}
   [credentials5696 & args5697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5698
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5698
      describeStorediSCSIVolumes
      (storagegateway/describe-storedi-scsivolumes-request
       (clojure.core/nth args5697 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-upload-buffer
   [m5699]
   (clojure.core/let
    [credentials5700 (:credentials m5699) args5701 (:args m5699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5702
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5702
       describeUploadBuffer
       (storagegateway/describe-upload-buffer-request
        (clojure.core/nth args5701 0)))))))
  (clojure.core/defn
   describe-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeUploadBuffer"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-upload-buffer,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeUploadBuffer"}
   [credentials5704 & args5705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5706
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5704)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5706
      describeUploadBuffer
      (storagegateway/describe-upload-buffer-request
       (clojure.core/nth args5705 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-upload-buffer
   [m5707]
   (clojure.core/let
    [credentials5708 (:credentials m5707) args5709 (:args m5707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5710
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5708)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5710
       addUploadBuffer
       (storagegateway/add-upload-buffer-request
        (clojure.core/nth args5709 0)))))))
  (clojure.core/defn
   add-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addUploadBuffer"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-upload-buffer,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addUploadBuffer"}
   [credentials5712 & args5713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5714
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5712)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5714
      addUploadBuffer
      (storagegateway/add-upload-buffer-request
       (clojure.core/nth args5713 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-archive
   [m5715]
   (clojure.core/let
    [credentials5716 (:credentials m5715) args5717 (:args m5715)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5718
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5716)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5718
       retrieveTapeArchive
       (storagegateway/retrieve-tape-archive-request
        (clojure.core/nth args5717 0)))))))
  (clojure.core/defn
   retrieve-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for retrieveTapeArchive"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :retrieve-tape-archive,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   retrieve-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call retrieveTapeArchive"}
   [credentials5720 & args5721]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5722
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5720)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5722
      retrieveTapeArchive
      (storagegateway/retrieve-tape-archive-request
       (clojure.core/nth args5721 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tapes
   [m5723]
   (clojure.core/let
    [credentials5724 (:credentials m5723) args5725 (:args m5723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5726
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5724)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5726
       describeTapes
       (storagegateway/describe-tapes-request
        (clojure.core/nth args5725 0)))))))
  (clojure.core/defn
   describe-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for describeTapes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-tapes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-tapes
   {:arglists (quote
               [[credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call describeTapes"}
   [credentials5728 & args5729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5730
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5728)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5730
      describeTapes
      (storagegateway/describe-tapes-request
       (clojure.core/nth args5729 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-working-storage
   [m5731]
   (clojure.core/let
    [credentials5732 (:credentials m5731) args5733 (:args m5731)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5734
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5732)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5734
       addWorkingStorage
       (storagegateway/add-working-storage-request
        (clojure.core/nth args5733 0)))))))
  (clojure.core/defn
   add-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addWorkingStorage"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-working-storage,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addWorkingStorage"}
   [credentials5736 & args5737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5738
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5736)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5738
      addWorkingStorage
      (storagegateway/add-working-storage-request
       (clojure.core/nth args5737 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :start-gateway
   [m5739]
   (clojure.core/let
    [credentials5740 (:credentials m5739) args5741 (:args m5739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5742
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5740)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5742
       startGateway
       (storagegateway/start-gateway-request
        (clojure.core/nth args5741 0)))))))
  (clojure.core/defn
   start-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for startGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :start-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   start-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call startGateway"}
   [credentials5744 & args5745]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5746
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5744)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5746
      startGateway
      (storagegateway/start-gateway-request
       (clojure.core/nth args5745 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-recovery-points
   [m5747]
   (clojure.core/let
    [credentials5748 (:credentials m5747) args5749 (:args m5747)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5750
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5748)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5750
       describeTapeRecoveryPoints
       (storagegateway/describe-tape-recovery-points-request
        (clojure.core/nth args5749 0)))))))
  (clojure.core/defn
   describe-tape-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for describeTapeRecoveryPoints"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-tape-recovery-points,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-tape-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call describeTapeRecoveryPoints"}
   [credentials5752 & args5753]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5754
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5752)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5754
      describeTapeRecoveryPoints
      (storagegateway/describe-tape-recovery-points-request
       (clojure.core/nth args5753 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-local-disks
   [m5755]
   (clojure.core/let
    [credentials5756 (:credentials m5755) args5757 (:args m5755)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5758
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5756)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5758
       listLocalDisks
       (storagegateway/list-local-disks-request
        (clojure.core/nth args5757 0)))))))
  (clojure.core/defn
   list-local-disks-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for listLocalDisks"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-local-disks,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-local-disks
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call listLocalDisks"}
   [credentials5760 & args5761]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5762
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5760)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5762
      listLocalDisks
      (storagegateway/list-local-disks-request
       (clojure.core/nth args5761 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-chap-credentials
   [m5763]
   (clojure.core/let
    [credentials5764 (:credentials m5763) args5765 (:args m5763)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5766
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5764)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5766
       deleteChapCredentials
       (storagegateway/delete-chap-credentials-request
        (clojure.core/nth args5765 0)))))))
  (clojure.core/defn
   delete-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteChapCredentials"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-chap-credentials,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Call deleteChapCredentials"}
   [credentials5768 & args5769]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5770
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5768)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5770
      deleteChapCredentials
      (storagegateway/delete-chap-credentials-request
       (clojure.core/nth args5769 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-maintenance-start-time
   [m5771]
   (clojure.core/let
    [credentials5772 (:credentials m5771) args5773 (:args m5771)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5774
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5772)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5774
       updateMaintenanceStartTime
       (storagegateway/update-maintenance-start-time-request
        (clojure.core/nth args5773 0)))))))
  (clojure.core/defn
   update-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [minute-of-hour
                         hour-of-day
                         general-progress-listener
                         gateway-arn
                         day-of-week]}]]),
    :doc "Generate map for updateMaintenanceStartTime"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-maintenance-start-time,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [minute-of-hour
                         hour-of-day
                         general-progress-listener
                         gateway-arn
                         day-of-week]}]]),
    :doc "Call updateMaintenanceStartTime"}
   [credentials5776 & args5777]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5778
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5776)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5778
      updateMaintenanceStartTime
      (storagegateway/update-maintenance-start-time-request
       (clojure.core/nth args5777 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-cache
   [m5779]
   (clojure.core/let
    [credentials5780 (:credentials m5779) args5781 (:args m5779)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5782
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5780)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5782
       addCache
       (storagegateway/add-cache-request
        (clojure.core/nth args5781 0)))))))
  (clojure.core/defn
   add-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addCache"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-cache,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-cache
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addCache"}
   [credentials5784 & args5785]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5786
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5784)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5786
      addCache
      (storagegateway/add-cache-request (clojure.core/nth args5785 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cachedi-scsivolumes
   [m5787]
   (clojure.core/let
    [credentials5788 (:credentials m5787) args5789 (:args m5787)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5790
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5788)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5790
       describeCachediSCSIVolumes
       (storagegateway/describe-cachedi-scsivolumes-request
        (clojure.core/nth args5789 0)))))))
  (clojure.core/defn
   describe-cachedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Generate map for describeCachediSCSIVolumes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-cachedi-scsivolumes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cachedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Call describeCachediSCSIVolumes"}
   [credentials5792 & args5793]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5794
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5792)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5794
      describeCachediSCSIVolumes
      (storagegateway/describe-cachedi-scsivolumes-request
       (clojure.core/nth args5793 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-bandwidth-rate-limit
   [m5795]
   (clojure.core/let
    [credentials5796 (:credentials m5795) args5797 (:args m5795)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5798
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5796)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5798
       describeBandwidthRateLimit
       (storagegateway/describe-bandwidth-rate-limit-request
        (clojure.core/nth args5797 0)))))))
  (clojure.core/defn
   describe-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeBandwidthRateLimit"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-bandwidth-rate-limit,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeBandwidthRateLimit"}
   [credentials5800 & args5801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5802
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5800)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5802
      describeBandwidthRateLimit
      (storagegateway/describe-bandwidth-rate-limit-request
       (clojure.core/nth args5801 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volumes
   [m5803]
   (clojure.core/let
    [credentials5804 (:credentials m5803) args5805 (:args m5803)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5806
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5804)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5806
       listVolumes
       (storagegateway/list-volumes-request
        (clojure.core/nth args5805 0)))))))
  (clojure.core/defn
   list-volumes-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for listVolumes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-volumes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-volumes
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call listVolumes"}
   [credentials5808 & args5809]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5810
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5808)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5810
      listVolumes
      (storagegateway/list-volumes-request
       (clojure.core/nth args5809 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-tapes
   [m5811]
   (clojure.core/let
    [credentials5812 (:credentials m5811) args5813 (:args m5811)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5814
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5812)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5814
       createTapes
       (storagegateway/create-tapes-request
        (clojure.core/nth args5813 0)))))))
  (clojure.core/defn
   create-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [num-tapes-to-create
                         tape-size-in-bytes
                         client-token
                         tape-barcode-prefix
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for createTapes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-tapes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-tapes
   {:arglists (quote
               [[credentials
                 {:keys [num-tapes-to-create
                         tape-size-in-bytes
                         client-token
                         tape-barcode-prefix
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call createTapes"}
   [credentials5816 & args5817]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5818
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5816)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5818
      createTapes
      (storagegateway/create-tapes-request
       (clojure.core/nth args5817 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :activate-gateway
   [m5819]
   (clojure.core/let
    [credentials5820 (:credentials m5819) args5821 (:args m5819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5822
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5820)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5822
       activateGateway
       (storagegateway/activate-gateway-request
        (clojure.core/nth args5821 0)))))))
  (clojure.core/defn
   activate-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [activation-key
                         general-progress-listener
                         tape-drive-type
                         gateway-timezone
                         medium-changer-type
                         gateway-region
                         gateway-name
                         gateway-type]}]]),
    :doc "Generate map for activateGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :activate-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   activate-gateway
   {:arglists (quote
               [[credentials
                 {:keys [activation-key
                         general-progress-listener
                         tape-drive-type
                         gateway-timezone
                         medium-changer-type
                         gateway-region
                         gateway-name
                         gateway-type]}]]),
    :doc "Call activateGateway"}
   [credentials5824 & args5825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5826
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5824)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5826
      activateGateway
      (storagegateway/activate-gateway-request
       (clojure.core/nth args5825 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cache
   [m5827]
   (clojure.core/let
    [credentials5828 (:credentials m5827) args5829 (:args m5827)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5830
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5828)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5830
       describeCache
       (storagegateway/describe-cache-request
        (clojure.core/nth args5829 0)))))))
  (clojure.core/defn
   describe-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeCache"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-cache,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cache
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeCache"}
   [credentials5832 & args5833]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5834
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5832)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5834
      describeCache
      (storagegateway/describe-cache-request
       (clojure.core/nth args5833 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-software-now
   [m5835]
   (clojure.core/let
    [credentials5836 (:credentials m5835) args5837 (:args m5835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5838
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5836)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5838
       updateGatewaySoftwareNow
       (storagegateway/update-gateway-software-now-request
        (clojure.core/nth args5837 0)))))))
  (clojure.core/defn
   update-gateway-software-now-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for updateGatewaySoftwareNow"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-gateway-software-now,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-gateway-software-now
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call updateGatewaySoftwareNow"}
   [credentials5840 & args5841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5842
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5840)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5842
      updateGatewaySoftwareNow
      (storagegateway/update-gateway-software-now-request
       (clojure.core/nth args5841 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-chap-credentials
   [m5843]
   (clojure.core/let
    [credentials5844 (:credentials m5843) args5845 (:args m5843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5846
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5846
       updateChapCredentials
       (storagegateway/update-chap-credentials-request
        (clojure.core/nth args5845 0)))))))
  (clojure.core/defn
   update-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         secret-to-authenticate-target
                         secret-to-authenticate-initiator
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Generate map for updateChapCredentials"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-chap-credentials,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         secret-to-authenticate-target
                         secret-to-authenticate-initiator
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Call updateChapCredentials"}
   [credentials5848 & args5849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5850
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5850
      updateChapCredentials
      (storagegateway/update-chap-credentials-request
       (clojure.core/nth args5849 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-archives
   [m5851]
   (clojure.core/let
    [credentials5852 (:credentials m5851) args5853 (:args m5851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5854
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5852)]
     (clojure.core/case
      (clojure.core/count args5853)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5854
        describeTapeArchives))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5854
        describeTapeArchives
        (storagegateway/describe-tape-archives-request
         (clojure.core/nth args5853 0))))))))
  (clojure.core/defn
   describe-tape-archives-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener]}]]),
    :doc "Generate map for describeTapeArchives, describeTapeArchives"}
   ([credentials__1649__auto__]
    {:args [],
     :client :storagegateway,
     :fn :describe-tape-archives,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-tape-archives,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-tape-archives
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener]}]]),
    :doc "Call describeTapeArchives, describeTapeArchives"}
   [credentials5856 & args5857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5858
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5856)]
    (clojure.core/case
     (clojure.core/count args5857)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5858
       describeTapeArchives))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5858
       describeTapeArchives
       (storagegateway/describe-tape-archives-request
        (clojure.core/nth args5857 0))))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape
   [m5859]
   (clojure.core/let
    [credentials5860 (:credentials m5859) args5861 (:args m5859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5862
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5860)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5862
       deleteTape
       (storagegateway/delete-tape-request
        (clojure.core/nth args5861 0)))))))
  (clojure.core/defn
   delete-tape-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for deleteTape"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-tape,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-tape
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call deleteTape"}
   [credentials5864 & args5865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5866
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5864)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5866
      deleteTape
      (storagegateway/delete-tape-request
       (clojure.core/nth args5865 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-recovery-point
   [m5867]
   (clojure.core/let
    [credentials5868 (:credentials m5867) args5869 (:args m5867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5870
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5868)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5870
       retrieveTapeRecoveryPoint
       (storagegateway/retrieve-tape-recovery-point-request
        (clojure.core/nth args5869 0)))))))
  (clojure.core/defn
   retrieve-tape-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for retrieveTapeRecoveryPoint"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :retrieve-tape-recovery-point,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   retrieve-tape-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call retrieveTapeRecoveryPoint"}
   [credentials5872 & args5873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5874
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5872)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5874
      retrieveTapeRecoveryPoint
      (storagegateway/retrieve-tape-recovery-point-request
       (clojure.core/nth args5873 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-storedi-scsivolume
   [m5875]
   (clojure.core/let
    [credentials5876 (:credentials m5875) args5877 (:args m5875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5878
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5876)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5878
       createStorediSCSIVolume
       (storagegateway/create-storedi-scsivolume-request
        (clojure.core/nth args5877 0)))))))
  (clojure.core/defn
   create-storedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         preserve-existing-data
                         network-interface-id
                         gateway-arn
                         disk-id]}]]),
    :doc "Generate map for createStorediSCSIVolume"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-storedi-scsivolume,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-storedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         preserve-existing-data
                         network-interface-id
                         gateway-arn
                         disk-id]}]]),
    :doc "Call createStorediSCSIVolume"}
   [credentials5880 & args5881]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5882
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5880)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5882
      createStorediSCSIVolume
      (storagegateway/create-storedi-scsivolume-request
       (clojure.core/nth args5881 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-information
   [m5883]
   (clojure.core/let
    [credentials5884 (:credentials m5883) args5885 (:args m5883)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5886
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5884)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5886
       updateGatewayInformation
       (storagegateway/update-gateway-information-request
        (clojure.core/nth args5885 0)))))))
  (clojure.core/defn
   update-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-timezone
                         gateway-name
                         gateway-arn]}]]),
    :doc "Generate map for updateGatewayInformation"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-gateway-information,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-timezone
                         gateway-name
                         gateway-arn]}]]),
    :doc "Call updateGatewayInformation"}
   [credentials5888 & args5889]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5890
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5888)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5890
      updateGatewayInformation
      (storagegateway/update-gateway-information-request
       (clojure.core/nth args5889 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-retrieval
   [m5891]
   (clojure.core/let
    [credentials5892 (:credentials m5891) args5893 (:args m5891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5894
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5892)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5894
       cancelRetrieval
       (storagegateway/cancel-retrieval-request
        (clojure.core/nth args5893 0)))))))
  (clojure.core/defn
   cancel-retrieval-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for cancelRetrieval"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :cancel-retrieval,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   cancel-retrieval
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call cancelRetrieval"}
   [credentials5896 & args5897]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5898
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5896)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5898
      cancelRetrieval
      (storagegateway/cancel-retrieval-request
       (clojure.core/nth args5897 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-gateway-information
   [m5899]
   (clojure.core/let
    [credentials5900 (:credentials m5899) args5901 (:args m5899)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5902
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5900)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5902
       describeGatewayInformation
       (storagegateway/describe-gateway-information-request
        (clojure.core/nth args5901 0)))))))
  (clojure.core/defn
   describe-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeGatewayInformation"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-gateway-information,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeGatewayInformation"}
   [credentials5904 & args5905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5906
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5904)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5906
      describeGatewayInformation
      (storagegateway/describe-gateway-information-request
       (clojure.core/nth args5905 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :shutdown-gateway
   [m5907]
   (clojure.core/let
    [credentials5908 (:credentials m5907) args5909 (:args m5907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5910
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5908)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5910
       shutdownGateway
       (storagegateway/shutdown-gateway-request
        (clojure.core/nth args5909 0)))))))
  (clojure.core/defn
   shutdown-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for shutdownGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :shutdown-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   shutdown-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call shutdownGateway"}
   [credentials5912 & args5913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5914
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5914
      shutdownGateway
      (storagegateway/shutdown-gateway-request
       (clojure.core/nth args5913 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-recovery-points
   [m5915]
   (clojure.core/let
    [credentials5916 (:credentials m5915) args5917 (:args m5915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5918
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5916)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5918
       listVolumeRecoveryPoints
       (storagegateway/list-volume-recovery-points-request
        (clojure.core/nth args5917 0)))))))
  (clojure.core/defn
   list-volume-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for listVolumeRecoveryPoints"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-volume-recovery-points,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-volume-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call listVolumeRecoveryPoints"}
   [credentials5920 & args5921]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5922
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5920)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5922
      listVolumeRecoveryPoints
      (storagegateway/list-volume-recovery-points-request
       (clojure.core/nth args5921 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-gateway
   [m5923]
   (clojure.core/let
    [credentials5924 (:credentials m5923) args5925 (:args m5923)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5926
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5924)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5926
       deleteGateway
       (storagegateway/delete-gateway-request
        (clojure.core/nth args5925 0)))))))
  (clojure.core/defn
   delete-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for deleteGateway"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-gateway,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call deleteGateway"}
   [credentials5928 & args5929]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5930
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5928)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5930
      deleteGateway
      (storagegateway/delete-gateway-request
       (clojure.core/nth args5929 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot
   [m5931]
   (clojure.core/let
    [credentials5932 (:credentials m5931) args5933 (:args m5931)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5934
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5932)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5934
       createSnapshot
       (storagegateway/create-snapshot-request
        (clojure.core/nth args5933 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-snapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Call createSnapshot"}
   [credentials5936 & args5937]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5938
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5936)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5938
      createSnapshot
      (storagegateway/create-snapshot-request
       (clojure.core/nth args5937 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-volume
   [m5939]
   (clojure.core/let
    [credentials5940 (:credentials m5939) args5941 (:args m5939)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5942
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5940)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5942
       deleteVolume
       (storagegateway/delete-volume-request
        (clojure.core/nth args5941 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-volume,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Call deleteVolume"}
   [credentials5944 & args5945]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5946
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5944)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5946
      deleteVolume
      (storagegateway/delete-volume-request
       (clojure.core/nth args5945 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-vtldevices
   [m5947]
   (clojure.core/let
    [credentials5948 (:credentials m5947) args5949 (:args m5947)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5950
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5948)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5950
       describeVTLDevices
       (storagegateway/describe-vtldevices-request
        (clojure.core/nth args5949 0)))))))
  (clojure.core/defn
   describe-vtldevices-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn
                         vtldevice-arns]}]]),
    :doc "Generate map for describeVTLDevices"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-vtldevices,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-vtldevices
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn
                         vtldevice-arns]}]]),
    :doc "Call describeVTLDevices"}
   [credentials5952 & args5953]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5954
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5952)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5954
      describeVTLDevices
      (storagegateway/describe-vtldevices-request
       (clojure.core/nth args5953 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-snapshot-schedule
   [m5955]
   (clojure.core/let
    [credentials5956 (:credentials m5955) args5957 (:args m5955)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5958
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5956)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5958
       updateSnapshotSchedule
       (storagegateway/update-snapshot-schedule-request
        (clojure.core/nth args5957 0)))))))
  (clojure.core/defn
   update-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         start-at
                         recurrence-in-hours
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for updateSnapshotSchedule"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-snapshot-schedule,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         start-at
                         recurrence-in-hours
                         general-progress-listener
                         description]}]]),
    :doc "Call updateSnapshotSchedule"}
   [credentials5960 & args5961]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5962
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5960)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5962
      updateSnapshotSchedule
      (storagegateway/update-snapshot-schedule-request
       (clojure.core/nth args5961 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-snapshot-schedule
   [m5963]
   (clojure.core/let
    [credentials5964 (:credentials m5963) args5965 (:args m5963)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5966
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5964)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5966
       describeSnapshotSchedule
       (storagegateway/describe-snapshot-schedule-request
        (clojure.core/nth args5965 0)))))))
  (clojure.core/defn
   describe-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Generate map for describeSnapshotSchedule"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-snapshot-schedule,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Call describeSnapshotSchedule"}
   [credentials5968 & args5969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5970
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5968)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5970
      describeSnapshotSchedule
      (storagegateway/describe-snapshot-schedule-request
       (clojure.core/nth args5969 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-gateways
   [m5971]
   (clojure.core/let
    [credentials5972 (:credentials m5971) args5973 (:args m5971)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5974
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5972)]
     (clojure.core/case
      (clojure.core/count args5973)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5974
        listGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5974
        listGateways
        (storagegateway/list-gateways-request
         (clojure.core/nth args5973 0))))))))
  (clojure.core/defn
   list-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker limit general-progress-listener]}]]),
    :doc "Generate map for listGateways, listGateways"}
   ([credentials__1649__auto__]
    {:args [],
     :client :storagegateway,
     :fn :list-gateways,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-gateways,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker limit general-progress-listener]}]]),
    :doc "Call listGateways, listGateways"}
   [credentials5976 & args5977]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5978
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5976)]
    (clojure.core/case
     (clojure.core/count args5977)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5978
       listGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5978
       listGateways
       (storagegateway/list-gateways-request
        (clojure.core/nth args5977 0)))))))))
