(ns
 com.palletops.awaze.sqs
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sqs :as sqs]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sqs
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.sqs.AmazonSQSClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.MessageAttributeValue}
message-attribute-value
  [m8534]
  (clojure.core/let
   [bean8533
    (new com.amazonaws.services.sqs.model.MessageAttributeValue)]
   (clojure.core/when-let
    [v8535 (:data-type m8534)]
    (. bean8533 setDataType (clojure.core/str v8535)))
   (clojure.core/when-let
    [v8535 (:string-value m8534)]
    (. bean8533 setStringValue (clojure.core/str v8535)))
   (clojure.core/when-let
    [v8535 (:binary-value m8534)]
    (. bean8533 setBinaryValue (clojure.core/identity v8535)))
   (clojure.core/when-let
    [v8535 (:string-list-values m8534)]
    (.
     bean8533
     setStringListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8593] (clojure.core/str arg8593))
 v8535)))
   (clojure.core/when-let
    [v8535 (:binary-list-values m8534)]
    (.
     bean8533
     setBinaryListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8594] (clojure.core/identity arg8594))
 v8535)))
   bean8533))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry}
change-message-visibility-batch-request-entry
  [m8537]
  (clojure.core/let
   [bean8536
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry)]
   (clojure.core/when-let
    [v8538 (:id m8537)]
    (. bean8536 setId (clojure.core/str v8538)))
   (clojure.core/when-let
    [v8538 (:receipt-handle m8537)]
    (. bean8536 setReceiptHandle (clojure.core/str v8538)))
   (clojure.core/when-let
    [v8538 (:visibility-timeout m8537)]
    (. bean8536 setVisibilityTimeout (clojure.core/int v8538)))
   bean8536))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry}
send-message-batch-request-entry
  [m8540]
  (clojure.core/let
   [bean8539
    (new
     com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry)]
   (clojure.core/when-let
    [v8541 (:id m8540)]
    (. bean8539 setId (clojure.core/str v8541)))
   (clojure.core/when-let
    [v8541 (:message-attributes m8540)]
    (.
     bean8539
     setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8595] (clojure.core/str arg8595))
  (clojure.core/keys v8541))
 (clojure.core/map
  (clojure.core/fn [arg8595] (sqs/message-attribute-value arg8595))
  (clojure.core/vals v8541)))))
   (clojure.core/when-let
    [v8541 (:message-body m8540)]
    (. bean8539 setMessageBody (clojure.core/str v8541)))
   (clojure.core/when-let
    [v8541 (:delay-seconds m8540)]
    (. bean8539 setDelaySeconds (clojure.core/int v8541)))
   bean8539))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry}
delete-message-batch-request-entry
  [m8543]
  (clojure.core/let
   [bean8542
    (new
     com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry)]
   (clojure.core/when-let
    [v8544 (:id m8543)]
    (. bean8542 setId (clojure.core/str v8544)))
   (clojure.core/when-let
    [v8544 (:receipt-handle m8543)]
    (. bean8542 setReceiptHandle (clojure.core/str v8544)))
   bean8542))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueAttributesRequest}
get-queue-attributes-request
  [m8546]
  (clojure.core/let
   [bean8545
    (new com.amazonaws.services.sqs.model.GetQueueAttributesRequest)]
   (clojure.core/when-let
    [v8547 (:attribute-names m8546)]
    (.
     bean8545
     setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8596] (clojure.core/str arg8596))
 v8547)))
   (clojure.core/when-let
    [v8547 (:queue-url m8546)]
    (. bean8545 setQueueUrl (clojure.core/str v8547)))
   bean8545))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest}
change-message-visibility-batch-request
  [m8549]
  (clojure.core/let
   [bean8548
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest)]
   (clojure.core/when-let
    [v8550 (:queue-url m8549)]
    (. bean8548 setQueueUrl (clojure.core/str v8550)))
   (clojure.core/when-let
    [v8550 (:entries m8549)]
    (.
     bean8548
     setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8597]
  (sqs/change-message-visibility-batch-request-entry arg8597))
 v8550)))
   bean8548))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageRequest}
send-message-request
  [m8552]
  (clojure.core/let
   [bean8551
    (new com.amazonaws.services.sqs.model.SendMessageRequest)]
   (clojure.core/when-let
    [v8553 (:message-attributes m8552)]
    (.
     bean8551
     setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8598] (clojure.core/str arg8598))
  (clojure.core/keys v8553))
 (clojure.core/map
  (clojure.core/fn [arg8598] (sqs/message-attribute-value arg8598))
  (clojure.core/vals v8553)))))
   (clojure.core/when-let
    [v8553 (:queue-url m8552)]
    (. bean8551 setQueueUrl (clojure.core/str v8553)))
   (clojure.core/when-let
    [v8553 (:message-body m8552)]
    (. bean8551 setMessageBody (clojure.core/str v8553)))
   (clojure.core/when-let
    [v8553 (:delay-seconds m8552)]
    (. bean8551 setDelaySeconds (clojure.core/int v8553)))
   bean8551))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
list-queues-request
  [m8555]
  (clojure.core/let
   [bean8554 (new com.amazonaws.services.sqs.model.ListQueuesRequest)]
   (clojure.core/when-let
    [v8556 (:queue-name-prefix m8555)]
    (. bean8554 setQueueNamePrefix (clojure.core/str v8556)))
   bean8554))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.AddPermissionRequest}
add-permission-request
  [m8558]
  (clojure.core/let
   [bean8557
    (new com.amazonaws.services.sqs.model.AddPermissionRequest)]
   (clojure.core/when-let
    [v8559 (:label m8558)]
    (. bean8557 setLabel (clojure.core/str v8559)))
   (clojure.core/when-let
    [v8559 (:awsaccount-ids m8558)]
    (.
     bean8557
     setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8599] (clojure.core/str arg8599))
 v8559)))
   (clojure.core/when-let
    [v8559 (:queue-url m8558)]
    (. bean8557 setQueueUrl (clojure.core/str v8559)))
   (clojure.core/when-let
    [v8559 (:actions m8558)]
    (.
     bean8557
     setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8600] (clojure.core/str arg8600))
 v8559)))
   bean8557))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest}
list-dead-letter-source-queues-request
  [m8561]
  (clojure.core/let
   [bean8560
    (new
     com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest)]
   (clojure.core/when-let
    [v8562 (:queue-url m8561)]
    (. bean8560 setQueueUrl (clojure.core/str v8562)))
   bean8560))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageRequest}
delete-message-request
  [m8564]
  (clojure.core/let
   [bean8563
    (new com.amazonaws.services.sqs.model.DeleteMessageRequest)]
   (clojure.core/when-let
    [v8565 (:queue-url m8564)]
    (. bean8563 setQueueUrl (clojure.core/str v8565)))
   (clojure.core/when-let
    [v8565 (:receipt-handle m8564)]
    (. bean8563 setReceiptHandle (clojure.core/str v8565)))
   bean8563))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
create-queue-request
  [m8567]
  (clojure.core/let
   [bean8566
    (new com.amazonaws.services.sqs.model.CreateQueueRequest)]
   (clojure.core/when-let
    [v8568 (:attributes m8567)]
    (.
     bean8566
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8601] (clojure.core/str arg8601))
  (clojure.core/keys v8568))
 (clojure.core/map
  (clojure.core/fn [arg8601] (clojure.core/str arg8601))
  (clojure.core/vals v8568)))))
   (clojure.core/when-let
    [v8568 (:queue-name m8567)]
    (. bean8566 setQueueName (clojure.core/str v8568)))
   bean8566))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest}
change-message-visibility-request
  [m8570]
  (clojure.core/let
   [bean8569
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest)]
   (clojure.core/when-let
    [v8571 (:queue-url m8570)]
    (. bean8569 setQueueUrl (clojure.core/str v8571)))
   (clojure.core/when-let
    [v8571 (:receipt-handle m8570)]
    (. bean8569 setReceiptHandle (clojure.core/str v8571)))
   (clojure.core/when-let
    [v8571 (:visibility-timeout m8570)]
    (. bean8569 setVisibilityTimeout (clojure.core/int v8571)))
   bean8569))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequest}
send-message-batch-request
  [m8573]
  (clojure.core/let
   [bean8572
    (new com.amazonaws.services.sqs.model.SendMessageBatchRequest)]
   (clojure.core/when-let
    [v8574 (:queue-url m8573)]
    (. bean8572 setQueueUrl (clojure.core/str v8574)))
   (clojure.core/when-let
    [v8574 (:entries m8573)]
    (.
     bean8572
     setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8602]
  (sqs/send-message-batch-request-entry arg8602))
 v8574)))
   bean8572))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
delete-queue-request
  [m8576]
  (clojure.core/let
   [bean8575
    (new com.amazonaws.services.sqs.model.DeleteQueueRequest)]
   (clojure.core/when-let
    [v8577 (:queue-url m8576)]
    (. bean8575 setQueueUrl (clojure.core/str v8577)))
   bean8575))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
receive-message-request
  [m8579]
  (clojure.core/let
   [bean8578
    (new com.amazonaws.services.sqs.model.ReceiveMessageRequest)]
   (clojure.core/when-let
    [v8580 (:attribute-names m8579)]
    (.
     bean8578
     setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8603] (clojure.core/str arg8603))
 v8580)))
   (clojure.core/when-let
    [v8580 (:queue-url m8579)]
    (. bean8578 setQueueUrl (clojure.core/str v8580)))
   (clojure.core/when-let
    [v8580 (:visibility-timeout m8579)]
    (. bean8578 setVisibilityTimeout (clojure.core/int v8580)))
   (clojure.core/when-let
    [v8580 (:message-attribute-names m8579)]
    (.
     bean8578
     setMessageAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8604] (clojure.core/str arg8604))
 v8580)))
   (clojure.core/when-let
    [v8580 (:max-number-of-messages m8579)]
    (. bean8578 setMaxNumberOfMessages (clojure.core/int v8580)))
   (clojure.core/when-let
    [v8580 (:wait-time-seconds m8579)]
    (. bean8578 setWaitTimeSeconds (clojure.core/int v8580)))
   bean8578))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SetQueueAttributesRequest}
set-queue-attributes-request
  [m8582]
  (clojure.core/let
   [bean8581
    (new com.amazonaws.services.sqs.model.SetQueueAttributesRequest)]
   (clojure.core/when-let
    [v8583 (:attributes m8582)]
    (.
     bean8581
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8605] (clojure.core/str arg8605))
  (clojure.core/keys v8583))
 (clojure.core/map
  (clojure.core/fn [arg8605] (clojure.core/str arg8605))
  (clojure.core/vals v8583)))))
   (clojure.core/when-let
    [v8583 (:queue-url m8582)]
    (. bean8581 setQueueUrl (clojure.core/str v8583)))
   bean8581))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.RemovePermissionRequest}
remove-permission-request
  [m8585]
  (clojure.core/let
   [bean8584
    (new com.amazonaws.services.sqs.model.RemovePermissionRequest)]
   (clojure.core/when-let
    [v8586 (:label m8585)]
    (. bean8584 setLabel (clojure.core/str v8586)))
   (clojure.core/when-let
    [v8586 (:queue-url m8585)]
    (. bean8584 setQueueUrl (clojure.core/str v8586)))
   bean8584))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequest}
delete-message-batch-request
  [m8588]
  (clojure.core/let
   [bean8587
    (new com.amazonaws.services.sqs.model.DeleteMessageBatchRequest)]
   (clojure.core/when-let
    [v8589 (:queue-url m8588)]
    (. bean8587 setQueueUrl (clojure.core/str v8589)))
   (clojure.core/when-let
    [v8589 (:entries m8588)]
    (.
     bean8587
     setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8606]
  (sqs/delete-message-batch-request-entry arg8606))
 v8589)))
   bean8587))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
get-queue-url-request
  [m8591]
  (clojure.core/let
   [bean8590
    (new com.amazonaws.services.sqs.model.GetQueueUrlRequest)]
   (clojure.core/when-let
    [v8592 (:queue-name m8591)]
    (. bean8590 setQueueName (clojure.core/str v8592)))
   (clojure.core/when-let
    [v8592 (:queue-owner-awsaccount-id m8591)]
    (. bean8590 setQueueOwnerAWSAccountId (clojure.core/str v8592)))
   bean8590))
 (clojure.core/defmulti
  sqs
  (clojure.core/fn sqs [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-attributes
   [m8607]
   (clojure.core/let
    [credentials8608 (:credentials m8607) args8609 (:args m8607)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8610
      (com.palletops.awaze.common/aws-client :sqs credentials8608)]
     (clojure.core/case
      (clojure.core/count args8609)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8610
        getQueueAttributes
        (sqs/get-queue-attributes-request
         (clojure.core/nth args8609 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8610
        getQueueAttributes
        (clojure.core/str (clojure.core/nth args8609 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8623] (clojure.core/str arg8623))
 (clojure.core/nth args8609 1))))))))
  (clojure.core/defn
   get-queue-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         general-progress-listener
                         attribute-names]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for getQueueAttributes, getQueueAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :get-queue-attributes,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :get-queue-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-queue-attributes
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         general-progress-listener
                         attribute-names]}]
                [credentials string-0 list-1]]),
    :doc "Call getQueueAttributes, getQueueAttributes"}
   [credentials8612 & args8613]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8614
     (com.palletops.awaze.common/aws-client :sqs credentials8612)]
    (clojure.core/case
     (clojure.core/count args8613)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8614
       getQueueAttributes
       (sqs/get-queue-attributes-request
        (clojure.core/nth args8613 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8614
       getQueueAttributes
       (clojure.core/str (clojure.core/nth args8613 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8624] (clojure.core/str arg8624))
 (clojure.core/nth args8613 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility-batch
   [m8615]
   (clojure.core/let
    [credentials8616 (:credentials m8615) args8617 (:args m8615)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8618
      (com.palletops.awaze.common/aws-client :sqs credentials8616)]
     (clojure.core/case
      (clojure.core/count args8617)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8618
        changeMessageVisibilityBatch
        (sqs/change-message-visibility-batch-request
         (clojure.core/nth args8617 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8618
        changeMessageVisibilityBatch
        (clojure.core/str (clojure.core/nth args8617 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8633]
  (sqs/change-message-visibility-batch-request-entry arg8633))
 (clojure.core/nth args8617 1))))))))
  (clojure.core/defn
   change-message-visibility-batch-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener entries]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :change-message-visibility-batch,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :change-message-visibility-batch,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   change-message-visibility-batch
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener entries]}]
                [credentials string-0 list-1]]),
    :doc "Call changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   [credentials8620 & args8621]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8622
     (com.palletops.awaze.common/aws-client :sqs credentials8620)]
    (clojure.core/case
     (clojure.core/count args8621)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8622
       changeMessageVisibilityBatch
       (sqs/change-message-visibility-batch-request
        (clojure.core/nth args8621 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8622
       changeMessageVisibilityBatch
       (clojure.core/str (clojure.core/nth args8621 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8634]
  (sqs/change-message-visibility-batch-request-entry arg8634))
 (clojure.core/nth args8621 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message
   [m8625]
   (clojure.core/let
    [credentials8626 (:credentials m8625) args8627 (:args m8625)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8628
      (com.palletops.awaze.common/aws-client :sqs credentials8626)]
     (clojure.core/case
      (clojure.core/count args8627)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8628
        sendMessage
        (clojure.core/str (clojure.core/nth args8627 0))
        (clojure.core/str (clojure.core/nth args8627 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8628
        sendMessage
        (sqs/send-message-request (clojure.core/nth args8627 0))))))))
  (clojure.core/defn
   send-message-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [queue-url
                         message-body
                         message-attributes
                         general-progress-listener
                         delay-seconds]}]]),
    :doc "Generate map for sendMessage, sendMessage"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :send-message,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :send-message,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   send-message
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [queue-url
                         message-body
                         message-attributes
                         general-progress-listener
                         delay-seconds]}]]),
    :doc "Call sendMessage, sendMessage"}
   [credentials8630 & args8631]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8632
     (com.palletops.awaze.common/aws-client :sqs credentials8630)]
    (clojure.core/case
     (clojure.core/count args8631)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8632
       sendMessage
       (clojure.core/str (clojure.core/nth args8631 0))
       (clojure.core/str (clojure.core/nth args8631 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8632
       sendMessage
       (sqs/send-message-request (clojure.core/nth args8631 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-queues
   [m8635]
   (clojure.core/let
    [credentials8636 (:credentials m8635) args8637 (:args m8635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8638
      (com.palletops.awaze.common/aws-client :sqs credentials8636)]
     (clojure.core/case
      (clojure.core/count args8637)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8638
        listQueues))
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8637 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8638
           listQueues
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.ListQueuesRequest
               (clojure.core/nth args8637 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8638
               listQueues
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listQueues")
                {:args args8637}))))))))))))))
  (clojure.core/defn
   list-queues-map
   {:arglists (quote
               [[credentials]
                [credentials string-0]
                [credentials
                 {:keys [queue-name-prefix general-progress-listener]}]]),
    :doc "Generate map for listQueues, listQueues, listQueues"}
   ([credentials__1649__auto__]
    {:args [],
     :client :sqs,
     :fn :list-queues,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :list-queues,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-queues
   {:arglists (quote
               [[credentials]
                [credentials string-0]
                [credentials
                 {:keys [queue-name-prefix general-progress-listener]}]]),
    :doc "Call listQueues, listQueues, listQueues"}
   [credentials8640 & args8641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8642
     (com.palletops.awaze.common/aws-client :sqs credentials8640)]
    (clojure.core/case
     (clojure.core/count args8641)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8642
       listQueues))
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8641 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8642
          listQueues
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.ListQueuesRequest
              (clojure.core/nth args8641 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8642
              listQueues
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listQueues")
               {:args args8641}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :add-permission
   [m8643]
   (clojure.core/let
    [credentials8644 (:credentials m8643) args8645 (:args m8643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8646
      (com.palletops.awaze.common/aws-client :sqs credentials8644)]
     (clojure.core/case
      (clojure.core/count args8645)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8646
        addPermission
        (clojure.core/str (clojure.core/nth args8645 0))
        (clojure.core/str (clojure.core/nth args8645 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8659] (clojure.core/str arg8659))
 (clojure.core/nth args8645 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8660] (clojure.core/str arg8660))
 (clojure.core/nth args8645 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8646
        addPermission
        (sqs/add-permission-request (clojure.core/nth args8645 0))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [queue-url
                         label
                         general-progress-listener
                         actions
                         awsaccount-ids]}]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :add-permission,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c d]
    {:args [a b c d],
     :client :sqs,
     :fn :add-permission,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [queue-url
                         label
                         general-progress-listener
                         actions
                         awsaccount-ids]}]]),
    :doc "Call addPermission, addPermission"}
   [credentials8648 & args8649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8650
     (com.palletops.awaze.common/aws-client :sqs credentials8648)]
    (clojure.core/case
     (clojure.core/count args8649)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8650
       addPermission
       (clojure.core/str (clojure.core/nth args8649 0))
       (clojure.core/str (clojure.core/nth args8649 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8661] (clojure.core/str arg8661))
 (clojure.core/nth args8649 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8662] (clojure.core/str arg8662))
 (clojure.core/nth args8649 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8650
       addPermission
       (sqs/add-permission-request (clojure.core/nth args8649 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-dead-letter-source-queues
   [m8651]
   (clojure.core/let
    [credentials8652 (:credentials m8651) args8653 (:args m8651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8654
      (com.palletops.awaze.common/aws-client :sqs credentials8652)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8654
       listDeadLetterSourceQueues
       (sqs/list-dead-letter-source-queues-request
        (clojure.core/nth args8653 0)))))))
  (clojure.core/defn
   list-dead-letter-source-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Generate map for listDeadLetterSourceQueues"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :list-dead-letter-source-queues,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-dead-letter-source-queues
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Call listDeadLetterSourceQueues"}
   [credentials8656 & args8657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8658
     (com.palletops.awaze.common/aws-client :sqs credentials8656)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8658
      listDeadLetterSourceQueues
      (sqs/list-dead-letter-source-queues-request
       (clojure.core/nth args8657 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message
   [m8663]
   (clojure.core/let
    [credentials8664 (:credentials m8663) args8665 (:args m8663)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8666
      (com.palletops.awaze.common/aws-client :sqs credentials8664)]
     (clojure.core/case
      (clojure.core/count args8665)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8666
        deleteMessage
        (clojure.core/str (clojure.core/nth args8665 0))
        (clojure.core/str (clojure.core/nth args8665 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8666
        deleteMessage
        (sqs/delete-message-request (clojure.core/nth args8665 0))))))))
  (clojure.core/defn
   delete-message-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [receipt-handle
                         queue-url
                         general-progress-listener]}]]),
    :doc "Generate map for deleteMessage, deleteMessage"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :delete-message,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :delete-message,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-message
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [receipt-handle
                         queue-url
                         general-progress-listener]}]]),
    :doc "Call deleteMessage, deleteMessage"}
   [credentials8668 & args8669]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8670
     (com.palletops.awaze.common/aws-client :sqs credentials8668)]
    (clojure.core/case
     (clojure.core/count args8669)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8670
       deleteMessage
       (clojure.core/str (clojure.core/nth args8669 0))
       (clojure.core/str (clojure.core/nth args8669 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8670
       deleteMessage
       (sqs/delete-message-request (clojure.core/nth args8669 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :create-queue
   [m8671]
   (clojure.core/let
    [credentials8672 (:credentials m8671) args8673 (:args m8671)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8674
      (com.palletops.awaze.common/aws-client :sqs credentials8672)]
     (clojure.core/case
      (clojure.core/count args8673)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.CreateQueueRequest
           (clojure.core/nth args8673 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8674
           createQueue
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8673 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8674
               createQueue
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createQueue")
                {:args args8673}))))))))))))))
  (clojure.core/defn
   create-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-name
                         general-progress-listener
                         attributes]}]
                [credentials string-0]]),
    :doc "Generate map for createQueue, createQueue"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :create-queue,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-queue
   {:arglists (quote
               [[credentials
                 {:keys [queue-name
                         general-progress-listener
                         attributes]}]
                [credentials string-0]]),
    :doc "Call createQueue, createQueue"}
   [credentials8676 & args8677]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8678
     (com.palletops.awaze.common/aws-client :sqs credentials8676)]
    (clojure.core/case
     (clojure.core/count args8677)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.CreateQueueRequest
          (clojure.core/nth args8677 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8678
          createQueue
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8677 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8678
              createQueue
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createQueue")
               {:args args8677}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility
   [m8679]
   (clojure.core/let
    [credentials8680 (:credentials m8679) args8681 (:args m8679)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8682
      (com.palletops.awaze.common/aws-client :sqs credentials8680)]
     (clojure.core/case
      (clojure.core/count args8681)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8682
        changeMessageVisibility
        (sqs/change-message-visibility-request
         (clojure.core/nth args8681 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8682
        changeMessageVisibility
        (clojure.core/str (clojure.core/nth args8681 0))
        (clojure.core/str (clojure.core/nth args8681 1))
        (clojure.core/int (clojure.core/nth args8681 2))))))))
  (clojure.core/defn
   change-message-visibility-map
   {:arglists (quote
               [[credentials
                 {:keys [visibility-timeout
                         receipt-handle
                         queue-url
                         general-progress-listener]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Generate map for changeMessageVisibility, changeMessageVisibility"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :change-message-visibility,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :sqs,
     :fn :change-message-visibility,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   change-message-visibility
   {:arglists (quote
               [[credentials
                 {:keys [visibility-timeout
                         receipt-handle
                         queue-url
                         general-progress-listener]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Call changeMessageVisibility, changeMessageVisibility"}
   [credentials8684 & args8685]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8686
     (com.palletops.awaze.common/aws-client :sqs credentials8684)]
    (clojure.core/case
     (clojure.core/count args8685)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8686
       changeMessageVisibility
       (sqs/change-message-visibility-request
        (clojure.core/nth args8685 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8686
       changeMessageVisibility
       (clojure.core/str (clojure.core/nth args8685 0))
       (clojure.core/str (clojure.core/nth args8685 1))
       (clojure.core/int (clojure.core/nth args8685 2))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message-batch
   [m8687]
   (clojure.core/let
    [credentials8688 (:credentials m8687) args8689 (:args m8687)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8690
      (com.palletops.awaze.common/aws-client :sqs credentials8688)]
     (clojure.core/case
      (clojure.core/count args8689)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8690
        sendMessageBatch
        (sqs/send-message-batch-request (clojure.core/nth args8689 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8690
        sendMessageBatch
        (clojure.core/str (clojure.core/nth args8689 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8703]
  (sqs/send-message-batch-request-entry arg8703))
 (clojure.core/nth args8689 1))))))))
  (clojure.core/defn
   send-message-batch-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener entries]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for sendMessageBatch, sendMessageBatch"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :send-message-batch,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :send-message-batch,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   send-message-batch
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener entries]}]
                [credentials string-0 list-1]]),
    :doc "Call sendMessageBatch, sendMessageBatch"}
   [credentials8692 & args8693]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8694
     (com.palletops.awaze.common/aws-client :sqs credentials8692)]
    (clojure.core/case
     (clojure.core/count args8693)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8694
       sendMessageBatch
       (sqs/send-message-batch-request (clojure.core/nth args8693 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8694
       sendMessageBatch
       (clojure.core/str (clojure.core/nth args8693 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8704]
  (sqs/send-message-batch-request-entry arg8704))
 (clojure.core/nth args8693 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-queue
   [m8695]
   (clojure.core/let
    [credentials8696 (:credentials m8695) args8697 (:args m8695)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8698
      (com.palletops.awaze.common/aws-client :sqs credentials8696)]
     (clojure.core/case
      (clojure.core/count args8697)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8697 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8698
           deleteQueue
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.DeleteQueueRequest
               (clojure.core/nth args8697 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8698
               deleteQueue
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteQueue")
                {:args args8697}))))))))))))))
  (clojure.core/defn
   delete-queue-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Generate map for deleteQueue, deleteQueue"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :delete-queue,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-queue
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Call deleteQueue, deleteQueue"}
   [credentials8700 & args8701]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8702
     (com.palletops.awaze.common/aws-client :sqs credentials8700)]
    (clojure.core/case
     (clojure.core/count args8701)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8701 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8702
          deleteQueue
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.DeleteQueueRequest
              (clojure.core/nth args8701 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8702
              deleteQueue
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteQueue")
               {:args args8701}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :receive-message
   [m8705]
   (clojure.core/let
    [credentials8706 (:credentials m8705) args8707 (:args m8705)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8708
      (com.palletops.awaze.common/aws-client :sqs credentials8706)]
     (clojure.core/case
      (clojure.core/count args8707)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8707 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8708
           receiveMessage
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.ReceiveMessageRequest
               (clojure.core/nth args8707 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8708
               receiveMessage
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "receiveMessage")
                {:args args8707}))))))))))))))
  (clojure.core/defn
   receive-message-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener
                         message-attribute-names
                         queue-url
                         wait-time-seconds
                         attribute-names
                         max-number-of-messages
                         visibility-timeout]}]]),
    :doc "Generate map for receiveMessage, receiveMessage"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :receive-message,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   receive-message
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener
                         message-attribute-names
                         queue-url
                         wait-time-seconds
                         attribute-names
                         max-number-of-messages
                         visibility-timeout]}]]),
    :doc "Call receiveMessage, receiveMessage"}
   [credentials8710 & args8711]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8712
     (com.palletops.awaze.common/aws-client :sqs credentials8710)]
    (clojure.core/case
     (clojure.core/count args8711)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8711 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8712
          receiveMessage
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.ReceiveMessageRequest
              (clojure.core/nth args8711 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8712
              receiveMessage
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "receiveMessage")
               {:args args8711}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :set-queue-attributes
   [m8713]
   (clojure.core/let
    [credentials8714 (:credentials m8713) args8715 (:args m8713)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8716
      (com.palletops.awaze.common/aws-client :sqs credentials8714)]
     (clojure.core/case
      (clojure.core/count args8715)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8716
        setQueueAttributes
        (sqs/set-queue-attributes-request
         (clojure.core/nth args8715 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8716
        setQueueAttributes
        (clojure.core/str (clojure.core/nth args8715 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8729] (clojure.core/str arg8729))
  (clojure.core/keys (clojure.core/nth args8715 1)))
 (clojure.core/map
  (clojure.core/fn [arg8729] (clojure.core/str arg8729))
  (clojure.core/vals (clojure.core/nth args8715 1))))))))))
  (clojure.core/defn
   set-queue-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         general-progress-listener
                         attributes]}]
                [credentials string-0 map-1]]),
    :doc "Generate map for setQueueAttributes, setQueueAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :set-queue-attributes,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :set-queue-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-queue-attributes
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         general-progress-listener
                         attributes]}]
                [credentials string-0 map-1]]),
    :doc "Call setQueueAttributes, setQueueAttributes"}
   [credentials8718 & args8719]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8720
     (com.palletops.awaze.common/aws-client :sqs credentials8718)]
    (clojure.core/case
     (clojure.core/count args8719)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8720
       setQueueAttributes
       (sqs/set-queue-attributes-request
        (clojure.core/nth args8719 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8720
       setQueueAttributes
       (clojure.core/str (clojure.core/nth args8719 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8730] (clojure.core/str arg8730))
  (clojure.core/keys (clojure.core/nth args8719 1)))
 (clojure.core/map
  (clojure.core/fn [arg8730] (clojure.core/str arg8730))
  (clojure.core/vals (clojure.core/nth args8719 1))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :remove-permission
   [m8721]
   (clojure.core/let
    [credentials8722 (:credentials m8721) args8723 (:args m8721)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8724
      (com.palletops.awaze.common/aws-client :sqs credentials8722)]
     (clojure.core/case
      (clojure.core/count args8723)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8724
        removePermission
        (sqs/remove-permission-request (clojure.core/nth args8723 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8724
        removePermission
        (clojure.core/str (clojure.core/nth args8723 0))
        (clojure.core/str (clojure.core/nth args8723 1))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url label general-progress-listener]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :remove-permission,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :remove-permission,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials
                 {:keys [queue-url label general-progress-listener]}]
                [credentials string-0 string-1]]),
    :doc "Call removePermission, removePermission"}
   [credentials8726 & args8727]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8728
     (com.palletops.awaze.common/aws-client :sqs credentials8726)]
    (clojure.core/case
     (clojure.core/count args8727)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8728
       removePermission
       (sqs/remove-permission-request (clojure.core/nth args8727 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8728
       removePermission
       (clojure.core/str (clojure.core/nth args8727 0))
       (clojure.core/str (clojure.core/nth args8727 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message-batch
   [m8731]
   (clojure.core/let
    [credentials8732 (:credentials m8731) args8733 (:args m8731)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8734
      (com.palletops.awaze.common/aws-client :sqs credentials8732)]
     (clojure.core/case
      (clojure.core/count args8733)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8734
        deleteMessageBatch
        (clojure.core/str (clojure.core/nth args8733 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8747]
  (sqs/delete-message-batch-request-entry arg8747))
 (clojure.core/nth args8733 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8734
        deleteMessageBatch
        (sqs/delete-message-batch-request
         (clojure.core/nth args8733 0))))))))
  (clojure.core/defn
   delete-message-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [queue-url general-progress-listener entries]}]]),
    :doc "Generate map for deleteMessageBatch, deleteMessageBatch"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :delete-message-batch,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :delete-message-batch,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-message-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [queue-url general-progress-listener entries]}]]),
    :doc "Call deleteMessageBatch, deleteMessageBatch"}
   [credentials8736 & args8737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8738
     (com.palletops.awaze.common/aws-client :sqs credentials8736)]
    (clojure.core/case
     (clojure.core/count args8737)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8738
       deleteMessageBatch
       (clojure.core/str (clojure.core/nth args8737 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8748]
  (sqs/delete-message-batch-request-entry arg8748))
 (clojure.core/nth args8737 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8738
       deleteMessageBatch
       (sqs/delete-message-batch-request
        (clojure.core/nth args8737 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-url
   [m8739]
   (clojure.core/let
    [credentials8740 (:credentials m8739) args8741 (:args m8739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8742
      (com.palletops.awaze.common/aws-client :sqs credentials8740)]
     (clojure.core/case
      (clojure.core/count args8741)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8741 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8742
           getQueueUrl
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.GetQueueUrlRequest
               (clojure.core/nth args8741 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8742
               getQueueUrl
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getQueueUrl")
                {:args args8741}))))))))))))))
  (clojure.core/defn
   get-queue-url-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-owner-awsaccount-id
                         queue-name
                         general-progress-listener]}]]),
    :doc "Generate map for getQueueUrl, getQueueUrl"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :get-queue-url,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-queue-url
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-owner-awsaccount-id
                         queue-name
                         general-progress-listener]}]]),
    :doc "Call getQueueUrl, getQueueUrl"}
   [credentials8744 & args8745]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8746
     (com.palletops.awaze.common/aws-client :sqs credentials8744)]
    (clojure.core/case
     (clojure.core/count args8745)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8745 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8746
          getQueueUrl
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.GetQueueUrlRequest
              (clojure.core/nth args8745 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8746
              getQueueUrl
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getQueueUrl")
               {:args args8745})))))))))))))))
