(ns
 com.palletops.awaze.sns
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sns :as sns]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sns
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.sns.AmazonSNSClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.MessageAttributeValue}
message-attribute-value
  [m3128]
  (clojure.core/let
   [bean3127
    (new com.amazonaws.services.sns.model.MessageAttributeValue)]
   (clojure.core/when-let
    [v3129 (:data-type m3128)]
    (. bean3127 setDataType (clojure.core/str v3129)))
   (clojure.core/when-let
    [v3129 (:string-value m3128)]
    (. bean3127 setStringValue (clojure.core/str v3129)))
   (clojure.core/when-let
    [v3129 (:binary-value m3128)]
    (. bean3127 setBinaryValue (clojure.core/identity v3129)))
   bean3127))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetEndpointAttributesRequest}
get-endpoint-attributes-request
  [m3131]
  (clojure.core/let
   [bean3130
    (new
     com.amazonaws.services.sns.model.GetEndpointAttributesRequest)]
   (clojure.core/when-let
    [v3132 (:endpoint-arn m3131)]
    (. bean3130 setEndpointArn (clojure.core/str v3132)))
   bean3130))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest}
get-platform-application-attributes-request
  [m3134]
  (clojure.core/let
   [bean3133
    (new
     com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest)]
   (clojure.core/when-let
    [v3135 (:platform-application-arn m3134)]
    (. bean3133 setPlatformApplicationArn (clojure.core/str v3135)))
   bean3133))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetTopicAttributesRequest}
set-topic-attributes-request
  [m3137]
  (clojure.core/let
   [bean3136
    (new com.amazonaws.services.sns.model.SetTopicAttributesRequest)]
   (clojure.core/when-let
    [v3138 (:topic-arn m3137)]
    (. bean3136 setTopicArn (clojure.core/str v3138)))
   (clojure.core/when-let
    [v3138 (:attribute-name m3137)]
    (. bean3136 setAttributeName (clojure.core/str v3138)))
   (clojure.core/when-let
    [v3138 (:attribute-value m3137)]
    (. bean3136 setAttributeValue (clojure.core/str v3138)))
   bean3136))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.AddPermissionRequest}
add-permission-request
  [m3140]
  (clojure.core/let
   [bean3139
    (new com.amazonaws.services.sns.model.AddPermissionRequest)]
   (clojure.core/when-let
    [v3141 (:topic-arn m3140)]
    (. bean3139 setTopicArn (clojure.core/str v3141)))
   (clojure.core/when-let
    [v3141 (:label m3140)]
    (. bean3139 setLabel (clojure.core/str v3141)))
   (clojure.core/when-let
    [v3141 (:awsaccount-ids m3140)]
    (.
     bean3139
     setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3205] (clojure.core/str arg3205))
 v3141)))
   (clojure.core/when-let
    [v3141 (:action-names m3140)]
    (.
     bean3139
     setActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3206] (clojure.core/str arg3206))
 v3141)))
   bean3139))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
get-subscription-attributes-request
  [m3143]
  (clojure.core/let
   [bean3142
    (new
     com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest)]
   (clojure.core/when-let
    [v3144 (:subscription-arn m3143)]
    (. bean3142 setSubscriptionArn (clojure.core/str v3144)))
   bean3142))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ConfirmSubscriptionRequest}
confirm-subscription-request
  [m3146]
  (clojure.core/let
   [bean3145
    (new com.amazonaws.services.sns.model.ConfirmSubscriptionRequest)]
   (clojure.core/when-let
    [v3147 (:topic-arn m3146)]
    (. bean3145 setTopicArn (clojure.core/str v3147)))
   (clojure.core/when-let
    [v3147 (:token m3146)]
    (. bean3145 setToken (clojure.core/str v3147)))
   (clojure.core/when-let
    [v3147 (:authenticate-on-unsubscribe m3146)]
    (. bean3145 setAuthenticateOnUnsubscribe (clojure.core/str v3147)))
   bean3145))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
delete-topic-request
  [m3149]
  (clojure.core/let
   [bean3148
    (new com.amazonaws.services.sns.model.DeleteTopicRequest)]
   (clojure.core/when-let
    [v3150 (:topic-arn m3149)]
    (. bean3148 setTopicArn (clojure.core/str v3150)))
   bean3148))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.PublishRequest}
publish-request
  [m3152]
  (clojure.core/let
   [bean3151 (new com.amazonaws.services.sns.model.PublishRequest)]
   (clojure.core/when-let
    [v3153 (:message m3152)]
    (. bean3151 setMessage (clojure.core/str v3153)))
   (clojure.core/when-let
    [v3153 (:topic-arn m3152)]
    (. bean3151 setTopicArn (clojure.core/str v3153)))
   (clojure.core/when-let
    [v3153 (:target-arn m3152)]
    (. bean3151 setTargetArn (clojure.core/str v3153)))
   (clojure.core/when-let
    [v3153 (:message-structure m3152)]
    (. bean3151 setMessageStructure (clojure.core/str v3153)))
   (clojure.core/when-let
    [v3153 (:message-attributes m3152)]
    (.
     bean3151
     setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3207] (clojure.core/str arg3207))
  (clojure.core/keys v3153))
 (clojure.core/map
  (clojure.core/fn [arg3207] (sns/message-attribute-value arg3207))
  (clojure.core/vals v3153)))))
   (clojure.core/when-let
    [v3153 (:subject m3152)]
    (. bean3151 setSubject (clojure.core/str v3153)))
   bean3151))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
list-topics-request
  [m3155]
  (clojure.core/let
   [bean3154 (new com.amazonaws.services.sns.model.ListTopicsRequest)]
   (clojure.core/when-let
    [v3156 (:next-token m3155)]
    (. bean3154 setNextToken (clojure.core/str v3156)))
   bean3154))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
list-subscriptions-by-topic-request
  [m3158]
  (clojure.core/let
   [bean3157
    (new
     com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest)]
   (clojure.core/when-let
    [v3159 (:next-token m3158)]
    (. bean3157 setNextToken (clojure.core/str v3159)))
   (clojure.core/when-let
    [v3159 (:topic-arn m3158)]
    (. bean3157 setTopicArn (clojure.core/str v3159)))
   bean3157))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeletePlatformApplicationRequest}
delete-platform-application-request
  [m3161]
  (clojure.core/let
   [bean3160
    (new
     com.amazonaws.services.sns.model.DeletePlatformApplicationRequest)]
   (clojure.core/when-let
    [v3162 (:platform-application-arn m3161)]
    (. bean3160 setPlatformApplicationArn (clojure.core/str v3162)))
   bean3160))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest}
list-endpoints-by-platform-application-request
  [m3164]
  (clojure.core/let
   [bean3163
    (new
     com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest)]
   (clojure.core/when-let
    [v3165 (:next-token m3164)]
    (. bean3163 setNextToken (clojure.core/str v3165)))
   (clojure.core/when-let
    [v3165 (:platform-application-arn m3164)]
    (. bean3163 setPlatformApplicationArn (clojure.core/str v3165)))
   bean3163))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
unsubscribe-request
  [m3167]
  (clojure.core/let
   [bean3166
    (new com.amazonaws.services.sns.model.UnsubscribeRequest)]
   (clojure.core/when-let
    [v3168 (:subscription-arn m3167)]
    (. bean3166 setSubscriptionArn (clojure.core/str v3168)))
   bean3166))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest}
set-subscription-attributes-request
  [m3170]
  (clojure.core/let
   [bean3169
    (new
     com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest)]
   (clojure.core/when-let
    [v3171 (:attribute-name m3170)]
    (. bean3169 setAttributeName (clojure.core/str v3171)))
   (clojure.core/when-let
    [v3171 (:attribute-value m3170)]
    (. bean3169 setAttributeValue (clojure.core/str v3171)))
   (clojure.core/when-let
    [v3171 (:subscription-arn m3170)]
    (. bean3169 setSubscriptionArn (clojure.core/str v3171)))
   bean3169))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
list-subscriptions-request
  [m3173]
  (clojure.core/let
   [bean3172
    (new com.amazonaws.services.sns.model.ListSubscriptionsRequest)]
   (clojure.core/when-let
    [v3174 (:next-token m3173)]
    (. bean3172 setNextToken (clojure.core/str v3174)))
   bean3172))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
create-topic-request
  [m3176]
  (clojure.core/let
   [bean3175
    (new com.amazonaws.services.sns.model.CreateTopicRequest)]
   (clojure.core/when-let
    [v3177 (:name m3176)]
    (. bean3175 setName (clojure.core/str v3177)))
   bean3175))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformEndpointRequest}
create-platform-endpoint-request
  [m3179]
  (clojure.core/let
   [bean3178
    (new
     com.amazonaws.services.sns.model.CreatePlatformEndpointRequest)]
   (clojure.core/when-let
    [v3180 (:token m3179)]
    (. bean3178 setToken (clojure.core/str v3180)))
   (clojure.core/when-let
    [v3180 (:platform-application-arn m3179)]
    (. bean3178 setPlatformApplicationArn (clojure.core/str v3180)))
   (clojure.core/when-let
    [v3180 (:custom-user-data m3179)]
    (. bean3178 setCustomUserData (clojure.core/str v3180)))
   (clojure.core/when-let
    [v3180 (:attributes m3179)]
    (.
     bean3178
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3208] (clojure.core/str arg3208))
  (clojure.core/keys v3180))
 (clojure.core/map
  (clojure.core/fn [arg3208] (clojure.core/str arg3208))
  (clojure.core/vals v3180)))))
   bean3178))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.RemovePermissionRequest}
remove-permission-request
  [m3182]
  (clojure.core/let
   [bean3181
    (new com.amazonaws.services.sns.model.RemovePermissionRequest)]
   (clojure.core/when-let
    [v3183 (:topic-arn m3182)]
    (. bean3181 setTopicArn (clojure.core/str v3183)))
   (clojure.core/when-let
    [v3183 (:label m3182)]
    (. bean3181 setLabel (clojure.core/str v3183)))
   bean3181))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
get-topic-attributes-request
  [m3185]
  (clojure.core/let
   [bean3184
    (new com.amazonaws.services.sns.model.GetTopicAttributesRequest)]
   (clojure.core/when-let
    [v3186 (:topic-arn m3185)]
    (. bean3184 setTopicArn (clojure.core/str v3186)))
   bean3184))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SubscribeRequest}
subscribe-request
  [m3188]
  (clojure.core/let
   [bean3187 (new com.amazonaws.services.sns.model.SubscribeRequest)]
   (clojure.core/when-let
    [v3189 (:protocol m3188)]
    (. bean3187 setProtocol (clojure.core/str v3189)))
   (clojure.core/when-let
    [v3189 (:topic-arn m3188)]
    (. bean3187 setTopicArn (clojure.core/str v3189)))
   (clojure.core/when-let
    [v3189 (:endpoint m3188)]
    (. bean3187 setEndpoint (clojure.core/str v3189)))
   bean3187))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteEndpointRequest}
delete-endpoint-request
  [m3191]
  (clojure.core/let
   [bean3190
    (new com.amazonaws.services.sns.model.DeleteEndpointRequest)]
   (clojure.core/when-let
    [v3192 (:endpoint-arn m3191)]
    (. bean3190 setEndpointArn (clojure.core/str v3192)))
   bean3190))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListPlatformApplicationsRequest}
list-platform-applications-request
  [m3194]
  (clojure.core/let
   [bean3193
    (new
     com.amazonaws.services.sns.model.ListPlatformApplicationsRequest)]
   (clojure.core/when-let
    [v3195 (:next-token m3194)]
    (. bean3193 setNextToken (clojure.core/str v3195)))
   bean3193))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest}
set-platform-application-attributes-request
  [m3197]
  (clojure.core/let
   [bean3196
    (new
     com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest)]
   (clojure.core/when-let
    [v3198 (:platform-application-arn m3197)]
    (. bean3196 setPlatformApplicationArn (clojure.core/str v3198)))
   (clojure.core/when-let
    [v3198 (:attributes m3197)]
    (.
     bean3196
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3209] (clojure.core/str arg3209))
  (clojure.core/keys v3198))
 (clojure.core/map
  (clojure.core/fn [arg3209] (clojure.core/str arg3209))
  (clojure.core/vals v3198)))))
   bean3196))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformApplicationRequest}
create-platform-application-request
  [m3200]
  (clojure.core/let
   [bean3199
    (new
     com.amazonaws.services.sns.model.CreatePlatformApplicationRequest)]
   (clojure.core/when-let
    [v3201 (:name m3200)]
    (. bean3199 setName (clojure.core/str v3201)))
   (clojure.core/when-let
    [v3201 (:platform m3200)]
    (. bean3199 setPlatform (clojure.core/str v3201)))
   (clojure.core/when-let
    [v3201 (:attributes m3200)]
    (.
     bean3199
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3210] (clojure.core/str arg3210))
  (clojure.core/keys v3201))
 (clojure.core/map
  (clojure.core/fn [arg3210] (clojure.core/str arg3210))
  (clojure.core/vals v3201)))))
   bean3199))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetEndpointAttributesRequest}
set-endpoint-attributes-request
  [m3203]
  (clojure.core/let
   [bean3202
    (new
     com.amazonaws.services.sns.model.SetEndpointAttributesRequest)]
   (clojure.core/when-let
    [v3204 (:endpoint-arn m3203)]
    (. bean3202 setEndpointArn (clojure.core/str v3204)))
   (clojure.core/when-let
    [v3204 (:attributes m3203)]
    (.
     bean3202
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3211] (clojure.core/str arg3211))
  (clojure.core/keys v3204))
 (clojure.core/map
  (clojure.core/fn [arg3211] (clojure.core/str arg3211))
  (clojure.core/vals v3204)))))
   bean3202))
 (clojure.core/defmulti
  sns
  (clojure.core/fn sns [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   sns
   :get-endpoint-attributes
   [m3212]
   (clojure.core/let
    [credentials3213 (:credentials m3212) args3214 (:args m3212)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3215
      (com.palletops.awaze.common/aws-client :sns credentials3213)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3215
       getEndpointAttributes
       (sns/get-endpoint-attributes-request
        (clojure.core/nth args3214 0)))))))
  (clojure.core/defn
   get-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Generate map for getEndpointAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-endpoint-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Call getEndpointAttributes"}
   [credentials3217 & args3218]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3219
     (com.palletops.awaze.common/aws-client :sns credentials3217)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3219
      getEndpointAttributes
      (sns/get-endpoint-attributes-request
       (clojure.core/nth args3218 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-platform-application-attributes
   [m3220]
   (clojure.core/let
    [credentials3221 (:credentials m3220) args3222 (:args m3220)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3223
      (com.palletops.awaze.common/aws-client :sns credentials3221)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3223
       getPlatformApplicationAttributes
       (sns/get-platform-application-attributes-request
        (clojure.core/nth args3222 0)))))))
  (clojure.core/defn
   get-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Generate map for getPlatformApplicationAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-platform-application-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Call getPlatformApplicationAttributes"}
   [credentials3225 & args3226]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3227
     (com.palletops.awaze.common/aws-client :sns credentials3225)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3227
      getPlatformApplicationAttributes
      (sns/get-platform-application-attributes-request
       (clojure.core/nth args3226 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-topic-attributes
   [m3228]
   (clojure.core/let
    [credentials3229 (:credentials m3228) args3230 (:args m3228)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3231
      (com.palletops.awaze.common/aws-client :sns credentials3229)]
     (clojure.core/case
      (clojure.core/count args3230)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3231
        setTopicAttributes
        (sns/set-topic-attributes-request
         (clojure.core/nth args3230 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3231
        setTopicAttributes
        (clojure.core/str (clojure.core/nth args3230 0))
        (clojure.core/str (clojure.core/nth args3230 1))
        (clojure.core/str (clojure.core/nth args3230 2))))))))
  (clojure.core/defn
   set-topic-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for setTopicAttributes, setTopicAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-topic-attributes,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :set-topic-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-topic-attributes
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call setTopicAttributes, setTopicAttributes"}
   [credentials3233 & args3234]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3235
     (com.palletops.awaze.common/aws-client :sns credentials3233)]
    (clojure.core/case
     (clojure.core/count args3234)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3235
       setTopicAttributes
       (sns/set-topic-attributes-request
        (clojure.core/nth args3234 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3235
       setTopicAttributes
       (clojure.core/str (clojure.core/nth args3234 0))
       (clojure.core/str (clojure.core/nth args3234 1))
       (clojure.core/str (clojure.core/nth args3234 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :add-permission
   [m3236]
   (clojure.core/let
    [credentials3237 (:credentials m3236) args3238 (:args m3236)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3239
      (com.palletops.awaze.common/aws-client :sns credentials3237)]
     (clojure.core/case
      (clojure.core/count args3238)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3239
        addPermission
        (sns/add-permission-request (clojure.core/nth args3238 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3239
        addPermission
        (clojure.core/str (clojure.core/nth args3238 0))
        (clojure.core/str (clojure.core/nth args3238 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3252] (clojure.core/str arg3252))
 (clojure.core/nth args3238 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3253] (clojure.core/str arg3253))
 (clojure.core/nth args3238 3))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         label
                         general-progress-listener
                         action-names
                         awsaccount-ids]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :add-permission,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c d]
    {:args [a b c d],
     :client :sns,
     :fn :add-permission,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         label
                         general-progress-listener
                         action-names
                         awsaccount-ids]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Call addPermission, addPermission"}
   [credentials3241 & args3242]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3243
     (com.palletops.awaze.common/aws-client :sns credentials3241)]
    (clojure.core/case
     (clojure.core/count args3242)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3243
       addPermission
       (sns/add-permission-request (clojure.core/nth args3242 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3243
       addPermission
       (clojure.core/str (clojure.core/nth args3242 0))
       (clojure.core/str (clojure.core/nth args3242 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3254] (clojure.core/str arg3254))
 (clojure.core/nth args3242 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3255] (clojure.core/str arg3255))
 (clojure.core/nth args3242 3))))))))
 (do
  (clojure.core/defmethod
   sns
   :get-subscription-attributes
   [m3244]
   (clojure.core/let
    [credentials3245 (:credentials m3244) args3246 (:args m3244)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3247
      (com.palletops.awaze.common/aws-client :sns credentials3245)]
     (clojure.core/case
      (clojure.core/count args3246)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3246 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3247
           getSubscriptionAttributes
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
               (clojure.core/nth args3246 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3247
               getSubscriptionAttributes
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getSubscriptionAttributes")
                {:args args3246}))))))))))))))
  (clojure.core/defn
   get-subscription-attributes-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [subscription-arn general-progress-listener]}]]),
    :doc "Generate map for getSubscriptionAttributes, getSubscriptionAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-subscription-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-subscription-attributes
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [subscription-arn general-progress-listener]}]]),
    :doc "Call getSubscriptionAttributes, getSubscriptionAttributes"}
   [credentials3249 & args3250]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3251
     (com.palletops.awaze.common/aws-client :sns credentials3249)]
    (clojure.core/case
     (clojure.core/count args3250)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3250 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3251
          getSubscriptionAttributes
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
              (clojure.core/nth args3250 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3251
              getSubscriptionAttributes
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getSubscriptionAttributes")
               {:args args3250}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :confirm-subscription
   [m3256]
   (clojure.core/let
    [credentials3257 (:credentials m3256) args3258 (:args m3256)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3259
      (com.palletops.awaze.common/aws-client :sns credentials3257)]
     (clojure.core/case
      (clojure.core/count args3258)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3259
        confirmSubscription
        (clojure.core/str (clojure.core/nth args3258 0))
        (clojure.core/str (clojure.core/nth args3258 1))
        (clojure.core/str (clojure.core/nth args3258 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3259
        confirmSubscription
        (clojure.core/str (clojure.core/nth args3258 0))
        (clojure.core/str (clojure.core/nth args3258 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3259
        confirmSubscription
        (sns/confirm-subscription-request
         (clojure.core/nth args3258 0))))))))
  (clojure.core/defn
   confirm-subscription-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn
                         token
                         general-progress-listener
                         authenticate-on-unsubscribe]}]]),
    :doc "Generate map for confirmSubscription, confirmSubscription, confirmSubscription"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :confirm-subscription,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :confirm-subscription,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :confirm-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   confirm-subscription
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn
                         token
                         general-progress-listener
                         authenticate-on-unsubscribe]}]]),
    :doc "Call confirmSubscription, confirmSubscription, confirmSubscription"}
   [credentials3261 & args3262]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3263
     (com.palletops.awaze.common/aws-client :sns credentials3261)]
    (clojure.core/case
     (clojure.core/count args3262)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3263
       confirmSubscription
       (clojure.core/str (clojure.core/nth args3262 0))
       (clojure.core/str (clojure.core/nth args3262 1))
       (clojure.core/str (clojure.core/nth args3262 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3263
       confirmSubscription
       (clojure.core/str (clojure.core/nth args3262 0))
       (clojure.core/str (clojure.core/nth args3262 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3263
       confirmSubscription
       (sns/confirm-subscription-request
        (clojure.core/nth args3262 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-topic
   [m3264]
   (clojure.core/let
    [credentials3265 (:credentials m3264) args3266 (:args m3264)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3267
      (com.palletops.awaze.common/aws-client :sns credentials3265)]
     (clojure.core/case
      (clojure.core/count args3266)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3266 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3267
           deleteTopic
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.DeleteTopicRequest
               (clojure.core/nth args3266 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3267
               deleteTopic
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteTopic")
                {:args args3266}))))))))))))))
  (clojure.core/defn
   delete-topic-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [topic-arn general-progress-listener]}]]),
    :doc "Generate map for deleteTopic, deleteTopic"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-topic,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-topic
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [topic-arn general-progress-listener]}]]),
    :doc "Call deleteTopic, deleteTopic"}
   [credentials3269 & args3270]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3271
     (com.palletops.awaze.common/aws-client :sns credentials3269)]
    (clojure.core/case
     (clojure.core/count args3270)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3270 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3271
          deleteTopic
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.DeleteTopicRequest
              (clojure.core/nth args3270 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3271
              deleteTopic
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteTopic")
               {:args args3270}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :publish
   [m3272]
   (clojure.core/let
    [credentials3273 (:credentials m3272) args3274 (:args m3272)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3275
      (com.palletops.awaze.common/aws-client :sns credentials3273)]
     (clojure.core/case
      (clojure.core/count args3274)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3275
        publish
        (sns/publish-request (clojure.core/nth args3274 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3275
        publish
        (clojure.core/str (clojure.core/nth args3274 0))
        (clojure.core/str (clojure.core/nth args3274 1))
        (clojure.core/str (clojure.core/nth args3274 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3275
        publish
        (clojure.core/str (clojure.core/nth args3274 0))
        (clojure.core/str (clojure.core/nth args3274 1))))))))
  (clojure.core/defn
   publish-map
   {:arglists (quote
               [[credentials
                 {:keys [subject
                         message-structure
                         general-progress-listener
                         message-attributes
                         topic-arn
                         message
                         target-arn]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Generate map for publish, publish, publish"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :publish,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :publish,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :publish,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   publish
   {:arglists (quote
               [[credentials
                 {:keys [subject
                         message-structure
                         general-progress-listener
                         message-attributes
                         topic-arn
                         message
                         target-arn]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Call publish, publish, publish"}
   [credentials3277 & args3278]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3279
     (com.palletops.awaze.common/aws-client :sns credentials3277)]
    (clojure.core/case
     (clojure.core/count args3278)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3279
       publish
       (sns/publish-request (clojure.core/nth args3278 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3279
       publish
       (clojure.core/str (clojure.core/nth args3278 0))
       (clojure.core/str (clojure.core/nth args3278 1))
       (clojure.core/str (clojure.core/nth args3278 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3279
       publish
       (clojure.core/str (clojure.core/nth args3278 0))
       (clojure.core/str (clojure.core/nth args3278 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-topics
   [m3280]
   (clojure.core/let
    [credentials3281 (:credentials m3280) args3282 (:args m3280)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3283
      (com.palletops.awaze.common/aws-client :sns credentials3281)]
     (clojure.core/case
      (clojure.core/count args3282)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3282 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3283
           listTopics
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.ListTopicsRequest
               (clojure.core/nth args3282 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3283
               listTopics
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listTopics")
                {:args args3282}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3283
        listTopics))))))
  (clojure.core/defn
   list-topics-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listTopics, listTopics, listTopics"}
   ([credentials__1649__auto__]
    {:args [],
     :client :sns,
     :fn :list-topics,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-topics,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-topics
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]]),
    :doc "Call listTopics, listTopics, listTopics"}
   [credentials3285 & args3286]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3287
     (com.palletops.awaze.common/aws-client :sns credentials3285)]
    (clojure.core/case
     (clojure.core/count args3286)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3286 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3287
          listTopics
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.ListTopicsRequest
              (clojure.core/nth args3286 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3287
              listTopics
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listTopics")
               {:args args3286}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3287
       listTopics))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions-by-topic
   [m3288]
   (clojure.core/let
    [credentials3289 (:credentials m3288) args3290 (:args m3288)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3291
      (com.palletops.awaze.common/aws-client :sns credentials3289)]
     (clojure.core/case
      (clojure.core/count args3290)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3290 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3291
           listSubscriptionsByTopic
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
               (clojure.core/nth args3290 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3291
               listSubscriptionsByTopic
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptionsByTopic")
                {:args args3290}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3291
        listSubscriptionsByTopic
        (clojure.core/str (clojure.core/nth args3290 0))
        (clojure.core/str (clojure.core/nth args3290 1))))))))
  (clojure.core/defn
   list-subscriptions-by-topic-map
   {:arglists (quote
               [[credentials string-0]
                [credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-subscriptions-by-topic
   {:arglists (quote
               [[credentials string-0]
                [credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn
                         next-token
                         general-progress-listener]}]]),
    :doc "Call listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   [credentials3293 & args3294]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3295
     (com.palletops.awaze.common/aws-client :sns credentials3293)]
    (clojure.core/case
     (clojure.core/count args3294)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3294 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3295
          listSubscriptionsByTopic
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
              (clojure.core/nth args3294 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3295
              listSubscriptionsByTopic
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptionsByTopic")
               {:args args3294}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3295
       listSubscriptionsByTopic
       (clojure.core/str (clojure.core/nth args3294 0))
       (clojure.core/str (clojure.core/nth args3294 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-platform-application
   [m3296]
   (clojure.core/let
    [credentials3297 (:credentials m3296) args3298 (:args m3296)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3299
      (com.palletops.awaze.common/aws-client :sns credentials3297)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3299
       deletePlatformApplication
       (sns/delete-platform-application-request
        (clojure.core/nth args3298 0)))))))
  (clojure.core/defn
   delete-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Generate map for deletePlatformApplication"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-platform-application,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Call deletePlatformApplication"}
   [credentials3301 & args3302]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3303
     (com.palletops.awaze.common/aws-client :sns credentials3301)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3303
      deletePlatformApplication
      (sns/delete-platform-application-request
       (clojure.core/nth args3302 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-endpoints-by-platform-application
   [m3304]
   (clojure.core/let
    [credentials3305 (:credentials m3304) args3306 (:args m3304)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3307
      (com.palletops.awaze.common/aws-client :sns credentials3305)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3307
       listEndpointsByPlatformApplication
       (sns/list-endpoints-by-platform-application-request
        (clojure.core/nth args3306 0)))))))
  (clojure.core/defn
   list-endpoints-by-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for listEndpointsByPlatformApplication"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-endpoints-by-platform-application,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-endpoints-by-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         next-token
                         general-progress-listener]}]]),
    :doc "Call listEndpointsByPlatformApplication"}
   [credentials3309 & args3310]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3311
     (com.palletops.awaze.common/aws-client :sns credentials3309)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3311
      listEndpointsByPlatformApplication
      (sns/list-endpoints-by-platform-application-request
       (clojure.core/nth args3310 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :unsubscribe
   [m3312]
   (clojure.core/let
    [credentials3313 (:credentials m3312) args3314 (:args m3312)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3315
      (com.palletops.awaze.common/aws-client :sns credentials3313)]
     (clojure.core/case
      (clojure.core/count args3314)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3314 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3315
           unsubscribe
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.UnsubscribeRequest
               (clojure.core/nth args3314 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3315
               unsubscribe
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "unsubscribe")
                {:args args3314}))))))))))))))
  (clojure.core/defn
   unsubscribe-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [subscription-arn general-progress-listener]}]]),
    :doc "Generate map for unsubscribe, unsubscribe"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :unsubscribe,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   unsubscribe
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [subscription-arn general-progress-listener]}]]),
    :doc "Call unsubscribe, unsubscribe"}
   [credentials3317 & args3318]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3319
     (com.palletops.awaze.common/aws-client :sns credentials3317)]
    (clojure.core/case
     (clojure.core/count args3318)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3318 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3319
          unsubscribe
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.UnsubscribeRequest
              (clojure.core/nth args3318 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3319
              unsubscribe
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "unsubscribe")
               {:args args3318}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :set-subscription-attributes
   [m3320]
   (clojure.core/let
    [credentials3321 (:credentials m3320) args3322 (:args m3320)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3323
      (com.palletops.awaze.common/aws-client :sns credentials3321)]
     (clojure.core/case
      (clojure.core/count args3322)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3323
        setSubscriptionAttributes
        (sns/set-subscription-attributes-request
         (clojure.core/nth args3322 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3323
        setSubscriptionAttributes
        (clojure.core/str (clojure.core/nth args3322 0))
        (clojure.core/str (clojure.core/nth args3322 1))
        (clojure.core/str (clojure.core/nth args3322 2))))))))
  (clojure.core/defn
   set-subscription-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for setSubscriptionAttributes, setSubscriptionAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-subscription-attributes,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :set-subscription-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-subscription-attributes
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call setSubscriptionAttributes, setSubscriptionAttributes"}
   [credentials3325 & args3326]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3327
     (com.palletops.awaze.common/aws-client :sns credentials3325)]
    (clojure.core/case
     (clojure.core/count args3326)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3327
       setSubscriptionAttributes
       (sns/set-subscription-attributes-request
        (clojure.core/nth args3326 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3327
       setSubscriptionAttributes
       (clojure.core/str (clojure.core/nth args3326 0))
       (clojure.core/str (clojure.core/nth args3326 1))
       (clojure.core/str (clojure.core/nth args3326 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions
   [m3328]
   (clojure.core/let
    [credentials3329 (:credentials m3328) args3330 (:args m3328)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3331
      (com.palletops.awaze.common/aws-client :sns credentials3329)]
     (clojure.core/case
      (clojure.core/count args3330)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.ListSubscriptionsRequest
           (clojure.core/nth args3330 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3331
           listSubscriptions
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3330 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3331
               listSubscriptions
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptions")
                {:args args3330}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3331
        listSubscriptions))))))
  (clojure.core/defn
   list-subscriptions-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]
                [credentials string-0]]),
    :doc "Generate map for listSubscriptions, listSubscriptions, listSubscriptions"}
   ([credentials__1649__auto__]
    {:args [],
     :client :sns,
     :fn :list-subscriptions,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-subscriptions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-subscriptions
   {:arglists (quote
               [[credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]
                [credentials string-0]]),
    :doc "Call listSubscriptions, listSubscriptions, listSubscriptions"}
   [credentials3333 & args3334]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3335
     (com.palletops.awaze.common/aws-client :sns credentials3333)]
    (clojure.core/case
     (clojure.core/count args3334)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.ListSubscriptionsRequest
          (clojure.core/nth args3334 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3335
          listSubscriptions
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3334 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3335
              listSubscriptions
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptions")
               {:args args3334}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3335
       listSubscriptions))))))
 (do
  (clojure.core/defmethod
   sns
   :create-topic
   [m3336]
   (clojure.core/let
    [credentials3337 (:credentials m3336) args3338 (:args m3336)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3339
      (com.palletops.awaze.common/aws-client :sns credentials3337)]
     (clojure.core/case
      (clojure.core/count args3338)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.CreateTopicRequest
           (clojure.core/nth args3338 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3339
           createTopic
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3338 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3339
               createTopic
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createTopic")
                {:args args3338}))))))))))))))
  (clojure.core/defn
   create-topic-map
   {:arglists (quote
               [[credentials {:keys [name general-progress-listener]}]
                [credentials string-0]]),
    :doc "Generate map for createTopic, createTopic"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-topic,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-topic
   {:arglists (quote
               [[credentials {:keys [name general-progress-listener]}]
                [credentials string-0]]),
    :doc "Call createTopic, createTopic"}
   [credentials3341 & args3342]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3343
     (com.palletops.awaze.common/aws-client :sns credentials3341)]
    (clojure.core/case
     (clojure.core/count args3342)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.CreateTopicRequest
          (clojure.core/nth args3342 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3343
          createTopic
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3342 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3343
              createTopic
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createTopic")
               {:args args3342}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-endpoint
   [m3344]
   (clojure.core/let
    [credentials3345 (:credentials m3344) args3346 (:args m3344)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3347
      (com.palletops.awaze.common/aws-client :sns credentials3345)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3347
       createPlatformEndpoint
       (sns/create-platform-endpoint-request
        (clojure.core/nth args3346 0)))))))
  (clojure.core/defn
   create-platform-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [token
                         platform-application-arn
                         general-progress-listener
                         custom-user-data
                         attributes]}]]),
    :doc "Generate map for createPlatformEndpoint"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-platform-endpoint,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-platform-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [token
                         platform-application-arn
                         general-progress-listener
                         custom-user-data
                         attributes]}]]),
    :doc "Call createPlatformEndpoint"}
   [credentials3349 & args3350]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3351
     (com.palletops.awaze.common/aws-client :sns credentials3349)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3351
      createPlatformEndpoint
      (sns/create-platform-endpoint-request
       (clojure.core/nth args3350 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :remove-permission
   [m3352]
   (clojure.core/let
    [credentials3353 (:credentials m3352) args3354 (:args m3352)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3355
      (com.palletops.awaze.common/aws-client :sns credentials3353)]
     (clojure.core/case
      (clojure.core/count args3354)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3355
        removePermission
        (clojure.core/str (clojure.core/nth args3354 0))
        (clojure.core/str (clojure.core/nth args3354 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3355
        removePermission
        (sns/remove-permission-request (clojure.core/nth args3354 0))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn label general-progress-listener]}]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :remove-permission,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :remove-permission,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn label general-progress-listener]}]]),
    :doc "Call removePermission, removePermission"}
   [credentials3357 & args3358]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3359
     (com.palletops.awaze.common/aws-client :sns credentials3357)]
    (clojure.core/case
     (clojure.core/count args3358)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3359
       removePermission
       (clojure.core/str (clojure.core/nth args3358 0))
       (clojure.core/str (clojure.core/nth args3358 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3359
       removePermission
       (sns/remove-permission-request (clojure.core/nth args3358 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :get-topic-attributes
   [m3360]
   (clojure.core/let
    [credentials3361 (:credentials m3360) args3362 (:args m3360)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3363
      (com.palletops.awaze.common/aws-client :sns credentials3361)]
     (clojure.core/case
      (clojure.core/count args3362)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.GetTopicAttributesRequest
           (clojure.core/nth args3362 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3363
           getTopicAttributes
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3362 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3363
               getTopicAttributes
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getTopicAttributes")
                {:args args3362}))))))))))))))
  (clojure.core/defn
   get-topic-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn general-progress-listener]}]
                [credentials string-0]]),
    :doc "Generate map for getTopicAttributes, getTopicAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-topic-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-topic-attributes
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn general-progress-listener]}]
                [credentials string-0]]),
    :doc "Call getTopicAttributes, getTopicAttributes"}
   [credentials3365 & args3366]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3367
     (com.palletops.awaze.common/aws-client :sns credentials3365)]
    (clojure.core/case
     (clojure.core/count args3366)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.GetTopicAttributesRequest
          (clojure.core/nth args3366 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3367
          getTopicAttributes
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3366 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3367
              getTopicAttributes
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getTopicAttributes")
               {:args args3366}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :subscribe
   [m3368]
   (clojure.core/let
    [credentials3369 (:credentials m3368) args3370 (:args m3368)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3371
      (com.palletops.awaze.common/aws-client :sns credentials3369)]
     (clojure.core/case
      (clojure.core/count args3370)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3371
        subscribe
        (sns/subscribe-request (clojure.core/nth args3370 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3371
        subscribe
        (clojure.core/str (clojure.core/nth args3370 0))
        (clojure.core/str (clojure.core/nth args3370 1))
        (clojure.core/str (clojure.core/nth args3370 2))))))))
  (clojure.core/defn
   subscribe-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         protocol
                         general-progress-listener
                         endpoint]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for subscribe, subscribe"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :subscribe,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :subscribe,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   subscribe
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         protocol
                         general-progress-listener
                         endpoint]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call subscribe, subscribe"}
   [credentials3373 & args3374]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3375
     (com.palletops.awaze.common/aws-client :sns credentials3373)]
    (clojure.core/case
     (clojure.core/count args3374)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3375
       subscribe
       (sns/subscribe-request (clojure.core/nth args3374 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3375
       subscribe
       (clojure.core/str (clojure.core/nth args3374 0))
       (clojure.core/str (clojure.core/nth args3374 1))
       (clojure.core/str (clojure.core/nth args3374 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-endpoint
   [m3376]
   (clojure.core/let
    [credentials3377 (:credentials m3376) args3378 (:args m3376)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3379
      (com.palletops.awaze.common/aws-client :sns credentials3377)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3379
       deleteEndpoint
       (sns/delete-endpoint-request (clojure.core/nth args3378 0)))))))
  (clojure.core/defn
   delete-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Generate map for deleteEndpoint"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-endpoint,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Call deleteEndpoint"}
   [credentials3381 & args3382]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3383
     (com.palletops.awaze.common/aws-client :sns credentials3381)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3383
      deleteEndpoint
      (sns/delete-endpoint-request (clojure.core/nth args3382 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-platform-applications
   [m3384]
   (clojure.core/let
    [credentials3385 (:credentials m3384) args3386 (:args m3384)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3387
      (com.palletops.awaze.common/aws-client :sns credentials3385)]
     (clojure.core/case
      (clojure.core/count args3386)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3387
        listPlatformApplications
        (sns/list-platform-applications-request
         (clojure.core/nth args3386 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3387
        listPlatformApplications))))))
  (clojure.core/defn
   list-platform-applications-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listPlatformApplications, listPlatformApplications"}
   ([credentials__1649__auto__]
    {:args [],
     :client :sns,
     :fn :list-platform-applications,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-platform-applications,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-platform-applications
   {:arglists (quote
               [[credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials]]),
    :doc "Call listPlatformApplications, listPlatformApplications"}
   [credentials3389 & args3390]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3391
     (com.palletops.awaze.common/aws-client :sns credentials3389)]
    (clojure.core/case
     (clojure.core/count args3390)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3391
       listPlatformApplications
       (sns/list-platform-applications-request
        (clojure.core/nth args3390 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3391
       listPlatformApplications))))))
 (do
  (clojure.core/defmethod
   sns
   :set-platform-application-attributes
   [m3392]
   (clojure.core/let
    [credentials3393 (:credentials m3392) args3394 (:args m3392)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3395
      (com.palletops.awaze.common/aws-client :sns credentials3393)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3395
       setPlatformApplicationAttributes
       (sns/set-platform-application-attributes-request
        (clojure.core/nth args3394 0)))))))
  (clojure.core/defn
   set-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener
                         attributes]}]]),
    :doc "Generate map for setPlatformApplicationAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-platform-application-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener
                         attributes]}]]),
    :doc "Call setPlatformApplicationAttributes"}
   [credentials3397 & args3398]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3399
     (com.palletops.awaze.common/aws-client :sns credentials3397)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3399
      setPlatformApplicationAttributes
      (sns/set-platform-application-attributes-request
       (clojure.core/nth args3398 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-application
   [m3400]
   (clojure.core/let
    [credentials3401 (:credentials m3400) args3402 (:args m3400)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3403
      (com.palletops.awaze.common/aws-client :sns credentials3401)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3403
       createPlatformApplication
       (sns/create-platform-application-request
        (clojure.core/nth args3402 0)))))))
  (clojure.core/defn
   create-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         name
                         general-progress-listener
                         attributes]}]]),
    :doc "Generate map for createPlatformApplication"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-platform-application,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         name
                         general-progress-listener
                         attributes]}]]),
    :doc "Call createPlatformApplication"}
   [credentials3405 & args3406]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3407
     (com.palletops.awaze.common/aws-client :sns credentials3405)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3407
      createPlatformApplication
      (sns/create-platform-application-request
       (clojure.core/nth args3406 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-endpoint-attributes
   [m3408]
   (clojure.core/let
    [credentials3409 (:credentials m3408) args3410 (:args m3408)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3411
      (com.palletops.awaze.common/aws-client :sns credentials3409)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3411
       setEndpointAttributes
       (sns/set-endpoint-attributes-request
        (clojure.core/nth args3410 0)))))))
  (clojure.core/defn
   set-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         endpoint-arn
                         attributes]}]]),
    :doc "Generate map for setEndpointAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-endpoint-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         endpoint-arn
                         attributes]}]]),
    :doc "Call setEndpointAttributes"}
   [credentials3413 & args3414]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3415
     (com.palletops.awaze.common/aws-client :sns credentials3413)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3415
      setEndpointAttributes
      (sns/set-endpoint-attributes-request
       (clojure.core/nth args3414 0))))))))
