(ns
 com.palletops.awaze.simpledb
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpledb :as simpledb]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpledb
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.simpledb.AmazonSimpleDBClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.Attribute}
attribute
  [m4329]
  (clojure.core/let
   [bean4328 (new com.amazonaws.services.simpledb.model.Attribute)]
   (clojure.core/when-let
    [v4330 (:alternate-name-encoding m4329)]
    (. bean4328 setAlternateNameEncoding (clojure.core/str v4330)))
   (clojure.core/when-let
    [v4330 (:alternate-value-encoding m4329)]
    (. bean4328 setAlternateValueEncoding (clojure.core/str v4330)))
   (clojure.core/when-let
    [v4330 (:name m4329)]
    (. bean4328 setName (clojure.core/str v4330)))
   (clojure.core/when-let
    [v4330 (:value m4329)]
    (. bean4328 setValue (clojure.core/str v4330)))
   bean4328))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableAttribute}
replaceable-attribute
  [m4332]
  (clojure.core/let
   [bean4331
    (new com.amazonaws.services.simpledb.model.ReplaceableAttribute)]
   (clojure.core/when-let
    [v4333 (:replace m4332)]
    (. bean4331 setReplace (clojure.core/boolean v4333)))
   (clojure.core/when-let
    [v4333 (:name m4332)]
    (. bean4331 setName (clojure.core/str v4333)))
   (clojure.core/when-let
    [v4333 (:value m4332)]
    (. bean4331 setValue (clojure.core/str v4333)))
   bean4331))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeletableItem}
deletable-item
  [m4335]
  (clojure.core/let
   [bean4334
    (new com.amazonaws.services.simpledb.model.DeletableItem)]
   (clojure.core/when-let
    [v4336 (:name m4335)]
    (. bean4334 setName (clojure.core/str v4336)))
   (clojure.core/when-let
    [v4336 (:attributes m4335)]
    (.
     bean4334
     setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4373] (simpledb/attribute arg4373))
 v4336)))
   bean4334))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.UpdateCondition}
update-condition
  [m4338]
  (clojure.core/let
   [bean4337
    (new com.amazonaws.services.simpledb.model.UpdateCondition)]
   (clojure.core/when-let
    [v4339 (:exists m4338)]
    (. bean4337 setExists (clojure.core/boolean v4339)))
   (clojure.core/when-let
    [v4339 (:name m4338)]
    (. bean4337 setName (clojure.core/str v4339)))
   (clojure.core/when-let
    [v4339 (:value m4338)]
    (. bean4337 setValue (clojure.core/str v4339)))
   bean4337))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableItem}
replaceable-item
  [m4341]
  (clojure.core/let
   [bean4340
    (new com.amazonaws.services.simpledb.model.ReplaceableItem)]
   (clojure.core/when-let
    [v4342 (:name m4341)]
    (. bean4340 setName (clojure.core/str v4342)))
   (clojure.core/when-let
    [v4342 (:attributes m4341)]
    (.
     bean4340
     setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4374] (simpledb/replaceable-attribute arg4374))
 v4342)))
   bean4340))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DomainMetadataRequest}
domain-metadata-request
  [m4344]
  (clojure.core/let
   [bean4343
    (new com.amazonaws.services.simpledb.model.DomainMetadataRequest)]
   (clojure.core/when-let
    [v4345 (:domain-name m4344)]
    (. bean4343 setDomainName (clojure.core/str v4345)))
   bean4343))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.GetAttributesRequest}
get-attributes-request
  [m4347]
  (clojure.core/let
   [bean4346
    (new com.amazonaws.services.simpledb.model.GetAttributesRequest)]
   (clojure.core/when-let
    [v4348 (:domain-name m4347)]
    (. bean4346 setDomainName (clojure.core/str v4348)))
   (clojure.core/when-let
    [v4348 (:item-name m4347)]
    (. bean4346 setItemName (clojure.core/str v4348)))
   (clojure.core/when-let
    [v4348 (:consistent-read m4347)]
    (. bean4346 setConsistentRead (clojure.core/boolean v4348)))
   (clojure.core/when-let
    [v4348 (:attribute-names m4347)]
    (.
     bean4346
     setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4375] (clojure.core/str arg4375))
 v4348)))
   bean4346))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.CreateDomainRequest}
create-domain-request
  [m4350]
  (clojure.core/let
   [bean4349
    (new com.amazonaws.services.simpledb.model.CreateDomainRequest)]
   (clojure.core/when-let
    [v4351 (:domain-name m4350)]
    (. bean4349 setDomainName (clojure.core/str v4351)))
   bean4349))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest}
batch-delete-attributes-request
  [m4353]
  (clojure.core/let
   [bean4352
    (new
     com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest)]
   (clojure.core/when-let
    [v4354 (:domain-name m4353)]
    (. bean4352 setDomainName (clojure.core/str v4354)))
   (clojure.core/when-let
    [v4354 (:items m4353)]
    (.
     bean4352
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4376] (simpledb/deletable-item arg4376))
 v4354)))
   bean4352))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ListDomainsRequest}
list-domains-request
  [m4356]
  (clojure.core/let
   [bean4355
    (new com.amazonaws.services.simpledb.model.ListDomainsRequest)]
   (clojure.core/when-let
    [v4357 (:max-number-of-domains m4356)]
    (. bean4355 setMaxNumberOfDomains (clojure.core/int v4357)))
   (clojure.core/when-let
    [v4357 (:next-token m4356)]
    (. bean4355 setNextToken (clojure.core/str v4357)))
   bean4355))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.PutAttributesRequest}
put-attributes-request
  [m4359]
  (clojure.core/let
   [bean4358
    (new com.amazonaws.services.simpledb.model.PutAttributesRequest)]
   (clojure.core/when-let
    [v4360 (:domain-name m4359)]
    (. bean4358 setDomainName (clojure.core/str v4360)))
   (clojure.core/when-let
    [v4360 (:item-name m4359)]
    (. bean4358 setItemName (clojure.core/str v4360)))
   (clojure.core/when-let
    [v4360 (:expected m4359)]
    (. bean4358 setExpected (simpledb/update-condition v4360)))
   (clojure.core/when-let
    [v4360 (:attributes m4359)]
    (.
     bean4358
     setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4377] (simpledb/replaceable-attribute arg4377))
 v4360)))
   bean4358))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteAttributesRequest}
delete-attributes-request
  [m4362]
  (clojure.core/let
   [bean4361
    (new
     com.amazonaws.services.simpledb.model.DeleteAttributesRequest)]
   (clojure.core/when-let
    [v4363 (:domain-name m4362)]
    (. bean4361 setDomainName (clojure.core/str v4363)))
   (clojure.core/when-let
    [v4363 (:item-name m4362)]
    (. bean4361 setItemName (clojure.core/str v4363)))
   (clojure.core/when-let
    [v4363 (:expected m4362)]
    (. bean4361 setExpected (simpledb/update-condition v4363)))
   (clojure.core/when-let
    [v4363 (:attributes m4362)]
    (.
     bean4361
     setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4378] (simpledb/attribute arg4378))
 v4363)))
   bean4361))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchPutAttributesRequest}
batch-put-attributes-request
  [m4365]
  (clojure.core/let
   [bean4364
    (new
     com.amazonaws.services.simpledb.model.BatchPutAttributesRequest)]
   (clojure.core/when-let
    [v4366 (:domain-name m4365)]
    (. bean4364 setDomainName (clojure.core/str v4366)))
   (clojure.core/when-let
    [v4366 (:items m4365)]
    (.
     bean4364
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4379] (simpledb/replaceable-item arg4379))
 v4366)))
   bean4364))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteDomainRequest}
delete-domain-request
  [m4368]
  (clojure.core/let
   [bean4367
    (new com.amazonaws.services.simpledb.model.DeleteDomainRequest)]
   (clojure.core/when-let
    [v4369 (:domain-name m4368)]
    (. bean4367 setDomainName (clojure.core/str v4369)))
   bean4367))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.SelectRequest}
select-request
  [m4371]
  (clojure.core/let
   [bean4370
    (new com.amazonaws.services.simpledb.model.SelectRequest)]
   (clojure.core/when-let
    [v4372 (:select-expression m4371)]
    (. bean4370 setSelectExpression (clojure.core/str v4372)))
   (clojure.core/when-let
    [v4372 (:consistent-read m4371)]
    (. bean4370 setConsistentRead (clojure.core/boolean v4372)))
   (clojure.core/when-let
    [v4372 (:next-token m4371)]
    (. bean4370 setNextToken (clojure.core/str v4372)))
   bean4370))
 (clojure.core/defmulti
  simpledb
  (clojure.core/fn simpledb [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   simpledb
   :domain-metadata
   [m4380]
   (clojure.core/let
    [credentials4381 (:credentials m4380) args4382 (:args m4380)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4383
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4381)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4383
       domainMetadata
       (simpledb/domain-metadata-request
        (clojure.core/nth args4382 0)))))))
  (clojure.core/defn
   domain-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for domainMetadata"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :domain-metadata,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   domain-metadata
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call domainMetadata"}
   [credentials4385 & args4386]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4387
     (com.palletops.awaze.common/aws-client :simpledb credentials4385)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4387
      domainMetadata
      (simpledb/domain-metadata-request (clojure.core/nth args4386 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :get-attributes
   [m4388]
   (clojure.core/let
    [credentials4389 (:credentials m4388) args4390 (:args m4388)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4391
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4389)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4391
       getAttributes
       (simpledb/get-attributes-request (clojure.core/nth args4390 0)))))))
  (clojure.core/defn
   get-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         domain-name
                         consistent-read
                         attribute-names]}]]),
    :doc "Generate map for getAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :get-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-attributes
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         domain-name
                         consistent-read
                         attribute-names]}]]),
    :doc "Call getAttributes"}
   [credentials4393 & args4394]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4395
     (com.palletops.awaze.common/aws-client :simpledb credentials4393)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4395
      getAttributes
      (simpledb/get-attributes-request (clojure.core/nth args4394 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :create-domain
   [m4396]
   (clojure.core/let
    [credentials4397 (:credentials m4396) args4398 (:args m4396)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4399
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4397)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4399
       createDomain
       (simpledb/create-domain-request (clojure.core/nth args4398 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :create-domain,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call createDomain"}
   [credentials4401 & args4402]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4403
     (com.palletops.awaze.common/aws-client :simpledb credentials4401)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4403
      createDomain
      (simpledb/create-domain-request (clojure.core/nth args4402 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-delete-attributes
   [m4404]
   (clojure.core/let
    [credentials4405 (:credentials m4404) args4406 (:args m4404)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4407
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4405)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4407
       batchDeleteAttributes
       (simpledb/batch-delete-attributes-request
        (clojure.core/nth args4406 0)))))))
  (clojure.core/defn
   batch-delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Generate map for batchDeleteAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :batch-delete-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   batch-delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Call batchDeleteAttributes"}
   [credentials4409 & args4410]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4411
     (com.palletops.awaze.common/aws-client :simpledb credentials4409)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4411
      batchDeleteAttributes
      (simpledb/batch-delete-attributes-request
       (clojure.core/nth args4410 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :list-domains
   [m4412]
   (clojure.core/let
    [credentials4413 (:credentials m4412) args4414 (:args m4412)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4415
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4413)]
     (clojure.core/case
      (clojure.core/count args4414)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4415
        listDomains
        (simpledb/list-domains-request (clojure.core/nth args4414 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4415
        listDomains))))))
  (clojure.core/defn
   list-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-number-of-domains
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listDomains, listDomains"}
   ([credentials__1649__auto__]
    {:args [],
     :client :simpledb,
     :fn :list-domains,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :list-domains,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-domains
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-number-of-domains
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listDomains, listDomains"}
   [credentials4417 & args4418]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4419
     (com.palletops.awaze.common/aws-client :simpledb credentials4417)]
    (clojure.core/case
     (clojure.core/count args4418)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4419
       listDomains
       (simpledb/list-domains-request (clojure.core/nth args4418 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4419
       listDomains))))))
 (do
  (clojure.core/defmethod
   simpledb
   :put-attributes
   [m4420]
   (clojure.core/let
    [credentials4421 (:credentials m4420) args4422 (:args m4420)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4423
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4421)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4423
       putAttributes
       (simpledb/put-attributes-request (clojure.core/nth args4422 0)))))))
  (clojure.core/defn
   put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Generate map for putAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :put-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Call putAttributes"}
   [credentials4425 & args4426]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4427
     (com.palletops.awaze.common/aws-client :simpledb credentials4425)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4427
      putAttributes
      (simpledb/put-attributes-request (clojure.core/nth args4426 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-attributes
   [m4428]
   (clojure.core/let
    [credentials4429 (:credentials m4428) args4430 (:args m4428)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4431
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4429)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4431
       deleteAttributes
       (simpledb/delete-attributes-request
        (clojure.core/nth args4430 0)))))))
  (clojure.core/defn
   delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Generate map for deleteAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :delete-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Call deleteAttributes"}
   [credentials4433 & args4434]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4435
     (com.palletops.awaze.common/aws-client :simpledb credentials4433)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4435
      deleteAttributes
      (simpledb/delete-attributes-request
       (clojure.core/nth args4434 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-put-attributes
   [m4436]
   (clojure.core/let
    [credentials4437 (:credentials m4436) args4438 (:args m4436)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4439
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4437)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4439
       batchPutAttributes
       (simpledb/batch-put-attributes-request
        (clojure.core/nth args4438 0)))))))
  (clojure.core/defn
   batch-put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Generate map for batchPutAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :batch-put-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   batch-put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Call batchPutAttributes"}
   [credentials4441 & args4442]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4443
     (com.palletops.awaze.common/aws-client :simpledb credentials4441)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4443
      batchPutAttributes
      (simpledb/batch-put-attributes-request
       (clojure.core/nth args4442 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-domain
   [m4444]
   (clojure.core/let
    [credentials4445 (:credentials m4444) args4446 (:args m4444)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4447
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4445)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4447
       deleteDomain
       (simpledb/delete-domain-request (clojure.core/nth args4446 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :delete-domain,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call deleteDomain"}
   [credentials4449 & args4450]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4451
     (com.palletops.awaze.common/aws-client :simpledb credentials4449)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4451
      deleteDomain
      (simpledb/delete-domain-request (clojure.core/nth args4450 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :select
   [m4452]
   (clojure.core/let
    [credentials4453 (:credentials m4452) args4454 (:args m4452)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4455
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4453)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4455
       select
       (simpledb/select-request (clojure.core/nth args4454 0)))))))
  (clojure.core/defn
   select-map
   {:arglists (quote
               [[credentials
                 {:keys [select-expression
                         next-token
                         general-progress-listener
                         consistent-read]}]]),
    :doc "Generate map for select"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :select,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   select
   {:arglists (quote
               [[credentials
                 {:keys [select-expression
                         next-token
                         general-progress-listener
                         consistent-read]}]]),
    :doc "Call select"}
   [credentials4457 & args4458]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4459
     (com.palletops.awaze.common/aws-client :simpledb credentials4457)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4459
      select
      (simpledb/select-request (clojure.core/nth args4458 0))))))))
