(ns
 com.palletops.awaze.s3
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.s3 :as s3]
  [com.palletops.awaze.beans.root :as root]
  [com.palletops.awaze.beans.metrics :as metrics]
  [com.palletops.awaze.beans.regions :as regions]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :s3
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.s3.AmazonS3Client
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.StorageClass}
storage-class
  [m9988]
  (.
   com.amazonaws.services.s3.model.StorageClass
   fromValue
   (clojure.core/name m9988)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRuleCondition}
routing-rule-condition
  [m9991]
  (clojure.core/let
   [bean9990
    (new com.amazonaws.services.s3.model.RoutingRuleCondition)]
   (clojure.core/when-let
    [v9992 (:key-prefix-equals m9991)]
    (. bean9990 setKeyPrefixEquals (clojure.core/str v9992)))
   (clojure.core/when-let
    [v9992 (:http-error-code-returned-equals m9991)]
    (.
     bean9990
     setHttpErrorCodeReturnedEquals
     (clojure.core/str v9992)))
   bean9990))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RedirectRule}
redirect-rule
  [m9994]
  (clojure.core/let
   [bean9993 (new com.amazonaws.services.s3.model.RedirectRule)]
   (clojure.core/when-let
    [v9995 (:protocol m9994)]
    (. bean9993 setProtocol (clojure.core/str v9995)))
   (clojure.core/when-let
    [v9995 (:host-name m9994)]
    (. bean9993 setHostName (clojure.core/str v9995)))
   (clojure.core/when-let
    [v9995 (:replace-key-prefix-with m9994)]
    (. bean9993 setReplaceKeyPrefixWith (clojure.core/str v9995)))
   (clojure.core/when-let
    [v9995 (:replace-key-with m9994)]
    (. bean9993 setReplaceKeyWith (clojure.core/str v9995)))
   (clojure.core/when-let
    [v9995 (:http-redirect-code m9994)]
    (. bean9993 setHttpRedirectCode (clojure.core/str v9995)))
   bean9993))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule$AllowedMethods}
corsrule-allowed-methods
  [m9997]
  (.
   com.amazonaws.services.s3.model.CORSRule$AllowedMethods
   fromValue
   (clojure.core/name m9997)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition}
bucket-lifecycle-configuration-transition
  [m10000]
  (clojure.core/let
   [bean9999
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition)]
   (clojure.core/when-let
    [v10001 (:date m10000)]
    (. bean9999 setDate (com.palletops.awaze.common/to-date v10001)))
   (clojure.core/when-let
    [v10001 (:storage-class m10000)]
    (. bean9999 setStorageClass (s3/storage-class v10001)))
   (clojure.core/when-let
    [v10001 (:days m10000)]
    (. bean9999 setDays (clojure.core/int v10001)))
   bean9999))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition}
bucket-lifecycle-configuration-noncurrent-version-transition
  [m10003]
  (clojure.core/let
   [bean10002
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition)]
   (clojure.core/when-let
    [v10004 (:storage-class m10003)]
    (. bean10002 setStorageClass (s3/storage-class v10004)))
   (clojure.core/when-let
    [v10004 (:days m10003)]
    (. bean10002 setDays (clojure.core/int v10004)))
   bean10002))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration}
bucket-notification-configuration-topic-configuration
  [m10006]
  (clojure.core/let
   [arg10008
    nil
    arg10009
    nil
    bean10005
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration
     arg10008
     arg10009)]
   bean10005))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRule}
routing-rule
  [m10011]
  (clojure.core/let
   [bean10010 (new com.amazonaws.services.s3.model.RoutingRule)]
   (clojure.core/when-let
    [v10012 (:condition m10011)]
    (. bean10010 setCondition (s3/routing-rule-condition v10012)))
   (clojure.core/when-let
    [v10012 (:redirect m10011)]
    (. bean10010 setRedirect (s3/redirect-rule v10012)))
   bean10010))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Owner}
owner
  [m10014]
  (clojure.core/let
   [bean10013 (new com.amazonaws.services.s3.model.Owner)]
   (clojure.core/when-let
    [v10015 (:id m10014)]
    (. bean10013 setId (clojure.core/str v10015)))
   (clojure.core/when-let
    [v10015 (:display-name m10014)]
    (. bean10013 setDisplayName (clojure.core/str v10015)))
   bean10013))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule}
corsrule
  [m10017]
  (clojure.core/let
   [bean10016 (new com.amazonaws.services.s3.model.CORSRule)]
   (clojure.core/when-let
    [v10018 (:id m10017)]
    (. bean10016 setId (clojure.core/str v10018)))
   (clojure.core/when-let
    [v10018 (:allowed-methods m10017)]
    (.
     bean10016
     setAllowedMethods
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10274] (s3/corsrule-allowed-methods arg10274))
 v10018)))
   (clojure.core/when-let
    [v10018 (:allowed-origins m10017)]
    (.
     bean10016
     setAllowedOrigins
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10275] (clojure.core/str arg10275))
 v10018)))
   (clojure.core/when-let
    [v10018 (:max-age-seconds m10017)]
    (. bean10016 setMaxAgeSeconds (clojure.core/int v10018)))
   (clojure.core/when-let
    [v10018 (:exposed-headers m10017)]
    (.
     bean10016
     setExposedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10276] (clojure.core/str arg10276))
 v10018)))
   (clojure.core/when-let
    [v10018 (:allowed-headers m10017)]
    (.
     bean10016
     setAllowedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10277] (clojure.core/str arg10277))
 v10018)))
   bean10016))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.TagSet}
tag-set
  [m10020]
  (clojure.core/let
   [bean10019 (new com.amazonaws.services.s3.model.TagSet)]
   bean10019))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule}
bucket-lifecycle-configuration-rule
  [m10023]
  (clojure.core/let
   [bean10022
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule)]
   (clojure.core/when-let
    [v10024 (:id m10023)]
    (. bean10022 setId (clojure.core/str v10024)))
   (clojure.core/when-let
    [v10024 (:prefix m10023)]
    (. bean10022 setPrefix (clojure.core/str v10024)))
   (clojure.core/when-let
    [v10024 (:status m10023)]
    (. bean10022 setStatus (clojure.core/str v10024)))
   (clojure.core/when-let
    [v10024 (:expiration-in-days m10023)]
    (. bean10022 setExpirationInDays (clojure.core/int v10024)))
   (clojure.core/when-let
    [v10024 (:expiration-date m10023)]
    (.
     bean10022
     setExpirationDate
     (com.palletops.awaze.common/to-date v10024)))
   (clojure.core/when-let
    [v10024 (:noncurrent-version-expiration-in-days m10023)]
    (.
     bean10022
     setNoncurrentVersionExpirationInDays
     (clojure.core/int v10024)))
   (clojure.core/when-let
    [v10024 (:transition m10023)]
    (.
     bean10022
     setTransition
     (s3/bucket-lifecycle-configuration-transition v10024)))
   (clojure.core/when-let
    [v10024 (:noncurrent-version-transition m10023)]
    (.
     bean10022
     setNoncurrentVersionTransition
     (s3/bucket-lifecycle-configuration-noncurrent-version-transition
      v10024)))
   bean10022))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.MultiFactorAuthentication}
multi-factor-authentication
  [m10026]
  (clojure.core/let
   [arg10028
    nil
    arg10029
    nil
    bean10025
    (new
     com.amazonaws.services.s3.model.MultiFactorAuthentication
     arg10028
     arg10029)]
   (clojure.core/when-let
    [v10027 (:token m10026)]
    (. bean10025 setToken (clojure.core/str v10027)))
   (clojure.core/when-let
    [v10027 (:device-serial-number m10026)]
    (. bean10025 setDeviceSerialNumber (clojure.core/str v10027)))
   bean10025))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion}
delete-objects-request-key-version
  [m10031]
  (clojure.core/let
   [arg10033
    nil
    bean10030
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion
     arg10033)]
   bean10030))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
bucket-notification-configuration
  [m10035]
  (clojure.core/let
   [bean10034
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration)]
   (clojure.core/when-let
    [v10036 (:topic-configurations m10035)]
    (.
     bean10034
     setTopicConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10278]
  (s3/bucket-notification-configuration-topic-configuration arg10278))
 v10036)))
   bean10034))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ProgressListener}
progress-listener
  [m10038]
  (throw
   (clojure.core/ex-info
    "Trying to construct an interface"
    {:type "com.amazonaws.services.s3.model.ProgressListener",
     :value m10038})))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ResponseHeaderOverrides}
response-header-overrides
  [m10041]
  (clojure.core/let
   [bean10040
    (new com.amazonaws.services.s3.model.ResponseHeaderOverrides)]
   (clojure.core/when-let
    [v10042 (:content-type m10041)]
    (. bean10040 setContentType (clojure.core/str v10042)))
   (clojure.core/when-let
    [v10042 (:content-encoding m10041)]
    (. bean10040 setContentEncoding (clojure.core/str v10042)))
   (clojure.core/when-let
    [v10042 (:cache-control m10041)]
    (. bean10040 setCacheControl (clojure.core/str v10042)))
   (clojure.core/when-let
    [v10042 (:content-disposition m10041)]
    (. bean10040 setContentDisposition (clojure.core/str v10042)))
   (clojure.core/when-let
    [v10042 (:content-language m10041)]
    (. bean10040 setContentLanguage (clojure.core/str v10042)))
   (clojure.core/when-let
    [v10042 (:expires m10041)]
    (. bean10040 setExpires (clojure.core/str v10042)))
   bean10040))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSECustomerKey}
ssecustomer-key
  [m10044]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg10046
    nil
    bean10043
    (new
     com.amazonaws.services.s3.model.SSECustomerKey
^{:tag java.lang.String}
arg10046)]
   (clojure.core/when-let
    [v10045 (:algorithm m10044)]
    (. bean10043 setAlgorithm (clojure.core/str v10045)))
   (clojure.core/when-let
    [v10045 (:md5 m10044)]
    (. bean10043 setMd5 (clojure.core/str v10045)))
   bean10043))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketWebsiteConfiguration}
bucket-website-configuration
  [m10048]
  (clojure.core/let
   [bean10047
    (new com.amazonaws.services.s3.model.BucketWebsiteConfiguration)]
   (clojure.core/when-let
    [v10049 (:index-document-suffix m10048)]
    (. bean10047 setIndexDocumentSuffix (clojure.core/str v10049)))
   (clojure.core/when-let
    [v10049 (:error-document m10048)]
    (. bean10047 setErrorDocument (clojure.core/str v10049)))
   (clojure.core/when-let
    [v10049 (:redirect-all-requests-to m10048)]
    (. bean10047 setRedirectAllRequestsTo (s3/redirect-rule v10049)))
   (clojure.core/when-let
    [v10049 (:routing-rules m10048)]
    (.
     bean10047
     setRoutingRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10279] (s3/routing-rule arg10279))
 v10049)))
   bean10047))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectMetadata}
object-metadata
  [m10051]
  (clojure.core/let
   [bean10050 (new com.amazonaws.services.s3.model.ObjectMetadata)]
   (clojure.core/when-let
    [v10052 (:ssecustomer-key-md5 m10051)]
    (. bean10050 setSSECustomerKeyMd5 (clojure.core/str v10052)))
   (clojure.core/when-let
    [v10052 (:content-disposition m10051)]
    (. bean10050 setContentDisposition (clojure.core/str v10052)))
   (clojure.core/when-let
    [v10052 (:last-modified m10051)]
    (.
     bean10050
     setLastModified
     (com.palletops.awaze.common/to-date v10052)))
   (clojure.core/when-let
    [v10052 (:content-md5 m10051)]
    (. bean10050 setContentMD5 (clojure.core/str v10052)))
   (clojure.core/when-let
    [v10052 (:restore-expiration-time m10051)]
    (.
     bean10050
     setRestoreExpirationTime
     (com.palletops.awaze.common/to-date v10052)))
   (clojure.core/when-let
    [v10052 (:content-encoding m10051)]
    (. bean10050 setContentEncoding (clojure.core/str v10052)))
   (clojure.core/when-let
    [v10052 (:ssealgorithm m10051)]
    (. bean10050 setSSEAlgorithm (clojure.core/str v10052)))
   (clojure.core/when-let
    [v10052 (:ssecustomer-algorithm m10051)]
    (. bean10050 setSSECustomerAlgorithm (clojure.core/str v10052)))
   (clojure.core/when-let
    [v10052 (:content-type m10051)]
    (. bean10050 setContentType (clojure.core/str v10052)))
   (clojure.core/when-let
    [v10052 (:expiration-time-rule-id m10051)]
    (. bean10050 setExpirationTimeRuleId (clojure.core/str v10052)))
   (clojure.core/when-let
    [v10052 (:ongoing-restore m10051)]
    (. bean10050 setOngoingRestore (clojure.core/boolean v10052)))
   (clojure.core/when-let
    [v10052 (:http-expires-date m10051)]
    (.
     bean10050
     setHttpExpiresDate
     (com.palletops.awaze.common/to-date v10052)))
   (clojure.core/when-let
    [v10052 (:user-metadata m10051)]
    (.
     bean10050
     setUserMetadata
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg10280] (clojure.core/str arg10280))
  (clojure.core/keys v10052))
 (clojure.core/map
  (clojure.core/fn [arg10280] (clojure.core/str arg10280))
  (clojure.core/vals v10052)))))
   (clojure.core/when-let
    [v10052 (:cache-control m10051)]
    (. bean10050 setCacheControl (clojure.core/str v10052)))
   (clojure.core/when-let
    [v10052 (:content-length m10051)]
    (. bean10050 setContentLength (clojure.core/long v10052)))
   (clojure.core/when-let
    [v10052 (:expiration-time m10051)]
    (.
     bean10050
     setExpirationTime
     (com.palletops.awaze.common/to-date v10052)))
   (clojure.core/when-let
    [v10052 (:server-side-encryption m10051)]
    (. bean10050 setServerSideEncryption (clojure.core/str v10052)))
   bean10050))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AccessControlList}
access-control-list
  [m10054]
  (clojure.core/let
   [bean10053 (new com.amazonaws.services.s3.model.AccessControlList)]
   (clojure.core/when-let
    [v10055 (:owner m10054)]
    (. bean10053 setOwner (s3/owner v10055)))
   bean10053))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
canned-access-control-list
  [m10057]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.CannedAccessControlList
   (clojure.core/name m10057)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketCrossOriginConfiguration}
bucket-cross-origin-configuration
  [m10060]
  (clojure.core/let
   [bean10059
    (new
     com.amazonaws.services.s3.model.BucketCrossOriginConfiguration)]
   (clojure.core/when-let
    [v10061 (:rules m10060)]
    (.
     bean10059
     setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10281] (s3/corsrule arg10281))
 v10061)))
   bean10059))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketTaggingConfiguration}
bucket-tagging-configuration
  [m10063]
  (clojure.core/let
   [bean10062
    (new com.amazonaws.services.s3.model.BucketTaggingConfiguration)]
   (clojure.core/when-let
    [v10064 (:tag-sets m10063)]
    (.
     bean10062
     setTagSets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10282] (s3/tag-set arg10282))
 v10064)))
   bean10062))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketVersioningConfiguration}
bucket-versioning-configuration
  [m10066]
  (clojure.core/let
   [bean10065
    (new
     com.amazonaws.services.s3.model.BucketVersioningConfiguration)]
   (clojure.core/when-let
    [v10067 (:status m10066)]
    (. bean10065 setStatus (clojure.core/str v10067)))
   (clojure.core/when-let
    [v10067 (:mfa-delete-enabled m10066)]
    (. bean10065 setMfaDeleteEnabled (clojure.core/boolean v10067)))
   bean10065))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PartETag}
part-etag
  [m10069]
  (clojure.core/let
   [arg10071
    0
    arg10072
    nil
    bean10068
    (new com.amazonaws.services.s3.model.PartETag arg10071 arg10072)]
   (clojure.core/when-let
    [v10070 (:etag m10069)]
    (. bean10068 setETag (clojure.core/str v10070)))
   (clojure.core/when-let
    [v10070 (:part-number m10069)]
    (. bean10068 setPartNumber (clojure.core/int v10070)))
   bean10068))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration}
bucket-lifecycle-configuration
  [m10074]
  (clojure.core/let
   [bean10073
    (new com.amazonaws.services.s3.model.BucketLifecycleConfiguration)]
   (clojure.core/when-let
    [v10075 (:rules m10074)]
    (.
     bean10073
     setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg10283]
  (s3/bucket-lifecycle-configuration-rule arg10283))
 v10075)))
   bean10073))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLoggingConfiguration}
bucket-logging-configuration
  [m10077]
  (clojure.core/let
   [bean10076
    (new com.amazonaws.services.s3.model.BucketLoggingConfiguration)]
   (clojure.core/when-let
    [v10078 (:destination-bucket-name m10077)]
    (. bean10076 setDestinationBucketName (clojure.core/str v10078)))
   (clojure.core/when-let
    [v10078 (:log-file-prefix m10077)]
    (. bean10076 setLogFilePrefix (clojure.core/str v10078)))
   bean10076))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3VersionSummary}
s3version-summary
  [m10080]
  (clojure.core/let
   [bean10079 (new com.amazonaws.services.s3.model.S3VersionSummary)]
   (clojure.core/when-let
    [v10081 (:last-modified m10080)]
    (.
     bean10079
     setLastModified
     (com.palletops.awaze.common/to-date v10081)))
   (clojure.core/when-let
    [v10081 (:size m10080)]
    (. bean10079 setSize (clojure.core/long v10081)))
   (clojure.core/when-let
    [v10081 (:is-delete-marker m10080)]
    (. bean10079 setIsDeleteMarker (clojure.core/boolean v10081)))
   (clojure.core/when-let
    [v10081 (:version-id m10080)]
    (. bean10079 setVersionId (clojure.core/str v10081)))
   (clojure.core/when-let
    [v10081 (:owner m10080)]
    (. bean10079 setOwner (s3/owner v10081)))
   (clojure.core/when-let
    [v10081 (:is-latest m10080)]
    (. bean10079 setIsLatest (clojure.core/boolean v10081)))
   (clojure.core/when-let
    [v10081 (:etag m10080)]
    (. bean10079 setETag (clojure.core/str v10081)))
   (clojure.core/when-let
    [v10081 (:bucket-name m10080)]
    (. bean10079 setBucketName (clojure.core/str v10081)))
   (clojure.core/when-let
    [v10081 (:key m10080)]
    (. bean10079 setKey (clojure.core/str v10081)))
   (clojure.core/when-let
    [v10081 (:storage-class m10080)]
    (. bean10079 setStorageClass (clojure.core/str v10081)))
   bean10079))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest}
delete-objects-request
  [m10083]
  (clojure.core/let
   [arg10085
    nil
    bean10082
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest
     arg10085)]
   (clojure.core/when-let
    [v10084 (:bucket-name m10083)]
    (. bean10082 setBucketName (clojure.core/str v10084)))
   (clojure.core/when-let
    [v10084 (:mfa m10083)]
    (. bean10082 setMfa (s3/multi-factor-authentication v10084)))
   (clojure.core/when-let
    [v10084 (:quiet m10083)]
    (. bean10082 setQuiet (clojure.core/boolean v10084)))
   (clojure.core/when-let
    [v10084 (:keys m10083)]
    (.
     bean10082
     setKeys
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg10284]
  (s3/delete-objects-request-key-version arg10284))
 v10084)))
   bean10082))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketAclRequest}
set-bucket-acl-request
  [m10087]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg10089
    nil
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg10090
    (access-control-list {})
    bean10086
    (new
     com.amazonaws.services.s3.model.SetBucketAclRequest
^{:tag java.lang.String}
arg10089
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg10090)]
   bean10086))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
get-bucket-location-request
  [m10092]
  (clojure.core/let
   [arg10094
    nil
    bean10091
    (new
     com.amazonaws.services.s3.model.GetBucketLocationRequest
     arg10094)]
   (clojure.core/when-let
    [v10093 (:bucket-name m10092)]
    (. bean10091 setBucketName (clojure.core/str v10093)))
   bean10091))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest}
set-bucket-notification-configuration-request
  [m10096]
  (clojure.core/let
   [^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
    arg10098
    (bucket-notification-configuration {})
^{:tag java.lang.String}
arg10099
    nil
    bean10095
    (new
     com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
arg10098
^{:tag java.lang.String}
arg10099)]
   (clojure.core/when-let
    [v10097 (:bucket m10096)]
    (. bean10095 setBucket (clojure.core/str v10097)))
   (clojure.core/when-let
    [v10097 (:bucket-name m10096)]
    (. bean10095 setBucketName (clojure.core/str v10097)))
   (clojure.core/when-let
    [v10097 (:bucket-notification-configuration m10096)]
    (.
     bean10095
     setBucketNotificationConfiguration
     (s3/bucket-notification-configuration v10097)))
   (clojure.core/when-let
    [v10097 (:notification-configuration m10096)]
    (.
     bean10095
     setNotificationConfiguration
     (s3/bucket-notification-configuration v10097)))
   bean10095))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
get-object-request
  [m10101]
  (clojure.core/let
   [arg10103
    nil
    arg10104
    nil
    bean10100
    (new
     com.amazonaws.services.s3.model.GetObjectRequest
     arg10103
     arg10104)]
   (clojure.core/when-let
    [v10102 (:matching-etag-constraints m10101)]
    (.
     bean10100
     setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10285] (clojure.core/str arg10285))
 v10102)))
   (clojure.core/when-let
    [v10102 (:progress-listener m10101)]
    (. bean10100 setProgressListener (s3/progress-listener v10102)))
   (clojure.core/when-let
    [v10102 (:response-headers m10101)]
    (.
     bean10100
     setResponseHeaders
     (s3/response-header-overrides v10102)))
   (clojure.core/when-let
    [v10102 (:requester-pays m10101)]
    (. bean10100 setRequesterPays (clojure.core/boolean v10102)))
   (clojure.core/when-let
    [v10102 (:modified-since-constraint m10101)]
    (.
     bean10100
     setModifiedSinceConstraint
     (com.palletops.awaze.common/to-date v10102)))
   (clojure.core/when-let
    [v10102 (:version-id m10101)]
    (. bean10100 setVersionId (clojure.core/str v10102)))
   (clojure.core/when-let
    [v10102 (:unmodified-since-constraint m10101)]
    (.
     bean10100
     setUnmodifiedSinceConstraint
     (com.palletops.awaze.common/to-date v10102)))
   (clojure.core/when-let
    [v10102 (:bucket-name m10101)]
    (. bean10100 setBucketName (clojure.core/str v10102)))
   (clojure.core/when-let
    [v10102 (:nonmatching-etag-constraints m10101)]
    (.
     bean10100
     setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10286] (clojure.core/str arg10286))
 v10102)))
   (clojure.core/when-let
    [v10102 (:key m10101)]
    (. bean10100 setKey (clojure.core/str v10102)))
   (clojure.core/when-let
    [v10102 (:ssecustomer-key m10101)]
    (. bean10100 setSSECustomerKey (s3/ssecustomer-key v10102)))
   bean10100))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest}
set-bucket-website-configuration-request
  [m10106]
  (clojure.core/let
   [arg10108
    nil
    arg10109
    nil
    bean10105
    (new
     com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest
     arg10108
     arg10109)]
   (clojure.core/when-let
    [v10107 (:bucket-name m10106)]
    (. bean10105 setBucketName (clojure.core/str v10107)))
   (clojure.core/when-let
    [v10107 (:configuration m10106)]
    (.
     bean10105
     setConfiguration
     (s3/bucket-website-configuration v10107)))
   bean10105))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyObjectRequest}
copy-object-request
  [m10111]
  (clojure.core/let
   [arg10113
    nil
    arg10114
    nil
    arg10115
    nil
    arg10116
    nil
    bean10110
    (new
     com.amazonaws.services.s3.model.CopyObjectRequest
     arg10113
     arg10114
     arg10115
     arg10116)]
   (clojure.core/when-let
    [v10112 (:destination-bucket-name m10111)]
    (. bean10110 setDestinationBucketName (clojure.core/str v10112)))
   (clojure.core/when-let
    [v10112 (:matching-etag-constraints m10111)]
    (.
     bean10110
     setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10287] (clojure.core/str arg10287))
 v10112)))
   (clojure.core/when-let
    [v10112 (:source-key m10111)]
    (. bean10110 setSourceKey (clojure.core/str v10112)))
   (clojure.core/when-let
    [v10112 (:destination-ssecustomer-key m10111)]
    (.
     bean10110
     setDestinationSSECustomerKey
     (s3/ssecustomer-key v10112)))
   (clojure.core/when-let
    [v10112 (:new-object-metadata m10111)]
    (. bean10110 setNewObjectMetadata (s3/object-metadata v10112)))
   (clojure.core/when-let
    [v10112 (:modified-since-constraint m10111)]
    (.
     bean10110
     setModifiedSinceConstraint
     (com.palletops.awaze.common/to-date v10112)))
   (clojure.core/when-let
    [v10112 (:source-bucket-name m10111)]
    (. bean10110 setSourceBucketName (clojure.core/str v10112)))
   (clojure.core/when-let
    [v10112 (:redirect-location m10111)]
    (. bean10110 setRedirectLocation (clojure.core/str v10112)))
   (clojure.core/when-let
    [v10112 (:destination-key m10111)]
    (. bean10110 setDestinationKey (clojure.core/str v10112)))
   (clojure.core/when-let
    [v10112 (:unmodified-since-constraint m10111)]
    (.
     bean10110
     setUnmodifiedSinceConstraint
     (com.palletops.awaze.common/to-date v10112)))
   (clojure.core/when-let
    [v10112 (:access-control-list m10111)]
    (. bean10110 setAccessControlList (s3/access-control-list v10112)))
   (clojure.core/when-let
    [v10112 (:source-version-id m10111)]
    (. bean10110 setSourceVersionId (clojure.core/str v10112)))
   (clojure.core/when-let
    [v10112 (:canned-access-control-list m10111)]
    (.
     bean10110
     setCannedAccessControlList
     (s3/canned-access-control-list v10112)))
   (clojure.core/when-let
    [v10112 (:nonmatching-etag-constraints m10111)]
    (.
     bean10110
     setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10288] (clojure.core/str arg10288))
 v10112)))
   (clojure.core/when-let
    [v10112 (:source-ssecustomer-key m10111)]
    (. bean10110 setSourceSSECustomerKey (s3/ssecustomer-key v10112)))
   (clojure.core/when-let
    [v10112 (:storage-class m10111)]
    (. bean10110 setStorageClass (clojure.core/str v10112)))
   bean10110))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest}
set-bucket-cross-origin-configuration-request
  [m10118]
  (clojure.core/let
   [arg10120
    nil
    arg10121
    nil
    bean10117
    (new
     com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest
     arg10120
     arg10121)]
   (clojure.core/when-let
    [v10119 (:bucket-name m10118)]
    (. bean10117 setBucketName (clojure.core/str v10119)))
   (clojure.core/when-let
    [v10119 (:cross-origin-configuration m10118)]
    (.
     bean10117
     setCrossOriginConfiguration
     (s3/bucket-cross-origin-configuration v10119)))
   bean10117))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest}
set-bucket-tagging-configuration-request
  [m10123]
  (clojure.core/let
   [arg10125
    nil
    arg10126
    nil
    bean10122
    (new
     com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest
     arg10125
     arg10126)]
   (clojure.core/when-let
    [v10124 (:bucket-name m10123)]
    (. bean10122 setBucketName (clojure.core/str v10124)))
   (clojure.core/when-let
    [v10124 (:tagging-configuration m10123)]
    (.
     bean10122
     setTaggingConfiguration
     (s3/bucket-tagging-configuration v10124)))
   bean10122))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.S3ClientOptions}
s3client-options
  [m10128]
  (clojure.core/let
   [bean10127 (new com.amazonaws.services.s3.S3ClientOptions)]
   (clojure.core/when-let
    [v10129 (:path-style-access m10128)]
    (. bean10127 setPathStyleAccess (clojure.core/boolean v10129)))
   bean10127))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RestoreObjectRequest}
restore-object-request
  [m10131]
  (clojure.core/let
   [arg10133
    nil
    arg10134
    nil
    bean10130
    (new
     com.amazonaws.services.s3.model.RestoreObjectRequest
     arg10133
     arg10134)]
   (clojure.core/when-let
    [v10132 (:bucket-name m10131)]
    (. bean10130 setBucketName (clojure.core/str v10132)))
   (clojure.core/when-let
    [v10132 (:key m10131)]
    (. bean10130 setKey (clojure.core/str v10132)))
   (clojure.core/when-let
    [v10132 (:version-id m10131)]
    (. bean10130 setVersionId (clojure.core/str v10132)))
   (clojure.core/when-let
    [v10132 (:expiration-in-days m10131)]
    (. bean10130 setExpirationInDays (clojure.core/int v10132)))
   bean10130))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteVersionRequest}
delete-version-request
  [m10136]
  (clojure.core/let
   [arg10138
    nil
    arg10139
    nil
    arg10140
    nil
    bean10135
    (new
     com.amazonaws.services.s3.model.DeleteVersionRequest
     arg10138
     arg10139
     arg10140)]
   (clojure.core/when-let
    [v10137 (:bucket-name m10136)]
    (. bean10135 setBucketName (clojure.core/str v10137)))
   (clojure.core/when-let
    [v10137 (:key m10136)]
    (. bean10135 setKey (clojure.core/str v10137)))
   (clojure.core/when-let
    [v10137 (:version-id m10136)]
    (. bean10135 setVersionId (clojure.core/str v10137)))
   (clojure.core/when-let
    [v10137 (:mfa m10136)]
    (. bean10135 setMfa (s3/multi-factor-authentication v10137)))
   bean10135))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest}
set-bucket-versioning-configuration-request
  [m10142]
  (clojure.core/let
   [arg10144
    nil
    arg10145
    nil
    bean10141
    (new
     com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest
     arg10144
     arg10145)]
   (clojure.core/when-let
    [v10143 (:bucket-name m10142)]
    (. bean10141 setBucketName (clojure.core/str v10143)))
   (clojure.core/when-let
    [v10143 (:mfa m10142)]
    (. bean10141 setMfa (s3/multi-factor-authentication v10143)))
   (clojure.core/when-let
    [v10143 (:versioning-configuration m10142)]
    (.
     bean10141
     setVersioningConfiguration
     (s3/bucket-versioning-configuration v10143)))
   bean10141))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Region}
region
  [m10147]
  (.
   com.amazonaws.services.s3.model.Region
   fromValue
   (clojure.core/name m10147)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
create-bucket-request
  [m10150]
  (clojure.core/let
   [arg10152
    nil
    bean10149
    (new com.amazonaws.services.s3.model.CreateBucketRequest arg10152)]
   (clojure.core/when-let
    [v10151 (:bucket-name m10150)]
    (. bean10149 setBucketName (clojure.core/str v10151)))
   (clojure.core/when-let
    [v10151 (:region m10150)]
    (. bean10149 setRegion (clojure.core/str v10151)))
   (clojure.core/when-let
    [v10151 (:canned-acl m10150)]
    (. bean10149 setCannedAcl (s3/canned-access-control-list v10151)))
   (clojure.core/when-let
    [v10151 (:access-control-list m10150)]
    (. bean10149 setAccessControlList (s3/access-control-list v10151)))
   bean10149))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectListing}
object-listing
  [m10154]
  (clojure.core/let
   [bean10153 (new com.amazonaws.services.s3.model.ObjectListing)]
   (clojure.core/when-let
    [v10155 (:delimiter m10154)]
    (. bean10153 setDelimiter (clojure.core/str v10155)))
   (clojure.core/when-let
    [v10155 (:common-prefixes m10154)]
    (.
     bean10153
     setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10289] (clojure.core/str arg10289))
 v10155)))
   (clojure.core/when-let
    [v10155 (:encoding-type m10154)]
    (. bean10153 setEncodingType (clojure.core/str v10155)))
   (clojure.core/when-let
    [v10155 (:next-marker m10154)]
    (. bean10153 setNextMarker (clojure.core/str v10155)))
   (clojure.core/when-let
    [v10155 (:prefix m10154)]
    (. bean10153 setPrefix (clojure.core/str v10155)))
   (clojure.core/when-let
    [v10155 (:max-keys m10154)]
    (. bean10153 setMaxKeys (clojure.core/int v10155)))
   (clojure.core/when-let
    [v10155 (:bucket-name m10154)]
    (. bean10153 setBucketName (clojure.core/str v10155)))
   (clojure.core/when-let
    [v10155 (:truncated m10154)]
    (. bean10153 setTruncated (clojure.core/boolean v10155)))
   (clojure.core/when-let
    [v10155 (:marker m10154)]
    (. bean10153 setMarker (clojure.core/str v10155)))
   bean10153))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PutObjectRequest}
put-object-request
  [m10157]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg10159
    nil
^{:tag java.lang.String}
arg10160
    nil
^{:tag java.io.File}
arg10161
    nil
    bean10156
    (new
     com.amazonaws.services.s3.model.PutObjectRequest
^{:tag java.lang.String}
arg10159
^{:tag java.lang.String}
arg10160
^{:tag java.io.File}
arg10161)]
   (clojure.core/when-let
    [v10158 (:progress-listener m10157)]
    (. bean10156 setProgressListener (s3/progress-listener v10158)))
   (clojure.core/when-let
    [v10158 (:input-stream m10157)]
    (. bean10156 setInputStream (clojure.java.io/input-stream v10158)))
   (clojure.core/when-let
    [v10158 (:canned-acl m10157)]
    (. bean10156 setCannedAcl (s3/canned-access-control-list v10158)))
   (clojure.core/when-let
    [v10158 (:metadata m10157)]
    (. bean10156 setMetadata (s3/object-metadata v10158)))
   (clojure.core/when-let
    [v10158 (:redirect-location m10157)]
    (. bean10156 setRedirectLocation (clojure.core/str v10158)))
   (clojure.core/when-let
    [v10158 (:access-control-list m10157)]
    (. bean10156 setAccessControlList (s3/access-control-list v10158)))
   (clojure.core/when-let
    [v10158 (:bucket-name m10157)]
    (. bean10156 setBucketName (clojure.core/str v10158)))
   (clojure.core/when-let
    [v10158 (:key m10157)]
    (. bean10156 setKey (clojure.core/str v10158)))
   (clojure.core/when-let
    [v10158 (:file m10157)]
    (. bean10156 setFile (clojure.java.io/file v10158)))
   (clojure.core/when-let
    [v10158 (:ssecustomer-key m10157)]
    (. bean10156 setSSECustomerKey (s3/ssecustomer-key v10158)))
   (clojure.core/when-let
    [v10158 (:storage-class m10157)]
    (. bean10156 setStorageClass (s3/storage-class v10158)))
   bean10156))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
get-bucket-policy-request
  [m10163]
  (clojure.core/let
   [arg10165
    nil
    bean10162
    (new
     com.amazonaws.services.s3.model.GetBucketPolicyRequest
     arg10165)]
   (clojure.core/when-let
    [v10164 (:bucket-name m10163)]
    (. bean10162 setBucketName (clojure.core/str v10164)))
   bean10162))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
list-objects-request
  [m10167]
  (clojure.core/let
   [bean10166
    (new com.amazonaws.services.s3.model.ListObjectsRequest)]
   (clojure.core/when-let
    [v10168 (:prefix m10167)]
    (. bean10166 setPrefix (clojure.core/str v10168)))
   (clojure.core/when-let
    [v10168 (:bucket-name m10167)]
    (. bean10166 setBucketName (clojure.core/str v10168)))
   (clojure.core/when-let
    [v10168 (:marker m10167)]
    (. bean10166 setMarker (clojure.core/str v10168)))
   (clojure.core/when-let
    [v10168 (:delimiter m10167)]
    (. bean10166 setDelimiter (clojure.core/str v10168)))
   (clojure.core/when-let
    [v10168 (:max-keys m10167)]
    (. bean10166 setMaxKeys (clojure.core/int v10168)))
   (clojure.core/when-let
    [v10168 (:encoding-type m10167)]
    (. bean10166 setEncodingType (clojure.core/str v10168)))
   bean10166))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m10170]
  (clojure.core/let
   [arg10172
    nil
    arg10173
    nil
    arg10174
    nil
    bean10169
    (new
     com.amazonaws.services.s3.model.AbortMultipartUploadRequest
     arg10172
     arg10173
     arg10174)]
   (clojure.core/when-let
    [v10171 (:bucket-name m10170)]
    (. bean10169 setBucketName (clojure.core/str v10171)))
   (clojure.core/when-let
    [v10171 (:key m10170)]
    (. bean10169 setKey (clojure.core/str v10171)))
   (clojure.core/when-let
    [v10171 (:upload-id m10170)]
    (. bean10169 setUploadId (clojure.core/str v10171)))
   bean10169))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.UploadPartRequest}
upload-part-request
  [m10176]
  (clojure.core/let
   [bean10175 (new com.amazonaws.services.s3.model.UploadPartRequest)]
   (clojure.core/when-let
    [v10177 (:md5digest m10176)]
    (. bean10175 setMd5Digest (clojure.core/str v10177)))
   (clojure.core/when-let
    [v10177 (:progress-listener m10176)]
    (. bean10175 setProgressListener (s3/progress-listener v10177)))
   (clojure.core/when-let
    [v10177 (:input-stream m10176)]
    (. bean10175 setInputStream (clojure.java.io/input-stream v10177)))
   (clojure.core/when-let
    [v10177 (:last-part m10176)]
    (. bean10175 setLastPart (clojure.core/boolean v10177)))
   (clojure.core/when-let
    [v10177 (:file-offset m10176)]
    (. bean10175 setFileOffset (clojure.core/long v10177)))
   (clojure.core/when-let
    [v10177 (:part-size m10176)]
    (. bean10175 setPartSize (clojure.core/long v10177)))
   (clojure.core/when-let
    [v10177 (:bucket-name m10176)]
    (. bean10175 setBucketName (clojure.core/str v10177)))
   (clojure.core/when-let
    [v10177 (:key m10176)]
    (. bean10175 setKey (clojure.core/str v10177)))
   (clojure.core/when-let
    [v10177 (:file m10176)]
    (. bean10175 setFile (clojure.java.io/file v10177)))
   (clojure.core/when-let
    [v10177 (:upload-id m10176)]
    (. bean10175 setUploadId (clojure.core/str v10177)))
   (clojure.core/when-let
    [v10177 (:part-number m10176)]
    (. bean10175 setPartNumber (clojure.core/int v10177)))
   (clojure.core/when-let
    [v10177 (:ssecustomer-key m10176)]
    (. bean10175 setSSECustomerKey (s3/ssecustomer-key v10177)))
   bean10175))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m10179]
  (clojure.core/let
   [arg10181
    nil
    arg10182
    nil
    arg10183
    nil
    arg10184
    nil
    bean10178
    (new
     com.amazonaws.services.s3.model.CompleteMultipartUploadRequest
     arg10181
     arg10182
     arg10183
     arg10184)]
   (clojure.core/when-let
    [v10180 (:bucket-name m10179)]
    (. bean10178 setBucketName (clojure.core/str v10180)))
   (clojure.core/when-let
    [v10180 (:key m10179)]
    (. bean10178 setKey (clojure.core/str v10180)))
   (clojure.core/when-let
    [v10180 (:upload-id m10179)]
    (. bean10178 setUploadId (clojure.core/str v10180)))
   (clojure.core/when-let
    [v10180 (:part-etags m10179)]
    (.
     bean10178
     setPartETags
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10290] (s3/part-etag arg10290))
 v10180)))
   bean10178))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListVersionsRequest}
list-versions-request
  [m10186]
  (clojure.core/let
   [bean10185
    (new com.amazonaws.services.s3.model.ListVersionsRequest)]
   (clojure.core/when-let
    [v10187 (:prefix m10186)]
    (. bean10185 setPrefix (clojure.core/str v10187)))
   (clojure.core/when-let
    [v10187 (:bucket-name m10186)]
    (. bean10185 setBucketName (clojure.core/str v10187)))
   (clojure.core/when-let
    [v10187 (:max-results m10186)]
    (. bean10185 setMaxResults (clojure.core/int v10187)))
   (clojure.core/when-let
    [v10187 (:delimiter m10186)]
    (. bean10185 setDelimiter (clojure.core/str v10187)))
   (clojure.core/when-let
    [v10187 (:key-marker m10186)]
    (. bean10185 setKeyMarker (clojure.core/str v10187)))
   (clojure.core/when-let
    [v10187 (:version-id-marker m10186)]
    (. bean10185 setVersionIdMarker (clojure.core/str v10187)))
   (clojure.core/when-let
    [v10187 (:encoding-type m10186)]
    (. bean10185 setEncodingType (clojure.core/str v10187)))
   bean10185))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
delete-bucket-website-configuration-request
  [m10189]
  (clojure.core/let
   [arg10191
    nil
    bean10188
    (new
     com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
     arg10191)]
   bean10188))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m10193]
  (clojure.core/let
   [arg10195
    nil
    bean10192
    (new
     com.amazonaws.services.s3.model.ListMultipartUploadsRequest
     arg10195)]
   (clojure.core/when-let
    [v10194 (:prefix m10193)]
    (. bean10192 setPrefix (clojure.core/str v10194)))
   (clojure.core/when-let
    [v10194 (:bucket-name m10193)]
    (. bean10192 setBucketName (clojure.core/str v10194)))
   (clojure.core/when-let
    [v10194 (:upload-id-marker m10193)]
    (. bean10192 setUploadIdMarker (clojure.core/str v10194)))
   (clojure.core/when-let
    [v10194 (:delimiter m10193)]
    (. bean10192 setDelimiter (clojure.core/str v10194)))
   (clojure.core/when-let
    [v10194 (:key-marker m10193)]
    (. bean10192 setKeyMarker (clojure.core/str v10194)))
   (clojure.core/when-let
    [v10194 (:encoding-type m10193)]
    (. bean10192 setEncodingType (clojure.core/str v10194)))
   (clojure.core/when-let
    [v10194 (:max-uploads m10193)]
    (. bean10192 setMaxUploads (clojure.core/int v10194)))
   bean10192))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest}
set-bucket-lifecycle-configuration-request
  [m10197]
  (clojure.core/let
   [arg10199
    nil
    arg10200
    nil
    bean10196
    (new
     com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest
     arg10199
     arg10200)]
   (clojure.core/when-let
    [v10198 (:bucket-name m10197)]
    (. bean10196 setBucketName (clojure.core/str v10198)))
   (clojure.core/when-let
    [v10198 (:lifecycle-configuration m10197)]
    (.
     bean10196
     setLifecycleConfiguration
     (s3/bucket-lifecycle-configuration v10198)))
   bean10196))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectMetadataRequest}
get-object-metadata-request
  [m10202]
  (clojure.core/let
   [arg10204
    nil
    arg10205
    nil
    bean10201
    (new
     com.amazonaws.services.s3.model.GetObjectMetadataRequest
     arg10204
     arg10205)]
   (clojure.core/when-let
    [v10203 (:bucket-name m10202)]
    (. bean10201 setBucketName (clojure.core/str v10203)))
   (clojure.core/when-let
    [v10203 (:key m10202)]
    (. bean10201 setKey (clojure.core/str v10203)))
   (clojure.core/when-let
    [v10203 (:version-id m10202)]
    (. bean10201 setVersionId (clojure.core/str v10203)))
   (clojure.core/when-let
    [v10203 (:ssecustomer-key m10202)]
    (. bean10201 setSSECustomerKey (s3/ssecustomer-key v10203)))
   bean10201))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
delete-bucket-cross-origin-configuration-request
  [m10207]
  (clojure.core/let
   [arg10209
    nil
    bean10206
    (new
     com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
     arg10209)]
   bean10206))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
delete-bucket-tagging-configuration-request
  [m10211]
  (clojure.core/let
   [arg10213
    nil
    bean10210
    (new
     com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
     arg10213)]
   bean10210))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
delete-bucket-policy-request
  [m10215]
  (clojure.core/let
   [arg10217
    nil
    bean10214
    (new
     com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
     arg10217)]
   (clojure.core/when-let
    [v10216 (:bucket-name m10215)]
    (. bean10214 setBucketName (clojure.core/str v10216)))
   bean10214))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
get-bucket-website-configuration-request
  [m10219]
  (clojure.core/let
   [arg10221
    nil
    bean10218
    (new
     com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
     arg10221)]
   (clojure.core/when-let
    [v10220 (:bucket-name m10219)]
    (. bean10218 setBucketName (clojure.core/str v10220)))
   bean10218))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
delete-bucket-lifecycle-configuration-request
  [m10223]
  (clojure.core/let
   [arg10225
    nil
    bean10222
    (new
     com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
     arg10225)]
   bean10222))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
delete-bucket-request
  [m10227]
  (clojure.core/let
   [arg10229
    nil
    bean10226
    (new com.amazonaws.services.s3.model.DeleteBucketRequest arg10229)]
   (clojure.core/when-let
    [v10228 (:bucket-name m10227)]
    (. bean10226 setBucketName (clojure.core/str v10228)))
   bean10226))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectRequest}
delete-object-request
  [m10231]
  (clojure.core/let
   [arg10233
    nil
    arg10234
    nil
    bean10230
    (new
     com.amazonaws.services.s3.model.DeleteObjectRequest
     arg10233
     arg10234)]
   (clojure.core/when-let
    [v10232 (:bucket-name m10231)]
    (. bean10230 setBucketName (clojure.core/str v10232)))
   (clojure.core/when-let
    [v10232 (:key m10231)]
    (. bean10230 setKey (clojure.core/str v10232)))
   bean10230))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyPartRequest}
copy-part-request
  [m10236]
  (clojure.core/let
   [bean10235 (new com.amazonaws.services.s3.model.CopyPartRequest)]
   (clojure.core/when-let
    [v10237 (:last-byte m10236)]
    (. bean10235 setLastByte (clojure.core/long v10237)))
   (clojure.core/when-let
    [v10237 (:destination-bucket-name m10236)]
    (. bean10235 setDestinationBucketName (clojure.core/str v10237)))
   (clojure.core/when-let
    [v10237 (:matching-etag-constraints m10236)]
    (.
     bean10235
     setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10291] (clojure.core/str arg10291))
 v10237)))
   (clojure.core/when-let
    [v10237 (:source-key m10236)]
    (. bean10235 setSourceKey (clojure.core/str v10237)))
   (clojure.core/when-let
    [v10237 (:destination-ssecustomer-key m10236)]
    (.
     bean10235
     setDestinationSSECustomerKey
     (s3/ssecustomer-key v10237)))
   (clojure.core/when-let
    [v10237 (:modified-since-constraint m10236)]
    (.
     bean10235
     setModifiedSinceConstraint
     (com.palletops.awaze.common/to-date v10237)))
   (clojure.core/when-let
    [v10237 (:source-bucket-name m10236)]
    (. bean10235 setSourceBucketName (clojure.core/str v10237)))
   (clojure.core/when-let
    [v10237 (:destination-key m10236)]
    (. bean10235 setDestinationKey (clojure.core/str v10237)))
   (clojure.core/when-let
    [v10237 (:unmodified-since-constraint m10236)]
    (.
     bean10235
     setUnmodifiedSinceConstraint
     (com.palletops.awaze.common/to-date v10237)))
   (clojure.core/when-let
    [v10237 (:source-version-id m10236)]
    (. bean10235 setSourceVersionId (clojure.core/str v10237)))
   (clojure.core/when-let
    [v10237 (:first-byte m10236)]
    (. bean10235 setFirstByte (clojure.core/long v10237)))
   (clojure.core/when-let
    [v10237 (:nonmatching-etag-constraints m10236)]
    (.
     bean10235
     setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10292] (clojure.core/str arg10292))
 v10237)))
   (clojure.core/when-let
    [v10237 (:source-ssecustomer-key m10236)]
    (. bean10235 setSourceSSECustomerKey (s3/ssecustomer-key v10237)))
   (clojure.core/when-let
    [v10237 (:upload-id m10236)]
    (. bean10235 setUploadId (clojure.core/str v10237)))
   (clojure.core/when-let
    [v10237 (:part-number m10236)]
    (. bean10235 setPartNumber (clojure.core/int v10237)))
   bean10235))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m10239]
  (clojure.core/let
   [arg10241
    nil
    arg10242
    nil
    bean10238
    (new
     com.amazonaws.services.s3.model.InitiateMultipartUploadRequest
     arg10241
     arg10242)]
   (clojure.core/when-let
    [v10240 (:bucket-name m10239)]
    (. bean10238 setBucketName (clojure.core/str v10240)))
   (clojure.core/when-let
    [v10240 (:key m10239)]
    (. bean10238 setKey (clojure.core/str v10240)))
   (clojure.core/when-let
    [v10240 (:ssecustomer-key m10239)]
    (. bean10238 setSSECustomerKey (s3/ssecustomer-key v10240)))
   (clojure.core/when-let
    [v10240 (:storage-class m10239)]
    (. bean10238 setStorageClass (s3/storage-class v10240)))
   (clojure.core/when-let
    [v10240 (:access-control-list m10239)]
    (. bean10238 setAccessControlList (s3/access-control-list v10240)))
   (clojure.core/when-let
    [v10240 (:redirect-location m10239)]
    (. bean10238 setRedirectLocation (clojure.core/str v10240)))
   (clojure.core/when-let
    [v10240 (:canned-acl m10239)]
    (. bean10238 setCannedACL (s3/canned-access-control-list v10240)))
   (clojure.core/when-let
    [v10240 (:object-metadata m10239)]
    (. bean10238 setObjectMetadata (s3/object-metadata v10240)))
   bean10238))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketPolicyRequest}
set-bucket-policy-request
  [m10244]
  (clojure.core/let
   [arg10246
    nil
    arg10247
    nil
    bean10243
    (new
     com.amazonaws.services.s3.model.SetBucketPolicyRequest
     arg10246
     arg10247)]
   (clojure.core/when-let
    [v10245 (:bucket-name m10244)]
    (. bean10243 setBucketName (clojure.core/str v10245)))
   (clojure.core/when-let
    [v10245 (:policy-text m10244)]
    (. bean10243 setPolicyText (clojure.core/str v10245)))
   bean10243))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GeneratePresignedUrlRequest}
generate-presigned-url-request
  [m10249]
  (clojure.core/let
   [arg10251
    nil
    arg10252
    nil
    bean10248
    (new
     com.amazonaws.services.s3.model.GeneratePresignedUrlRequest
     arg10251
     arg10252)]
   (clojure.core/when-let
    [v10250 (:bucket-name m10249)]
    (. bean10248 setBucketName (clojure.core/str v10250)))
   (clojure.core/when-let
    [v10250 (:key m10249)]
    (. bean10248 setKey (clojure.core/str v10250)))
   (clojure.core/when-let
    [v10250 (:method m10249)]
    (. bean10248 setMethod (root/http-method v10250)))
   (clojure.core/when-let
    [v10250 (:content-type m10249)]
    (. bean10248 setContentType (clojure.core/str v10250)))
   (clojure.core/when-let
    [v10250 (:content-md5 m10249)]
    (. bean10248 setContentMd5 (clojure.core/str v10250)))
   (clojure.core/when-let
    [v10250 (:expiration m10249)]
    (.
     bean10248
     setExpiration
     (com.palletops.awaze.common/to-date v10250)))
   (clojure.core/when-let
    [v10250 (:response-headers m10249)]
    (.
     bean10248
     setResponseHeaders
     (s3/response-header-overrides v10250)))
   (clojure.core/when-let
    [v10250 (:ssecustomer-key m10249)]
    (. bean10248 setSSECustomerKey (s3/ssecustomer-key v10250)))
   bean10248))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListPartsRequest}
list-parts-request
  [m10254]
  (clojure.core/let
   [arg10256
    nil
    arg10257
    nil
    arg10258
    nil
    bean10253
    (new
     com.amazonaws.services.s3.model.ListPartsRequest
     arg10256
     arg10257
     arg10258)]
   (clojure.core/when-let
    [v10255 (:bucket-name m10254)]
    (. bean10253 setBucketName (clojure.core/str v10255)))
   (clojure.core/when-let
    [v10255 (:key m10254)]
    (. bean10253 setKey (clojure.core/str v10255)))
   (clojure.core/when-let
    [v10255 (:upload-id m10254)]
    (. bean10253 setUploadId (clojure.core/str v10255)))
   (clojure.core/when-let
    [v10255 (:encoding-type m10254)]
    (. bean10253 setEncodingType (clojure.core/str v10255)))
   (clojure.core/when-let
    [v10255 (:max-parts m10254)]
    (. bean10253 setMaxParts (clojure.core/int v10255)))
   (clojure.core/when-let
    [v10255 (:part-number-marker m10254)]
    (. bean10253 setPartNumberMarker (clojure.core/int v10255)))
   bean10253))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListBucketsRequest}
list-buckets-request
  [m10260]
  (clojure.core/let
   [bean10259
    (new com.amazonaws.services.s3.model.ListBucketsRequest)]
   bean10259))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest}
set-bucket-logging-configuration-request
  [m10263]
  (clojure.core/let
   [arg10265
    nil
    arg10266
    nil
    bean10262
    (new
     com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest
     arg10265
     arg10266)]
   (clojure.core/when-let
    [v10264 (:bucket-name m10263)]
    (. bean10262 setBucketName (clojure.core/str v10264)))
   (clojure.core/when-let
    [v10264 (:logging-configuration m10263)]
    (.
     bean10262
     setLoggingConfiguration
     (s3/bucket-logging-configuration v10264)))
   bean10262))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
get-bucket-acl-request
  [m10268]
  (clojure.core/let
   [arg10270
    nil
    bean10267
    (new com.amazonaws.services.s3.model.GetBucketAclRequest arg10270)]
   bean10267))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.VersionListing}
version-listing
  [m10272]
  (clojure.core/let
   [bean10271 (new com.amazonaws.services.s3.model.VersionListing)]
   (clojure.core/when-let
    [v10273 (:next-key-marker m10272)]
    (. bean10271 setNextKeyMarker (clojure.core/str v10273)))
   (clojure.core/when-let
    [v10273 (:delimiter m10272)]
    (. bean10271 setDelimiter (clojure.core/str v10273)))
   (clojure.core/when-let
    [v10273 (:version-id-marker m10272)]
    (. bean10271 setVersionIdMarker (clojure.core/str v10273)))
   (clojure.core/when-let
    [v10273 (:common-prefixes m10272)]
    (.
     bean10271
     setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10293] (clojure.core/str arg10293))
 v10273)))
   (clojure.core/when-let
    [v10273 (:version-summaries m10272)]
    (.
     bean10271
     setVersionSummaries
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg10294] (s3/s3version-summary arg10294))
 v10273)))
   (clojure.core/when-let
    [v10273 (:encoding-type m10272)]
    (. bean10271 setEncodingType (clojure.core/str v10273)))
   (clojure.core/when-let
    [v10273 (:prefix m10272)]
    (. bean10271 setPrefix (clojure.core/str v10273)))
   (clojure.core/when-let
    [v10273 (:max-keys m10272)]
    (. bean10271 setMaxKeys (clojure.core/int v10273)))
   (clojure.core/when-let
    [v10273 (:key-marker m10272)]
    (. bean10271 setKeyMarker (clojure.core/str v10273)))
   (clojure.core/when-let
    [v10273 (:bucket-name m10272)]
    (. bean10271 setBucketName (clojure.core/str v10273)))
   (clojure.core/when-let
    [v10273 (:next-version-id-marker m10272)]
    (. bean10271 setNextVersionIdMarker (clojure.core/str v10273)))
   (clojure.core/when-let
    [v10273 (:truncated m10272)]
    (. bean10271 setTruncated (clojure.core/boolean v10273)))
   bean10271))
 (clojure.core/defmulti
  s3
  (clojure.core/fn s3 [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-versioning-configuration
   [m10295]
   (clojure.core/let
    [credentials10296 (:credentials m10295) args10297 (:args m10295)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10298
      (com.palletops.awaze.common/aws-client :s3 credentials10296)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10298
       getBucketVersioningConfiguration
       (clojure.core/str (clojure.core/nth args10297 0)))))))
  (clojure.core/defn
   get-bucket-versioning-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketVersioningConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-versioning-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-bucket-versioning-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketVersioningConfiguration"}
   [credentials10300 & args10301]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10302
     (com.palletops.awaze.common/aws-client :s3 credentials10300)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10302
      getBucketVersioningConfiguration
      (clojure.core/str (clojure.core/nth args10301 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-objects
   [m10303]
   (clojure.core/let
    [credentials10304 (:credentials m10303) args10305 (:args m10303)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10306
      (com.palletops.awaze.common/aws-client :s3 credentials10304)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10306
       deleteObjects
       (s3/delete-objects-request (clojure.core/nth args10305 0)))))))
  (clojure.core/defn
   delete-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [quiet
                         mfa
                         keys
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Generate map for deleteObjects"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-objects,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-objects
   {:arglists (quote
               [[credentials
                 {:keys [quiet
                         mfa
                         keys
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Call deleteObjects"}
   [credentials10309 & args10310]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10312
     (com.palletops.awaze.common/aws-client :s3 credentials10309)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10312
      deleteObjects
      (s3/delete-objects-request (clojure.core/nth args10310 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-acl
   [m10313]
   (clojure.core/let
    [credentials10314 (:credentials m10313) args10315 (:args m10313)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10316
      (com.palletops.awaze.common/aws-client :s3 credentials10314)]
     (clojure.core/case
      (clojure.core/count args10315)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10316
        setBucketAcl
        (s3/set-bucket-acl-request (clojure.core/nth args10315 0))))
      3
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10315 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args10315 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args10315 2))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10316
           setBucketAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10315 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args10315 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args10315 2))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10316
               setBucketAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args10315}))))))))))
      2
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10315 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args10315 1))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10316
           setBucketAcl
           a
           b)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10315 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args10315 1))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10316
               setBucketAcl
               a
               b)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args10315}))))))))))))))
  (clojure.core/defn
   set-bucket-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         canned-acl
                         bucket-name
                         acl]}]
                [credentials
                 string-0
                 {:keys [owner grants]}
                 request-metric-collector-2]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]
                [credentials string-0 {:keys [owner grants]}]
                [credentials string-0 canned-access-control-list-1]]),
    :doc "Generate map for setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-acl,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-acl,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :set-bucket-acl,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-bucket-acl
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         canned-acl
                         bucket-name
                         acl]}]
                [credentials
                 string-0
                 {:keys [owner grants]}
                 request-metric-collector-2]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]
                [credentials string-0 {:keys [owner grants]}]
                [credentials string-0 canned-access-control-list-1]]),
    :doc "Call setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   [credentials10320 & args10321]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10324
     (com.palletops.awaze.common/aws-client :s3 credentials10320)]
    (clojure.core/case
     (clojure.core/count args10321)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10324
       setBucketAcl
       (s3/set-bucket-acl-request (clojure.core/nth args10321 0))))
     3
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10321 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args10321 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args10321 2))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10324
          setBucketAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10321 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args10321 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args10321 2))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10324
              setBucketAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args10321}))))))))))
     2
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10321 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args10321 1))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10324
          setBucketAcl
          a
          b)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10321 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args10321 1))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10324
              setBucketAcl
              a
              b)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args10321}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-location
   [m10325]
   (clojure.core/let
    [credentials10326 (:credentials m10325) args10327 (:args m10325)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10328
      (com.palletops.awaze.common/aws-client :s3 credentials10326)]
     (clojure.core/case
      (clojure.core/count args10327)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10327 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10328
           getBucketLocation
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketLocationRequest
               (clojure.core/nth args10327 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10328
               getBucketLocation
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLocation")
                {:args args10327}))))))))))))))
  (clojure.core/defn
   get-bucket-location-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener bucket-name]}]]),
    :doc "Generate map for getBucketLocation, getBucketLocation"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-location,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-bucket-location
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener bucket-name]}]]),
    :doc "Call getBucketLocation, getBucketLocation"}
   [credentials10331 & args10332]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10334
     (com.palletops.awaze.common/aws-client :s3 credentials10331)]
    (clojure.core/case
     (clojure.core/count args10332)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10332 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10334
          getBucketLocation
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketLocationRequest
              (clojure.core/nth args10332 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10334
              getBucketLocation
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLocation")
               {:args args10332}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-notification-configuration
   [m10335]
   (clojure.core/let
    [credentials10336 (:credentials m10335) args10337 (:args m10335)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10338
      (com.palletops.awaze.common/aws-client :s3 credentials10336)]
     (clojure.core/case
      (clojure.core/count args10337)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10338
        setBucketNotificationConfiguration
        (clojure.core/str (clojure.core/nth args10337 0))
        (s3/bucket-notification-configuration
         (clojure.core/nth args10337 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10338
        setBucketNotificationConfiguration
        (s3/set-bucket-notification-configuration-request
         (clojure.core/nth args10337 0))))))))
  (clojure.core/defn
   set-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [topic-configurations]}]
                [credentials
                 {:keys [notification-configuration
                         general-progress-listener
                         bucket-notification-configuration
                         bucket-name
                         bucket]}]]),
    :doc "Generate map for setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-bucket-notification-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [topic-configurations]}]
                [credentials
                 {:keys [notification-configuration
                         general-progress-listener
                         bucket-notification-configuration
                         bucket-name
                         bucket]}]]),
    :doc "Call setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   [credentials10342 & args10343]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10346
     (com.palletops.awaze.common/aws-client :s3 credentials10342)]
    (clojure.core/case
     (clojure.core/count args10343)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10346
       setBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args10343 0))
       (s3/bucket-notification-configuration
        (clojure.core/nth args10343 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10346
       setBucketNotificationConfiguration
       (s3/set-bucket-notification-configuration-request
        (clojure.core/nth args10343 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object
   [m10347]
   (clojure.core/let
    [credentials10348 (:credentials m10347) args10349 (:args m10347)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10350
      (com.palletops.awaze.common/aws-client :s3 credentials10348)]
     (clojure.core/case
      (clojure.core/count args10349)
      2
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetObjectRequest
           (clojure.core/nth args10349 0))
^{:tag java.io.File}
b
          (com.palletops.awaze.common/coerce-value-form
           java.io.File
           (clojure.core/nth args10349 1))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10350
           getObject
           a
           b)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10349 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10349 1))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10350
               getObject
               a
               b)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getObject")
                {:args args10349}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10350
        getObject
        (s3/get-object-request (clojure.core/nth args10349 0))))))))
  (clojure.core/defn
   get-object-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints
                         ssecustomer-key
                         requester-pays]}
                 file-1]
                [credentials
                 {:keys [general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints
                         ssecustomer-key
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObject, getObject, getObject"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-object,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-object
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints
                         ssecustomer-key
                         requester-pays]}
                 file-1]
                [credentials
                 {:keys [general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints
                         ssecustomer-key
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Call getObject, getObject, getObject"}
   [credentials10356 & args10357]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10362
     (com.palletops.awaze.common/aws-client :s3 credentials10356)]
    (clojure.core/case
     (clojure.core/count args10357)
     2
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetObjectRequest
          (clojure.core/nth args10357 0))
^{:tag java.io.File}
b
         (com.palletops.awaze.common/coerce-value-form
          java.io.File
          (clojure.core/nth args10357 1))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10362
          getObject
          a
          b)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10357 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10357 1))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10362
              getObject
              a
              b)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getObject")
               {:args args10357}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10362
       getObject
       (s3/get-object-request (clojure.core/nth args10357 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-website-configuration
   [m10363]
   (clojure.core/let
    [credentials10364 (:credentials m10363) args10365 (:args m10363)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10366
      (com.palletops.awaze.common/aws-client :s3 credentials10364)]
     (clojure.core/case
      (clojure.core/count args10365)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10366
        setBucketWebsiteConfiguration
        (clojure.core/str (clojure.core/nth args10365 0))
        (s3/bucket-website-configuration
         (clojure.core/nth args10365 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10366
        setBucketWebsiteConfiguration
        (s3/set-bucket-website-configuration-request
         (clojure.core/nth args10365 0))))))))
  (clojure.core/defn
   set-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [routing-rules
                         redirect-all-requests-to
                         index-document-suffix
                         error-document]}]
                [credentials
                 {:keys [general-progress-listener
                         configuration
                         bucket-name]}]]),
    :doc "Generate map for setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-website-configuration,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-website-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [routing-rules
                         redirect-all-requests-to
                         index-document-suffix
                         error-document]}]
                [credentials
                 {:keys [general-progress-listener
                         configuration
                         bucket-name]}]]),
    :doc "Call setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   [credentials10370 & args10371]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10374
     (com.palletops.awaze.common/aws-client :s3 credentials10370)]
    (clojure.core/case
     (clojure.core/count args10371)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10374
       setBucketWebsiteConfiguration
       (clojure.core/str (clojure.core/nth args10371 0))
       (s3/bucket-website-configuration
        (clojure.core/nth args10371 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10374
       setBucketWebsiteConfiguration
       (s3/set-bucket-website-configuration-request
        (clojure.core/nth args10371 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-object
   [m10375]
   (clojure.core/let
    [credentials10376 (:credentials m10375) args10377 (:args m10375)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10378
      (com.palletops.awaze.common/aws-client :s3 credentials10376)]
     (clojure.core/case
      (clojure.core/count args10377)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10378
        copyObject
        (s3/copy-object-request (clojure.core/nth args10377 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10378
        copyObject
        (clojure.core/str (clojure.core/nth args10377 0))
        (clojure.core/str (clojure.core/nth args10377 1))
        (clojure.core/str (clojure.core/nth args10377 2))
        (clojure.core/str (clojure.core/nth args10377 3))))))))
  (clojure.core/defn
   copy-object-map
   {:arglists (quote
               [[credentials
                 {:keys [source-key
                         source-ssecustomer-key
                         general-progress-listener
                         source-bucket-name
                         canned-access-control-list
                         destination-ssecustomer-key
                         unmodified-since-constraint
                         access-control-list
                         modified-since-constraint
                         redirect-location
                         new-object-metadata
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id
                         storage-class]}]
                [credentials string-0 string-1 string-2 string-3]]),
    :doc "Generate map for copyObject, copyObject"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :copy-object,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :copy-object,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   copy-object
   {:arglists (quote
               [[credentials
                 {:keys [source-key
                         source-ssecustomer-key
                         general-progress-listener
                         source-bucket-name
                         canned-access-control-list
                         destination-ssecustomer-key
                         unmodified-since-constraint
                         access-control-list
                         modified-since-constraint
                         redirect-location
                         new-object-metadata
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id
                         storage-class]}]
                [credentials string-0 string-1 string-2 string-3]]),
    :doc "Call copyObject, copyObject"}
   [credentials10384 & args10385]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10390
     (com.palletops.awaze.common/aws-client :s3 credentials10384)]
    (clojure.core/case
     (clojure.core/count args10385)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10390
       copyObject
       (s3/copy-object-request (clojure.core/nth args10385 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10390
       copyObject
       (clojure.core/str (clojure.core/nth args10385 0))
       (clojure.core/str (clojure.core/nth args10385 1))
       (clojure.core/str (clojure.core/nth args10385 2))
       (clojure.core/str (clojure.core/nth args10385 3))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-cross-origin-configuration
   [m10391]
   (clojure.core/let
    [credentials10392 (:credentials m10391) args10393 (:args m10391)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10394
      (com.palletops.awaze.common/aws-client :s3 credentials10392)]
     (clojure.core/case
      (clojure.core/count args10393)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10394
        setBucketCrossOriginConfiguration
        (clojure.core/str (clojure.core/nth args10393 0))
        (s3/bucket-cross-origin-configuration
         (clojure.core/nth args10393 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10394
        setBucketCrossOriginConfiguration
        (s3/set-bucket-cross-origin-configuration-request
         (clojure.core/nth args10393 0))))))))
  (clojure.core/defn
   set-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [general-progress-listener
                         cross-origin-configuration
                         bucket-name]}]]),
    :doc "Generate map for setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [rules]}]
                [credentials
                 {:keys [general-progress-listener
                         cross-origin-configuration
                         bucket-name]}]]),
    :doc "Call setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   [credentials10398 & args10399]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10402
     (com.palletops.awaze.common/aws-client :s3 credentials10398)]
    (clojure.core/case
     (clojure.core/count args10399)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10402
       setBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args10399 0))
       (s3/bucket-cross-origin-configuration
        (clojure.core/nth args10399 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10402
       setBucketCrossOriginConfiguration
       (s3/set-bucket-cross-origin-configuration-request
        (clojure.core/nth args10399 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-bucket-exist
   [m10403]
   (clojure.core/let
    [credentials10404 (:credentials m10403) args10405 (:args m10403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10406
      (com.palletops.awaze.common/aws-client :s3 credentials10404)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10406
       doesBucketExist
       (clojure.core/str (clojure.core/nth args10405 0)))))))
  (clojure.core/defn
   does-bucket-exist-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for doesBucketExist"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :does-bucket-exist,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   does-bucket-exist
   {:arglists (quote [[credentials string-0]]),
    :doc "Call doesBucketExist"}
   [credentials10408 & args10409]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10410
     (com.palletops.awaze.common/aws-client :s3 credentials10408)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10410
      doesBucketExist
      (clojure.core/str (clojure.core/nth args10409 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :change-object-storage-class
   [m10411]
   (clojure.core/let
    [credentials10412 (:credentials m10411) args10413 (:args m10411)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10414
      (com.palletops.awaze.common/aws-client :s3 credentials10412)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10414
       changeObjectStorageClass
       (clojure.core/str (clojure.core/nth args10413 0))
       (clojure.core/str (clojure.core/nth args10413 1))
       (s3/storage-class (clojure.core/nth args10413 2)))))))
  (clojure.core/defn
   change-object-storage-class-map
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Generate map for changeObjectStorageClass"}
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :change-object-storage-class,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   change-object-storage-class
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Call changeObjectStorageClass"}
   [credentials10416 & args10417]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10418
     (com.palletops.awaze.common/aws-client :s3 credentials10416)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10418
      changeObjectStorageClass
      (clojure.core/str (clojure.core/nth args10417 0))
      (clojure.core/str (clojure.core/nth args10417 1))
      (s3/storage-class (clojure.core/nth args10417 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-tagging-configuration
   [m10419]
   (clojure.core/let
    [credentials10420 (:credentials m10419) args10421 (:args m10419)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10422
      (com.palletops.awaze.common/aws-client :s3 credentials10420)]
     (clojure.core/case
      (clojure.core/count args10421)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10422
        setBucketTaggingConfiguration
        (s3/set-bucket-tagging-configuration-request
         (clojure.core/nth args10421 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10422
        setBucketTaggingConfiguration
        (clojure.core/str (clojure.core/nth args10421 0))
        (s3/bucket-tagging-configuration
         (clojure.core/nth args10421 1))))))))
  (clojure.core/defn
   set-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [tagging-configuration
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 {:keys []}]]),
    :doc "Generate map for setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-bucket-tagging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [tagging-configuration
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 {:keys []}]]),
    :doc "Call setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   [credentials10426 & args10427]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10430
     (com.palletops.awaze.common/aws-client :s3 credentials10426)]
    (clojure.core/case
     (clojure.core/count args10427)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10430
       setBucketTaggingConfiguration
       (s3/set-bucket-tagging-configuration-request
        (clojure.core/nth args10427 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10430
       setBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args10427 0))
       (s3/bucket-tagging-configuration
        (clojure.core/nth args10427 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-s3client-options
   [m10431]
   (clojure.core/let
    [credentials10432 (:credentials m10431) args10433 (:args m10431)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10434
      (com.palletops.awaze.common/aws-client :s3 credentials10432)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10434
       setS3ClientOptions
       (s3/s3client-options (clojure.core/nth args10433 0)))))))
  (clojure.core/defn
   set-s3client-options-map
   {:arglists (quote [[credentials {:keys [path-style-access]}]]),
    :doc "Generate map for setS3ClientOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-s3client-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-s3client-options
   {:arglists (quote [[credentials {:keys [path-style-access]}]]),
    :doc "Call setS3ClientOptions"}
   [credentials10436 & args10437]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10438
     (com.palletops.awaze.common/aws-client :s3 credentials10436)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10438
      setS3ClientOptions
      (s3/s3client-options (clojure.core/nth args10437 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-lifecycle-configuration
   [m10439]
   (clojure.core/let
    [credentials10440 (:credentials m10439) args10441 (:args m10439)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10442
      (com.palletops.awaze.common/aws-client :s3 credentials10440)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10442
       getBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args10441 0)))))))
  (clojure.core/defn
   get-bucket-lifecycle-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketLifecycleConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-lifecycle-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-bucket-lifecycle-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketLifecycleConfiguration"}
   [credentials10444 & args10445]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10446
     (com.palletops.awaze.common/aws-client :s3 credentials10444)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10446
      getBucketLifecycleConfiguration
      (clojure.core/str (clojure.core/nth args10445 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-resource-url
   [m10447]
   (clojure.core/let
    [credentials10448 (:credentials m10447) args10449 (:args m10447)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10450
      (com.palletops.awaze.common/aws-client :s3 credentials10448)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10450
       getResourceUrl
       (clojure.core/str (clojure.core/nth args10449 0))
       (clojure.core/str (clojure.core/nth args10449 1)))))))
  (clojure.core/defn
   get-resource-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getResourceUrl"}
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-resource-url,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-resource-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getResourceUrl"}
   [credentials10452 & args10453]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10454
     (com.palletops.awaze.common/aws-client :s3 credentials10452)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10454
      getResourceUrl
      (clojure.core/str (clojure.core/nth args10453 0))
      (clojure.core/str (clojure.core/nth args10453 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-acl
   [m10455]
   (clojure.core/let
    [credentials10456 (:credentials m10455) args10457 (:args m10455)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10458
      (com.palletops.awaze.common/aws-client :s3 credentials10456)]
     (clojure.core/case
      (clojure.core/count args10457)
      3
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10457 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10457 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args10457 2))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10458
           setObjectAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10457 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10457 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args10457 2))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10458
               setObjectAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args10457}))))))))))
      4
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10457 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10457 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10457 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args10457 3))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10458
           setObjectAcl
           a
           b
           c
           d)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10457 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10457 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10457 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args10457 3))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10458
               setObjectAcl
               a
               b
               c
               d)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args10457}))))))))))
      5
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10457 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10457 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10457 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args10457 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args10457 4))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10458
           setObjectAcl
           a
           b
           c
           d
           e)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10457 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10457 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10457 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args10457 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args10457 4))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10458
               setObjectAcl
               a
               b
               c
               d
               e)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args10457}))))))))))))))
  (clojure.core/defn
   set-object-acl-map
   {:arglists (quote
               [[credentials string-0 string-1 {:keys [owner grants]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [owner grants]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [owner grants]}]]),
    :doc "Generate map for setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :set-object-acl,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :set-object-acl,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c d e]
    {:args [a b c d e],
     :client :s3,
     :fn :set-object-acl,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-object-acl
   {:arglists (quote
               [[credentials string-0 string-1 {:keys [owner grants]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [owner grants]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [owner grants]}]]),
    :doc "Call setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   [credentials10460 & args10461]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10462
     (com.palletops.awaze.common/aws-client :s3 credentials10460)]
    (clojure.core/case
     (clojure.core/count args10461)
     3
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10461 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10461 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args10461 2))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10462
          setObjectAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10461 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10461 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args10461 2))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10462
              setObjectAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args10461}))))))))))
     4
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10461 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10461 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10461 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args10461 3))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10462
          setObjectAcl
          a
          b
          c
          d)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10461 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10461 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10461 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args10461 3))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10462
              setObjectAcl
              a
              b
              c
              d)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args10461}))))))))))
     5
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10461 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10461 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10461 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args10461 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args10461 4))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10462
          setObjectAcl
          a
          b
          c
          d
          e)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10461 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10461 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10461 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args10461 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args10461 4))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10462
              setObjectAcl
              a
              b
              c
              d
              e)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args10461}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :restore-object
   [m10463]
   (clojure.core/let
    [credentials10464 (:credentials m10463) args10465 (:args m10463)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10466
      (com.palletops.awaze.common/aws-client :s3 credentials10464)]
     (clojure.core/case
      (clojure.core/count args10465)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10466
        restoreObject
        (s3/restore-object-request (clojure.core/nth args10465 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10466
        restoreObject
        (clojure.core/str (clojure.core/nth args10465 0))
        (clojure.core/str (clojure.core/nth args10465 1))
        (clojure.core/int (clojure.core/nth args10465 2))))))))
  (clojure.core/defn
   restore-object-map
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         key
                         general-progress-listener
                         expiration-in-days
                         bucket-name]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Generate map for restoreObject, restoreObject"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :restore-object,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :restore-object,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   restore-object
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         key
                         general-progress-listener
                         expiration-in-days
                         bucket-name]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Call restoreObject, restoreObject"}
   [credentials10470 & args10471]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10474
     (com.palletops.awaze.common/aws-client :s3 credentials10470)]
    (clojure.core/case
     (clojure.core/count args10471)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10474
       restoreObject
       (s3/restore-object-request (clojure.core/nth args10471 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10474
       restoreObject
       (clojure.core/str (clojure.core/nth args10471 0))
       (clojure.core/str (clojure.core/nth args10471 1))
       (clojure.core/int (clojure.core/nth args10471 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-url
   [m10475]
   (clojure.core/let
    [credentials10476 (:credentials m10475) args10477 (:args m10475)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10478
      (com.palletops.awaze.common/aws-client :s3 credentials10476)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10478
       getUrl
       (clojure.core/str (clojure.core/nth args10477 0))
       (clojure.core/str (clojure.core/nth args10477 1)))))))
  (clojure.core/defn
   get-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getUrl"}
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-url,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getUrl"}
   [credentials10480 & args10481]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10482
     (com.palletops.awaze.common/aws-client :s3 credentials10480)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10482
      getUrl
      (clojure.core/str (clojure.core/nth args10481 0))
      (clojure.core/str (clojure.core/nth args10481 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-version
   [m10483]
   (clojure.core/let
    [credentials10484 (:credentials m10483) args10485 (:args m10483)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10486
      (com.palletops.awaze.common/aws-client :s3 credentials10484)]
     (clojure.core/case
      (clojure.core/count args10485)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10486
        deleteVersion
        (s3/delete-version-request (clojure.core/nth args10485 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10486
        deleteVersion
        (clojure.core/str (clojure.core/nth args10485 0))
        (clojure.core/str (clojure.core/nth args10485 1))
        (clojure.core/str (clojure.core/nth args10485 2))))))))
  (clojure.core/defn
   delete-version-map
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         mfa
                         key
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for deleteVersion, deleteVersion"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-version,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :delete-version,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-version
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         mfa
                         key
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call deleteVersion, deleteVersion"}
   [credentials10491 & args10492]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10496
     (com.palletops.awaze.common/aws-client :s3 credentials10491)]
    (clojure.core/case
     (clojure.core/count args10492)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10496
       deleteVersion
       (s3/delete-version-request (clojure.core/nth args10492 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10496
       deleteVersion
       (clojure.core/str (clojure.core/nth args10492 0))
       (clojure.core/str (clojure.core/nth args10492 1))
       (clojure.core/str (clojure.core/nth args10492 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-versioning-configuration
   [m10497]
   (clojure.core/let
    [credentials10498 (:credentials m10497) args10499 (:args m10497)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10500
      (com.palletops.awaze.common/aws-client :s3 credentials10498)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10500
       setBucketVersioningConfiguration
       (s3/set-bucket-versioning-configuration-request
        (clojure.core/nth args10499 0)))))))
  (clojure.core/defn
   set-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [versioning-configuration
                         mfa
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Generate map for setBucketVersioningConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-versioning-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-bucket-versioning-configuration
   {:arglists (quote
               [[credentials
                 {:keys [versioning-configuration
                         mfa
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Call setBucketVersioningConfiguration"}
   [credentials10504 & args10505]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10508
     (com.palletops.awaze.common/aws-client :s3 credentials10504)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10508
      setBucketVersioningConfiguration
      (s3/set-bucket-versioning-configuration-request
       (clojure.core/nth args10505 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-cross-origin-configuration
   [m10509]
   (clojure.core/let
    [credentials10510 (:credentials m10509) args10511 (:args m10509)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10512
      (com.palletops.awaze.common/aws-client :s3 credentials10510)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10512
       getBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args10511 0)))))))
  (clojure.core/defn
   get-bucket-cross-origin-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketCrossOriginConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-cross-origin-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-bucket-cross-origin-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketCrossOriginConfiguration"}
   [credentials10514 & args10515]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10516
     (com.palletops.awaze.common/aws-client :s3 credentials10514)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10516
      getBucketCrossOriginConfiguration
      (clojure.core/str (clojure.core/nth args10515 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :create-bucket
   [m10517]
   (clojure.core/let
    [credentials10518 (:credentials m10517) args10519 (:args m10517)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10520
      (com.palletops.awaze.common/aws-client :s3 credentials10518)]
     (clojure.core/case
      (clojure.core/count args10519)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10519 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10520
           createBucket
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CreateBucketRequest
               (clojure.core/nth args10519 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10520
               createBucket
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args10519}))))))))))
      2
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10519 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.Region
           (clojure.core/nth args10519 1))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10520
           createBucket
           a
           b)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10519 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10519 1))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10520
               createBucket
               a
               b)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args10519}))))))))))))))
  (clojure.core/defn
   create-bucket-map
   {:arglists (quote
               [[credentials string-0]
                [credentials string-0 region-1]
                [credentials string-0 string-1]
                [credentials
                 {:keys [region
                         general-progress-listener
                         canned-acl
                         bucket-name
                         access-control-list]}]]),
    :doc "Generate map for createBucket, createBucket, createBucket, createBucket"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :create-bucket,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :create-bucket,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-bucket
   {:arglists (quote
               [[credentials string-0]
                [credentials string-0 region-1]
                [credentials string-0 string-1]
                [credentials
                 {:keys [region
                         general-progress-listener
                         canned-acl
                         bucket-name
                         access-control-list]}]]),
    :doc "Call createBucket, createBucket, createBucket, createBucket"}
   [credentials10523 & args10524]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10526
     (com.palletops.awaze.common/aws-client :s3 credentials10523)]
    (clojure.core/case
     (clojure.core/count args10524)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10524 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10526
          createBucket
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CreateBucketRequest
              (clojure.core/nth args10524 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10526
              createBucket
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args10524}))))))))))
     2
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10524 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.Region
          (clojure.core/nth args10524 1))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10526
          createBucket
          a
          b)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10524 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10524 1))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10526
              createBucket
              a
              b)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args10524}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-objects
   [m10527]
   (clojure.core/let
    [credentials10528 (:credentials m10527) args10529 (:args m10527)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10530
      (com.palletops.awaze.common/aws-client :s3 credentials10528)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10530
       listNextBatchOfObjects
       (s3/object-listing (clojure.core/nth args10529 0)))))))
  (clojure.core/defn
   list-next-batch-of-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [prefix
                         object-summaries
                         bucket-name
                         common-prefixes
                         max-keys
                         truncated
                         next-marker
                         delimiter
                         marker
                         encoding-type]}]]),
    :doc "Generate map for listNextBatchOfObjects"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-next-batch-of-objects,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-next-batch-of-objects
   {:arglists (quote
               [[credentials
                 {:keys [prefix
                         object-summaries
                         bucket-name
                         common-prefixes
                         max-keys
                         truncated
                         next-marker
                         delimiter
                         marker
                         encoding-type]}]]),
    :doc "Call listNextBatchOfObjects"}
   [credentials10532 & args10533]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10534
     (com.palletops.awaze.common/aws-client :s3 credentials10532)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10534
      listNextBatchOfObjects
      (s3/object-listing (clojure.core/nth args10533 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :put-object
   [m10535]
   (clojure.core/let
    [credentials10536 (:credentials m10535) args10537 (:args m10535)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10538
      (com.palletops.awaze.common/aws-client :s3 credentials10536)]
     (clojure.core/case
      (clojure.core/count args10537)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10538
        putObject
        (s3/put-object-request (clojure.core/nth args10537 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10538
        putObject
        (clojure.core/str (clojure.core/nth args10537 0))
        (clojure.core/str (clojure.core/nth args10537 1))
        (clojure.java.io/input-stream (clojure.core/nth args10537 2))
        (s3/object-metadata (clojure.core/nth args10537 3))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10538
        putObject
        (clojure.core/str (clojure.core/nth args10537 0))
        (clojure.core/str (clojure.core/nth args10537 1))
        (clojure.java.io/file (clojure.core/nth args10537 2))))))))
  (clojure.core/defn
   put-object-map
   {:arglists (quote
               [[credentials
                 {:keys [metadata
                         general-progress-listener
                         canned-acl
                         key
                         bucket-name
                         input-stream
                         access-control-list
                         progress-listener
                         redirect-location
                         ssecustomer-key
                         storage-class
                         file]}]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [expiration-time
                         content-md5
                         server-side-encryption
                         etag
                         cache-control
                         ssealgorithm
                         raw-metadata
                         content-disposition
                         content-type
                         ongoing-restore
                         version-id
                         restore-expiration-time
                         expiration-time-rule-id
                         content-length
                         instance-length
                         ssecustomer-algorithm
                         http-expires-date
                         last-modified
                         ssecustomer-key-md5
                         user-metadata
                         content-encoding]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Generate map for putObject, putObject, putObject"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :put-object,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :put-object,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :put-object,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   put-object
   {:arglists (quote
               [[credentials
                 {:keys [metadata
                         general-progress-listener
                         canned-acl
                         key
                         bucket-name
                         input-stream
                         access-control-list
                         progress-listener
                         redirect-location
                         ssecustomer-key
                         storage-class
                         file]}]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [expiration-time
                         content-md5
                         server-side-encryption
                         etag
                         cache-control
                         ssealgorithm
                         raw-metadata
                         content-disposition
                         content-type
                         ongoing-restore
                         version-id
                         restore-expiration-time
                         expiration-time-rule-id
                         content-length
                         instance-length
                         ssecustomer-algorithm
                         http-expires-date
                         last-modified
                         ssecustomer-key-md5
                         user-metadata
                         content-encoding]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Call putObject, putObject, putObject"}
   [credentials10543 & args10544]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10548
     (com.palletops.awaze.common/aws-client :s3 credentials10543)]
    (clojure.core/case
     (clojure.core/count args10544)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10548
       putObject
       (s3/put-object-request (clojure.core/nth args10544 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10548
       putObject
       (clojure.core/str (clojure.core/nth args10544 0))
       (clojure.core/str (clojure.core/nth args10544 1))
       (clojure.java.io/input-stream (clojure.core/nth args10544 2))
       (s3/object-metadata (clojure.core/nth args10544 3))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10548
       putObject
       (clojure.core/str (clojure.core/nth args10544 0))
       (clojure.core/str (clojure.core/nth args10544 1))
       (clojure.java.io/file (clojure.core/nth args10544 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-policy
   [m10549]
   (clojure.core/let
    [credentials10550 (:credentials m10549) args10551 (:args m10549)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10552
      (com.palletops.awaze.common/aws-client :s3 credentials10550)]
     (clojure.core/case
      (clojure.core/count args10551)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10551 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10552
           getBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketPolicyRequest
               (clojure.core/nth args10551 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10552
               getBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketPolicy")
                {:args args10551}))))))))))))))
  (clojure.core/defn
   get-bucket-policy-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener bucket-name]}]]),
    :doc "Generate map for getBucketPolicy, getBucketPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-bucket-policy
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener bucket-name]}]]),
    :doc "Call getBucketPolicy, getBucketPolicy"}
   [credentials10555 & args10556]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10558
     (com.palletops.awaze.common/aws-client :s3 credentials10555)]
    (clojure.core/case
     (clojure.core/count args10556)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10556 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10558
          getBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketPolicyRequest
              (clojure.core/nth args10556 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10558
              getBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketPolicy")
               {:args args10556}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-objects
   [m10559]
   (clojure.core/let
    [credentials10560 (:credentials m10559) args10561 (:args m10559)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10562
      (com.palletops.awaze.common/aws-client :s3 credentials10560)]
     (clojure.core/case
      (clojure.core/count args10561)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.ListObjectsRequest
           (clojure.core/nth args10561 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10562
           listObjects
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10561 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10562
               listObjects
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listObjects")
                {:args args10561}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10562
        listObjects
        (clojure.core/str (clojure.core/nth args10561 0))
        (clojure.core/str (clojure.core/nth args10561 1))))))))
  (clojure.core/defn
   list-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         prefix
                         bucket-name
                         max-keys
                         delimiter
                         marker
                         encoding-type]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Generate map for listObjects, listObjects, listObjects"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-objects,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :list-objects,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-objects
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         prefix
                         bucket-name
                         max-keys
                         delimiter
                         marker
                         encoding-type]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Call listObjects, listObjects, listObjects"}
   [credentials10564 & args10565]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10566
     (com.palletops.awaze.common/aws-client :s3 credentials10564)]
    (clojure.core/case
     (clojure.core/count args10565)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.ListObjectsRequest
          (clojure.core/nth args10565 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10566
          listObjects
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10565 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10566
              listObjects
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listObjects")
               {:args args10565}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10566
       listObjects
       (clojure.core/str (clojure.core/nth args10565 0))
       (clojure.core/str (clojure.core/nth args10565 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-region
   [m10567]
   (clojure.core/let
    [credentials10568 (:credentials m10567) args10569 (:args m10567)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10570
      (com.palletops.awaze.common/aws-client :s3 credentials10568)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10570
       setRegion
       (regions/region (clojure.core/nth args10569 0)))))))
  (clojure.core/defn
   set-region-map
   {:arglists (quote [[credentials region-0]]),
    :doc "Generate map for setRegion"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-region,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-region
   {:arglists (quote [[credentials region-0]]), :doc "Call setRegion"}
   [credentials10572 & args10573]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10574
     (com.palletops.awaze.common/aws-client :s3 credentials10572)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10574
      setRegion
      (regions/region (clojure.core/nth args10573 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :abort-multipart-upload
   [m10575]
   (clojure.core/let
    [credentials10576 (:credentials m10575) args10577 (:args m10575)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10578
      (com.palletops.awaze.common/aws-client :s3 credentials10576)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10578
       abortMultipartUpload
       (s3/abort-multipart-upload-request
        (clojure.core/nth args10577 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         key
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :abort-multipart-upload,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         key
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials10583 & args10584]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10588
     (com.palletops.awaze.common/aws-client :s3 credentials10583)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10588
      abortMultipartUpload
      (s3/abort-multipart-upload-request
       (clojure.core/nth args10584 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :upload-part
   [m10589]
   (clojure.core/let
    [credentials10590 (:credentials m10589) args10591 (:args m10589)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10592
      (com.palletops.awaze.common/aws-client :s3 credentials10590)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10592
       uploadPart
       (s3/upload-part-request (clojure.core/nth args10591 0)))))))
  (clojure.core/defn
   upload-part-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         md5digest
                         key
                         bucket-name
                         part-number
                         input-stream
                         upload-id
                         progress-listener
                         file-offset
                         last-part
                         ssecustomer-key
                         file
                         part-size]}]]),
    :doc "Generate map for uploadPart"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :upload-part,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   upload-part
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         md5digest
                         key
                         bucket-name
                         part-number
                         input-stream
                         upload-id
                         progress-listener
                         file-offset
                         last-part
                         ssecustomer-key
                         file
                         part-size]}]]),
    :doc "Call uploadPart"}
   [credentials10594 & args10595]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10596
     (com.palletops.awaze.common/aws-client :s3 credentials10594)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10596
      uploadPart
      (s3/upload-part-request (clojure.core/nth args10595 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :disable-requester-pays
   [m10597]
   (clojure.core/let
    [credentials10598 (:credentials m10597) args10599 (:args m10597)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10600
      (com.palletops.awaze.common/aws-client :s3 credentials10598)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10600
       disableRequesterPays
       (clojure.core/str (clojure.core/nth args10599 0)))))))
  (clojure.core/defn
   disable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for disableRequesterPays"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :disable-requester-pays,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   disable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call disableRequesterPays"}
   [credentials10602 & args10603]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10604
     (com.palletops.awaze.common/aws-client :s3 credentials10602)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10604
      disableRequesterPays
      (clojure.core/str (clojure.core/nth args10603 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :complete-multipart-upload
   [m10605]
   (clojure.core/let
    [credentials10606 (:credentials m10605) args10607 (:args m10605)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10608
      (com.palletops.awaze.common/aws-client :s3 credentials10606)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10608
       completeMultipartUpload
       (s3/complete-multipart-upload-request
        (clojure.core/nth args10607 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         part-etags
                         key
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :complete-multipart-upload,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         part-etags
                         key
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials10614 & args10615]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10620
     (com.palletops.awaze.common/aws-client :s3 credentials10614)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10620
      completeMultipartUpload
      (s3/complete-multipart-upload-request
       (clojure.core/nth args10615 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :list-versions
   [m10621]
   (clojure.core/let
    [credentials10622 (:credentials m10621) args10623 (:args m10621)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10624
      (com.palletops.awaze.common/aws-client :s3 credentials10622)]
     (clojure.core/case
      (clojure.core/count args10623)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10624
        listVersions
        (s3/list-versions-request (clojure.core/nth args10623 0))))
      6
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10624
        listVersions
        (clojure.core/str (clojure.core/nth args10623 0))
        (clojure.core/str (clojure.core/nth args10623 1))
        (clojure.core/str (clojure.core/nth args10623 2))
        (clojure.core/str (clojure.core/nth args10623 3))
        (clojure.core/str (clojure.core/nth args10623 4))
        (clojure.core/int (clojure.core/nth args10623 5))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10624
        listVersions
        (clojure.core/str (clojure.core/nth args10623 0))
        (clojure.core/str (clojure.core/nth args10623 1))))))))
  (clojure.core/defn
   list-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         prefix
                         max-results
                         bucket-name
                         key-marker
                         delimiter
                         version-id-marker
                         encoding-type]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]
                [credentials string-0 string-1]]),
    :doc "Generate map for listVersions, listVersions, listVersions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c d e f]
    {:args [a b c d e f],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-versions
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         prefix
                         max-results
                         bucket-name
                         key-marker
                         delimiter
                         version-id-marker
                         encoding-type]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]
                [credentials string-0 string-1]]),
    :doc "Call listVersions, listVersions, listVersions"}
   [credentials10626 & args10627]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10628
     (com.palletops.awaze.common/aws-client :s3 credentials10626)]
    (clojure.core/case
     (clojure.core/count args10627)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10628
       listVersions
       (s3/list-versions-request (clojure.core/nth args10627 0))))
     6
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10628
       listVersions
       (clojure.core/str (clojure.core/nth args10627 0))
       (clojure.core/str (clojure.core/nth args10627 1))
       (clojure.core/str (clojure.core/nth args10627 2))
       (clojure.core/str (clojure.core/nth args10627 3))
       (clojure.core/str (clojure.core/nth args10627 4))
       (clojure.core/int (clojure.core/nth args10627 5))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10628
       listVersions
       (clojure.core/str (clojure.core/nth args10627 0))
       (clojure.core/str (clojure.core/nth args10627 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-redirect-location
   [m10629]
   (clojure.core/let
    [credentials10630 (:credentials m10629) args10631 (:args m10629)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10632
      (com.palletops.awaze.common/aws-client :s3 credentials10630)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10632
       setObjectRedirectLocation
       (clojure.core/str (clojure.core/nth args10631 0))
       (clojure.core/str (clojure.core/nth args10631 1))
       (clojure.core/str (clojure.core/nth args10631 2)))))))
  (clojure.core/defn
   set-object-redirect-location-map
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Generate map for setObjectRedirectLocation"}
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :set-object-redirect-location,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-object-redirect-location
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Call setObjectRedirectLocation"}
   [credentials10634 & args10635]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10636
     (com.palletops.awaze.common/aws-client :s3 credentials10634)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10636
      setObjectRedirectLocation
      (clojure.core/str (clojure.core/nth args10635 0))
      (clojure.core/str (clojure.core/nth args10635 1))
      (clojure.core/str (clojure.core/nth args10635 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-website-configuration
   [m10637]
   (clojure.core/let
    [credentials10638 (:credentials m10637) args10639 (:args m10637)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10640
      (com.palletops.awaze.common/aws-client :s3 credentials10638)]
     (clojure.core/case
      (clojure.core/count args10639)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
           (clojure.core/nth args10639 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10640
           deleteBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10639 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10640
               deleteBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketWebsiteConfiguration")
                {:args args10639}))))))))))))))
  (clojure.core/defn
   delete-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-website-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   [credentials10643 & args10644]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10646
     (com.palletops.awaze.common/aws-client :s3 credentials10643)]
    (clojure.core/case
     (clojure.core/count args10644)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
          (clojure.core/nth args10644 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10646
          deleteBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10644 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10646
              deleteBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketWebsiteConfiguration")
               {:args args10644}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-multipart-uploads
   [m10647]
   (clojure.core/let
    [credentials10648 (:credentials m10647) args10649 (:args m10647)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10650
      (com.palletops.awaze.common/aws-client :s3 credentials10648)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10650
       listMultipartUploads
       (s3/list-multipart-uploads-request
        (clojure.core/nth args10649 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [max-uploads
                         general-progress-listener
                         prefix
                         upload-id-marker
                         bucket-name
                         key-marker
                         delimiter
                         encoding-type]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-multipart-uploads,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [max-uploads
                         general-progress-listener
                         prefix
                         upload-id-marker
                         bucket-name
                         key-marker
                         delimiter
                         encoding-type]}]]),
    :doc "Call listMultipartUploads"}
   [credentials10653 & args10654]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10656
     (com.palletops.awaze.common/aws-client :s3 credentials10653)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10656
      listMultipartUploads
      (s3/list-multipart-uploads-request
       (clojure.core/nth args10654 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-lifecycle-configuration
   [m10657]
   (clojure.core/let
    [credentials10658 (:credentials m10657) args10659 (:args m10657)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10660
      (com.palletops.awaze.common/aws-client :s3 credentials10658)]
     (clojure.core/case
      (clojure.core/count args10659)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10660
        setBucketLifecycleConfiguration
        (s3/set-bucket-lifecycle-configuration-request
         (clojure.core/nth args10659 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10660
        setBucketLifecycleConfiguration
        (clojure.core/str (clojure.core/nth args10659 0))
        (s3/bucket-lifecycle-configuration
         (clojure.core/nth args10659 1))))))))
  (clojure.core/defn
   set-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-configuration
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Generate map for setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [lifecycle-configuration
                         general-progress-listener
                         bucket-name]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Call setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   [credentials10664 & args10665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10668
     (com.palletops.awaze.common/aws-client :s3 credentials10664)]
    (clojure.core/case
     (clojure.core/count args10665)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10668
       setBucketLifecycleConfiguration
       (s3/set-bucket-lifecycle-configuration-request
        (clojure.core/nth args10665 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10668
       setBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args10665 0))
       (s3/bucket-lifecycle-configuration
        (clojure.core/nth args10665 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :enable-requester-pays
   [m10669]
   (clojure.core/let
    [credentials10670 (:credentials m10669) args10671 (:args m10669)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10672
      (com.palletops.awaze.common/aws-client :s3 credentials10670)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10672
       enableRequesterPays
       (clojure.core/str (clojure.core/nth args10671 0)))))))
  (clojure.core/defn
   enable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for enableRequesterPays"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :enable-requester-pays,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   enable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call enableRequesterPays"}
   [credentials10674 & args10675]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10676
     (com.palletops.awaze.common/aws-client :s3 credentials10674)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10676
      enableRequesterPays
      (clojure.core/str (clojure.core/nth args10675 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-metadata
   [m10677]
   (clojure.core/let
    [credentials10678 (:credentials m10677) args10679 (:args m10677)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10680
      (com.palletops.awaze.common/aws-client :s3 credentials10678)]
     (clojure.core/case
      (clojure.core/count args10679)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10680
        getObjectMetadata
        (clojure.core/str (clojure.core/nth args10679 0))
        (clojure.core/str (clojure.core/nth args10679 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10680
        getObjectMetadata
        (s3/get-object-metadata-request
         (clojure.core/nth args10679 0))))))))
  (clojure.core/defn
   get-object-metadata-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [version-id
                         key
                         general-progress-listener
                         bucket-name
                         ssecustomer-key]}]]),
    :doc "Generate map for getObjectMetadata, getObjectMetadata"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-object-metadata,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object-metadata,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-object-metadata
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [version-id
                         key
                         general-progress-listener
                         bucket-name
                         ssecustomer-key]}]]),
    :doc "Call getObjectMetadata, getObjectMetadata"}
   [credentials10684 & args10685]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10688
     (com.palletops.awaze.common/aws-client :s3 credentials10684)]
    (clojure.core/case
     (clojure.core/count args10685)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10688
       getObjectMetadata
       (clojure.core/str (clojure.core/nth args10685 0))
       (clojure.core/str (clojure.core/nth args10685 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10688
       getObjectMetadata
       (s3/get-object-metadata-request (clojure.core/nth args10685 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-cross-origin-configuration
   [m10689]
   (clojure.core/let
    [credentials10690 (:credentials m10689) args10691 (:args m10689)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10692
      (com.palletops.awaze.common/aws-client :s3 credentials10690)]
     (clojure.core/case
      (clojure.core/count args10691)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
           (clojure.core/nth args10691 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10692
           deleteBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10691 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10692
               deleteBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketCrossOriginConfiguration")
                {:args args10691}))))))))))))))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-cross-origin-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   [credentials10695 & args10696]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10698
     (com.palletops.awaze.common/aws-client :s3 credentials10695)]
    (clojure.core/case
     (clojure.core/count args10696)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
          (clojure.core/nth args10696 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10698
          deleteBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10696 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10698
              deleteBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketCrossOriginConfiguration")
               {:args args10696}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-tagging-configuration
   [m10699]
   (clojure.core/let
    [credentials10700 (:credentials m10699) args10701 (:args m10699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10702
      (com.palletops.awaze.common/aws-client :s3 credentials10700)]
     (clojure.core/case
      (clojure.core/count args10701)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
           (clojure.core/nth args10701 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10702
           deleteBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10701 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10702
               deleteBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketTaggingConfiguration")
                {:args args10701}))))))))))))))
  (clojure.core/defn
   delete-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-tagging-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-bucket-tagging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   [credentials10705 & args10706]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10708
     (com.palletops.awaze.common/aws-client :s3 credentials10705)]
    (clojure.core/case
     (clojure.core/count args10706)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
          (clojure.core/nth args10706 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10708
          deleteBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10706 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10708
              deleteBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketTaggingConfiguration")
               {:args args10706}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-acl
   [m10709]
   (clojure.core/let
    [credentials10710 (:credentials m10709) args10711 (:args m10709)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10712
      (com.palletops.awaze.common/aws-client :s3 credentials10710)]
     (clojure.core/case
      (clojure.core/count args10711)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10712
        getObjectAcl
        (clojure.core/str (clojure.core/nth args10711 0))
        (clojure.core/str (clojure.core/nth args10711 1))
        (clojure.core/str (clojure.core/nth args10711 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10712
        getObjectAcl
        (clojure.core/str (clojure.core/nth args10711 0))
        (clojure.core/str (clojure.core/nth args10711 1))))))))
  (clojure.core/defn
   get-object-acl-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObjectAcl, getObjectAcl"}
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object-acl,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :get-object-acl,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-object-acl
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Call getObjectAcl, getObjectAcl"}
   [credentials10714 & args10715]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10716
     (com.palletops.awaze.common/aws-client :s3 credentials10714)]
    (clojure.core/case
     (clojure.core/count args10715)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10716
       getObjectAcl
       (clojure.core/str (clojure.core/nth args10715 0))
       (clojure.core/str (clojure.core/nth args10715 1))
       (clojure.core/str (clojure.core/nth args10715 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10716
       getObjectAcl
       (clojure.core/str (clojure.core/nth args10715 0))
       (clojure.core/str (clojure.core/nth args10715 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-policy
   [m10717]
   (clojure.core/let
    [credentials10718 (:credentials m10717) args10719 (:args m10717)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10720
      (com.palletops.awaze.common/aws-client :s3 credentials10718)]
     (clojure.core/case
      (clojure.core/count args10719)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
           (clojure.core/nth args10719 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10720
           deleteBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10719 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10720
               deleteBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketPolicy")
                {:args args10719}))))))))))))))
  (clojure.core/defn
   delete-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketPolicy, deleteBucketPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Call deleteBucketPolicy, deleteBucketPolicy"}
   [credentials10723 & args10724]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10726
     (com.palletops.awaze.common/aws-client :s3 credentials10723)]
    (clojure.core/case
     (clojure.core/count args10724)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
          (clojure.core/nth args10724 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10726
          deleteBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10724 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10726
              deleteBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketPolicy")
               {:args args10724}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-tagging-configuration
   [m10727]
   (clojure.core/let
    [credentials10728 (:credentials m10727) args10729 (:args m10727)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10730
      (com.palletops.awaze.common/aws-client :s3 credentials10728)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10730
       getBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args10729 0)))))))
  (clojure.core/defn
   get-bucket-tagging-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketTaggingConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-tagging-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-bucket-tagging-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketTaggingConfiguration"}
   [credentials10732 & args10733]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10734
     (com.palletops.awaze.common/aws-client :s3 credentials10732)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10734
      getBucketTaggingConfiguration
      (clojure.core/str (clojure.core/nth args10733 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-website-configuration
   [m10735]
   (clojure.core/let
    [credentials10736 (:credentials m10735) args10737 (:args m10735)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10738
      (com.palletops.awaze.common/aws-client :s3 credentials10736)]
     (clojure.core/case
      (clojure.core/count args10737)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
           (clojure.core/nth args10737 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10738
           getBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10737 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10738
               getBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketWebsiteConfiguration")
                {:args args10737}))))))))))))))
  (clojure.core/defn
   get-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-website-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Call getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   [credentials10741 & args10742]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10744
     (com.palletops.awaze.common/aws-client :s3 credentials10741)]
    (clojure.core/case
     (clojure.core/count args10742)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
          (clojure.core/nth args10742 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10744
          getBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10742 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10744
              getBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketWebsiteConfiguration")
               {:args args10742}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-lifecycle-configuration
   [m10745]
   (clojure.core/let
    [credentials10746 (:credentials m10745) args10747 (:args m10745)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10748
      (com.palletops.awaze.common/aws-client :s3 credentials10746)]
     (clojure.core/case
      (clojure.core/count args10747)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
           (clojure.core/nth args10747 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10748
           deleteBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10747 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10748
               deleteBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketLifecycleConfiguration")
                {:args args10747}))))))))))))))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-lifecycle-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   [credentials10751 & args10752]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10754
     (com.palletops.awaze.common/aws-client :s3 credentials10751)]
    (clojure.core/case
     (clojure.core/count args10752)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
          (clojure.core/nth args10752 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10754
          deleteBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10752 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10754
              deleteBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketLifecycleConfiguration")
               {:args args10752}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket
   [m10755]
   (clojure.core/let
    [credentials10756 (:credentials m10755) args10757 (:args m10755)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10758
      (com.palletops.awaze.common/aws-client :s3 credentials10756)]
     (clojure.core/case
      (clojure.core/count args10757)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args10757 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10758
           deleteBucket
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketRequest
               (clojure.core/nth args10757 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10758
               deleteBucket
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucket")
                {:args args10757}))))))))))))))
  (clojure.core/defn
   delete-bucket-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener bucket-name]}]]),
    :doc "Generate map for deleteBucket, deleteBucket"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-bucket
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [general-progress-listener bucket-name]}]]),
    :doc "Call deleteBucket, deleteBucket"}
   [credentials10761 & args10762]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10764
     (com.palletops.awaze.common/aws-client :s3 credentials10761)]
    (clojure.core/case
     (clojure.core/count args10762)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args10762 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10764
          deleteBucket
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketRequest
              (clojure.core/nth args10762 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10764
              deleteBucket
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucket")
               {:args args10762}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-object
   [m10765]
   (clojure.core/let
    [credentials10766 (:credentials m10765) args10767 (:args m10765)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10768
      (com.palletops.awaze.common/aws-client :s3 credentials10766)]
     (clojure.core/case
      (clojure.core/count args10767)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10768
        deleteObject
        (clojure.core/str (clojure.core/nth args10767 0))
        (clojure.core/str (clojure.core/nth args10767 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10768
        deleteObject
        (s3/delete-object-request (clojure.core/nth args10767 0))))))))
  (clojure.core/defn
   delete-object-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [key general-progress-listener bucket-name]}]]),
    :doc "Generate map for deleteObject, deleteObject"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-object,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :delete-object,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-object
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [key general-progress-listener bucket-name]}]]),
    :doc "Call deleteObject, deleteObject"}
   [credentials10772 & args10773]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10776
     (com.palletops.awaze.common/aws-client :s3 credentials10772)]
    (clojure.core/case
     (clojure.core/count args10773)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10776
       deleteObject
       (clojure.core/str (clojure.core/nth args10773 0))
       (clojure.core/str (clojure.core/nth args10773 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10776
       deleteObject
       (s3/delete-object-request (clojure.core/nth args10773 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-region
   [m10777]
   (clojure.core/let
    [credentials10778 (:credentials m10777) args10779 (:args m10777)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10780
      (com.palletops.awaze.common/aws-client :s3 credentials10778)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10780
       getRegion)))))
  (clojure.core/defn
   get-region-map
   {:arglists (quote [[credentials]]),
    :doc "Generate map for getRegion"}
   ([credentials__1649__auto__]
    {:args [],
     :client :s3,
     :fn :get-region,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-region
   {:arglists (quote [[credentials]]), :doc "Call getRegion"}
   [credentials10782 & args10783]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10784
     (com.palletops.awaze.common/aws-client :s3 credentials10782)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10784
      getRegion)))))
 (do
  (clojure.core/defmethod
   s3
   :copy-part
   [m10785]
   (clojure.core/let
    [credentials10786 (:credentials m10785) args10787 (:args m10785)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10788
      (com.palletops.awaze.common/aws-client :s3 credentials10786)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10788
       copyPart
       (s3/copy-part-request (clojure.core/nth args10787 0)))))))
  (clojure.core/defn
   copy-part-map
   {:arglists (quote
               [[credentials
                 {:keys [source-key
                         source-ssecustomer-key
                         general-progress-listener
                         source-bucket-name
                         last-byte
                         destination-ssecustomer-key
                         part-number
                         unmodified-since-constraint
                         upload-id
                         modified-since-constraint
                         first-byte
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id]}]]),
    :doc "Generate map for copyPart"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :copy-part,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   copy-part
   {:arglists (quote
               [[credentials
                 {:keys [source-key
                         source-ssecustomer-key
                         general-progress-listener
                         source-bucket-name
                         last-byte
                         destination-ssecustomer-key
                         part-number
                         unmodified-since-constraint
                         upload-id
                         modified-since-constraint
                         first-byte
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id]}]]),
    :doc "Call copyPart"}
   [credentials10790 & args10791]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10792
     (com.palletops.awaze.common/aws-client :s3 credentials10790)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10792
      copyPart
      (s3/copy-part-request (clojure.core/nth args10791 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :initiate-multipart-upload
   [m10793]
   (clojure.core/let
    [credentials10794 (:credentials m10793) args10795 (:args m10793)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10796
      (com.palletops.awaze.common/aws-client :s3 credentials10794)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10796
       initiateMultipartUpload
       (s3/initiate-multipart-upload-request
        (clojure.core/nth args10795 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         canned-acl
                         key
                         bucket-name
                         access-control-list
                         redirect-location
                         ssecustomer-key
                         storage-class
                         object-metadata]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :initiate-multipart-upload,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         canned-acl
                         key
                         bucket-name
                         access-control-list
                         redirect-location
                         ssecustomer-key
                         storage-class
                         object-metadata]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials10800 & args10801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10804
     (com.palletops.awaze.common/aws-client :s3 credentials10800)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10804
      initiateMultipartUpload
      (s3/initiate-multipart-upload-request
       (clojure.core/nth args10801 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-policy
   [m10805]
   (clojure.core/let
    [credentials10806 (:credentials m10805) args10807 (:args m10805)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10808
      (com.palletops.awaze.common/aws-client :s3 credentials10806)]
     (clojure.core/case
      (clojure.core/count args10807)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10808
        setBucketPolicy
        (clojure.core/str (clojure.core/nth args10807 0))
        (clojure.core/str (clojure.core/nth args10807 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10808
        setBucketPolicy
        (s3/set-bucket-policy-request (clojure.core/nth args10807 0))))))))
  (clojure.core/defn
   set-bucket-policy-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [policy-text
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Generate map for setBucketPolicy, setBucketPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-policy,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-bucket-policy
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [policy-text
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Call setBucketPolicy, setBucketPolicy"}
   [credentials10812 & args10813]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10816
     (com.palletops.awaze.common/aws-client :s3 credentials10812)]
    (clojure.core/case
     (clojure.core/count args10813)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10816
       setBucketPolicy
       (clojure.core/str (clojure.core/nth args10813 0))
       (clojure.core/str (clojure.core/nth args10813 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10816
       setBucketPolicy
       (s3/set-bucket-policy-request (clojure.core/nth args10813 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-notification-configuration
   [m10817]
   (clojure.core/let
    [credentials10818 (:credentials m10817) args10819 (:args m10817)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10820
      (com.palletops.awaze.common/aws-client :s3 credentials10818)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10820
       getBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args10819 0)))))))
  (clojure.core/defn
   get-bucket-notification-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketNotificationConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-notification-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-bucket-notification-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketNotificationConfiguration"}
   [credentials10822 & args10823]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10824
     (com.palletops.awaze.common/aws-client :s3 credentials10822)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10824
      getBucketNotificationConfiguration
      (clojure.core/str (clojure.core/nth args10823 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :generate-presigned-url
   [m10825]
   (clojure.core/let
    [credentials10826 (:credentials m10825) args10827 (:args m10825)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10828
      (com.palletops.awaze.common/aws-client :s3 credentials10826)]
     (clojure.core/case
      (clojure.core/count args10827)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10828
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args10827 0))
        (clojure.core/str (clojure.core/nth args10827 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args10827 2))
        (root/http-method (clojure.core/nth args10827 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10828
        generatePresignedUrl
        (s3/generate-presigned-url-request
         (clojure.core/nth args10827 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10828
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args10827 0))
        (clojure.core/str (clojure.core/nth args10827 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args10827 2))))))))
  (clojure.core/defn
   generate-presigned-url-map
   {:arglists (quote
               [[credentials string-0 string-1 date-2 http-method-3]
                [credentials
                 {:keys [content-md5
                         expiration
                         general-progress-listener
                         response-headers
                         key
                         method
                         bucket-name
                         content-type
                         request-parameters
                         ssecustomer-key]}]
                [credentials string-0 string-1 date-2]]),
    :doc "Generate map for generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   generate-presigned-url
   {:arglists (quote
               [[credentials string-0 string-1 date-2 http-method-3]
                [credentials
                 {:keys [content-md5
                         expiration
                         general-progress-listener
                         response-headers
                         key
                         method
                         bucket-name
                         content-type
                         request-parameters
                         ssecustomer-key]}]
                [credentials string-0 string-1 date-2]]),
    :doc "Call generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   [credentials10832 & args10833]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10836
     (com.palletops.awaze.common/aws-client :s3 credentials10832)]
    (clojure.core/case
     (clojure.core/count args10833)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10836
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args10833 0))
       (clojure.core/str (clojure.core/nth args10833 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args10833 2))
       (root/http-method (clojure.core/nth args10833 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10836
       generatePresignedUrl
       (s3/generate-presigned-url-request
        (clojure.core/nth args10833 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10836
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args10833 0))
       (clojure.core/str (clojure.core/nth args10833 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args10833 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-parts
   [m10837]
   (clojure.core/let
    [credentials10838 (:credentials m10837) args10839 (:args m10837)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10840
      (com.palletops.awaze.common/aws-client :s3 credentials10838)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10840
       listParts
       (s3/list-parts-request (clojure.core/nth args10839 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         key
                         max-parts
                         bucket-name
                         upload-id
                         part-number-marker
                         encoding-type]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-parts,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         key
                         max-parts
                         bucket-name
                         upload-id
                         part-number-marker
                         encoding-type]}]]),
    :doc "Call listParts"}
   [credentials10845 & args10846]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10850
     (com.palletops.awaze.common/aws-client :s3 credentials10845)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10850
      listParts
      (s3/list-parts-request (clojure.core/nth args10846 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-s3account-owner
   [m10851]
   (clojure.core/let
    [credentials10852 (:credentials m10851) args10853 (:args m10851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10854
      (com.palletops.awaze.common/aws-client :s3 credentials10852)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10854
       getS3AccountOwner)))))
  (clojure.core/defn
   get-s3account-owner-map
   {:arglists (quote [[credentials]]),
    :doc "Generate map for getS3AccountOwner"}
   ([credentials__1649__auto__]
    {:args [],
     :client :s3,
     :fn :get-s3account-owner,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-s3account-owner
   {:arglists (quote [[credentials]]), :doc "Call getS3AccountOwner"}
   [credentials10856 & args10857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10858
     (com.palletops.awaze.common/aws-client :s3 credentials10856)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10858
      getS3AccountOwner)))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-logging-configuration
   [m10859]
   (clojure.core/let
    [credentials10860 (:credentials m10859) args10861 (:args m10859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10862
      (com.palletops.awaze.common/aws-client :s3 credentials10860)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10862
       getBucketLoggingConfiguration
       (clojure.core/str (clojure.core/nth args10861 0)))))))
  (clojure.core/defn
   get-bucket-logging-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketLoggingConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-logging-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-bucket-logging-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketLoggingConfiguration"}
   [credentials10864 & args10865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10866
     (com.palletops.awaze.common/aws-client :s3 credentials10864)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10866
      getBucketLoggingConfiguration
      (clojure.core/str (clojure.core/nth args10865 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :list-buckets
   [m10867]
   (clojure.core/let
    [credentials10868 (:credentials m10867) args10869 (:args m10867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10870
      (com.palletops.awaze.common/aws-client :s3 credentials10868)]
     (clojure.core/case
      (clojure.core/count args10869)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10870
        listBuckets))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10870
        listBuckets
        (s3/list-buckets-request (clojure.core/nth args10869 0))))))))
  (clojure.core/defn
   list-buckets-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for listBuckets, listBuckets"}
   ([credentials__1649__auto__]
    {:args [],
     :client :s3,
     :fn :list-buckets,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-buckets,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-buckets
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call listBuckets, listBuckets"}
   [credentials10872 & args10873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10874
     (com.palletops.awaze.common/aws-client :s3 credentials10872)]
    (clojure.core/case
     (clojure.core/count args10873)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10874
       listBuckets))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10874
       listBuckets
       (s3/list-buckets-request (clojure.core/nth args10873 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-logging-configuration
   [m10875]
   (clojure.core/let
    [credentials10876 (:credentials m10875) args10877 (:args m10875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10878
      (com.palletops.awaze.common/aws-client :s3 credentials10876)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10878
       setBucketLoggingConfiguration
       (s3/set-bucket-logging-configuration-request
        (clojure.core/nth args10877 0)))))))
  (clojure.core/defn
   set-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [logging-configuration
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Generate map for setBucketLoggingConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-logging-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [logging-configuration
                         general-progress-listener
                         bucket-name]}]]),
    :doc "Call setBucketLoggingConfiguration"}
   [credentials10882 & args10883]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10886
     (com.palletops.awaze.common/aws-client :s3 credentials10882)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10886
      setBucketLoggingConfiguration
      (s3/set-bucket-logging-configuration-request
       (clojure.core/nth args10883 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-acl
   [m10887]
   (clojure.core/let
    [credentials10888 (:credentials m10887) args10889 (:args m10887)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10890
      (com.palletops.awaze.common/aws-client :s3 credentials10888)]
     (clojure.core/case
      (clojure.core/count args10889)
      1
      (clojure.core/let
       [a__1624__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketAclRequest
           (clojure.core/nth args10889 0))]
         (clojure.core/reset! a__1624__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10890
           getBucketAcl
           a)))
        (catch
         java.lang.Exception
         e__1625__auto__
         (if
          (clojure.core/deref a__1624__auto__)
          (throw e__1625__auto__)
          (clojure.core/let
           [a__1624__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10889 0))]
             (clojure.core/reset! a__1624__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10890
               getBucketAcl
               a)))
            (catch
             java.lang.Exception
             e__1625__auto__
             (if
              (clojure.core/deref a__1624__auto__)
              (throw e__1625__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketAcl")
                {:args args10889}))))))))))))))
  (clojure.core/defn
   get-bucket-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketAcl, getBucketAcl"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-acl,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-bucket-acl
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bucket-name]}]
                [credentials string-0]]),
    :doc "Call getBucketAcl, getBucketAcl"}
   [credentials10893 & args10894]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10896
     (com.palletops.awaze.common/aws-client :s3 credentials10893)]
    (clojure.core/case
     (clojure.core/count args10894)
     1
     (clojure.core/let
      [a__1624__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketAclRequest
          (clojure.core/nth args10894 0))]
        (clojure.core/reset! a__1624__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10896
          getBucketAcl
          a)))
       (catch
        java.lang.Exception
        e__1625__auto__
        (if
         (clojure.core/deref a__1624__auto__)
         (throw e__1625__auto__)
         (clojure.core/let
          [a__1624__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10894 0))]
            (clojure.core/reset! a__1624__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10896
              getBucketAcl
              a)))
           (catch
            java.lang.Exception
            e__1625__auto__
            (if
             (clojure.core/deref a__1624__auto__)
             (throw e__1625__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketAcl")
               {:args args10894}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-versions
   [m10897]
   (clojure.core/let
    [credentials10898 (:credentials m10897) args10899 (:args m10897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10900
      (com.palletops.awaze.common/aws-client :s3 credentials10898)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10900
       listNextBatchOfVersions
       (s3/version-listing (clojure.core/nth args10899 0)))))))
  (clojure.core/defn
   list-next-batch-of-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [prefix
                         bucket-name
                         common-prefixes
                         version-summaries
                         max-keys
                         truncated
                         key-marker
                         next-key-marker
                         delimiter
                         next-version-id-marker
                         version-id-marker
                         encoding-type]}]]),
    :doc "Generate map for listNextBatchOfVersions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-next-batch-of-versions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-next-batch-of-versions
   {:arglists (quote
               [[credentials
                 {:keys [prefix
                         bucket-name
                         common-prefixes
                         version-summaries
                         max-keys
                         truncated
                         key-marker
                         next-key-marker
                         delimiter
                         next-version-id-marker
                         version-id-marker
                         encoding-type]}]]),
    :doc "Call listNextBatchOfVersions"}
   [credentials10902 & args10903]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10904
     (com.palletops.awaze.common/aws-client :s3 credentials10902)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10904
      listNextBatchOfVersions
      (s3/version-listing (clojure.core/nth args10903 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :is-requester-pays-enabled
   [m10905]
   (clojure.core/let
    [credentials10906 (:credentials m10905) args10907 (:args m10905)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client10908
      (com.palletops.awaze.common/aws-client :s3 credentials10906)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10908
       isRequesterPaysEnabled
       (clojure.core/str (clojure.core/nth args10907 0)))))))
  (clojure.core/defn
   is-requester-pays-enabled-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for isRequesterPaysEnabled"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :s3,
     :fn :is-requester-pays-enabled,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   is-requester-pays-enabled
   {:arglists (quote [[credentials string-0]]),
    :doc "Call isRequesterPaysEnabled"}
   [credentials10910 & args10911]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client10912
     (com.palletops.awaze.common/aws-client :s3 credentials10910)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client10912
      isRequesterPaysEnabled
      (clojure.core/str (clojure.core/nth args10911 0))))))))
