(ns
 com.palletops.awaze.redshift
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.redshift :as redshift]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :redshift
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.redshift.AmazonRedshiftClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Parameter}
parameter
  [m2525]
  (clojure.core/let
   [bean2524 (new com.amazonaws.services.redshift.model.Parameter)]
   (clojure.core/when-let
    [v2526 (:parameter-name m2525)]
    (. bean2524 setParameterName (clojure.core/str v2526)))
   (clojure.core/when-let
    [v2526 (:parameter-value m2525)]
    (. bean2524 setParameterValue (clojure.core/str v2526)))
   (clojure.core/when-let
    [v2526 (:data-type m2525)]
    (. bean2524 setDataType (clojure.core/str v2526)))
   (clojure.core/when-let
    [v2526 (:allowed-values m2525)]
    (. bean2524 setAllowedValues (clojure.core/str v2526)))
   (clojure.core/when-let
    [v2526 (:is-modifiable m2525)]
    (. bean2524 setIsModifiable (clojure.core/boolean v2526)))
   (clojure.core/when-let
    [v2526 (:minimum-engine-version m2525)]
    (. bean2524 setMinimumEngineVersion (clojure.core/str v2526)))
   (clojure.core/when-let
    [v2526 (:source m2525)]
    (. bean2524 setSource (clojure.core/str v2526)))
   (clojure.core/when-let
    [v2526 (:description m2525)]
    (. bean2524 setDescription (clojure.core/str v2526)))
   bean2524))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.SourceType}
source-type
  [m2528]
  (.
   com.amazonaws.services.redshift.model.SourceType
   fromValue
   (clojure.core/name m2528)))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest}
describe-cluster-security-groups-request
  [m2531]
  (clojure.core/let
   [bean2530
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest)]
   (clojure.core/when-let
    [v2532 (:max-records m2531)]
    (. bean2530 setMaxRecords (clojure.core/int v2532)))
   (clojure.core/when-let
    [v2532 (:cluster-security-group-name m2531)]
    (. bean2530 setClusterSecurityGroupName (clojure.core/str v2532)))
   (clojure.core/when-let
    [v2532 (:marker m2531)]
    (. bean2530 setMarker (clojure.core/str v2532)))
   bean2530))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest}
describe-cluster-parameter-groups-request
  [m2534]
  (clojure.core/let
   [bean2533
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest)]
   (clojure.core/when-let
    [v2535 (:max-records m2534)]
    (. bean2533 setMaxRecords (clojure.core/int v2535)))
   (clojure.core/when-let
    [v2535 (:parameter-group-name m2534)]
    (. bean2533 setParameterGroupName (clojure.core/str v2535)))
   (clojure.core/when-let
    [v2535 (:marker m2534)]
    (. bean2533 setMarker (clojure.core/str v2535)))
   bean2533))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest}
enable-snapshot-copy-request
  [m2537]
  (clojure.core/let
   [bean2536
    (new
     com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest)]
   (clojure.core/when-let
    [v2538 (:cluster-identifier m2537)]
    (. bean2536 setClusterIdentifier (clojure.core/str v2538)))
   (clojure.core/when-let
    [v2538 (:retention-period m2537)]
    (. bean2536 setRetentionPeriod (clojure.core/int v2538)))
   (clojure.core/when-let
    [v2538 (:destination-region m2537)]
    (. bean2536 setDestinationRegion (clojure.core/str v2538)))
   bean2536))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterRequest}
create-cluster-request
  [m2540]
  (clojure.core/let
   [bean2539
    (new com.amazonaws.services.redshift.model.CreateClusterRequest)]
   (clojure.core/when-let
    [v2541 (:vpc-security-group-ids m2540)]
    (.
     bean2539
     setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2689] (clojure.core/str arg2689))
 v2541)))
   (clojure.core/when-let
    [v2541 (:cluster-version m2540)]
    (. bean2539 setClusterVersion (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:cluster-identifier m2540)]
    (. bean2539 setClusterIdentifier (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:encrypted m2540)]
    (. bean2539 setEncrypted (clojure.core/boolean v2541)))
   (clojure.core/when-let
    [v2541 (:port m2540)]
    (. bean2539 setPort (clojure.core/int v2541)))
   (clojure.core/when-let
    [v2541 (:preferred-maintenance-window m2540)]
    (.
     bean2539
     setPreferredMaintenanceWindow
     (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:availability-zone m2540)]
    (. bean2539 setAvailabilityZone (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:master-user-password m2540)]
    (. bean2539 setMasterUserPassword (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:allow-version-upgrade m2540)]
    (. bean2539 setAllowVersionUpgrade (clojure.core/boolean v2541)))
   (clojure.core/when-let
    [v2541 (:dbname m2540)]
    (. bean2539 setDBName (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:cluster-security-groups m2540)]
    (.
     bean2539
     setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2690] (clojure.core/str arg2690))
 v2541)))
   (clojure.core/when-let
    [v2541 (:automated-snapshot-retention-period m2540)]
    (.
     bean2539
     setAutomatedSnapshotRetentionPeriod
     (clojure.core/int v2541)))
   (clojure.core/when-let
    [v2541 (:publicly-accessible m2540)]
    (. bean2539 setPubliclyAccessible (clojure.core/boolean v2541)))
   (clojure.core/when-let
    [v2541 (:number-of-nodes m2540)]
    (. bean2539 setNumberOfNodes (clojure.core/int v2541)))
   (clojure.core/when-let
    [v2541 (:cluster-type m2540)]
    (. bean2539 setClusterType (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:cluster-subnet-group-name m2540)]
    (. bean2539 setClusterSubnetGroupName (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:hsm-client-certificate-identifier m2540)]
    (.
     bean2539
     setHsmClientCertificateIdentifier
     (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:cluster-parameter-group-name m2540)]
    (. bean2539 setClusterParameterGroupName (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:elastic-ip m2540)]
    (. bean2539 setElasticIp (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:master-username m2540)]
    (. bean2539 setMasterUsername (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:node-type m2540)]
    (. bean2539 setNodeType (clojure.core/str v2541)))
   (clojure.core/when-let
    [v2541 (:hsm-configuration-identifier m2540)]
    (.
     bean2539
     setHsmConfigurationIdentifier
     (clojure.core/str v2541)))
   bean2539))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest}
authorize-snapshot-access-request
  [m2543]
  (clojure.core/let
   [bean2542
    (new
     com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest)]
   (clojure.core/when-let
    [v2544 (:snapshot-identifier m2543)]
    (. bean2542 setSnapshotIdentifier (clojure.core/str v2544)))
   (clojure.core/when-let
    [v2544 (:snapshot-cluster-identifier m2543)]
    (. bean2542 setSnapshotClusterIdentifier (clojure.core/str v2544)))
   (clojure.core/when-let
    [v2544 (:account-with-restore-access m2543)]
    (. bean2542 setAccountWithRestoreAccess (clojure.core/str v2544)))
   bean2542))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest}
describe-cluster-subnet-groups-request
  [m2546]
  (clojure.core/let
   [bean2545
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest)]
   (clojure.core/when-let
    [v2547 (:cluster-subnet-group-name m2546)]
    (. bean2545 setClusterSubnetGroupName (clojure.core/str v2547)))
   (clojure.core/when-let
    [v2547 (:max-records m2546)]
    (. bean2545 setMaxRecords (clojure.core/int v2547)))
   (clojure.core/when-let
    [v2547 (:marker m2546)]
    (. bean2545 setMarker (clojure.core/str v2547)))
   bean2545))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableLoggingRequest}
enable-logging-request
  [m2549]
  (clojure.core/let
   [bean2548
    (new com.amazonaws.services.redshift.model.EnableLoggingRequest)]
   (clojure.core/when-let
    [v2550 (:cluster-identifier m2549)]
    (. bean2548 setClusterIdentifier (clojure.core/str v2550)))
   (clojure.core/when-let
    [v2550 (:bucket-name m2549)]
    (. bean2548 setBucketName (clojure.core/str v2550)))
   (clojure.core/when-let
    [v2550 (:s3key-prefix m2549)]
    (. bean2548 setS3KeyPrefix (clojure.core/str v2550)))
   bean2548))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClustersRequest}
describe-clusters-request
  [m2552]
  (clojure.core/let
   [bean2551
    (new
     com.amazonaws.services.redshift.model.DescribeClustersRequest)]
   (clojure.core/when-let
    [v2553 (:cluster-identifier m2552)]
    (. bean2551 setClusterIdentifier (clojure.core/str v2553)))
   (clojure.core/when-let
    [v2553 (:max-records m2552)]
    (. bean2551 setMaxRecords (clojure.core/int v2553)))
   (clojure.core/when-let
    [v2553 (:marker m2552)]
    (. bean2551 setMarker (clojure.core/str v2553)))
   bean2551))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest}
restore-from-cluster-snapshot-request
  [m2555]
  (clojure.core/let
   [bean2554
    (new
     com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2556 (:vpc-security-group-ids m2555)]
    (.
     bean2554
     setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2691] (clojure.core/str arg2691))
 v2556)))
   (clojure.core/when-let
    [v2556 (:cluster-identifier m2555)]
    (. bean2554 setClusterIdentifier (clojure.core/str v2556)))
   (clojure.core/when-let
    [v2556 (:port m2555)]
    (. bean2554 setPort (clojure.core/int v2556)))
   (clojure.core/when-let
    [v2556 (:preferred-maintenance-window m2555)]
    (.
     bean2554
     setPreferredMaintenanceWindow
     (clojure.core/str v2556)))
   (clojure.core/when-let
    [v2556 (:availability-zone m2555)]
    (. bean2554 setAvailabilityZone (clojure.core/str v2556)))
   (clojure.core/when-let
    [v2556 (:allow-version-upgrade m2555)]
    (. bean2554 setAllowVersionUpgrade (clojure.core/boolean v2556)))
   (clojure.core/when-let
    [v2556 (:cluster-security-groups m2555)]
    (.
     bean2554
     setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2692] (clojure.core/str arg2692))
 v2556)))
   (clojure.core/when-let
    [v2556 (:automated-snapshot-retention-period m2555)]
    (.
     bean2554
     setAutomatedSnapshotRetentionPeriod
     (clojure.core/int v2556)))
   (clojure.core/when-let
    [v2556 (:publicly-accessible m2555)]
    (. bean2554 setPubliclyAccessible (clojure.core/boolean v2556)))
   (clojure.core/when-let
    [v2556 (:snapshot-identifier m2555)]
    (. bean2554 setSnapshotIdentifier (clojure.core/str v2556)))
   (clojure.core/when-let
    [v2556 (:cluster-subnet-group-name m2555)]
    (. bean2554 setClusterSubnetGroupName (clojure.core/str v2556)))
   (clojure.core/when-let
    [v2556 (:hsm-client-certificate-identifier m2555)]
    (.
     bean2554
     setHsmClientCertificateIdentifier
     (clojure.core/str v2556)))
   (clojure.core/when-let
    [v2556 (:cluster-parameter-group-name m2555)]
    (. bean2554 setClusterParameterGroupName (clojure.core/str v2556)))
   (clojure.core/when-let
    [v2556 (:elastic-ip m2555)]
    (. bean2554 setElasticIp (clojure.core/str v2556)))
   (clojure.core/when-let
    [v2556 (:owner-account m2555)]
    (. bean2554 setOwnerAccount (clojure.core/str v2556)))
   (clojure.core/when-let
    [v2556 (:snapshot-cluster-identifier m2555)]
    (. bean2554 setSnapshotClusterIdentifier (clojure.core/str v2556)))
   (clojure.core/when-let
    [v2556 (:hsm-configuration-identifier m2555)]
    (.
     bean2554
     setHsmConfigurationIdentifier
     (clojure.core/str v2556)))
   bean2554))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest}
revoke-snapshot-access-request
  [m2558]
  (clojure.core/let
   [bean2557
    (new
     com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest)]
   (clojure.core/when-let
    [v2559 (:snapshot-identifier m2558)]
    (. bean2557 setSnapshotIdentifier (clojure.core/str v2559)))
   (clojure.core/when-let
    [v2559 (:snapshot-cluster-identifier m2558)]
    (. bean2557 setSnapshotClusterIdentifier (clojure.core/str v2559)))
   (clojure.core/when-let
    [v2559 (:account-with-restore-access m2558)]
    (. bean2557 setAccountWithRestoreAccess (clojure.core/str v2559)))
   bean2557))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest}
rotate-encryption-key-request
  [m2561]
  (clojure.core/let
   [bean2560
    (new
     com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest)]
   (clojure.core/when-let
    [v2562 (:cluster-identifier m2561)]
    (. bean2560 setClusterIdentifier (clojure.core/str v2562)))
   bean2560))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableLoggingRequest}
disable-logging-request
  [m2564]
  (clojure.core/let
   [bean2563
    (new com.amazonaws.services.redshift.model.DisableLoggingRequest)]
   (clojure.core/when-let
    [v2565 (:cluster-identifier m2564)]
    (. bean2563 setClusterIdentifier (clojure.core/str v2565)))
   bean2563))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest}
delete-cluster-security-group-request
  [m2567]
  (clojure.core/let
   [bean2566
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest)]
   (clojure.core/when-let
    [v2568 (:cluster-security-group-name m2567)]
    (. bean2566 setClusterSecurityGroupName (clojure.core/str v2568)))
   bean2566))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParametersRequest}
describe-cluster-parameters-request
  [m2570]
  (clojure.core/let
   [bean2569
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParametersRequest)]
   (clojure.core/when-let
    [v2571 (:max-records m2570)]
    (. bean2569 setMaxRecords (clojure.core/int v2571)))
   (clojure.core/when-let
    [v2571 (:parameter-group-name m2570)]
    (. bean2569 setParameterGroupName (clojure.core/str v2571)))
   (clojure.core/when-let
    [v2571 (:source m2570)]
    (. bean2569 setSource (clojure.core/str v2571)))
   (clojure.core/when-let
    [v2571 (:marker m2570)]
    (. bean2569 setMarker (clojure.core/str v2571)))
   bean2569))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m2573]
  (clojure.core/let
   [bean2572
    (new
     com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest)]
   (clojure.core/when-let
    [v2574 (:source-type m2573)]
    (. bean2572 setSourceType (clojure.core/str v2574)))
   (clojure.core/when-let
    [v2574 (:subscription-name m2573)]
    (. bean2572 setSubscriptionName (clojure.core/str v2574)))
   (clojure.core/when-let
    [v2574 (:sns-topic-arn m2573)]
    (. bean2572 setSnsTopicArn (clojure.core/str v2574)))
   (clojure.core/when-let
    [v2574 (:source-ids m2573)]
    (.
     bean2572
     setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2693] (clojure.core/str arg2693))
 v2574)))
   (clojure.core/when-let
    [v2574 (:event-categories m2573)]
    (.
     bean2572
     setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2694] (clojure.core/str arg2694))
 v2574)))
   (clojure.core/when-let
    [v2574 (:severity m2573)]
    (. bean2572 setSeverity (clojure.core/str v2574)))
   (clojure.core/when-let
    [v2574 (:enabled m2573)]
    (. bean2572 setEnabled (clojure.core/boolean v2574)))
   bean2572))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest}
reset-cluster-parameter-group-request
  [m2576]
  (clojure.core/let
   [bean2575
    (new
     com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2577 (:parameters m2576)]
    (.
     bean2575
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2695] (redshift/parameter arg2695))
 v2577)))
   (clojure.core/when-let
    [v2577 (:parameter-group-name m2576)]
    (. bean2575 setParameterGroupName (clojure.core/str v2577)))
   (clojure.core/when-let
    [v2577 (:reset-all-parameters m2576)]
    (. bean2575 setResetAllParameters (clojure.core/boolean v2577)))
   bean2575))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest}
create-cluster-parameter-group-request
  [m2579]
  (clojure.core/let
   [bean2578
    (new
     com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2580 (:parameter-group-family m2579)]
    (. bean2578 setParameterGroupFamily (clojure.core/str v2580)))
   (clojure.core/when-let
    [v2580 (:parameter-group-name m2579)]
    (. bean2578 setParameterGroupName (clojure.core/str v2580)))
   (clojure.core/when-let
    [v2580 (:description m2579)]
    (. bean2578 setDescription (clojure.core/str v2580)))
   bean2578))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest}
delete-hsm-configuration-request
  [m2582]
  (clojure.core/let
   [bean2581
    (new
     com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest)]
   (clojure.core/when-let
    [v2583 (:hsm-configuration-identifier m2582)]
    (.
     bean2581
     setHsmConfigurationIdentifier
     (clojure.core/str v2583)))
   bean2581))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m2585]
  (clojure.core/let
   [bean2584
    (new
     com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest)]
   (clojure.core/when-let
    [v2586 (:source-type m2585)]
    (. bean2584 setSourceType (clojure.core/str v2586)))
   (clojure.core/when-let
    [v2586 (:subscription-name m2585)]
    (. bean2584 setSubscriptionName (clojure.core/str v2586)))
   (clojure.core/when-let
    [v2586 (:sns-topic-arn m2585)]
    (. bean2584 setSnsTopicArn (clojure.core/str v2586)))
   (clojure.core/when-let
    [v2586 (:source-ids m2585)]
    (.
     bean2584
     setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2696] (clojure.core/str arg2696))
 v2586)))
   (clojure.core/when-let
    [v2586 (:event-categories m2585)]
    (.
     bean2584
     setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2697] (clojure.core/str arg2697))
 v2586)))
   (clojure.core/when-let
    [v2586 (:severity m2585)]
    (. bean2584 setSeverity (clojure.core/str v2586)))
   (clojure.core/when-let
    [v2586 (:enabled m2585)]
    (. bean2584 setEnabled (clojure.core/boolean v2586)))
   bean2584))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodesRequest}
describe-reserved-nodes-request
  [m2588]
  (clojure.core/let
   [bean2587
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodesRequest)]
   (clojure.core/when-let
    [v2589 (:max-records m2588)]
    (. bean2587 setMaxRecords (clojure.core/int v2589)))
   (clojure.core/when-let
    [v2589 (:reserved-node-id m2588)]
    (. bean2587 setReservedNodeId (clojure.core/str v2589)))
   (clojure.core/when-let
    [v2589 (:marker m2588)]
    (. bean2587 setMarker (clojure.core/str v2589)))
   bean2587))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest}
copy-cluster-snapshot-request
  [m2591]
  (clojure.core/let
   [bean2590
    (new
     com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2592 (:source-snapshot-identifier m2591)]
    (. bean2590 setSourceSnapshotIdentifier (clojure.core/str v2592)))
   (clojure.core/when-let
    [v2592 (:source-snapshot-cluster-identifier m2591)]
    (.
     bean2590
     setSourceSnapshotClusterIdentifier
     (clojure.core/str v2592)))
   (clojure.core/when-let
    [v2592 (:target-snapshot-identifier m2591)]
    (. bean2590 setTargetSnapshotIdentifier (clojure.core/str v2592)))
   bean2590))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest}
delete-hsm-client-certificate-request
  [m2594]
  (clojure.core/let
   [bean2593
    (new
     com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest)]
   (clojure.core/when-let
    [v2595 (:hsm-client-certificate-identifier m2594)]
    (.
     bean2593
     setHsmClientCertificateIdentifier
     (clojure.core/str v2595)))
   bean2593))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest}
modify-cluster-subnet-group-request
  [m2597]
  (clojure.core/let
   [bean2596
    (new
     com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v2598 (:cluster-subnet-group-name m2597)]
    (. bean2596 setClusterSubnetGroupName (clojure.core/str v2598)))
   (clojure.core/when-let
    [v2598 (:subnet-ids m2597)]
    (.
     bean2596
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2698] (clojure.core/str arg2698))
 v2598)))
   (clojure.core/when-let
    [v2598 (:description m2597)]
    (. bean2596 setDescription (clojure.core/str v2598)))
   bean2596))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest}
describe-logging-status-request
  [m2600]
  (clojure.core/let
   [bean2599
    (new
     com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest)]
   (clojure.core/when-let
    [v2601 (:cluster-identifier m2600)]
    (. bean2599 setClusterIdentifier (clojure.core/str v2601)))
   bean2599))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventsRequest}
describe-events-request
  [m2603]
  (clojure.core/let
   [bean2602
    (new com.amazonaws.services.redshift.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v2604 (:max-records m2603)]
    (. bean2602 setMaxRecords (clojure.core/int v2604)))
   (clojure.core/when-let
    [v2604 (:source-identifier m2603)]
    (. bean2602 setSourceIdentifier (clojure.core/str v2604)))
   (clojure.core/when-let
    [v2604 (:source-type m2603)]
    (. bean2602 setSourceType (redshift/source-type v2604)))
   (clojure.core/when-let
    [v2604 (:start-time m2603)]
    (.
     bean2602
     setStartTime
     (com.palletops.awaze.common/to-date v2604)))
   (clojure.core/when-let
    [v2604 (:end-time m2603)]
    (. bean2602 setEndTime (com.palletops.awaze.common/to-date v2604)))
   (clojure.core/when-let
    [v2604 (:duration m2603)]
    (. bean2602 setDuration (clojure.core/int v2604)))
   (clojure.core/when-let
    [v2604 (:marker m2603)]
    (. bean2602 setMarker (clojure.core/str v2604)))
   bean2602))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest}
delete-cluster-parameter-group-request
  [m2606]
  (clojure.core/let
   [bean2605
    (new
     com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2607 (:parameter-group-name m2606)]
    (. bean2605 setParameterGroupName (clojure.core/str v2607)))
   bean2605))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest}
authorize-cluster-security-group-ingress-request
  [m2609]
  (clojure.core/let
   [bean2608
    (new
     com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v2610 (:cluster-security-group-name m2609)]
    (. bean2608 setClusterSecurityGroupName (clojure.core/str v2610)))
   (clojure.core/when-let
    [v2610 (:cidrip m2609)]
    (. bean2608 setCIDRIP (clojure.core/str v2610)))
   (clojure.core/when-let
    [v2610 (:ec2security-group-name m2609)]
    (. bean2608 setEC2SecurityGroupName (clojure.core/str v2610)))
   (clojure.core/when-let
    [v2610 (:ec2security-group-owner-id m2609)]
    (. bean2608 setEC2SecurityGroupOwnerId (clojure.core/str v2610)))
   bean2608))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterRequest}
modify-cluster-request
  [m2612]
  (clojure.core/let
   [bean2611
    (new com.amazonaws.services.redshift.model.ModifyClusterRequest)]
   (clojure.core/when-let
    [v2613 (:vpc-security-group-ids m2612)]
    (.
     bean2611
     setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2699] (clojure.core/str arg2699))
 v2613)))
   (clojure.core/when-let
    [v2613 (:cluster-version m2612)]
    (. bean2611 setClusterVersion (clojure.core/str v2613)))
   (clojure.core/when-let
    [v2613 (:cluster-identifier m2612)]
    (. bean2611 setClusterIdentifier (clojure.core/str v2613)))
   (clojure.core/when-let
    [v2613 (:preferred-maintenance-window m2612)]
    (.
     bean2611
     setPreferredMaintenanceWindow
     (clojure.core/str v2613)))
   (clojure.core/when-let
    [v2613 (:new-cluster-identifier m2612)]
    (. bean2611 setNewClusterIdentifier (clojure.core/str v2613)))
   (clojure.core/when-let
    [v2613 (:master-user-password m2612)]
    (. bean2611 setMasterUserPassword (clojure.core/str v2613)))
   (clojure.core/when-let
    [v2613 (:allow-version-upgrade m2612)]
    (. bean2611 setAllowVersionUpgrade (clojure.core/boolean v2613)))
   (clojure.core/when-let
    [v2613 (:cluster-security-groups m2612)]
    (.
     bean2611
     setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2700] (clojure.core/str arg2700))
 v2613)))
   (clojure.core/when-let
    [v2613 (:automated-snapshot-retention-period m2612)]
    (.
     bean2611
     setAutomatedSnapshotRetentionPeriod
     (clojure.core/int v2613)))
   (clojure.core/when-let
    [v2613 (:number-of-nodes m2612)]
    (. bean2611 setNumberOfNodes (clojure.core/int v2613)))
   (clojure.core/when-let
    [v2613 (:cluster-type m2612)]
    (. bean2611 setClusterType (clojure.core/str v2613)))
   (clojure.core/when-let
    [v2613 (:hsm-client-certificate-identifier m2612)]
    (.
     bean2611
     setHsmClientCertificateIdentifier
     (clojure.core/str v2613)))
   (clojure.core/when-let
    [v2613 (:cluster-parameter-group-name m2612)]
    (. bean2611 setClusterParameterGroupName (clojure.core/str v2613)))
   (clojure.core/when-let
    [v2613 (:node-type m2612)]
    (. bean2611 setNodeType (clojure.core/str v2613)))
   (clojure.core/when-let
    [v2613 (:hsm-configuration-identifier m2612)]
    (.
     bean2611
     setHsmConfigurationIdentifier
     (clojure.core/str v2613)))
   bean2611))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest}
delete-cluster-subnet-group-request
  [m2615]
  (clojure.core/let
   [bean2614
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v2616 (:cluster-subnet-group-name m2615)]
    (. bean2614 setClusterSubnetGroupName (clojure.core/str v2616)))
   bean2614))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest}
create-cluster-subnet-group-request
  [m2618]
  (clojure.core/let
   [bean2617
    (new
     com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v2619 (:cluster-subnet-group-name m2618)]
    (. bean2617 setClusterSubnetGroupName (clojure.core/str v2619)))
   (clojure.core/when-let
    [v2619 (:subnet-ids m2618)]
    (.
     bean2617
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2701] (clojure.core/str arg2701))
 v2619)))
   (clojure.core/when-let
    [v2619 (:description m2618)]
    (. bean2617 setDescription (clojure.core/str v2619)))
   bean2617))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest}
purchase-reserved-node-offering-request
  [m2621]
  (clojure.core/let
   [bean2620
    (new
     com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest)]
   (clojure.core/when-let
    [v2622 (:reserved-node-offering-id m2621)]
    (. bean2620 setReservedNodeOfferingId (clojure.core/str v2622)))
   (clojure.core/when-let
    [v2622 (:node-count m2621)]
    (. bean2620 setNodeCount (clojure.core/int v2622)))
   bean2620))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest}
describe-reserved-node-offerings-request
  [m2624]
  (clojure.core/let
   [bean2623
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest)]
   (clojure.core/when-let
    [v2625 (:reserved-node-offering-id m2624)]
    (. bean2623 setReservedNodeOfferingId (clojure.core/str v2625)))
   (clojure.core/when-let
    [v2625 (:max-records m2624)]
    (. bean2623 setMaxRecords (clojure.core/int v2625)))
   (clojure.core/when-let
    [v2625 (:marker m2624)]
    (. bean2623 setMarker (clojure.core/str v2625)))
   bean2623))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterRequest}
delete-cluster-request
  [m2627]
  (clojure.core/let
   [bean2626
    (new com.amazonaws.services.redshift.model.DeleteClusterRequest)]
   (clojure.core/when-let
    [v2628 (:cluster-identifier m2627)]
    (. bean2626 setClusterIdentifier (clojure.core/str v2628)))
   (clojure.core/when-let
    [v2628 (:skip-final-cluster-snapshot m2627)]
    (.
     bean2626
     setSkipFinalClusterSnapshot
     (clojure.core/boolean v2628)))
   (clojure.core/when-let
    [v2628 (:final-cluster-snapshot-identifier m2627)]
    (.
     bean2626
     setFinalClusterSnapshotIdentifier
     (clojure.core/str v2628)))
   bean2626))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest}
create-cluster-security-group-request
  [m2630]
  (clojure.core/let
   [bean2629
    (new
     com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest)]
   (clojure.core/when-let
    [v2631 (:cluster-security-group-name m2630)]
    (. bean2629 setClusterSecurityGroupName (clojure.core/str v2631)))
   (clojure.core/when-let
    [v2631 (:description m2630)]
    (. bean2629 setDescription (clojure.core/str v2631)))
   bean2629))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m2633]
  (clojure.core/let
   [bean2632
    (new
     com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/when-let
    [v2634 (:max-records m2633)]
    (. bean2632 setMaxRecords (clojure.core/int v2634)))
   (clojure.core/when-let
    [v2634 (:subscription-name m2633)]
    (. bean2632 setSubscriptionName (clojure.core/str v2634)))
   (clojure.core/when-let
    [v2634 (:marker m2633)]
    (. bean2632 setMarker (clojure.core/str v2634)))
   bean2632))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest}
describe-default-cluster-parameters-request
  [m2636]
  (clojure.core/let
   [bean2635
    (new
     com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest)]
   (clojure.core/when-let
    [v2637 (:max-records m2636)]
    (. bean2635 setMaxRecords (clojure.core/int v2637)))
   (clojure.core/when-let
    [v2637 (:parameter-group-family m2636)]
    (. bean2635 setParameterGroupFamily (clojure.core/str v2637)))
   (clojure.core/when-let
    [v2637 (:marker m2636)]
    (. bean2635 setMarker (clojure.core/str v2637)))
   bean2635))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest}
describe-hsm-configurations-request
  [m2639]
  (clojure.core/let
   [bean2638
    (new
     com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest)]
   (clojure.core/when-let
    [v2640 (:hsm-configuration-identifier m2639)]
    (.
     bean2638
     setHsmConfigurationIdentifier
     (clojure.core/str v2640)))
   (clojure.core/when-let
    [v2640 (:max-records m2639)]
    (. bean2638 setMaxRecords (clojure.core/int v2640)))
   (clojure.core/when-let
    [v2640 (:marker m2639)]
    (. bean2638 setMarker (clojure.core/str v2640)))
   bean2638))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest}
create-cluster-snapshot-request
  [m2642]
  (clojure.core/let
   [bean2641
    (new
     com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2643 (:cluster-identifier m2642)]
    (. bean2641 setClusterIdentifier (clojure.core/str v2643)))
   (clojure.core/when-let
    [v2643 (:snapshot-identifier m2642)]
    (. bean2641 setSnapshotIdentifier (clojure.core/str v2643)))
   bean2641))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest}
describe-cluster-versions-request
  [m2645]
  (clojure.core/let
   [bean2644
    (new
     com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest)]
   (clojure.core/when-let
    [v2646 (:cluster-version m2645)]
    (. bean2644 setClusterVersion (clojure.core/str v2646)))
   (clojure.core/when-let
    [v2646 (:max-records m2645)]
    (. bean2644 setMaxRecords (clojure.core/int v2646)))
   (clojure.core/when-let
    [v2646 (:cluster-parameter-group-family m2645)]
    (.
     bean2644
     setClusterParameterGroupFamily
     (clojure.core/str v2646)))
   (clojure.core/when-let
    [v2646 (:marker m2645)]
    (. bean2644 setMarker (clojure.core/str v2646)))
   bean2644))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest}
disable-snapshot-copy-request
  [m2648]
  (clojure.core/let
   [bean2647
    (new
     com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest)]
   (clojure.core/when-let
    [v2649 (:cluster-identifier m2648)]
    (. bean2647 setClusterIdentifier (clojure.core/str v2649)))
   bean2647))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m2651]
  (clojure.core/let
   [bean2650
    (new
     com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest)]
   (clojure.core/when-let
    [v2652 (:subscription-name m2651)]
    (. bean2650 setSubscriptionName (clojure.core/str v2652)))
   bean2650))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest}
modify-snapshot-copy-retention-period-request
  [m2654]
  (clojure.core/let
   [bean2653
    (new
     com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest)]
   (clojure.core/when-let
    [v2655 (:cluster-identifier m2654)]
    (. bean2653 setClusterIdentifier (clojure.core/str v2655)))
   (clojure.core/when-let
    [v2655 (:retention-period m2654)]
    (. bean2653 setRetentionPeriod (clojure.core/int v2655)))
   bean2653))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RebootClusterRequest}
reboot-cluster-request
  [m2657]
  (clojure.core/let
   [bean2656
    (new com.amazonaws.services.redshift.model.RebootClusterRequest)]
   (clojure.core/when-let
    [v2658 (:cluster-identifier m2657)]
    (. bean2656 setClusterIdentifier (clojure.core/str v2658)))
   bean2656))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeResizeRequest}
describe-resize-request
  [m2660]
  (clojure.core/let
   [bean2659
    (new com.amazonaws.services.redshift.model.DescribeResizeRequest)]
   (clojure.core/when-let
    [v2661 (:cluster-identifier m2660)]
    (. bean2659 setClusterIdentifier (clojure.core/str v2661)))
   bean2659))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest}
revoke-cluster-security-group-ingress-request
  [m2663]
  (clojure.core/let
   [bean2662
    (new
     com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v2664 (:cluster-security-group-name m2663)]
    (. bean2662 setClusterSecurityGroupName (clojure.core/str v2664)))
   (clojure.core/when-let
    [v2664 (:cidrip m2663)]
    (. bean2662 setCIDRIP (clojure.core/str v2664)))
   (clojure.core/when-let
    [v2664 (:ec2security-group-name m2663)]
    (. bean2662 setEC2SecurityGroupName (clojure.core/str v2664)))
   (clojure.core/when-let
    [v2664 (:ec2security-group-owner-id m2663)]
    (. bean2662 setEC2SecurityGroupOwnerId (clojure.core/str v2664)))
   bean2662))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest}
modify-cluster-parameter-group-request
  [m2666]
  (clojure.core/let
   [bean2665
    (new
     com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2667 (:parameters m2666)]
    (.
     bean2665
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2702] (redshift/parameter arg2702))
 v2667)))
   (clojure.core/when-let
    [v2667 (:parameter-group-name m2666)]
    (. bean2665 setParameterGroupName (clojure.core/str v2667)))
   bean2665))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest}
describe-hsm-client-certificates-request
  [m2669]
  (clojure.core/let
   [bean2668
    (new
     com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest)]
   (clojure.core/when-let
    [v2670 (:hsm-client-certificate-identifier m2669)]
    (.
     bean2668
     setHsmClientCertificateIdentifier
     (clojure.core/str v2670)))
   (clojure.core/when-let
    [v2670 (:max-records m2669)]
    (. bean2668 setMaxRecords (clojure.core/int v2670)))
   (clojure.core/when-let
    [v2670 (:marker m2669)]
    (. bean2668 setMarker (clojure.core/str v2670)))
   bean2668))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest}
create-hsm-client-certificate-request
  [m2672]
  (clojure.core/let
   [bean2671
    (new
     com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest)]
   (clojure.core/when-let
    [v2673 (:hsm-client-certificate-identifier m2672)]
    (.
     bean2671
     setHsmClientCertificateIdentifier
     (clojure.core/str v2673)))
   bean2671))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m2675]
  (clojure.core/let
   [bean2674
    (new
     com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest)]
   (clojure.core/when-let
    [v2676 (:source-type m2675)]
    (. bean2674 setSourceType (clojure.core/str v2676)))
   bean2674))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest}
create-hsm-configuration-request
  [m2678]
  (clojure.core/let
   [bean2677
    (new
     com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest)]
   (clojure.core/when-let
    [v2679 (:hsm-configuration-identifier m2678)]
    (.
     bean2677
     setHsmConfigurationIdentifier
     (clojure.core/str v2679)))
   (clojure.core/when-let
    [v2679 (:hsm-ip-address m2678)]
    (. bean2677 setHsmIpAddress (clojure.core/str v2679)))
   (clojure.core/when-let
    [v2679 (:hsm-partition-name m2678)]
    (. bean2677 setHsmPartitionName (clojure.core/str v2679)))
   (clojure.core/when-let
    [v2679 (:hsm-partition-password m2678)]
    (. bean2677 setHsmPartitionPassword (clojure.core/str v2679)))
   (clojure.core/when-let
    [v2679 (:hsm-server-public-certificate m2678)]
    (.
     bean2677
     setHsmServerPublicCertificate
     (clojure.core/str v2679)))
   (clojure.core/when-let
    [v2679 (:description m2678)]
    (. bean2677 setDescription (clojure.core/str v2679)))
   bean2677))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest}
describe-cluster-snapshots-request
  [m2681]
  (clojure.core/let
   [bean2680
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest)]
   (clojure.core/when-let
    [v2682 (:cluster-identifier m2681)]
    (. bean2680 setClusterIdentifier (clojure.core/str v2682)))
   (clojure.core/when-let
    [v2682 (:snapshot-identifier m2681)]
    (. bean2680 setSnapshotIdentifier (clojure.core/str v2682)))
   (clojure.core/when-let
    [v2682 (:max-records m2681)]
    (. bean2680 setMaxRecords (clojure.core/int v2682)))
   (clojure.core/when-let
    [v2682 (:start-time m2681)]
    (.
     bean2680
     setStartTime
     (com.palletops.awaze.common/to-date v2682)))
   (clojure.core/when-let
    [v2682 (:end-time m2681)]
    (. bean2680 setEndTime (com.palletops.awaze.common/to-date v2682)))
   (clojure.core/when-let
    [v2682 (:owner-account m2681)]
    (. bean2680 setOwnerAccount (clojure.core/str v2682)))
   (clojure.core/when-let
    [v2682 (:snapshot-type m2681)]
    (. bean2680 setSnapshotType (clojure.core/str v2682)))
   (clojure.core/when-let
    [v2682 (:marker m2681)]
    (. bean2680 setMarker (clojure.core/str v2682)))
   bean2680))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest}
delete-cluster-snapshot-request
  [m2684]
  (clojure.core/let
   [bean2683
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2685 (:snapshot-identifier m2684)]
    (. bean2683 setSnapshotIdentifier (clojure.core/str v2685)))
   (clojure.core/when-let
    [v2685 (:snapshot-cluster-identifier m2684)]
    (. bean2683 setSnapshotClusterIdentifier (clojure.core/str v2685)))
   bean2683))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest}
describe-orderable-cluster-options-request
  [m2687]
  (clojure.core/let
   [bean2686
    (new
     com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest)]
   (clojure.core/when-let
    [v2688 (:node-type m2687)]
    (. bean2686 setNodeType (clojure.core/str v2688)))
   (clojure.core/when-let
    [v2688 (:cluster-version m2687)]
    (. bean2686 setClusterVersion (clojure.core/str v2688)))
   (clojure.core/when-let
    [v2688 (:max-records m2687)]
    (. bean2686 setMaxRecords (clojure.core/int v2688)))
   (clojure.core/when-let
    [v2688 (:marker m2687)]
    (. bean2686 setMarker (clojure.core/str v2688)))
   bean2686))
 (clojure.core/defmulti
  redshift
  (clojure.core/fn redshift [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-security-groups
   [m2703]
   (clojure.core/let
    [credentials2704 (:credentials m2703) args2705 (:args m2703)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2706
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2704)]
     (clojure.core/case
      (clojure.core/count args2705)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2706
        describeClusterSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2706
        describeClusterSecurityGroups
        (redshift/describe-cluster-security-groups-request
         (clojure.core/nth args2705 0))))))))
  (clojure.core/defn
   describe-cluster-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Generate map for describeClusterSecurityGroups, describeClusterSecurityGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-security-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-security-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cluster-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Call describeClusterSecurityGroups, describeClusterSecurityGroups"}
   [credentials2708 & args2709]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2710
     (com.palletops.awaze.common/aws-client :redshift credentials2708)]
    (clojure.core/case
     (clojure.core/count args2709)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2710
       describeClusterSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2710
       describeClusterSecurityGroups
       (redshift/describe-cluster-security-groups-request
        (clojure.core/nth args2709 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameter-groups
   [m2711]
   (clojure.core/let
    [credentials2712 (:credentials m2711) args2713 (:args m2711)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2714
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2712)]
     (clojure.core/case
      (clojure.core/count args2713)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2714
        describeClusterParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2714
        describeClusterParameterGroups
        (redshift/describe-cluster-parameter-groups-request
         (clojure.core/nth args2713 0))))))))
  (clojure.core/defn
   describe-cluster-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeClusterParameterGroups, describeClusterParameterGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cluster-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeClusterParameterGroups, describeClusterParameterGroups"}
   [credentials2716 & args2717]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2718
     (com.palletops.awaze.common/aws-client :redshift credentials2716)]
    (clojure.core/case
     (clojure.core/count args2717)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2718
       describeClusterParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2718
       describeClusterParameterGroups
       (redshift/describe-cluster-parameter-groups-request
        (clojure.core/nth args2717 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-snapshot-copy
   [m2719]
   (clojure.core/let
    [credentials2720 (:credentials m2719) args2721 (:args m2719)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2722
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2720)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2722
       enableSnapshotCopy
       (redshift/enable-snapshot-copy-request
        (clojure.core/nth args2721 0)))))))
  (clojure.core/defn
   enable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         destination-region
                         cluster-identifier]}]]),
    :doc "Generate map for enableSnapshotCopy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :enable-snapshot-copy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   enable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         destination-region
                         cluster-identifier]}]]),
    :doc "Call enableSnapshotCopy"}
   [credentials2724 & args2725]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2726
     (com.palletops.awaze.common/aws-client :redshift credentials2724)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2726
      enableSnapshotCopy
      (redshift/enable-snapshot-copy-request
       (clojure.core/nth args2725 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster
   [m2727]
   (clojure.core/let
    [credentials2728 (:credentials m2727) args2729 (:args m2727)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2730
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2728)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2730
       createCluster
       (redshift/create-cluster-request (clojure.core/nth args2729 0)))))))
  (clojure.core/defn
   create-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         encrypted
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         master-username
                         dbname
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         port
                         elastic-ip
                         cluster-version
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Generate map for createCluster"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-cluster
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         encrypted
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         master-username
                         dbname
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         port
                         elastic-ip
                         cluster-version
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Call createCluster"}
   [credentials2732 & args2733]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2734
     (com.palletops.awaze.common/aws-client :redshift credentials2732)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2734
      createCluster
      (redshift/create-cluster-request (clojure.core/nth args2733 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-snapshot-access
   [m2735]
   (clojure.core/let
    [credentials2736 (:credentials m2735) args2737 (:args m2735)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2738
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2736)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2738
       authorizeSnapshotAccess
       (redshift/authorize-snapshot-access-request
        (clojure.core/nth args2737 0)))))))
  (clojure.core/defn
   authorize-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Generate map for authorizeSnapshotAccess"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :authorize-snapshot-access,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   authorize-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Call authorizeSnapshotAccess"}
   [credentials2740 & args2741]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2742
     (com.palletops.awaze.common/aws-client :redshift credentials2740)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2742
      authorizeSnapshotAccess
      (redshift/authorize-snapshot-access-request
       (clojure.core/nth args2741 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-subnet-groups
   [m2743]
   (clojure.core/let
    [credentials2744 (:credentials m2743) args2745 (:args m2743)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2746
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2744)]
     (clojure.core/case
      (clojure.core/count args2745)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2746
        describeClusterSubnetGroups
        (redshift/describe-cluster-subnet-groups-request
         (clojure.core/nth args2745 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2746
        describeClusterSubnetGroups))))))
  (clojure.core/defn
   describe-cluster-subnet-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-subnet-group-name]}]
                [credentials]]),
    :doc "Generate map for describeClusterSubnetGroups, describeClusterSubnetGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cluster-subnet-groups
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-subnet-group-name]}]
                [credentials]]),
    :doc "Call describeClusterSubnetGroups, describeClusterSubnetGroups"}
   [credentials2748 & args2749]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2750
     (com.palletops.awaze.common/aws-client :redshift credentials2748)]
    (clojure.core/case
     (clojure.core/count args2749)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2750
       describeClusterSubnetGroups
       (redshift/describe-cluster-subnet-groups-request
        (clojure.core/nth args2749 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2750
       describeClusterSubnetGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-logging
   [m2751]
   (clojure.core/let
    [credentials2752 (:credentials m2751) args2753 (:args m2751)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2754
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2752)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2754
       enableLogging
       (redshift/enable-logging-request (clojure.core/nth args2753 0)))))))
  (clojure.core/defn
   enable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         general-progress-listener
                         cluster-identifier
                         bucket-name]}]]),
    :doc "Generate map for enableLogging"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :enable-logging,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   enable-logging
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         general-progress-listener
                         cluster-identifier
                         bucket-name]}]]),
    :doc "Call enableLogging"}
   [credentials2756 & args2757]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2758
     (com.palletops.awaze.common/aws-client :redshift credentials2756)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2758
      enableLogging
      (redshift/enable-logging-request (clojure.core/nth args2757 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-clusters
   [m2759]
   (clojure.core/let
    [credentials2760 (:credentials m2759) args2761 (:args m2759)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2762
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2760)]
     (clojure.core/case
      (clojure.core/count args2761)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2762
        describeClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2762
        describeClusters
        (redshift/describe-clusters-request
         (clojure.core/nth args2761 0))))))))
  (clojure.core/defn
   describe-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Generate map for describeClusters, describeClusters"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-clusters,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-clusters,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Call describeClusters, describeClusters"}
   [credentials2764 & args2765]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2766
     (com.palletops.awaze.common/aws-client :redshift credentials2764)]
    (clojure.core/case
     (clojure.core/count args2765)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2766
       describeClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2766
       describeClusters
       (redshift/describe-clusters-request
        (clojure.core/nth args2765 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-from-cluster-snapshot
   [m2767]
   (clojure.core/let
    [credentials2768 (:credentials m2767) args2769 (:args m2767)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2770
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2768)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2770
       restoreFromClusterSnapshot
       (redshift/restore-from-cluster-snapshot-request
        (clojure.core/nth args2769 0)))))))
  (clojure.core/defn
   restore-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         owner-account
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         vpc-security-group-ids
                         port
                         elastic-ip
                         snapshot-identifier
                         snapshot-cluster-identifier
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Generate map for restoreFromClusterSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :restore-from-cluster-snapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   restore-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         owner-account
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         vpc-security-group-ids
                         port
                         elastic-ip
                         snapshot-identifier
                         snapshot-cluster-identifier
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Call restoreFromClusterSnapshot"}
   [credentials2772 & args2773]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2774
     (com.palletops.awaze.common/aws-client :redshift credentials2772)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2774
      restoreFromClusterSnapshot
      (redshift/restore-from-cluster-snapshot-request
       (clojure.core/nth args2773 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-snapshot-access
   [m2775]
   (clojure.core/let
    [credentials2776 (:credentials m2775) args2777 (:args m2775)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2778
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2776)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2778
       revokeSnapshotAccess
       (redshift/revoke-snapshot-access-request
        (clojure.core/nth args2777 0)))))))
  (clojure.core/defn
   revoke-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Generate map for revokeSnapshotAccess"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :revoke-snapshot-access,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   revoke-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Call revokeSnapshotAccess"}
   [credentials2780 & args2781]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2782
     (com.palletops.awaze.common/aws-client :redshift credentials2780)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2782
      revokeSnapshotAccess
      (redshift/revoke-snapshot-access-request
       (clojure.core/nth args2781 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :rotate-encryption-key
   [m2783]
   (clojure.core/let
    [credentials2784 (:credentials m2783) args2785 (:args m2783)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2786
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2784)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2786
       rotateEncryptionKey
       (redshift/rotate-encryption-key-request
        (clojure.core/nth args2785 0)))))))
  (clojure.core/defn
   rotate-encryption-key-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for rotateEncryptionKey"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :rotate-encryption-key,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   rotate-encryption-key
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call rotateEncryptionKey"}
   [credentials2788 & args2789]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2790
     (com.palletops.awaze.common/aws-client :redshift credentials2788)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2790
      rotateEncryptionKey
      (redshift/rotate-encryption-key-request
       (clojure.core/nth args2789 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-logging
   [m2791]
   (clojure.core/let
    [credentials2792 (:credentials m2791) args2793 (:args m2791)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2794
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2792)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2794
       disableLogging
       (redshift/disable-logging-request
        (clojure.core/nth args2793 0)))))))
  (clojure.core/defn
   disable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for disableLogging"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :disable-logging,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   disable-logging
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call disableLogging"}
   [credentials2796 & args2797]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2798
     (com.palletops.awaze.common/aws-client :redshift credentials2796)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2798
      disableLogging
      (redshift/disable-logging-request (clojure.core/nth args2797 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-security-group
   [m2799]
   (clojure.core/let
    [credentials2800 (:credentials m2799) args2801 (:args m2799)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2802
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2800)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2802
       deleteClusterSecurityGroup
       (redshift/delete-cluster-security-group-request
        (clojure.core/nth args2801 0)))))))
  (clojure.core/defn
   delete-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Generate map for deleteClusterSecurityGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-security-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Call deleteClusterSecurityGroup"}
   [credentials2804 & args2805]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2806
     (com.palletops.awaze.common/aws-client :redshift credentials2804)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2806
      deleteClusterSecurityGroup
      (redshift/delete-cluster-security-group-request
       (clojure.core/nth args2805 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameters
   [m2807]
   (clojure.core/let
    [credentials2808 (:credentials m2807) args2809 (:args m2807)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2810
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2808)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2810
       describeClusterParameters
       (redshift/describe-cluster-parameters-request
        (clojure.core/nth args2809 0)))))))
  (clojure.core/defn
   describe-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeClusterParameters"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-parameters,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [source
                         parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeClusterParameters"}
   [credentials2812 & args2813]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2814
     (com.palletops.awaze.common/aws-client :redshift credentials2812)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2814
      describeClusterParameters
      (redshift/describe-cluster-parameters-request
       (clojure.core/nth args2813 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-event-subscription
   [m2815]
   (clojure.core/let
    [credentials2816 (:credentials m2815) args2817 (:args m2815)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2818
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2816)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2818
       createEventSubscription
       (redshift/create-event-subscription-request
        (clojure.core/nth args2817 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-event-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Call createEventSubscription"}
   [credentials2820 & args2821]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2822
     (com.palletops.awaze.common/aws-client :redshift credentials2820)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2822
      createEventSubscription
      (redshift/create-event-subscription-request
       (clojure.core/nth args2821 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reset-cluster-parameter-group
   [m2823]
   (clojure.core/let
    [credentials2824 (:credentials m2823) args2825 (:args m2823)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2826
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2824)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2826
       resetClusterParameterGroup
       (redshift/reset-cluster-parameter-group-request
        (clojure.core/nth args2825 0)))))))
  (clojure.core/defn
   reset-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for resetClusterParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :reset-cluster-parameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reset-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Call resetClusterParameterGroup"}
   [credentials2828 & args2829]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2830
     (com.palletops.awaze.common/aws-client :redshift credentials2828)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2830
      resetClusterParameterGroup
      (redshift/reset-cluster-parameter-group-request
       (clojure.core/nth args2829 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-parameter-group
   [m2831]
   (clojure.core/let
    [credentials2832 (:credentials m2831) args2833 (:args m2831)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2834
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2832)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2834
       createClusterParameterGroup
       (redshift/create-cluster-parameter-group-request
        (clojure.core/nth args2833 0)))))))
  (clojure.core/defn
   create-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         parameter-group-family
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for createClusterParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-parameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         parameter-group-family
                         general-progress-listener
                         description]}]]),
    :doc "Call createClusterParameterGroup"}
   [credentials2836 & args2837]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2838
     (com.palletops.awaze.common/aws-client :redshift credentials2836)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2838
      createClusterParameterGroup
      (redshift/create-cluster-parameter-group-request
       (clojure.core/nth args2837 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-configuration
   [m2839]
   (clojure.core/let
    [credentials2840 (:credentials m2839) args2841 (:args m2839)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2842
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2840)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2842
       deleteHsmConfiguration
       (redshift/delete-hsm-configuration-request
        (clojure.core/nth args2841 0)))))))
  (clojure.core/defn
   delete-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for deleteHsmConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-hsm-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         general-progress-listener]}]]),
    :doc "Call deleteHsmConfiguration"}
   [credentials2844 & args2845]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2846
     (com.palletops.awaze.common/aws-client :redshift credentials2844)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2846
      deleteHsmConfiguration
      (redshift/delete-hsm-configuration-request
       (clojure.core/nth args2845 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-event-subscription
   [m2847]
   (clojure.core/let
    [credentials2848 (:credentials m2847) args2849 (:args m2847)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2850
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2848)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2850
       modifyEventSubscription
       (redshift/modify-event-subscription-request
        (clojure.core/nth args2849 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-event-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials2852 & args2853]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2854
     (com.palletops.awaze.common/aws-client :redshift credentials2852)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2854
      modifyEventSubscription
      (redshift/modify-event-subscription-request
       (clojure.core/nth args2853 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-nodes
   [m2855]
   (clojure.core/let
    [credentials2856 (:credentials m2855) args2857 (:args m2855)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2858
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2856)]
     (clojure.core/case
      (clojure.core/count args2857)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2858
        describeReservedNodes
        (redshift/describe-reserved-nodes-request
         (clojure.core/nth args2857 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2858
        describeReservedNodes))))))
  (clojure.core/defn
   describe-reserved-nodes-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-id
                         max-records
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeReservedNodes, describeReservedNodes"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-reserved-nodes,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-reserved-nodes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-reserved-nodes
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-id
                         max-records
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeReservedNodes, describeReservedNodes"}
   [credentials2860 & args2861]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2862
     (com.palletops.awaze.common/aws-client :redshift credentials2860)]
    (clojure.core/case
     (clojure.core/count args2861)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2862
       describeReservedNodes
       (redshift/describe-reserved-nodes-request
        (clojure.core/nth args2861 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2862
       describeReservedNodes))))))
 (do
  (clojure.core/defmethod
   redshift
   :copy-cluster-snapshot
   [m2863]
   (clojure.core/let
    [credentials2864 (:credentials m2863) args2865 (:args m2863)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2866
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2864)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2866
       copyClusterSnapshot
       (redshift/copy-cluster-snapshot-request
        (clojure.core/nth args2865 0)))))))
  (clojure.core/defn
   copy-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-identifier
                         source-snapshot-identifier
                         source-snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for copyClusterSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :copy-cluster-snapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   copy-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-identifier
                         source-snapshot-identifier
                         source-snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Call copyClusterSnapshot"}
   [credentials2868 & args2869]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2870
     (com.palletops.awaze.common/aws-client :redshift credentials2868)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2870
      copyClusterSnapshot
      (redshift/copy-cluster-snapshot-request
       (clojure.core/nth args2869 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-client-certificate
   [m2871]
   (clojure.core/let
    [credentials2872 (:credentials m2871) args2873 (:args m2871)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2874
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2872)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2874
       deleteHsmClientCertificate
       (redshift/delete-hsm-client-certificate-request
        (clojure.core/nth args2873 0)))))))
  (clojure.core/defn
   delete-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for deleteHsmClientCertificate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-hsm-client-certificate,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Call deleteHsmClientCertificate"}
   [credentials2876 & args2877]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2878
     (com.palletops.awaze.common/aws-client :redshift credentials2876)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2878
      deleteHsmClientCertificate
      (redshift/delete-hsm-client-certificate-request
       (clojure.core/nth args2877 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-subnet-group
   [m2879]
   (clojure.core/let
    [credentials2880 (:credentials m2879) args2881 (:args m2879)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2882
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2880)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2882
       modifyClusterSubnetGroup
       (redshift/modify-cluster-subnet-group-request
        (clojure.core/nth args2881 0)))))))
  (clojure.core/defn
   modify-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for modifyClusterSubnetGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster-subnet-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Call modifyClusterSubnetGroup"}
   [credentials2884 & args2885]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2886
     (com.palletops.awaze.common/aws-client :redshift credentials2884)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2886
      modifyClusterSubnetGroup
      (redshift/modify-cluster-subnet-group-request
       (clojure.core/nth args2885 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-logging-status
   [m2887]
   (clojure.core/let
    [credentials2888 (:credentials m2887) args2889 (:args m2887)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2890
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2888)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2890
       describeLoggingStatus
       (redshift/describe-logging-status-request
        (clojure.core/nth args2889 0)))))))
  (clojure.core/defn
   describe-logging-status-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for describeLoggingStatus"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-logging-status,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-logging-status
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call describeLoggingStatus"}
   [credentials2892 & args2893]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2894
     (com.palletops.awaze.common/aws-client :redshift credentials2892)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2894
      describeLoggingStatus
      (redshift/describe-logging-status-request
       (clojure.core/nth args2893 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-events
   [m2895]
   (clojure.core/let
    [credentials2896 (:credentials m2895) args2897 (:args m2895)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2898
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2896)]
     (clojure.core/case
      (clojure.core/count args2897)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2898
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2898
        describeEvents
        (redshift/describe-events-request
         (clojure.core/nth args2897 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-events,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-events,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials2900 & args2901]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2902
     (com.palletops.awaze.common/aws-client :redshift credentials2900)]
    (clojure.core/case
     (clojure.core/count args2901)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2902
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2902
       describeEvents
       (redshift/describe-events-request
        (clojure.core/nth args2901 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-parameter-group
   [m2903]
   (clojure.core/let
    [credentials2904 (:credentials m2903) args2905 (:args m2903)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2906
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2904)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2906
       deleteClusterParameterGroup
       (redshift/delete-cluster-parameter-group-request
        (clojure.core/nth args2905 0)))))))
  (clojure.core/defn
   delete-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteClusterParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-parameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         general-progress-listener]}]]),
    :doc "Call deleteClusterParameterGroup"}
   [credentials2908 & args2909]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2910
     (com.palletops.awaze.common/aws-client :redshift credentials2908)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2910
      deleteClusterParameterGroup
      (redshift/delete-cluster-parameter-group-request
       (clojure.core/nth args2909 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-cluster-security-group-ingress
   [m2911]
   (clojure.core/let
    [credentials2912 (:credentials m2911) args2913 (:args m2911)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2914
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2912)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2914
       authorizeClusterSecurityGroupIngress
       (redshift/authorize-cluster-security-group-ingress-request
        (clojure.core/nth args2913 0)))))))
  (clojure.core/defn
   authorize-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Generate map for authorizeClusterSecurityGroupIngress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :authorize-cluster-security-group-ingress,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   authorize-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Call authorizeClusterSecurityGroupIngress"}
   [credentials2916 & args2917]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2918
     (com.palletops.awaze.common/aws-client :redshift credentials2916)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2918
      authorizeClusterSecurityGroupIngress
      (redshift/authorize-cluster-security-group-ingress-request
       (clojure.core/nth args2917 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster
   [m2919]
   (clojure.core/let
    [credentials2920 (:credentials m2919) args2921 (:args m2919)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2922
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2920)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2922
       modifyCluster
       (redshift/modify-cluster-request (clojure.core/nth args2921 0)))))))
  (clojure.core/defn
   modify-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         new-cluster-identifier
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         cluster-version
                         allow-version-upgrade]}]]),
    :doc "Generate map for modifyCluster"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-cluster
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         new-cluster-identifier
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         cluster-version
                         allow-version-upgrade]}]]),
    :doc "Call modifyCluster"}
   [credentials2924 & args2925]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2926
     (com.palletops.awaze.common/aws-client :redshift credentials2924)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2926
      modifyCluster
      (redshift/modify-cluster-request (clojure.core/nth args2925 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-subnet-group
   [m2927]
   (clojure.core/let
    [credentials2928 (:credentials m2927) args2929 (:args m2927)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2930
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2928)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2930
       deleteClusterSubnetGroup
       (redshift/delete-cluster-subnet-group-request
        (clojure.core/nth args2929 0)))))))
  (clojure.core/defn
   delete-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for deleteClusterSubnetGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-subnet-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-subnet-group-name]}]]),
    :doc "Call deleteClusterSubnetGroup"}
   [credentials2932 & args2933]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2934
     (com.palletops.awaze.common/aws-client :redshift credentials2932)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2934
      deleteClusterSubnetGroup
      (redshift/delete-cluster-subnet-group-request
       (clojure.core/nth args2933 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-subnet-group
   [m2935]
   (clojure.core/let
    [credentials2936 (:credentials m2935) args2937 (:args m2935)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2938
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2936)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2938
       createClusterSubnetGroup
       (redshift/create-cluster-subnet-group-request
        (clojure.core/nth args2937 0)))))))
  (clojure.core/defn
   create-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for createClusterSubnetGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-subnet-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Call createClusterSubnetGroup"}
   [credentials2940 & args2941]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2942
     (com.palletops.awaze.common/aws-client :redshift credentials2940)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2942
      createClusterSubnetGroup
      (redshift/create-cluster-subnet-group-request
       (clojure.core/nth args2941 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :purchase-reserved-node-offering
   [m2943]
   (clojure.core/let
    [credentials2944 (:credentials m2943) args2945 (:args m2943)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2946
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2944)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2946
       purchaseReservedNodeOffering
       (redshift/purchase-reserved-node-offering-request
        (clojure.core/nth args2945 0)))))))
  (clojure.core/defn
   purchase-reserved-node-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-offering-id
                         node-count
                         general-progress-listener]}]]),
    :doc "Generate map for purchaseReservedNodeOffering"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :purchase-reserved-node-offering,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   purchase-reserved-node-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-offering-id
                         node-count
                         general-progress-listener]}]]),
    :doc "Call purchaseReservedNodeOffering"}
   [credentials2948 & args2949]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2950
     (com.palletops.awaze.common/aws-client :redshift credentials2948)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2950
      purchaseReservedNodeOffering
      (redshift/purchase-reserved-node-offering-request
       (clojure.core/nth args2949 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-node-offerings
   [m2951]
   (clojure.core/let
    [credentials2952 (:credentials m2951) args2953 (:args m2951)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2954
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2952)]
     (clojure.core/case
      (clojure.core/count args2953)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2954
        describeReservedNodeOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2954
        describeReservedNodeOfferings
        (redshift/describe-reserved-node-offerings-request
         (clojure.core/nth args2953 0))))))))
  (clojure.core/defn
   describe-reserved-node-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-node-offering-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeReservedNodeOfferings, describeReservedNodeOfferings"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-reserved-node-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-node-offering-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeReservedNodeOfferings, describeReservedNodeOfferings"}
   [credentials2956 & args2957]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2958
     (com.palletops.awaze.common/aws-client :redshift credentials2956)]
    (clojure.core/case
     (clojure.core/count args2957)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2958
       describeReservedNodeOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2958
       describeReservedNodeOfferings
       (redshift/describe-reserved-node-offerings-request
        (clojure.core/nth args2957 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster
   [m2959]
   (clojure.core/let
    [credentials2960 (:credentials m2959) args2961 (:args m2959)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2962
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2960)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2962
       deleteCluster
       (redshift/delete-cluster-request (clojure.core/nth args2961 0)))))))
  (clojure.core/defn
   delete-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-cluster-snapshot
                         general-progress-listener
                         final-cluster-snapshot-identifier
                         cluster-identifier]}]]),
    :doc "Generate map for deleteCluster"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-cluster
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-cluster-snapshot
                         general-progress-listener
                         final-cluster-snapshot-identifier
                         cluster-identifier]}]]),
    :doc "Call deleteCluster"}
   [credentials2964 & args2965]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2966
     (com.palletops.awaze.common/aws-client :redshift credentials2964)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2966
      deleteCluster
      (redshift/delete-cluster-request (clojure.core/nth args2965 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-security-group
   [m2967]
   (clojure.core/let
    [credentials2968 (:credentials m2967) args2969 (:args m2967)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2970
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2968)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2970
       createClusterSecurityGroup
       (redshift/create-cluster-security-group-request
        (clojure.core/nth args2969 0)))))))
  (clojure.core/defn
   create-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cluster-security-group-name]}]]),
    :doc "Generate map for createClusterSecurityGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-security-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cluster-security-group-name]}]]),
    :doc "Call createClusterSecurityGroup"}
   [credentials2972 & args2973]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2974
     (com.palletops.awaze.common/aws-client :redshift credentials2972)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2974
      createClusterSecurityGroup
      (redshift/create-cluster-security-group-request
       (clojure.core/nth args2973 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-subscriptions
   [m2975]
   (clojure.core/let
    [credentials2976 (:credentials m2975) args2977 (:args m2975)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2978
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2976)]
     (clojure.core/case
      (clojure.core/count args2977)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2978
        describeEventSubscriptions
        (redshift/describe-event-subscriptions-request
         (clojure.core/nth args2977 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2978
        describeEventSubscriptions))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-event-subscriptions,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-event-subscriptions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials2980 & args2981]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2982
     (com.palletops.awaze.common/aws-client :redshift credentials2980)]
    (clojure.core/case
     (clojure.core/count args2981)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2982
       describeEventSubscriptions
       (redshift/describe-event-subscriptions-request
        (clojure.core/nth args2981 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2982
       describeEventSubscriptions))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-default-cluster-parameters
   [m2983]
   (clojure.core/let
    [credentials2984 (:credentials m2983) args2985 (:args m2983)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2986
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2984)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2986
       describeDefaultClusterParameters
       (redshift/describe-default-cluster-parameters-request
        (clojure.core/nth args2985 0)))))))
  (clojure.core/defn
   describe-default-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-family
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeDefaultClusterParameters"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-default-cluster-parameters,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-default-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-family
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeDefaultClusterParameters"}
   [credentials2988 & args2989]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2990
     (com.palletops.awaze.common/aws-client :redshift credentials2988)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2990
      describeDefaultClusterParameters
      (redshift/describe-default-cluster-parameters-request
       (clojure.core/nth args2989 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-configurations
   [m2991]
   (clojure.core/let
    [credentials2992 (:credentials m2991) args2993 (:args m2991)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2994
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2992)]
     (clojure.core/case
      (clojure.core/count args2993)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2994
        describeHsmConfigurations
        (redshift/describe-hsm-configurations-request
         (clojure.core/nth args2993 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2994
        describeHsmConfigurations))))))
  (clojure.core/defn
   describe-hsm-configurations-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         hsm-configuration-identifier
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeHsmConfigurations, describeHsmConfigurations"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-hsm-configurations,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-hsm-configurations,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-hsm-configurations
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         hsm-configuration-identifier
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeHsmConfigurations, describeHsmConfigurations"}
   [credentials2996 & args2997]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2998
     (com.palletops.awaze.common/aws-client :redshift credentials2996)]
    (clojure.core/case
     (clojure.core/count args2997)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2998
       describeHsmConfigurations
       (redshift/describe-hsm-configurations-request
        (clojure.core/nth args2997 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2998
       describeHsmConfigurations))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-snapshot
   [m2999]
   (clojure.core/let
    [credentials3000 (:credentials m2999) args3001 (:args m2999)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3002
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3000)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3002
       createClusterSnapshot
       (redshift/create-cluster-snapshot-request
        (clojure.core/nth args3001 0)))))))
  (clojure.core/defn
   create-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Generate map for createClusterSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-snapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Call createClusterSnapshot"}
   [credentials3004 & args3005]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3006
     (com.palletops.awaze.common/aws-client :redshift credentials3004)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3006
      createClusterSnapshot
      (redshift/create-cluster-snapshot-request
       (clojure.core/nth args3005 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-versions
   [m3007]
   (clojure.core/let
    [credentials3008 (:credentials m3007) args3009 (:args m3007)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3010
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3008)]
     (clojure.core/case
      (clojure.core/count args3009)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3010
        describeClusterVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3010
        describeClusterVersions
        (redshift/describe-cluster-versions-request
         (clojure.core/nth args3009 0))))))))
  (clojure.core/defn
   describe-cluster-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-version
                         cluster-parameter-group-family]}]]),
    :doc "Generate map for describeClusterVersions, describeClusterVersions"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-versions,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-versions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cluster-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-version
                         cluster-parameter-group-family]}]]),
    :doc "Call describeClusterVersions, describeClusterVersions"}
   [credentials3012 & args3013]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3014
     (com.palletops.awaze.common/aws-client :redshift credentials3012)]
    (clojure.core/case
     (clojure.core/count args3013)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3014
       describeClusterVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3014
       describeClusterVersions
       (redshift/describe-cluster-versions-request
        (clojure.core/nth args3013 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-snapshot-copy
   [m3015]
   (clojure.core/let
    [credentials3016 (:credentials m3015) args3017 (:args m3015)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3018
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3016)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3018
       disableSnapshotCopy
       (redshift/disable-snapshot-copy-request
        (clojure.core/nth args3017 0)))))))
  (clojure.core/defn
   disable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for disableSnapshotCopy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :disable-snapshot-copy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   disable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call disableSnapshotCopy"}
   [credentials3020 & args3021]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3022
     (com.palletops.awaze.common/aws-client :redshift credentials3020)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3022
      disableSnapshotCopy
      (redshift/disable-snapshot-copy-request
       (clojure.core/nth args3021 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-event-subscription
   [m3023]
   (clojure.core/let
    [credentials3024 (:credentials m3023) args3025 (:args m3023)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3026
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3024)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3026
       deleteEventSubscription
       (redshift/delete-event-subscription-request
        (clojure.core/nth args3025 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-event-subscription,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials3028 & args3029]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3030
     (com.palletops.awaze.common/aws-client :redshift credentials3028)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3030
      deleteEventSubscription
      (redshift/delete-event-subscription-request
       (clojure.core/nth args3029 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-snapshot-copy-retention-period
   [m3031]
   (clojure.core/let
    [credentials3032 (:credentials m3031) args3033 (:args m3031)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3034
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3032)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3034
       modifySnapshotCopyRetentionPeriod
       (redshift/modify-snapshot-copy-retention-period-request
        (clojure.core/nth args3033 0)))))))
  (clojure.core/defn
   modify-snapshot-copy-retention-period-map
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Generate map for modifySnapshotCopyRetentionPeriod"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-snapshot-copy-retention-period,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-snapshot-copy-retention-period
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Call modifySnapshotCopyRetentionPeriod"}
   [credentials3036 & args3037]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3038
     (com.palletops.awaze.common/aws-client :redshift credentials3036)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3038
      modifySnapshotCopyRetentionPeriod
      (redshift/modify-snapshot-copy-retention-period-request
       (clojure.core/nth args3037 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reboot-cluster
   [m3039]
   (clojure.core/let
    [credentials3040 (:credentials m3039) args3041 (:args m3039)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3042
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3040)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3042
       rebootCluster
       (redshift/reboot-cluster-request (clojure.core/nth args3041 0)))))))
  (clojure.core/defn
   reboot-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for rebootCluster"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :reboot-cluster,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reboot-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call rebootCluster"}
   [credentials3044 & args3045]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3046
     (com.palletops.awaze.common/aws-client :redshift credentials3044)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3046
      rebootCluster
      (redshift/reboot-cluster-request (clojure.core/nth args3045 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-resize
   [m3047]
   (clojure.core/let
    [credentials3048 (:credentials m3047) args3049 (:args m3047)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3050
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3048)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3050
       describeResize
       (redshift/describe-resize-request
        (clojure.core/nth args3049 0)))))))
  (clojure.core/defn
   describe-resize-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for describeResize"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-resize,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-resize
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call describeResize"}
   [credentials3052 & args3053]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3054
     (com.palletops.awaze.common/aws-client :redshift credentials3052)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3054
      describeResize
      (redshift/describe-resize-request (clojure.core/nth args3053 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-cluster-security-group-ingress
   [m3055]
   (clojure.core/let
    [credentials3056 (:credentials m3055) args3057 (:args m3055)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3058
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3056)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3058
       revokeClusterSecurityGroupIngress
       (redshift/revoke-cluster-security-group-ingress-request
        (clojure.core/nth args3057 0)))))))
  (clojure.core/defn
   revoke-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Generate map for revokeClusterSecurityGroupIngress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :revoke-cluster-security-group-ingress,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   revoke-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Call revokeClusterSecurityGroupIngress"}
   [credentials3060 & args3061]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3062
     (com.palletops.awaze.common/aws-client :redshift credentials3060)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3062
      revokeClusterSecurityGroupIngress
      (redshift/revoke-cluster-security-group-ingress-request
       (clojure.core/nth args3061 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-parameter-group
   [m3063]
   (clojure.core/let
    [credentials3064 (:credentials m3063) args3065 (:args m3063)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3066
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3064)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3066
       modifyClusterParameterGroup
       (redshift/modify-cluster-parameter-group-request
        (clojure.core/nth args3065 0)))))))
  (clojure.core/defn
   modify-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for modifyClusterParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster-parameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Call modifyClusterParameterGroup"}
   [credentials3068 & args3069]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3070
     (com.palletops.awaze.common/aws-client :redshift credentials3068)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3070
      modifyClusterParameterGroup
      (redshift/modify-cluster-parameter-group-request
       (clojure.core/nth args3069 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-client-certificates
   [m3071]
   (clojure.core/let
    [credentials3072 (:credentials m3071) args3073 (:args m3071)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3074
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3072)]
     (clojure.core/case
      (clojure.core/count args3073)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3074
        describeHsmClientCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3074
        describeHsmClientCertificates
        (redshift/describe-hsm-client-certificates-request
         (clojure.core/nth args3073 0))))))))
  (clojure.core/defn
   describe-hsm-client-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for describeHsmClientCertificates, describeHsmClientCertificates"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-hsm-client-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Call describeHsmClientCertificates, describeHsmClientCertificates"}
   [credentials3076 & args3077]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3078
     (com.palletops.awaze.common/aws-client :redshift credentials3076)]
    (clojure.core/case
     (clojure.core/count args3077)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3078
       describeHsmClientCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3078
       describeHsmClientCertificates
       (redshift/describe-hsm-client-certificates-request
        (clojure.core/nth args3077 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-client-certificate
   [m3079]
   (clojure.core/let
    [credentials3080 (:credentials m3079) args3081 (:args m3079)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3082
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3080)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3082
       createHsmClientCertificate
       (redshift/create-hsm-client-certificate-request
        (clojure.core/nth args3081 0)))))))
  (clojure.core/defn
   create-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for createHsmClientCertificate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-hsm-client-certificate,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Call createHsmClientCertificate"}
   [credentials3084 & args3085]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3086
     (com.palletops.awaze.common/aws-client :redshift credentials3084)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3086
      createHsmClientCertificate
      (redshift/create-hsm-client-certificate-request
       (clojure.core/nth args3085 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-categories
   [m3087]
   (clojure.core/let
    [credentials3088 (:credentials m3087) args3089 (:args m3087)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3090
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3088)]
     (clojure.core/case
      (clojure.core/count args3089)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3090
        describeEventCategories
        (redshift/describe-event-categories-request
         (clojure.core/nth args3089 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3090
        describeEventCategories))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials
                 {:keys [source-type general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-event-categories,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-event-categories,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials
                 {:keys [source-type general-progress-listener]}]
                [credentials]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials3092 & args3093]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3094
     (com.palletops.awaze.common/aws-client :redshift credentials3092)]
    (clojure.core/case
     (clojure.core/count args3093)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3094
       describeEventCategories
       (redshift/describe-event-categories-request
        (clojure.core/nth args3093 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3094
       describeEventCategories))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-configuration
   [m3095]
   (clojure.core/let
    [credentials3096 (:credentials m3095) args3097 (:args m3095)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3098
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3096)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3098
       createHsmConfiguration
       (redshift/create-hsm-configuration-request
        (clojure.core/nth args3097 0)))))))
  (clojure.core/defn
   create-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         hsm-partition-name
                         hsm-configuration-identifier
                         hsm-partition-password
                         hsm-server-public-certificate
                         hsm-ip-address
                         description]}]]),
    :doc "Generate map for createHsmConfiguration"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-hsm-configuration,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         hsm-partition-name
                         hsm-configuration-identifier
                         hsm-partition-password
                         hsm-server-public-certificate
                         hsm-ip-address
                         description]}]]),
    :doc "Call createHsmConfiguration"}
   [credentials3100 & args3101]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3102
     (com.palletops.awaze.common/aws-client :redshift credentials3100)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3102
      createHsmConfiguration
      (redshift/create-hsm-configuration-request
       (clojure.core/nth args3101 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-snapshots
   [m3103]
   (clojure.core/let
    [credentials3104 (:credentials m3103) args3105 (:args m3103)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3106
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3104)]
     (clojure.core/case
      (clojure.core/count args3105)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3106
        describeClusterSnapshots
        (redshift/describe-cluster-snapshots-request
         (clojure.core/nth args3105 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3106
        describeClusterSnapshots))))))
  (clojure.core/defn
   describe-cluster-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         cluster-identifier
                         owner-account
                         max-records
                         start-time
                         marker
                         snapshot-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Generate map for describeClusterSnapshots, describeClusterSnapshots"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-snapshots,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-snapshots,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cluster-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         cluster-identifier
                         owner-account
                         max-records
                         start-time
                         marker
                         snapshot-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Call describeClusterSnapshots, describeClusterSnapshots"}
   [credentials3108 & args3109]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3110
     (com.palletops.awaze.common/aws-client :redshift credentials3108)]
    (clojure.core/case
     (clojure.core/count args3109)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3110
       describeClusterSnapshots
       (redshift/describe-cluster-snapshots-request
        (clojure.core/nth args3109 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3110
       describeClusterSnapshots))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-snapshot
   [m3111]
   (clojure.core/let
    [credentials3112 (:credentials m3111) args3113 (:args m3111)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3114
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3112)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3114
       deleteClusterSnapshot
       (redshift/delete-cluster-snapshot-request
        (clojure.core/nth args3113 0)))))))
  (clojure.core/defn
   delete-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for deleteClusterSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-snapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Call deleteClusterSnapshot"}
   [credentials3116 & args3117]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3118
     (com.palletops.awaze.common/aws-client :redshift credentials3116)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3118
      deleteClusterSnapshot
      (redshift/delete-cluster-snapshot-request
       (clojure.core/nth args3117 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-orderable-cluster-options
   [m3119]
   (clojure.core/let
    [credentials3120 (:credentials m3119) args3121 (:args m3119)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3122
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3120)]
     (clojure.core/case
      (clojure.core/count args3121)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3122
        describeOrderableClusterOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3122
        describeOrderableClusterOptions
        (redshift/describe-orderable-cluster-options-request
         (clojure.core/nth args3121 0))))))))
  (clojure.core/defn
   describe-orderable-cluster-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [node-type
                         max-records
                         marker
                         general-progress-listener
                         cluster-version]}]]),
    :doc "Generate map for describeOrderableClusterOptions, describeOrderableClusterOptions"}
   ([credentials__1649__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-orderable-cluster-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [node-type
                         max-records
                         marker
                         general-progress-listener
                         cluster-version]}]]),
    :doc "Call describeOrderableClusterOptions, describeOrderableClusterOptions"}
   [credentials3124 & args3125]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3126
     (com.palletops.awaze.common/aws-client :redshift credentials3124)]
    (clojure.core/case
     (clojure.core/count args3125)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3126
       describeOrderableClusterOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3126
       describeOrderableClusterOptions
       (redshift/describe-orderable-cluster-options-request
        (clojure.core/nth args3125 0)))))))))
