(ns
 com.palletops.awaze.iam
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.iam :as iam]
  [com.palletops.awaze.beans.identitymanagement
   :as
   identitymanagement]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :iam
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient
   credentials__1599__auto__))
 (clojure.core/defmulti
  iam
  (clojure.core/fn iam [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   iam
   :get-role-policy
   [m7941]
   (clojure.core/let
    [credentials7942 (:credentials m7941) args7943 (:args m7941)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7944
      (com.palletops.awaze.common/aws-client :iam credentials7942)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7944
       getRolePolicy
       (identitymanagement/get-role-policy-request
        (clojure.core/nth args7943 0)))))))
  (clojure.core/defn
   get-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for getRolePolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-role-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call getRolePolicy"}
   [credentials7946 & args7947]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7948
     (com.palletops.awaze.common/aws-client :iam credentials7946)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7948
      getRolePolicy
      (identitymanagement/get-role-policy-request
       (clojure.core/nth args7947 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :change-password
   [m7949]
   (clojure.core/let
    [credentials7950 (:credentials m7949) args7951 (:args m7949)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7952
      (com.palletops.awaze.common/aws-client :iam credentials7950)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7952
       changePassword
       (identitymanagement/change-password-request
        (clojure.core/nth args7951 0)))))))
  (clojure.core/defn
   change-password-map
   {:arglists (quote
               [[credentials
                 {:keys [old-password
                         new-password
                         general-progress-listener]}]]),
    :doc "Generate map for changePassword"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :change-password,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   change-password
   {:arglists (quote
               [[credentials
                 {:keys [old-password
                         new-password
                         general-progress-listener]}]]),
    :doc "Call changePassword"}
   [credentials7954 & args7955]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7956
     (com.palletops.awaze.common/aws-client :iam credentials7954)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7956
      changePassword
      (identitymanagement/change-password-request
       (clojure.core/nth args7955 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :deactivate-mfadevice
   [m7957]
   (clojure.core/let
    [credentials7958 (:credentials m7957) args7959 (:args m7957)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7960
      (com.palletops.awaze.common/aws-client :iam credentials7958)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7960
       deactivateMFADevice
       (identitymanagement/deactivate-mfadevice-request
        (clojure.core/nth args7959 0)))))))
  (clojure.core/defn
   deactivate-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener]}]]),
    :doc "Generate map for deactivateMFADevice"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :deactivate-mfadevice,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   deactivate-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener]}]]),
    :doc "Call deactivateMFADevice"}
   [credentials7962 & args7963]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7964
     (com.palletops.awaze.common/aws-client :iam credentials7962)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7964
      deactivateMFADevice
      (identitymanagement/deactivate-mfadevice-request
       (clojure.core/nth args7963 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :resync-mfadevice
   [m7965]
   (clojure.core/let
    [credentials7966 (:credentials m7965) args7967 (:args m7965)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7968
      (com.palletops.awaze.common/aws-client :iam credentials7966)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7968
       resyncMFADevice
       (identitymanagement/resync-mfadevice-request
        (clojure.core/nth args7967 0)))))))
  (clojure.core/defn
   resync-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Generate map for resyncMFADevice"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :resync-mfadevice,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   resync-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Call resyncMFADevice"}
   [credentials7970 & args7971]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7972
     (com.palletops.awaze.common/aws-client :iam credentials7970)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7972
      resyncMFADevice
      (identitymanagement/resync-mfadevice-request
       (clojure.core/nth args7971 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-login-profile
   [m7973]
   (clojure.core/let
    [credentials7974 (:credentials m7973) args7975 (:args m7973)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7976
      (com.palletops.awaze.common/aws-client :iam credentials7974)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7976
       updateLoginProfile
       (identitymanagement/update-login-profile-request
        (clojure.core/nth args7975 0)))))))
  (clojure.core/defn
   update-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Generate map for updateLoginProfile"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-login-profile,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Call updateLoginProfile"}
   [credentials7978 & args7979]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7980
     (com.palletops.awaze.common/aws-client :iam credentials7978)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7980
      updateLoginProfile
      (identitymanagement/update-login-profile-request
       (clojure.core/nth args7979 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-role-policy
   [m7981]
   (clojure.core/let
    [credentials7982 (:credentials m7981) args7983 (:args m7981)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7984
      (com.palletops.awaze.common/aws-client :iam credentials7982)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7984
       putRolePolicy
       (identitymanagement/put-role-policy-request
        (clojure.core/nth args7983 0)))))))
  (clojure.core/defn
   put-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Generate map for putRolePolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-role-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   put-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Call putRolePolicy"}
   [credentials7986 & args7987]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7988
     (com.palletops.awaze.common/aws-client :iam credentials7986)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7988
      putRolePolicy
      (identitymanagement/put-role-policy-request
       (clojure.core/nth args7987 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-signing-certificate
   [m7989]
   (clojure.core/let
    [credentials7990 (:credentials m7989) args7991 (:args m7989)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client7992
      (com.palletops.awaze.common/aws-client :iam credentials7990)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7992
       deleteSigningCertificate
       (identitymanagement/delete-signing-certificate-request
        (clojure.core/nth args7991 0)))))))
  (clojure.core/defn
   delete-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Generate map for deleteSigningCertificate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-signing-certificate,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Call deleteSigningCertificate"}
   [credentials7994 & args7995]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client7996
     (com.palletops.awaze.common/aws-client :iam credentials7994)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client7996
      deleteSigningCertificate
      (identitymanagement/delete-signing-certificate-request
       (clojure.core/nth args7995 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-samlprovider
   [m7997]
   (clojure.core/let
    [credentials7998 (:credentials m7997) args7999 (:args m7997)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8000
      (com.palletops.awaze.common/aws-client :iam credentials7998)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8000
       deleteSAMLProvider
       (identitymanagement/delete-samlprovider-request
        (clojure.core/nth args7999 0)))))))
  (clojure.core/defn
   delete-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Generate map for deleteSAMLProvider"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-samlprovider,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Call deleteSAMLProvider"}
   [credentials8002 & args8003]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8004
     (com.palletops.awaze.common/aws-client :iam credentials8002)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8004
      deleteSAMLProvider
      (identitymanagement/delete-samlprovider-request
       (clojure.core/nth args8003 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user
   [m8005]
   (clojure.core/let
    [credentials8006 (:credentials m8005) args8007 (:args m8005)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8008
      (com.palletops.awaze.common/aws-client :iam credentials8006)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8008
       deleteUser
       (identitymanagement/delete-user-request
        (clojure.core/nth args8007 0)))))))
  (clojure.core/defn
   delete-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for deleteUser"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-user,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call deleteUser"}
   [credentials8010 & args8011]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8012
     (com.palletops.awaze.common/aws-client :iam credentials8010)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8012
      deleteUser
      (identitymanagement/delete-user-request
       (clojure.core/nth args8011 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-user-to-group
   [m8013]
   (clojure.core/let
    [credentials8014 (:credentials m8013) args8015 (:args m8013)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8016
      (com.palletops.awaze.common/aws-client :iam credentials8014)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8016
       addUserToGroup
       (identitymanagement/add-user-to-group-request
        (clojure.core/nth args8015 0)))))))
  (clojure.core/defn
   add-user-to-group-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for addUserToGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :add-user-to-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-user-to-group
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call addUserToGroup"}
   [credentials8018 & args8019]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8020
     (com.palletops.awaze.common/aws-client :iam credentials8018)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8020
      addUserToGroup
      (identitymanagement/add-user-to-group-request
       (clojure.core/nth args8019 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-account-aliases
   [m8021]
   (clojure.core/let
    [credentials8022 (:credentials m8021) args8023 (:args m8021)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8024
      (com.palletops.awaze.common/aws-client :iam credentials8022)]
     (clojure.core/case
      (clojure.core/count args8023)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8024
        listAccountAliases))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8024
        listAccountAliases
        (identitymanagement/list-account-aliases-request
         (clojure.core/nth args8023 0))))))))
  (clojure.core/defn
   list-account-aliases-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Generate map for listAccountAliases, listAccountAliases"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :list-account-aliases,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-account-aliases,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-account-aliases
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Call listAccountAliases, listAccountAliases"}
   [credentials8026 & args8027]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8028
     (com.palletops.awaze.common/aws-client :iam credentials8026)]
    (clojure.core/case
     (clojure.core/count args8027)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8028
       listAccountAliases))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8028
       listAccountAliases
       (identitymanagement/list-account-aliases-request
        (clojure.core/nth args8027 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-user-from-group
   [m8029]
   (clojure.core/let
    [credentials8030 (:credentials m8029) args8031 (:args m8029)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8032
      (com.palletops.awaze.common/aws-client :iam credentials8030)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8032
       removeUserFromGroup
       (identitymanagement/remove-user-from-group-request
        (clojure.core/nth args8031 0)))))))
  (clojure.core/defn
   remove-user-from-group-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for removeUserFromGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :remove-user-from-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   remove-user-from-group
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call removeUserFromGroup"}
   [credentials8034 & args8035]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8036
     (com.palletops.awaze.common/aws-client :iam credentials8034)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8036
      removeUserFromGroup
      (identitymanagement/remove-user-from-group-request
       (clojure.core/nth args8035 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-group
   [m8037]
   (clojure.core/let
    [credentials8038 (:credentials m8037) args8039 (:args m8037)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8040
      (com.palletops.awaze.common/aws-client :iam credentials8038)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8040
       updateGroup
       (identitymanagement/update-group-request
        (clojure.core/nth args8039 0)))))))
  (clojure.core/defn
   update-group-map
   {:arglists (quote
               [[credentials
                 {:keys [new-path
                         new-group-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for updateGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-group
   {:arglists (quote
               [[credentials
                 {:keys [new-path
                         new-group-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call updateGroup"}
   [credentials8042 & args8043]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8044
     (com.palletops.awaze.common/aws-client :iam credentials8042)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8044
      updateGroup
      (identitymanagement/update-group-request
       (clojure.core/nth args8043 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-server-certificate
   [m8045]
   (clojure.core/let
    [credentials8046 (:credentials m8045) args8047 (:args m8045)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8048
      (com.palletops.awaze.common/aws-client :iam credentials8046)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8048
       updateServerCertificate
       (identitymanagement/update-server-certificate-request
        (clojure.core/nth args8047 0)))))))
  (clojure.core/defn
   update-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         new-server-certificate-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Generate map for updateServerCertificate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-server-certificate,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         new-server-certificate-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Call updateServerCertificate"}
   [credentials8050 & args8051]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8052
     (com.palletops.awaze.common/aws-client :iam credentials8050)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8052
      updateServerCertificate
      (identitymanagement/update-server-certificate-request
       (clojure.core/nth args8051 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role-policy
   [m8053]
   (clojure.core/let
    [credentials8054 (:credentials m8053) args8055 (:args m8053)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8056
      (com.palletops.awaze.common/aws-client :iam credentials8054)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8056
       deleteRolePolicy
       (identitymanagement/delete-role-policy-request
        (clojure.core/nth args8055 0)))))))
  (clojure.core/defn
   delete-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteRolePolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-role-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call deleteRolePolicy"}
   [credentials8058 & args8059]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8060
     (com.palletops.awaze.common/aws-client :iam credentials8058)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8060
      deleteRolePolicy
      (identitymanagement/delete-role-policy-request
       (clojure.core/nth args8059 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-access-key
   [m8061]
   (clojure.core/let
    [credentials8062 (:credentials m8061) args8063 (:args m8061)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8064
      (com.palletops.awaze.common/aws-client :iam credentials8062)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8064
       updateAccessKey
       (identitymanagement/update-access-key-request
        (clojure.core/nth args8063 0)))))))
  (clojure.core/defn
   update-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Generate map for updateAccessKey"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-access-key,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-access-key
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Call updateAccessKey"}
   [credentials8066 & args8067]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8068
     (com.palletops.awaze.common/aws-client :iam credentials8066)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8068
      updateAccessKey
      (identitymanagement/update-access-key-request
       (clojure.core/nth args8067 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group
   [m8069]
   (clojure.core/let
    [credentials8070 (:credentials m8069) args8071 (:args m8069)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8072
      (com.palletops.awaze.common/aws-client :iam credentials8070)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8072
       deleteGroup
       (identitymanagement/delete-group-request
        (clojure.core/nth args8071 0)))))))
  (clojure.core/defn
   delete-group-map
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Generate map for deleteGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-group
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Call deleteGroup"}
   [credentials8074 & args8075]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8076
     (com.palletops.awaze.common/aws-client :iam credentials8074)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8076
      deleteGroup
      (identitymanagement/delete-group-request
       (clojure.core/nth args8075 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups-for-user
   [m8077]
   (clojure.core/let
    [credentials8078 (:credentials m8077) args8079 (:args m8077)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8080
      (com.palletops.awaze.common/aws-client :iam credentials8078)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8080
       listGroupsForUser
       (identitymanagement/list-groups-for-user-request
        (clojure.core/nth args8079 0)))))))
  (clojure.core/defn
   list-groups-for-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listGroupsForUser"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-groups-for-user,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-groups-for-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listGroupsForUser"}
   [credentials8082 & args8083]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8084
     (com.palletops.awaze.common/aws-client :iam credentials8082)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8084
      listGroupsForUser
      (identitymanagement/list-groups-for-user-request
       (clojure.core/nth args8083 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-user-policy
   [m8085]
   (clojure.core/let
    [credentials8086 (:credentials m8085) args8087 (:args m8085)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8088
      (com.palletops.awaze.common/aws-client :iam credentials8086)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8088
       putUserPolicy
       (identitymanagement/put-user-policy-request
        (clojure.core/nth args8087 0)))))))
  (clojure.core/defn
   put-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Generate map for putUserPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-user-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   put-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Call putUserPolicy"}
   [credentials8090 & args8091]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8092
     (com.palletops.awaze.common/aws-client :iam credentials8090)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8092
      putUserPolicy
      (identitymanagement/put-user-policy-request
       (clojure.core/nth args8091 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role
   [m8093]
   (clojure.core/let
    [credentials8094 (:credentials m8093) args8095 (:args m8093)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8096
      (com.palletops.awaze.common/aws-client :iam credentials8094)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8096
       getRole
       (identitymanagement/get-role-request
        (clojure.core/nth args8095 0)))))))
  (clojure.core/defn
   get-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Generate map for getRole"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-role,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Call getRole"}
   [credentials8098 & args8099]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8100
     (com.palletops.awaze.common/aws-client :iam credentials8098)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8100
      getRole
      (identitymanagement/get-role-request
       (clojure.core/nth args8099 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-password-policy
   [m8101]
   (clojure.core/let
    [credentials8102 (:credentials m8101) args8103 (:args m8101)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8104
      (com.palletops.awaze.common/aws-client :iam credentials8102)]
     (clojure.core/case
      (clojure.core/count args8103)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8104
        getAccountPasswordPolicy
        (identitymanagement/get-account-password-policy-request
         (clojure.core/nth args8103 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8104
        getAccountPasswordPolicy))))))
  (clojure.core/defn
   get-account-password-policy-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for getAccountPasswordPolicy, getAccountPasswordPolicy"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :get-account-password-policy,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-account-password-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-account-password-policy
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call getAccountPasswordPolicy, getAccountPasswordPolicy"}
   [credentials8106 & args8107]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8108
     (com.palletops.awaze.common/aws-client :iam credentials8106)]
    (clojure.core/case
     (clojure.core/count args8107)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8108
       getAccountPasswordPolicy
       (identitymanagement/get-account-password-policy-request
        (clojure.core/nth args8107 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8108
       getAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :list-access-keys
   [m8109]
   (clojure.core/let
    [credentials8110 (:credentials m8109) args8111 (:args m8109)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8112
      (com.palletops.awaze.common/aws-client :iam credentials8110)]
     (clojure.core/case
      (clojure.core/count args8111)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8112
        listAccessKeys))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8112
        listAccessKeys
        (identitymanagement/list-access-keys-request
         (clojure.core/nth args8111 0))))))))
  (clojure.core/defn
   list-access-keys-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listAccessKeys, listAccessKeys"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :list-access-keys,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-access-keys,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-access-keys
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listAccessKeys, listAccessKeys"}
   [credentials8114 & args8115]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8116
     (com.palletops.awaze.common/aws-client :iam credentials8114)]
    (clojure.core/case
     (clojure.core/count args8115)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8116
       listAccessKeys))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8116
       listAccessKeys
       (identitymanagement/list-access-keys-request
        (clojure.core/nth args8115 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-alias
   [m8117]
   (clojure.core/let
    [credentials8118 (:credentials m8117) args8119 (:args m8117)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8120
      (com.palletops.awaze.common/aws-client :iam credentials8118)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8120
       deleteAccountAlias
       (identitymanagement/delete-account-alias-request
        (clojure.core/nth args8119 0)))))))
  (clojure.core/defn
   delete-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Generate map for deleteAccountAlias"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-account-alias,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Call deleteAccountAlias"}
   [credentials8122 & args8123]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8124
     (com.palletops.awaze.common/aws-client :iam credentials8122)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8124
      deleteAccountAlias
      (identitymanagement/delete-account-alias-request
       (clojure.core/nth args8123 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-login-profile
   [m8125]
   (clojure.core/let
    [credentials8126 (:credentials m8125) args8127 (:args m8125)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8128
      (com.palletops.awaze.common/aws-client :iam credentials8126)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8128
       getLoginProfile
       (identitymanagement/get-login-profile-request
        (clojure.core/nth args8127 0)))))))
  (clojure.core/defn
   get-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for getLoginProfile"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-login-profile,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call getLoginProfile"}
   [credentials8130 & args8131]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8132
     (com.palletops.awaze.common/aws-client :iam credentials8130)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8132
      getLoginProfile
      (identitymanagement/get-login-profile-request
       (clojure.core/nth args8131 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-login-profile
   [m8133]
   (clojure.core/let
    [credentials8134 (:credentials m8133) args8135 (:args m8133)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8136
      (com.palletops.awaze.common/aws-client :iam credentials8134)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8136
       createLoginProfile
       (identitymanagement/create-login-profile-request
        (clojure.core/nth args8135 0)))))))
  (clojure.core/defn
   create-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Generate map for createLoginProfile"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-login-profile,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name password general-progress-listener]}]]),
    :doc "Call createLoginProfile"}
   [credentials8138 & args8139]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8140
     (com.palletops.awaze.common/aws-client :iam credentials8138)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8140
      createLoginProfile
      (identitymanagement/create-login-profile-request
       (clojure.core/nth args8139 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups
   [m8141]
   (clojure.core/let
    [credentials8142 (:credentials m8141) args8143 (:args m8141)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8144
      (com.palletops.awaze.common/aws-client :iam credentials8142)]
     (clojure.core/case
      (clojure.core/count args8143)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8144
        listGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8144
        listGroups
        (identitymanagement/list-groups-request
         (clojure.core/nth args8143 0))))))))
  (clojure.core/defn
   list-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listGroups, listGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :list-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listGroups, listGroups"}
   [credentials8146 & args8147]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8148
     (com.palletops.awaze.common/aws-client :iam credentials8146)]
    (clojure.core/case
     (clojure.core/count args8147)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8148
       listGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8148
       listGroups
       (identitymanagement/list-groups-request
        (clojure.core/nth args8147 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-summary
   [m8149]
   (clojure.core/let
    [credentials8150 (:credentials m8149) args8151 (:args m8149)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8152
      (com.palletops.awaze.common/aws-client :iam credentials8150)]
     (clojure.core/case
      (clojure.core/count args8151)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8152
        getAccountSummary
        (identitymanagement/get-account-summary-request
         (clojure.core/nth args8151 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8152
        getAccountSummary))))))
  (clojure.core/defn
   get-account-summary-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for getAccountSummary, getAccountSummary"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :get-account-summary,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-account-summary,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-account-summary
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call getAccountSummary, getAccountSummary"}
   [credentials8154 & args8155]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8156
     (com.palletops.awaze.common/aws-client :iam credentials8154)]
    (clojure.core/case
     (clojure.core/count args8155)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8156
       getAccountSummary
       (identitymanagement/get-account-summary-request
        (clojure.core/nth args8155 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8156
       getAccountSummary))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-password-policy
   [m8157]
   (clojure.core/let
    [credentials8158 (:credentials m8157) args8159 (:args m8157)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8160
      (com.palletops.awaze.common/aws-client :iam credentials8158)]
     (clojure.core/case
      (clojure.core/count args8159)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8160
        deleteAccountPasswordPolicy
        (identitymanagement/delete-account-password-policy-request
         (clojure.core/nth args8159 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8160
        deleteAccountPasswordPolicy))))))
  (clojure.core/defn
   delete-account-password-policy-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :delete-account-password-policy,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-account-password-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-account-password-policy
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   [credentials8162 & args8163]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8164
     (com.palletops.awaze.common/aws-client :iam credentials8162)]
    (clojure.core/case
     (clojure.core/count args8163)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8164
       deleteAccountPasswordPolicy
       (identitymanagement/delete-account-password-policy-request
        (clojure.core/nth args8163 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8164
       deleteAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :get-instance-profile
   [m8165]
   (clojure.core/let
    [credentials8166 (:credentials m8165) args8167 (:args m8165)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8168
      (com.palletops.awaze.common/aws-client :iam credentials8166)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8168
       getInstanceProfile
       (identitymanagement/get-instance-profile-request
        (clojure.core/nth args8167 0)))))))
  (clojure.core/defn
   get-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for getInstanceProfile"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-instance-profile,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call getInstanceProfile"}
   [credentials8170 & args8171]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8172
     (com.palletops.awaze.common/aws-client :iam credentials8170)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8172
      getInstanceProfile
      (identitymanagement/get-instance-profile-request
       (clojure.core/nth args8171 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user
   [m8173]
   (clojure.core/let
    [credentials8174 (:credentials m8173) args8175 (:args m8173)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8176
      (com.palletops.awaze.common/aws-client :iam credentials8174)]
     (clojure.core/case
      (clojure.core/count args8175)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8176
        getUser
        (identitymanagement/get-user-request
         (clojure.core/nth args8175 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8176
        getUser))))))
  (clojure.core/defn
   get-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for getUser, getUser"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :get-user,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-user,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]
                [credentials]]),
    :doc "Call getUser, getUser"}
   [credentials8178 & args8179]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8180
     (com.palletops.awaze.common/aws-client :iam credentials8178)]
    (clojure.core/case
     (clojure.core/count args8179)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8180
       getUser
       (identitymanagement/get-user-request
        (clojure.core/nth args8179 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8180
       getUser))))))
 (do
  (clojure.core/defmethod
   iam
   :update-samlprovider
   [m8181]
   (clojure.core/let
    [credentials8182 (:credentials m8181) args8183 (:args m8181)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8184
      (com.palletops.awaze.common/aws-client :iam credentials8182)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8184
       updateSAMLProvider
       (identitymanagement/update-samlprovider-request
        (clojure.core/nth args8183 0)))))))
  (clojure.core/defn
   update-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         samlprovider-arn
                         samlmetadata-document]}]]),
    :doc "Generate map for updateSAMLProvider"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-samlprovider,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         samlprovider-arn
                         samlmetadata-document]}]]),
    :doc "Call updateSAMLProvider"}
   [credentials8186 & args8187]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8188
     (com.palletops.awaze.common/aws-client :iam credentials8186)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8188
      updateSAMLProvider
      (identitymanagement/update-samlprovider-request
       (clojure.core/nth args8187 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-samlprovider
   [m8189]
   (clojure.core/let
    [credentials8190 (:credentials m8189) args8191 (:args m8189)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8192
      (com.palletops.awaze.common/aws-client :iam credentials8190)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8192
       createSAMLProvider
       (identitymanagement/create-samlprovider-request
        (clojure.core/nth args8191 0)))))))
  (clojure.core/defn
   create-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [name
                         general-progress-listener
                         samlmetadata-document]}]]),
    :doc "Generate map for createSAMLProvider"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-samlprovider,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [name
                         general-progress-listener
                         samlmetadata-document]}]]),
    :doc "Call createSAMLProvider"}
   [credentials8194 & args8195]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8196
     (com.palletops.awaze.common/aws-client :iam credentials8194)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8196
      createSAMLProvider
      (identitymanagement/create-samlprovider-request
       (clojure.core/nth args8195 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-samlproviders
   [m8197]
   (clojure.core/let
    [credentials8198 (:credentials m8197) args8199 (:args m8197)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8200
      (com.palletops.awaze.common/aws-client :iam credentials8198)]
     (clojure.core/case
      (clojure.core/count args8199)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8200
        listSAMLProviders))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8200
        listSAMLProviders
        (identitymanagement/list-samlproviders-request
         (clojure.core/nth args8199 0))))))))
  (clojure.core/defn
   list-samlproviders-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for listSAMLProviders, listSAMLProviders"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :list-samlproviders,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-samlproviders,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-samlproviders
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call listSAMLProviders, listSAMLProviders"}
   [credentials8202 & args8203]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8204
     (com.palletops.awaze.common/aws-client :iam credentials8202)]
    (clojure.core/case
     (clojure.core/count args8203)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8204
       listSAMLProviders))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8204
       listSAMLProviders
       (identitymanagement/list-samlproviders-request
        (clojure.core/nth args8203 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-virtual-mfadevice
   [m8205]
   (clojure.core/let
    [credentials8206 (:credentials m8205) args8207 (:args m8205)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8208
      (com.palletops.awaze.common/aws-client :iam credentials8206)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8208
       deleteVirtualMFADevice
       (identitymanagement/delete-virtual-mfadevice-request
        (clojure.core/nth args8207 0)))))))
  (clojure.core/defn
   delete-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number general-progress-listener]}]]),
    :doc "Generate map for deleteVirtualMFADevice"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-virtual-mfadevice,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number general-progress-listener]}]]),
    :doc "Call deleteVirtualMFADevice"}
   [credentials8210 & args8211]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8212
     (com.palletops.awaze.common/aws-client :iam credentials8210)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8212
      deleteVirtualMFADevice
      (identitymanagement/delete-virtual-mfadevice-request
       (clojure.core/nth args8211 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-access-key
   [m8213]
   (clojure.core/let
    [credentials8214 (:credentials m8213) args8215 (:args m8213)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8216
      (com.palletops.awaze.common/aws-client :iam credentials8214)]
     (clojure.core/case
      (clojure.core/count args8215)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8216
        createAccessKey))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8216
        createAccessKey
        (identitymanagement/create-access-key-request
         (clojure.core/nth args8215 0))))))))
  (clojure.core/defn
   create-access-key-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for createAccessKey, createAccessKey"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :create-access-key,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-access-key,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-access-key
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call createAccessKey, createAccessKey"}
   [credentials8218 & args8219]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8220
     (com.palletops.awaze.common/aws-client :iam credentials8218)]
    (clojure.core/case
     (clojure.core/count args8219)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8220
       createAccessKey))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8220
       createAccessKey
       (identitymanagement/create-access-key-request
        (clojure.core/nth args8219 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles
   [m8221]
   (clojure.core/let
    [credentials8222 (:credentials m8221) args8223 (:args m8221)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8224
      (com.palletops.awaze.common/aws-client :iam credentials8222)]
     (clojure.core/case
      (clojure.core/count args8223)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8224
        listInstanceProfiles
        (identitymanagement/list-instance-profiles-request
         (clojure.core/nth args8223 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8224
        listInstanceProfiles))))))
  (clojure.core/defn
   list-instance-profiles-map
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listInstanceProfiles, listInstanceProfiles"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :list-instance-profiles,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-instance-profiles,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-instance-profiles
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listInstanceProfiles, listInstanceProfiles"}
   [credentials8226 & args8227]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8228
     (com.palletops.awaze.common/aws-client :iam credentials8226)]
    (clojure.core/case
     (clojure.core/count args8227)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8228
       listInstanceProfiles
       (identitymanagement/list-instance-profiles-request
        (clojure.core/nth args8227 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8228
       listInstanceProfiles))))))
 (do
  (clojure.core/defmethod
   iam
   :put-group-policy
   [m8229]
   (clojure.core/let
    [credentials8230 (:credentials m8229) args8231 (:args m8229)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8232
      (com.palletops.awaze.common/aws-client :iam credentials8230)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8232
       putGroupPolicy
       (identitymanagement/put-group-policy-request
        (clojure.core/nth args8231 0)))))))
  (clojure.core/defn
   put-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         policy-document
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for putGroupPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-group-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   put-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         policy-document
                         group-name
                         general-progress-listener]}]]),
    :doc "Call putGroupPolicy"}
   [credentials8234 & args8235]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8236
     (com.palletops.awaze.common/aws-client :iam credentials8234)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8236
      putGroupPolicy
      (identitymanagement/put-group-policy-request
       (clojure.core/nth args8235 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-server-certificate
   [m8237]
   (clojure.core/let
    [credentials8238 (:credentials m8237) args8239 (:args m8237)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8240
      (com.palletops.awaze.common/aws-client :iam credentials8238)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8240
       getServerCertificate
       (identitymanagement/get-server-certificate-request
        (clojure.core/nth args8239 0)))))))
  (clojure.core/defn
   get-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Generate map for getServerCertificate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-server-certificate,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Call getServerCertificate"}
   [credentials8242 & args8243]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8244
     (com.palletops.awaze.common/aws-client :iam credentials8242)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8244
      getServerCertificate
      (identitymanagement/get-server-certificate-request
       (clojure.core/nth args8243 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-server-certificate
   [m8245]
   (clojure.core/let
    [credentials8246 (:credentials m8245) args8247 (:args m8245)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8248
      (com.palletops.awaze.common/aws-client :iam credentials8246)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8248
       uploadServerCertificate
       (identitymanagement/upload-server-certificate-request
        (clojure.core/nth args8247 0)))))))
  (clojure.core/defn
   upload-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [certificate-chain
                         certificate-body
                         general-progress-listener
                         private-key
                         server-certificate-name
                         path]}]]),
    :doc "Generate map for uploadServerCertificate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :upload-server-certificate,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   upload-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [certificate-chain
                         certificate-body
                         general-progress-listener
                         private-key
                         server-certificate-name
                         path]}]]),
    :doc "Call uploadServerCertificate"}
   [credentials8250 & args8251]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8252
     (com.palletops.awaze.common/aws-client :iam credentials8250)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8252
      uploadServerCertificate
      (identitymanagement/upload-server-certificate-request
       (clojure.core/nth args8251 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-role-policies
   [m8253]
   (clojure.core/let
    [credentials8254 (:credentials m8253) args8255 (:args m8253)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8256
      (com.palletops.awaze.common/aws-client :iam credentials8254)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8256
       listRolePolicies
       (identitymanagement/list-role-policies-request
        (clojure.core/nth args8255 0)))))))
  (clojure.core/defn
   list-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listRolePolicies"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-role-policies,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listRolePolicies"}
   [credentials8258 & args8259]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8260
     (com.palletops.awaze.common/aws-client :iam credentials8258)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8260
      listRolePolicies
      (identitymanagement/list-role-policies-request
       (clojure.core/nth args8259 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-role-to-instance-profile
   [m8261]
   (clojure.core/let
    [credentials8262 (:credentials m8261) args8263 (:args m8261)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8264
      (com.palletops.awaze.common/aws-client :iam credentials8262)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8264
       addRoleToInstanceProfile
       (identitymanagement/add-role-to-instance-profile-request
        (clojure.core/nth args8263 0)))))))
  (clojure.core/defn
   add-role-to-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for addRoleToInstanceProfile"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :add-role-to-instance-profile,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-role-to-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call addRoleToInstanceProfile"}
   [credentials8266 & args8267]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8268
     (com.palletops.awaze.common/aws-client :iam credentials8266)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8268
      addRoleToInstanceProfile
      (identitymanagement/add-role-to-instance-profile-request
       (clojure.core/nth args8267 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-access-key
   [m8269]
   (clojure.core/let
    [credentials8270 (:credentials m8269) args8271 (:args m8269)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8272
      (com.palletops.awaze.common/aws-client :iam credentials8270)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8272
       deleteAccessKey
       (identitymanagement/delete-access-key-request
        (clojure.core/nth args8271 0)))))))
  (clojure.core/defn
   delete-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Generate map for deleteAccessKey"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-access-key,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-access-key
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         access-key-id]}]]),
    :doc "Call deleteAccessKey"}
   [credentials8274 & args8275]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8276
     (com.palletops.awaze.common/aws-client :iam credentials8274)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8276
      deleteAccessKey
      (identitymanagement/delete-access-key-request
       (clojure.core/nth args8275 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role
   [m8277]
   (clojure.core/let
    [credentials8278 (:credentials m8277) args8279 (:args m8277)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8280
      (com.palletops.awaze.common/aws-client :iam credentials8278)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8280
       deleteRole
       (identitymanagement/delete-role-request
        (clojure.core/nth args8279 0)))))))
  (clojure.core/defn
   delete-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Generate map for deleteRole"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-role,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name general-progress-listener]}]]),
    :doc "Call deleteRole"}
   [credentials8282 & args8283]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8284
     (com.palletops.awaze.common/aws-client :iam credentials8282)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8284
      deleteRole
      (identitymanagement/delete-role-request
       (clojure.core/nth args8283 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-virtual-mfadevice
   [m8285]
   (clojure.core/let
    [credentials8286 (:credentials m8285) args8287 (:args m8285)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8288
      (com.palletops.awaze.common/aws-client :iam credentials8286)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8288
       createVirtualMFADevice
       (identitymanagement/create-virtual-mfadevice-request
        (clojure.core/nth args8287 0)))))))
  (clojure.core/defn
   create-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-mfadevice-name
                         path
                         general-progress-listener]}]]),
    :doc "Generate map for createVirtualMFADevice"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-virtual-mfadevice,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [virtual-mfadevice-name
                         path
                         general-progress-listener]}]]),
    :doc "Call createVirtualMFADevice"}
   [credentials8290 & args8291]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8292
     (com.palletops.awaze.common/aws-client :iam credentials8290)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8292
      createVirtualMFADevice
      (identitymanagement/create-virtual-mfadevice-request
       (clojure.core/nth args8291 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-group-policies
   [m8293]
   (clojure.core/let
    [credentials8294 (:credentials m8293) args8295 (:args m8293)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8296
      (com.palletops.awaze.common/aws-client :iam credentials8294)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8296
       listGroupPolicies
       (identitymanagement/list-group-policies-request
        (clojure.core/nth args8295 0)))))))
  (clojure.core/defn
   list-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for listGroupPolicies"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-group-policies,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Call listGroupPolicies"}
   [credentials8298 & args8299]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8300
     (com.palletops.awaze.common/aws-client :iam credentials8298)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8300
      listGroupPolicies
      (identitymanagement/list-group-policies-request
       (clojure.core/nth args8299 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group-policy
   [m8301]
   (clojure.core/let
    [credentials8302 (:credentials m8301) args8303 (:args m8301)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8304
      (com.palletops.awaze.common/aws-client :iam credentials8302)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8304
       getGroupPolicy
       (identitymanagement/get-group-policy-request
        (clojure.core/nth args8303 0)))))))
  (clojure.core/defn
   get-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for getGroupPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-group-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call getGroupPolicy"}
   [credentials8306 & args8307]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8308
     (com.palletops.awaze.common/aws-client :iam credentials8306)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8308
      getGroupPolicy
      (identitymanagement/get-group-policy-request
       (clojure.core/nth args8307 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-server-certificates
   [m8309]
   (clojure.core/let
    [credentials8310 (:credentials m8309) args8311 (:args m8309)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8312
      (com.palletops.awaze.common/aws-client :iam credentials8310)]
     (clojure.core/case
      (clojure.core/count args8311)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8312
        listServerCertificates
        (identitymanagement/list-server-certificates-request
         (clojure.core/nth args8311 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8312
        listServerCertificates))))))
  (clojure.core/defn
   list-server-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listServerCertificates, listServerCertificates"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :list-server-certificates,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-server-certificates,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-server-certificates
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listServerCertificates, listServerCertificates"}
   [credentials8314 & args8315]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8316
     (com.palletops.awaze.common/aws-client :iam credentials8314)]
    (clojure.core/case
     (clojure.core/count args8315)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8316
       listServerCertificates
       (identitymanagement/list-server-certificates-request
        (clojure.core/nth args8315 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8316
       listServerCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :update-account-password-policy
   [m8317]
   (clojure.core/let
    [credentials8318 (:credentials m8317) args8319 (:args m8317)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8320
      (com.palletops.awaze.common/aws-client :iam credentials8318)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8320
       updateAccountPasswordPolicy
       (identitymanagement/update-account-password-policy-request
        (clojure.core/nth args8319 0)))))))
  (clojure.core/defn
   update-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [require-uppercase-characters
                         allow-users-to-change-password
                         general-progress-listener
                         require-numbers
                         require-lowercase-characters
                         minimum-password-length
                         require-symbols]}]]),
    :doc "Generate map for updateAccountPasswordPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-account-password-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [require-uppercase-characters
                         allow-users-to-change-password
                         general-progress-listener
                         require-numbers
                         require-lowercase-characters
                         minimum-password-length
                         require-symbols]}]]),
    :doc "Call updateAccountPasswordPolicy"}
   [credentials8322 & args8323]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8324
     (com.palletops.awaze.common/aws-client :iam credentials8322)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8324
      updateAccountPasswordPolicy
      (identitymanagement/update-account-password-policy-request
       (clojure.core/nth args8323 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-group
   [m8325]
   (clojure.core/let
    [credentials8326 (:credentials m8325) args8327 (:args m8325)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8328
      (com.palletops.awaze.common/aws-client :iam credentials8326)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8328
       createGroup
       (identitymanagement/create-group-request
        (clojure.core/nth args8327 0)))))))
  (clojure.core/defn
   create-group-map
   {:arglists (quote
               [[credentials
                 {:keys [path group-name general-progress-listener]}]]),
    :doc "Generate map for createGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-group
   {:arglists (quote
               [[credentials
                 {:keys [path group-name general-progress-listener]}]]),
    :doc "Call createGroup"}
   [credentials8330 & args8331]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8332
     (com.palletops.awaze.common/aws-client :iam credentials8330)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8332
      createGroup
      (identitymanagement/create-group-request
       (clojure.core/nth args8331 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles-for-role
   [m8333]
   (clojure.core/let
    [credentials8334 (:credentials m8333) args8335 (:args m8333)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8336
      (com.palletops.awaze.common/aws-client :iam credentials8334)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8336
       listInstanceProfilesForRole
       (identitymanagement/list-instance-profiles-for-role-request
        (clojure.core/nth args8335 0)))))))
  (clojure.core/defn
   list-instance-profiles-for-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listInstanceProfilesForRole"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-instance-profiles-for-role,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-instance-profiles-for-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listInstanceProfilesForRole"}
   [credentials8338 & args8339]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8340
     (com.palletops.awaze.common/aws-client :iam credentials8338)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8340
      listInstanceProfilesForRole
      (identitymanagement/list-instance-profiles-for-role-request
       (clojure.core/nth args8339 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-signing-certificate
   [m8341]
   (clojure.core/let
    [credentials8342 (:credentials m8341) args8343 (:args m8341)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8344
      (com.palletops.awaze.common/aws-client :iam credentials8342)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8344
       uploadSigningCertificate
       (identitymanagement/upload-signing-certificate-request
        (clojure.core/nth args8343 0)))))))
  (clojure.core/defn
   upload-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-body]}]]),
    :doc "Generate map for uploadSigningCertificate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :upload-signing-certificate,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   upload-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         general-progress-listener
                         certificate-body]}]]),
    :doc "Call uploadSigningCertificate"}
   [credentials8346 & args8347]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8348
     (com.palletops.awaze.common/aws-client :iam credentials8346)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8348
      uploadSigningCertificate
      (identitymanagement/upload-signing-certificate-request
       (clojure.core/nth args8347 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-server-certificate
   [m8349]
   (clojure.core/let
    [credentials8350 (:credentials m8349) args8351 (:args m8349)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8352
      (com.palletops.awaze.common/aws-client :iam credentials8350)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8352
       deleteServerCertificate
       (identitymanagement/delete-server-certificate-request
        (clojure.core/nth args8351 0)))))))
  (clojure.core/defn
   delete-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteServerCertificate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-server-certificate,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         general-progress-listener]}]]),
    :doc "Call deleteServerCertificate"}
   [credentials8354 & args8355]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8356
     (com.palletops.awaze.common/aws-client :iam credentials8354)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8356
      deleteServerCertificate
      (identitymanagement/delete-server-certificate-request
       (clojure.core/nth args8355 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-virtual-mfadevices
   [m8357]
   (clojure.core/let
    [credentials8358 (:credentials m8357) args8359 (:args m8357)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8360
      (com.palletops.awaze.common/aws-client :iam credentials8358)]
     (clojure.core/case
      (clojure.core/count args8359)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8360
        listVirtualMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8360
        listVirtualMFADevices
        (identitymanagement/list-virtual-mfadevices-request
         (clojure.core/nth args8359 0))))))))
  (clojure.core/defn
   list-virtual-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items
                         marker
                         general-progress-listener
                         assignment-status]}]]),
    :doc "Generate map for listVirtualMFADevices, listVirtualMFADevices"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :list-virtual-mfadevices,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-virtual-mfadevices,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-virtual-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items
                         marker
                         general-progress-listener
                         assignment-status]}]]),
    :doc "Call listVirtualMFADevices, listVirtualMFADevices"}
   [credentials8362 & args8363]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8364
     (com.palletops.awaze.common/aws-client :iam credentials8362)]
    (clojure.core/case
     (clojure.core/count args8363)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8364
       listVirtualMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8364
       listVirtualMFADevices
       (identitymanagement/list-virtual-mfadevices-request
        (clojure.core/nth args8363 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-role-from-instance-profile
   [m8365]
   (clojure.core/let
    [credentials8366 (:credentials m8365) args8367 (:args m8365)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8368
      (com.palletops.awaze.common/aws-client :iam credentials8366)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8368
       removeRoleFromInstanceProfile
       (identitymanagement/remove-role-from-instance-profile-request
        (clojure.core/nth args8367 0)))))))
  (clojure.core/defn
   remove-role-from-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for removeRoleFromInstanceProfile"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :remove-role-from-instance-profile,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   remove-role-from-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call removeRoleFromInstanceProfile"}
   [credentials8370 & args8371]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8372
     (com.palletops.awaze.common/aws-client :iam credentials8370)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8372
      removeRoleFromInstanceProfile
      (identitymanagement/remove-role-from-instance-profile-request
       (clojure.core/nth args8371 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-signing-certificates
   [m8373]
   (clojure.core/let
    [credentials8374 (:credentials m8373) args8375 (:args m8373)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8376
      (com.palletops.awaze.common/aws-client :iam credentials8374)]
     (clojure.core/case
      (clojure.core/count args8375)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8376
        listSigningCertificates
        (identitymanagement/list-signing-certificates-request
         (clojure.core/nth args8375 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8376
        listSigningCertificates))))))
  (clojure.core/defn
   list-signing-certificates-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listSigningCertificates, listSigningCertificates"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :list-signing-certificates,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-signing-certificates,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-signing-certificates
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listSigningCertificates, listSigningCertificates"}
   [credentials8378 & args8379]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8380
     (com.palletops.awaze.common/aws-client :iam credentials8378)]
    (clojure.core/case
     (clojure.core/count args8379)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8380
       listSigningCertificates
       (identitymanagement/list-signing-certificates-request
        (clojure.core/nth args8379 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8380
       listSigningCertificates))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-instance-profile
   [m8381]
   (clojure.core/let
    [credentials8382 (:credentials m8381) args8383 (:args m8381)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8384
      (com.palletops.awaze.common/aws-client :iam credentials8382)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8384
       deleteInstanceProfile
       (identitymanagement/delete-instance-profile-request
        (clojure.core/nth args8383 0)))))))
  (clojure.core/defn
   delete-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteInstanceProfile"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-instance-profile,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call deleteInstanceProfile"}
   [credentials8386 & args8387]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8388
     (com.palletops.awaze.common/aws-client :iam credentials8386)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8388
      deleteInstanceProfile
      (identitymanagement/delete-instance-profile-request
       (clojure.core/nth args8387 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-mfadevices
   [m8389]
   (clojure.core/let
    [credentials8390 (:credentials m8389) args8391 (:args m8389)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8392
      (com.palletops.awaze.common/aws-client :iam credentials8390)]
     (clojure.core/case
      (clojure.core/count args8391)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8392
        listMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8392
        listMFADevices
        (identitymanagement/list-mfadevices-request
         (clojure.core/nth args8391 0))))))))
  (clojure.core/defn
   list-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listMFADevices, listMFADevices"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :list-mfadevices,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-mfadevices,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listMFADevices, listMFADevices"}
   [credentials8394 & args8395]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8396
     (com.palletops.awaze.common/aws-client :iam credentials8394)]
    (clojure.core/case
     (clojure.core/count args8395)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8396
       listMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8396
       listMFADevices
       (identitymanagement/list-mfadevices-request
        (clojure.core/nth args8395 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user-policy
   [m8397]
   (clojure.core/let
    [credentials8398 (:credentials m8397) args8399 (:args m8397)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8400
      (com.palletops.awaze.common/aws-client :iam credentials8398)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8400
       deleteUserPolicy
       (identitymanagement/delete-user-policy-request
        (clojure.core/nth args8399 0)))))))
  (clojure.core/defn
   delete-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteUserPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-user-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call deleteUserPolicy"}
   [credentials8402 & args8403]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8404
     (com.palletops.awaze.common/aws-client :iam credentials8402)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8404
      deleteUserPolicy
      (identitymanagement/delete-user-policy-request
       (clojure.core/nth args8403 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-account-alias
   [m8405]
   (clojure.core/let
    [credentials8406 (:credentials m8405) args8407 (:args m8405)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8408
      (com.palletops.awaze.common/aws-client :iam credentials8406)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8408
       createAccountAlias
       (identitymanagement/create-account-alias-request
        (clojure.core/nth args8407 0)))))))
  (clojure.core/defn
   create-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Generate map for createAccountAlias"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-account-alias,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener account-alias]}]]),
    :doc "Call createAccountAlias"}
   [credentials8410 & args8411]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8412
     (com.palletops.awaze.common/aws-client :iam credentials8410)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8412
      createAccountAlias
      (identitymanagement/create-account-alias-request
       (clojure.core/nth args8411 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-signing-certificate
   [m8413]
   (clojure.core/let
    [credentials8414 (:credentials m8413) args8415 (:args m8413)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8416
      (com.palletops.awaze.common/aws-client :iam credentials8414)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8416
       updateSigningCertificate
       (identitymanagement/update-signing-certificate-request
        (clojure.core/nth args8415 0)))))))
  (clojure.core/defn
   update-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Generate map for updateSigningCertificate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-signing-certificate,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         general-progress-listener
                         certificate-id]}]]),
    :doc "Call updateSigningCertificate"}
   [credentials8418 & args8419]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8420
     (com.palletops.awaze.common/aws-client :iam credentials8418)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8420
      updateSigningCertificate
      (identitymanagement/update-signing-certificate-request
       (clojure.core/nth args8419 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-assume-role-policy
   [m8421]
   (clojure.core/let
    [credentials8422 (:credentials m8421) args8423 (:args m8421)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8424
      (com.palletops.awaze.common/aws-client :iam credentials8422)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8424
       updateAssumeRolePolicy
       (identitymanagement/update-assume-role-policy-request
        (clojure.core/nth args8423 0)))))))
  (clojure.core/defn
   update-assume-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Generate map for updateAssumeRolePolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-assume-role-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-assume-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         policy-document
                         general-progress-listener]}]]),
    :doc "Call updateAssumeRolePolicy"}
   [credentials8426 & args8427]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8428
     (com.palletops.awaze.common/aws-client :iam credentials8426)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8428
      updateAssumeRolePolicy
      (identitymanagement/update-assume-role-policy-request
       (clojure.core/nth args8427 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-roles
   [m8429]
   (clojure.core/let
    [credentials8430 (:credentials m8429) args8431 (:args m8429)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8432
      (com.palletops.awaze.common/aws-client :iam credentials8430)]
     (clojure.core/case
      (clojure.core/count args8431)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8432
        listRoles
        (identitymanagement/list-roles-request
         (clojure.core/nth args8431 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8432
        listRoles))))))
  (clojure.core/defn
   list-roles-map
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listRoles, listRoles"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :list-roles,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-roles,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-roles
   {:arglists (quote
               [[credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call listRoles, listRoles"}
   [credentials8434 & args8435]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8436
     (com.palletops.awaze.common/aws-client :iam credentials8434)]
    (clojure.core/case
     (clojure.core/count args8435)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8436
       listRoles
       (identitymanagement/list-roles-request
        (clojure.core/nth args8435 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8436
       listRoles))))))
 (do
  (clojure.core/defmethod
   iam
   :list-user-policies
   [m8437]
   (clojure.core/let
    [credentials8438 (:credentials m8437) args8439 (:args m8437)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8440
      (com.palletops.awaze.common/aws-client :iam credentials8438)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8440
       listUserPolicies
       (identitymanagement/list-user-policies-request
        (clojure.core/nth args8439 0)))))))
  (clojure.core/defn
   list-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listUserPolicies"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-user-policies,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listUserPolicies"}
   [credentials8442 & args8443]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8444
     (com.palletops.awaze.common/aws-client :iam credentials8442)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8444
      listUserPolicies
      (identitymanagement/list-user-policies-request
       (clojure.core/nth args8443 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-login-profile
   [m8445]
   (clojure.core/let
    [credentials8446 (:credentials m8445) args8447 (:args m8445)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8448
      (com.palletops.awaze.common/aws-client :iam credentials8446)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8448
       deleteLoginProfile
       (identitymanagement/delete-login-profile-request
        (clojure.core/nth args8447 0)))))))
  (clojure.core/defn
   delete-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Generate map for deleteLoginProfile"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-login-profile,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name general-progress-listener]}]]),
    :doc "Call deleteLoginProfile"}
   [credentials8450 & args8451]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8452
     (com.palletops.awaze.common/aws-client :iam credentials8450)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8452
      deleteLoginProfile
      (identitymanagement/delete-login-profile-request
       (clojure.core/nth args8451 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :enable-mfadevice
   [m8453]
   (clojure.core/let
    [credentials8454 (:credentials m8453) args8455 (:args m8453)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8456
      (com.palletops.awaze.common/aws-client :iam credentials8454)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8456
       enableMFADevice
       (identitymanagement/enable-mfadevice-request
        (clojure.core/nth args8455 0)))))))
  (clojure.core/defn
   enable-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Generate map for enableMFADevice"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :enable-mfadevice,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   enable-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         general-progress-listener
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Call enableMFADevice"}
   [credentials8458 & args8459]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8460
     (com.palletops.awaze.common/aws-client :iam credentials8458)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8460
      enableMFADevice
      (identitymanagement/enable-mfadevice-request
       (clojure.core/nth args8459 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-samlprovider
   [m8461]
   (clojure.core/let
    [credentials8462 (:credentials m8461) args8463 (:args m8461)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8464
      (com.palletops.awaze.common/aws-client :iam credentials8462)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8464
       getSAMLProvider
       (identitymanagement/get-samlprovider-request
        (clojure.core/nth args8463 0)))))))
  (clojure.core/defn
   get-samlprovider-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Generate map for getSAMLProvider"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-samlprovider,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-samlprovider
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener samlprovider-arn]}]]),
    :doc "Call getSAMLProvider"}
   [credentials8466 & args8467]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8468
     (com.palletops.awaze.common/aws-client :iam credentials8466)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8468
      getSAMLProvider
      (identitymanagement/get-samlprovider-request
       (clojure.core/nth args8467 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group
   [m8469]
   (clojure.core/let
    [credentials8470 (:credentials m8469) args8471 (:args m8469)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8472
      (com.palletops.awaze.common/aws-client :iam credentials8470)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8472
       getGroup
       (identitymanagement/get-group-request
        (clojure.core/nth args8471 0)))))))
  (clojure.core/defn
   get-group-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for getGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-group
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         group-name
                         general-progress-listener]}]]),
    :doc "Call getGroup"}
   [credentials8474 & args8475]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8476
     (com.palletops.awaze.common/aws-client :iam credentials8474)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8476
      getGroup
      (identitymanagement/get-group-request
       (clojure.core/nth args8475 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group-policy
   [m8477]
   (clojure.core/let
    [credentials8478 (:credentials m8477) args8479 (:args m8477)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8480
      (com.palletops.awaze.common/aws-client :iam credentials8478)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8480
       deleteGroupPolicy
       (identitymanagement/delete-group-policy-request
        (clojure.core/nth args8479 0)))))))
  (clojure.core/defn
   delete-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteGroupPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-group-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         group-name
                         general-progress-listener]}]]),
    :doc "Call deleteGroupPolicy"}
   [credentials8482 & args8483]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8484
     (com.palletops.awaze.common/aws-client :iam credentials8482)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8484
      deleteGroupPolicy
      (identitymanagement/delete-group-policy-request
       (clojure.core/nth args8483 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-instance-profile
   [m8485]
   (clojure.core/let
    [credentials8486 (:credentials m8485) args8487 (:args m8485)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8488
      (com.palletops.awaze.common/aws-client :iam credentials8486)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8488
       createInstanceProfile
       (identitymanagement/create-instance-profile-request
        (clojure.core/nth args8487 0)))))))
  (clojure.core/defn
   create-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [path
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Generate map for createInstanceProfile"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-instance-profile,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [path
                         instance-profile-name
                         general-progress-listener]}]]),
    :doc "Call createInstanceProfile"}
   [credentials8490 & args8491]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8492
     (com.palletops.awaze.common/aws-client :iam credentials8490)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8492
      createInstanceProfile
      (identitymanagement/create-instance-profile-request
       (clojure.core/nth args8491 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-user
   [m8493]
   (clojure.core/let
    [credentials8494 (:credentials m8493) args8495 (:args m8493)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8496
      (com.palletops.awaze.common/aws-client :iam credentials8494)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8496
       updateUser
       (identitymanagement/update-user-request
        (clojure.core/nth args8495 0)))))))
  (clojure.core/defn
   update-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         new-user-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Generate map for updateUser"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-user,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         new-user-name
                         new-path
                         general-progress-listener]}]]),
    :doc "Call updateUser"}
   [credentials8498 & args8499]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8500
     (com.palletops.awaze.common/aws-client :iam credentials8498)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8500
      updateUser
      (identitymanagement/update-user-request
       (clojure.core/nth args8499 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-user
   [m8501]
   (clojure.core/let
    [credentials8502 (:credentials m8501) args8503 (:args m8501)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8504
      (com.palletops.awaze.common/aws-client :iam credentials8502)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8504
       createUser
       (identitymanagement/create-user-request
        (clojure.core/nth args8503 0)))))))
  (clojure.core/defn
   create-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name path general-progress-listener]}]]),
    :doc "Generate map for createUser"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-user,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name path general-progress-listener]}]]),
    :doc "Call createUser"}
   [credentials8506 & args8507]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8508
     (com.palletops.awaze.common/aws-client :iam credentials8506)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8508
      createUser
      (identitymanagement/create-user-request
       (clojure.core/nth args8507 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-role
   [m8509]
   (clojure.core/let
    [credentials8510 (:credentials m8509) args8511 (:args m8509)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8512
      (com.palletops.awaze.common/aws-client :iam credentials8510)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8512
       createRole
       (identitymanagement/create-role-request
        (clojure.core/nth args8511 0)))))))
  (clojure.core/defn
   create-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         path
                         general-progress-listener
                         assume-role-policy-document]}]]),
    :doc "Generate map for createRole"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-role,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         path
                         general-progress-listener
                         assume-role-policy-document]}]]),
    :doc "Call createRole"}
   [credentials8514 & args8515]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8516
     (com.palletops.awaze.common/aws-client :iam credentials8514)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8516
      createRole
      (identitymanagement/create-role-request
       (clojure.core/nth args8515 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user-policy
   [m8517]
   (clojure.core/let
    [credentials8518 (:credentials m8517) args8519 (:args m8517)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8520
      (com.palletops.awaze.common/aws-client :iam credentials8518)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8520
       getUserPolicy
       (identitymanagement/get-user-policy-request
        (clojure.core/nth args8519 0)))))))
  (clojure.core/defn
   get-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Generate map for getUserPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-user-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         policy-name
                         general-progress-listener]}]]),
    :doc "Call getUserPolicy"}
   [credentials8522 & args8523]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8524
     (com.palletops.awaze.common/aws-client :iam credentials8522)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8524
      getUserPolicy
      (identitymanagement/get-user-policy-request
       (clojure.core/nth args8523 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-users
   [m8525]
   (clojure.core/let
    [credentials8526 (:credentials m8525) args8527 (:args m8525)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
      client8528
      (com.palletops.awaze.common/aws-client :iam credentials8526)]
     (clojure.core/case
      (clojure.core/count args8527)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8528
        listUsers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8528
        listUsers
        (identitymanagement/list-users-request
         (clojure.core/nth args8527 0))))))))
  (clojure.core/defn
   list-users-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for listUsers, listUsers"}
   ([credentials__1649__auto__]
    {:args [],
     :client :iam,
     :fn :list-users,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-users,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-users
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [path-prefix
                         max-items
                         marker
                         general-progress-listener]}]]),
    :doc "Call listUsers, listUsers"}
   [credentials8530 & args8531]
   (clojure.core/let
    [^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
     client8532
     (com.palletops.awaze.common/aws-client :iam credentials8530)]
    (clojure.core/case
     (clojure.core/count args8531)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8532
       listUsers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient}
client8532
       listUsers
       (identitymanagement/list-users-request
        (clojure.core/nth args8531 0)))))))))
