(ns
 com.palletops.awaze.glacier
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.glacier :as glacier]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :glacier
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.glacier.AmazonGlacierClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InventoryRetrievalJobInput}
inventory-retrieval-job-input
  [m2306]
  (clojure.core/let
   [bean2305
    (new
     com.amazonaws.services.glacier.model.InventoryRetrievalJobInput)]
   (clojure.core/when-let
    [v2307 (:start-date m2306)]
    (. bean2305 setStartDate (clojure.core/str v2307)))
   (clojure.core/when-let
    [v2307 (:end-date m2306)]
    (. bean2305 setEndDate (clojure.core/str v2307)))
   (clojure.core/when-let
    [v2307 (:marker m2306)]
    (. bean2305 setMarker (clojure.core/str v2307)))
   (clojure.core/when-let
    [v2307 (:limit m2306)]
    (. bean2305 setLimit (clojure.core/str v2307)))
   bean2305))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.JobParameters}
job-parameters
  [m2309]
  (clojure.core/let
   [bean2308 (new com.amazonaws.services.glacier.model.JobParameters)]
   (clojure.core/when-let
    [v2310 (:format m2309)]
    (. bean2308 setFormat (clojure.core/str v2310)))
   (clojure.core/when-let
    [v2310 (:archive-id m2309)]
    (. bean2308 setArchiveId (clojure.core/str v2310)))
   (clojure.core/when-let
    [v2310 (:snstopic m2309)]
    (. bean2308 setSNSTopic (clojure.core/str v2310)))
   (clojure.core/when-let
    [v2310 (:retrieval-byte-range m2309)]
    (. bean2308 setRetrievalByteRange (clojure.core/str v2310)))
   (clojure.core/when-let
    [v2310 (:inventory-retrieval-parameters m2309)]
    (.
     bean2308
     setInventoryRetrievalParameters
     (glacier/inventory-retrieval-job-input v2310)))
   (clojure.core/when-let
    [v2310 (:description m2309)]
    (. bean2308 setDescription (clojure.core/str v2310)))
   (clojure.core/when-let
    [v2310 (:type m2309)]
    (. bean2308 setType (clojure.core/str v2310)))
   bean2308))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultNotificationConfig}
vault-notification-config
  [m2312]
  (clojure.core/let
   [bean2311
    (new com.amazonaws.services.glacier.model.VaultNotificationConfig)]
   (clojure.core/when-let
    [v2313 (:snstopic m2312)]
    (. bean2311 setSNSTopic (clojure.core/str v2313)))
   (clojure.core/when-let
    [v2313 (:events m2312)]
    (.
     bean2311
     setEvents
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2371] (clojure.core/str arg2371))
 v2313)))
   bean2311))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListJobsRequest}
list-jobs-request
  [m2315]
  (clojure.core/let
   [bean2314
    (new com.amazonaws.services.glacier.model.ListJobsRequest)]
   (clojure.core/when-let
    [v2316 (:marker m2315)]
    (. bean2314 setMarker (clojure.core/str v2316)))
   (clojure.core/when-let
    [v2316 (:account-id m2315)]
    (. bean2314 setAccountId (clojure.core/str v2316)))
   (clojure.core/when-let
    [v2316 (:limit m2315)]
    (. bean2314 setLimit (clojure.core/str v2316)))
   (clojure.core/when-let
    [v2316 (:vault-name m2315)]
    (. bean2314 setVaultName (clojure.core/str v2316)))
   (clojure.core/when-let
    [v2316 (:statuscode m2315)]
    (. bean2314 setStatuscode (clojure.core/str v2316)))
   (clojure.core/when-let
    [v2316 (:completed m2315)]
    (. bean2314 setCompleted (clojure.core/str v2316)))
   bean2314))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultNotificationsRequest}
get-vault-notifications-request
  [m2318]
  (clojure.core/let
   [bean2317
    (new
     com.amazonaws.services.glacier.model.GetVaultNotificationsRequest)]
   (clojure.core/when-let
    [v2319 (:account-id m2318)]
    (. bean2317 setAccountId (clojure.core/str v2319)))
   (clojure.core/when-let
    [v2319 (:vault-name m2318)]
    (. bean2317 setVaultName (clojure.core/str v2319)))
   bean2317))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadMultipartPartRequest}
upload-multipart-part-request
  [m2321]
  (clojure.core/let
   [bean2320
    (new
     com.amazonaws.services.glacier.model.UploadMultipartPartRequest)]
   (clojure.core/when-let
    [v2322 (:range m2321)]
    (. bean2320 setRange (clojure.core/str v2322)))
   (clojure.core/when-let
    [v2322 (:checksum m2321)]
    (. bean2320 setChecksum (clojure.core/str v2322)))
   (clojure.core/when-let
    [v2322 (:account-id m2321)]
    (. bean2320 setAccountId (clojure.core/str v2322)))
   (clojure.core/when-let
    [v2322 (:upload-id m2321)]
    (. bean2320 setUploadId (clojure.core/str v2322)))
   (clojure.core/when-let
    [v2322 (:vault-name m2321)]
    (. bean2320 setVaultName (clojure.core/str v2322)))
   (clojure.core/when-let
    [v2322 (:body m2321)]
    (. bean2320 setBody (clojure.java.io/input-stream v2322)))
   bean2320))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListVaultsRequest}
list-vaults-request
  [m2324]
  (clojure.core/let
   [bean2323
    (new com.amazonaws.services.glacier.model.ListVaultsRequest)]
   (clojure.core/when-let
    [v2325 (:marker m2324)]
    (. bean2323 setMarker (clojure.core/str v2325)))
   (clojure.core/when-let
    [v2325 (:account-id m2324)]
    (. bean2323 setAccountId (clojure.core/str v2325)))
   (clojure.core/when-let
    [v2325 (:limit m2324)]
    (. bean2323 setLimit (clojure.core/str v2325)))
   bean2323))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultRequest}
delete-vault-request
  [m2327]
  (clojure.core/let
   [bean2326
    (new com.amazonaws.services.glacier.model.DeleteVaultRequest)]
   (clojure.core/when-let
    [v2328 (:account-id m2327)]
    (. bean2326 setAccountId (clojure.core/str v2328)))
   (clojure.core/when-let
    [v2328 (:vault-name m2327)]
    (. bean2326 setVaultName (clojure.core/str v2328)))
   bean2326))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateJobRequest}
initiate-job-request
  [m2330]
  (clojure.core/let
   [bean2329
    (new com.amazonaws.services.glacier.model.InitiateJobRequest)]
   (clojure.core/when-let
    [v2331 (:job-parameters m2330)]
    (. bean2329 setJobParameters (glacier/job-parameters v2331)))
   (clojure.core/when-let
    [v2331 (:account-id m2330)]
    (. bean2329 setAccountId (clojure.core/str v2331)))
   (clojure.core/when-let
    [v2331 (:vault-name m2330)]
    (. bean2329 setVaultName (clojure.core/str v2331)))
   bean2329))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeVaultRequest}
describe-vault-request
  [m2333]
  (clojure.core/let
   [bean2332
    (new com.amazonaws.services.glacier.model.DescribeVaultRequest)]
   (clojure.core/when-let
    [v2334 (:account-id m2333)]
    (. bean2332 setAccountId (clojure.core/str v2334)))
   (clojure.core/when-let
    [v2334 (:vault-name m2333)]
    (. bean2332 setVaultName (clojure.core/str v2334)))
   bean2332))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m2336]
  (clojure.core/let
   [bean2335
    (new
     com.amazonaws.services.glacier.model.AbortMultipartUploadRequest)]
   (clojure.core/when-let
    [v2337 (:account-id m2336)]
    (. bean2335 setAccountId (clojure.core/str v2337)))
   (clojure.core/when-let
    [v2337 (:upload-id m2336)]
    (. bean2335 setUploadId (clojure.core/str v2337)))
   (clojure.core/when-let
    [v2337 (:vault-name m2336)]
    (. bean2335 setVaultName (clojure.core/str v2337)))
   bean2335))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest}
delete-vault-notifications-request
  [m2339]
  (clojure.core/let
   [bean2338
    (new
     com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest)]
   (clojure.core/when-let
    [v2340 (:account-id m2339)]
    (. bean2338 setAccountId (clojure.core/str v2340)))
   (clojure.core/when-let
    [v2340 (:vault-name m2339)]
    (. bean2338 setVaultName (clojure.core/str v2340)))
   bean2338))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m2342]
  (clojure.core/let
   [bean2341
    (new
     com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest)]
   (clojure.core/when-let
    [v2343 (:checksum m2342)]
    (. bean2341 setChecksum (clojure.core/str v2343)))
   (clojure.core/when-let
    [v2343 (:archive-size m2342)]
    (. bean2341 setArchiveSize (clojure.core/str v2343)))
   (clojure.core/when-let
    [v2343 (:account-id m2342)]
    (. bean2341 setAccountId (clojure.core/str v2343)))
   (clojure.core/when-let
    [v2343 (:upload-id m2342)]
    (. bean2341 setUploadId (clojure.core/str v2343)))
   (clojure.core/when-let
    [v2343 (:vault-name m2342)]
    (. bean2341 setVaultName (clojure.core/str v2343)))
   bean2341))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetJobOutputRequest}
get-job-output-request
  [m2345]
  (clojure.core/let
   [bean2344
    (new com.amazonaws.services.glacier.model.GetJobOutputRequest)]
   (clojure.core/when-let
    [v2346 (:range m2345)]
    (. bean2344 setRange (clojure.core/str v2346)))
   (clojure.core/when-let
    [v2346 (:account-id m2345)]
    (. bean2344 setAccountId (clojure.core/str v2346)))
   (clojure.core/when-let
    [v2346 (:vault-name m2345)]
    (. bean2344 setVaultName (clojure.core/str v2346)))
   (clojure.core/when-let
    [v2346 (:job-id m2345)]
    (. bean2344 setJobId (clojure.core/str v2346)))
   bean2344))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m2348]
  (clojure.core/let
   [bean2347
    (new
     com.amazonaws.services.glacier.model.ListMultipartUploadsRequest)]
   (clojure.core/when-let
    [v2349 (:upload-id-marker m2348)]
    (. bean2347 setUploadIdMarker (clojure.core/str v2349)))
   (clojure.core/when-let
    [v2349 (:account-id m2348)]
    (. bean2347 setAccountId (clojure.core/str v2349)))
   (clojure.core/when-let
    [v2349 (:limit m2348)]
    (. bean2347 setLimit (clojure.core/str v2349)))
   (clojure.core/when-let
    [v2349 (:vault-name m2348)]
    (. bean2347 setVaultName (clojure.core/str v2349)))
   bean2347))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeJobRequest}
describe-job-request
  [m2351]
  (clojure.core/let
   [bean2350
    (new com.amazonaws.services.glacier.model.DescribeJobRequest)]
   (clojure.core/when-let
    [v2352 (:account-id m2351)]
    (. bean2350 setAccountId (clojure.core/str v2352)))
   (clojure.core/when-let
    [v2352 (:vault-name m2351)]
    (. bean2350 setVaultName (clojure.core/str v2352)))
   (clojure.core/when-let
    [v2352 (:job-id m2351)]
    (. bean2350 setJobId (clojure.core/str v2352)))
   bean2350))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CreateVaultRequest}
create-vault-request
  [m2354]
  (clojure.core/let
   [bean2353
    (new com.amazonaws.services.glacier.model.CreateVaultRequest)]
   (clojure.core/when-let
    [v2355 (:account-id m2354)]
    (. bean2353 setAccountId (clojure.core/str v2355)))
   (clojure.core/when-let
    [v2355 (:vault-name m2354)]
    (. bean2353 setVaultName (clojure.core/str v2355)))
   bean2353))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadArchiveRequest}
upload-archive-request
  [m2357]
  (clojure.core/let
   [bean2356
    (new com.amazonaws.services.glacier.model.UploadArchiveRequest)]
   (clojure.core/when-let
    [v2358 (:checksum m2357)]
    (. bean2356 setChecksum (clojure.core/str v2358)))
   (clojure.core/when-let
    [v2358 (:account-id m2357)]
    (. bean2356 setAccountId (clojure.core/str v2358)))
   (clojure.core/when-let
    [v2358 (:vault-name m2357)]
    (. bean2356 setVaultName (clojure.core/str v2358)))
   (clojure.core/when-let
    [v2358 (:archive-description m2357)]
    (. bean2356 setArchiveDescription (clojure.core/str v2358)))
   (clojure.core/when-let
    [v2358 (:content-length m2357)]
    (. bean2356 setContentLength (clojure.core/long v2358)))
   (clojure.core/when-let
    [v2358 (:body m2357)]
    (. bean2356 setBody (clojure.java.io/input-stream v2358)))
   bean2356))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m2360]
  (clojure.core/let
   [bean2359
    (new
     com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest)]
   (clojure.core/when-let
    [v2361 (:account-id m2360)]
    (. bean2359 setAccountId (clojure.core/str v2361)))
   (clojure.core/when-let
    [v2361 (:vault-name m2360)]
    (. bean2359 setVaultName (clojure.core/str v2361)))
   (clojure.core/when-let
    [v2361 (:archive-description m2360)]
    (. bean2359 setArchiveDescription (clojure.core/str v2361)))
   (clojure.core/when-let
    [v2361 (:part-size m2360)]
    (. bean2359 setPartSize (clojure.core/str v2361)))
   bean2359))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteArchiveRequest}
delete-archive-request
  [m2363]
  (clojure.core/let
   [bean2362
    (new com.amazonaws.services.glacier.model.DeleteArchiveRequest)]
   (clojure.core/when-let
    [v2364 (:archive-id m2363)]
    (. bean2362 setArchiveId (clojure.core/str v2364)))
   (clojure.core/when-let
    [v2364 (:account-id m2363)]
    (. bean2362 setAccountId (clojure.core/str v2364)))
   (clojure.core/when-let
    [v2364 (:vault-name m2363)]
    (. bean2362 setVaultName (clojure.core/str v2364)))
   bean2362))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetVaultNotificationsRequest}
set-vault-notifications-request
  [m2366]
  (clojure.core/let
   [bean2365
    (new
     com.amazonaws.services.glacier.model.SetVaultNotificationsRequest)]
   (clojure.core/when-let
    [v2367 (:vault-notification-config m2366)]
    (.
     bean2365
     setVaultNotificationConfig
     (glacier/vault-notification-config v2367)))
   (clojure.core/when-let
    [v2367 (:account-id m2366)]
    (. bean2365 setAccountId (clojure.core/str v2367)))
   (clojure.core/when-let
    [v2367 (:vault-name m2366)]
    (. bean2365 setVaultName (clojure.core/str v2367)))
   bean2365))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListPartsRequest}
list-parts-request
  [m2369]
  (clojure.core/let
   [bean2368
    (new com.amazonaws.services.glacier.model.ListPartsRequest)]
   (clojure.core/when-let
    [v2370 (:marker m2369)]
    (. bean2368 setMarker (clojure.core/str v2370)))
   (clojure.core/when-let
    [v2370 (:account-id m2369)]
    (. bean2368 setAccountId (clojure.core/str v2370)))
   (clojure.core/when-let
    [v2370 (:limit m2369)]
    (. bean2368 setLimit (clojure.core/str v2370)))
   (clojure.core/when-let
    [v2370 (:upload-id m2369)]
    (. bean2368 setUploadId (clojure.core/str v2370)))
   (clojure.core/when-let
    [v2370 (:vault-name m2369)]
    (. bean2368 setVaultName (clojure.core/str v2370)))
   bean2368))
 (clojure.core/defmulti
  glacier
  (clojure.core/fn glacier [m__1681__auto__] (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   glacier
   :list-jobs
   [m2372]
   (clojure.core/let
    [credentials2373 (:credentials m2372) args2374 (:args m2372)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2375
      (com.palletops.awaze.common/aws-client :glacier credentials2373)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2375
       listJobs
       (glacier/list-jobs-request (clojure.core/nth args2374 0)))))))
  (clojure.core/defn
   list-jobs-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         vault-name
                         statuscode
                         account-id
                         limit
                         marker
                         completed]}]]),
    :doc "Generate map for listJobs"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :list-jobs,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-jobs
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         vault-name
                         statuscode
                         account-id
                         limit
                         marker
                         completed]}]]),
    :doc "Call listJobs"}
   [credentials2377 & args2378]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2379
     (com.palletops.awaze.common/aws-client :glacier credentials2377)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2379
      listJobs
      (glacier/list-jobs-request (clojure.core/nth args2378 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-notifications
   [m2380]
   (clojure.core/let
    [credentials2381 (:credentials m2380) args2382 (:args m2380)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2383
      (com.palletops.awaze.common/aws-client :glacier credentials2381)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2383
       getVaultNotifications
       (glacier/get-vault-notifications-request
        (clojure.core/nth args2382 0)))))))
  (clojure.core/defn
   get-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for getVaultNotifications"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :get-vault-notifications,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call getVaultNotifications"}
   [credentials2385 & args2386]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2387
     (com.palletops.awaze.common/aws-client :glacier credentials2385)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2387
      getVaultNotifications
      (glacier/get-vault-notifications-request
       (clojure.core/nth args2386 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-multipart-part
   [m2388]
   (clojure.core/let
    [credentials2389 (:credentials m2388) args2390 (:args m2388)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2391
      (com.palletops.awaze.common/aws-client :glacier credentials2389)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2391
       uploadMultipartPart
       (glacier/upload-multipart-part-request
        (clojure.core/nth args2390 0)))))))
  (clojure.core/defn
   upload-multipart-part-map
   {:arglists (quote
               [[credentials
                 {:keys [checksum
                         general-progress-listener
                         vault-name
                         range
                         upload-id
                         account-id
                         body]}]]),
    :doc "Generate map for uploadMultipartPart"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :upload-multipart-part,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   upload-multipart-part
   {:arglists (quote
               [[credentials
                 {:keys [checksum
                         general-progress-listener
                         vault-name
                         range
                         upload-id
                         account-id
                         body]}]]),
    :doc "Call uploadMultipartPart"}
   [credentials2393 & args2394]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2395
     (com.palletops.awaze.common/aws-client :glacier credentials2393)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2395
      uploadMultipartPart
      (glacier/upload-multipart-part-request
       (clojure.core/nth args2394 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-vaults
   [m2396]
   (clojure.core/let
    [credentials2397 (:credentials m2396) args2398 (:args m2396)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2399
      (com.palletops.awaze.common/aws-client :glacier credentials2397)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2399
       listVaults
       (glacier/list-vaults-request (clojure.core/nth args2398 0)))))))
  (clojure.core/defn
   list-vaults-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for listVaults"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :list-vaults,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-vaults
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         account-id]}]]),
    :doc "Call listVaults"}
   [credentials2401 & args2402]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2403
     (com.palletops.awaze.common/aws-client :glacier credentials2401)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2403
      listVaults
      (glacier/list-vaults-request (clojure.core/nth args2402 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault
   [m2404]
   (clojure.core/let
    [credentials2405 (:credentials m2404) args2406 (:args m2404)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2407
      (com.palletops.awaze.common/aws-client :glacier credentials2405)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2407
       deleteVault
       (glacier/delete-vault-request (clojure.core/nth args2406 0)))))))
  (clojure.core/defn
   delete-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for deleteVault"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :delete-vault,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-vault
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call deleteVault"}
   [credentials2409 & args2410]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2411
     (com.palletops.awaze.common/aws-client :glacier credentials2409)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2411
      deleteVault
      (glacier/delete-vault-request (clojure.core/nth args2410 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-job
   [m2412]
   (clojure.core/let
    [credentials2413 (:credentials m2412) args2414 (:args m2412)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2415
      (com.palletops.awaze.common/aws-client :glacier credentials2413)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2415
       initiateJob
       (glacier/initiate-job-request (clojure.core/nth args2414 0)))))))
  (clojure.core/defn
   initiate-job-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         job-parameters
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for initiateJob"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :initiate-job,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   initiate-job
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         job-parameters
                         general-progress-listener
                         account-id]}]]),
    :doc "Call initiateJob"}
   [credentials2417 & args2418]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2419
     (com.palletops.awaze.common/aws-client :glacier credentials2417)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2419
      initiateJob
      (glacier/initiate-job-request (clojure.core/nth args2418 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-vault
   [m2420]
   (clojure.core/let
    [credentials2421 (:credentials m2420) args2422 (:args m2420)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2423
      (com.palletops.awaze.common/aws-client :glacier credentials2421)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2423
       describeVault
       (glacier/describe-vault-request (clojure.core/nth args2422 0)))))))
  (clojure.core/defn
   describe-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for describeVault"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :describe-vault,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-vault
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call describeVault"}
   [credentials2425 & args2426]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2427
     (com.palletops.awaze.common/aws-client :glacier credentials2425)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2427
      describeVault
      (glacier/describe-vault-request (clojure.core/nth args2426 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :abort-multipart-upload
   [m2428]
   (clojure.core/let
    [credentials2429 (:credentials m2428) args2430 (:args m2428)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2431
      (com.palletops.awaze.common/aws-client :glacier credentials2429)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2431
       abortMultipartUpload
       (glacier/abort-multipart-upload-request
        (clojure.core/nth args2430 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         upload-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :abort-multipart-upload,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         upload-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials2433 & args2434]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2435
     (com.palletops.awaze.common/aws-client :glacier credentials2433)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2435
      abortMultipartUpload
      (glacier/abort-multipart-upload-request
       (clojure.core/nth args2434 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault-notifications
   [m2436]
   (clojure.core/let
    [credentials2437 (:credentials m2436) args2438 (:args m2436)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2439
      (com.palletops.awaze.common/aws-client :glacier credentials2437)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2439
       deleteVaultNotifications
       (glacier/delete-vault-notifications-request
        (clojure.core/nth args2438 0)))))))
  (clojure.core/defn
   delete-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for deleteVaultNotifications"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :delete-vault-notifications,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call deleteVaultNotifications"}
   [credentials2441 & args2442]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2443
     (com.palletops.awaze.common/aws-client :glacier credentials2441)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2443
      deleteVaultNotifications
      (glacier/delete-vault-notifications-request
       (clojure.core/nth args2442 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :complete-multipart-upload
   [m2444]
   (clojure.core/let
    [credentials2445 (:credentials m2444) args2446 (:args m2444)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2447
      (com.palletops.awaze.common/aws-client :glacier credentials2445)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2447
       completeMultipartUpload
       (glacier/complete-multipart-upload-request
        (clojure.core/nth args2446 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         general-progress-listener
                         archive-size
                         vault-name
                         account-id
                         checksum]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :complete-multipart-upload,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         general-progress-listener
                         archive-size
                         vault-name
                         account-id
                         checksum]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials2449 & args2450]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2451
     (com.palletops.awaze.common/aws-client :glacier credentials2449)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2451
      completeMultipartUpload
      (glacier/complete-multipart-upload-request
       (clojure.core/nth args2450 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-job-output
   [m2452]
   (clojure.core/let
    [credentials2453 (:credentials m2452) args2454 (:args m2452)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2455
      (com.palletops.awaze.common/aws-client :glacier credentials2453)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2455
       getJobOutput
       (glacier/get-job-output-request (clojure.core/nth args2454 0)))))))
  (clojure.core/defn
   get-job-output-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         range
                         job-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for getJobOutput"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :get-job-output,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   get-job-output
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         range
                         job-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Call getJobOutput"}
   [credentials2457 & args2458]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2459
     (com.palletops.awaze.common/aws-client :glacier credentials2457)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2459
      getJobOutput
      (glacier/get-job-output-request (clojure.core/nth args2458 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-multipart-uploads
   [m2460]
   (clojure.core/let
    [credentials2461 (:credentials m2460) args2462 (:args m2460)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2463
      (com.palletops.awaze.common/aws-client :glacier credentials2461)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2463
       listMultipartUploads
       (glacier/list-multipart-uploads-request
        (clojure.core/nth args2462 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         upload-id-marker
                         limit
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :list-multipart-uploads,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         upload-id-marker
                         limit
                         general-progress-listener
                         account-id]}]]),
    :doc "Call listMultipartUploads"}
   [credentials2465 & args2466]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2467
     (com.palletops.awaze.common/aws-client :glacier credentials2465)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2467
      listMultipartUploads
      (glacier/list-multipart-uploads-request
       (clojure.core/nth args2466 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-job
   [m2468]
   (clojure.core/let
    [credentials2469 (:credentials m2468) args2470 (:args m2468)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2471
      (com.palletops.awaze.common/aws-client :glacier credentials2469)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2471
       describeJob
       (glacier/describe-job-request (clojure.core/nth args2470 0)))))))
  (clojure.core/defn
   describe-job-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         job-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for describeJob"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :describe-job,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-job
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         job-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Call describeJob"}
   [credentials2473 & args2474]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2475
     (com.palletops.awaze.common/aws-client :glacier credentials2473)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2475
      describeJob
      (glacier/describe-job-request (clojure.core/nth args2474 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :create-vault
   [m2476]
   (clojure.core/let
    [credentials2477 (:credentials m2476) args2478 (:args m2476)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2479
      (com.palletops.awaze.common/aws-client :glacier credentials2477)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2479
       createVault
       (glacier/create-vault-request (clojure.core/nth args2478 0)))))))
  (clojure.core/defn
   create-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for createVault"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :create-vault,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-vault
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call createVault"}
   [credentials2481 & args2482]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2483
     (com.palletops.awaze.common/aws-client :glacier credentials2481)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2483
      createVault
      (glacier/create-vault-request (clojure.core/nth args2482 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-archive
   [m2484]
   (clojure.core/let
    [credentials2485 (:credentials m2484) args2486 (:args m2484)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2487
      (com.palletops.awaze.common/aws-client :glacier credentials2485)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2487
       uploadArchive
       (glacier/upload-archive-request (clojure.core/nth args2486 0)))))))
  (clojure.core/defn
   upload-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [checksum
                         general-progress-listener
                         vault-name
                         account-id
                         content-length
                         body
                         archive-description]}]]),
    :doc "Generate map for uploadArchive"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :upload-archive,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   upload-archive
   {:arglists (quote
               [[credentials
                 {:keys [checksum
                         general-progress-listener
                         vault-name
                         account-id
                         content-length
                         body
                         archive-description]}]]),
    :doc "Call uploadArchive"}
   [credentials2489 & args2490]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2491
     (com.palletops.awaze.common/aws-client :glacier credentials2489)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2491
      uploadArchive
      (glacier/upload-archive-request (clojure.core/nth args2490 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-multipart-upload
   [m2492]
   (clojure.core/let
    [credentials2493 (:credentials m2492) args2494 (:args m2492)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2495
      (com.palletops.awaze.common/aws-client :glacier credentials2493)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2495
       initiateMultipartUpload
       (glacier/initiate-multipart-upload-request
        (clojure.core/nth args2494 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         part-size
                         general-progress-listener
                         archive-description
                         account-id]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :initiate-multipart-upload,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         part-size
                         general-progress-listener
                         archive-description
                         account-id]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials2497 & args2498]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2499
     (com.palletops.awaze.common/aws-client :glacier credentials2497)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2499
      initiateMultipartUpload
      (glacier/initiate-multipart-upload-request
       (clojure.core/nth args2498 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-archive
   [m2500]
   (clojure.core/let
    [credentials2501 (:credentials m2500) args2502 (:args m2500)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2503
      (com.palletops.awaze.common/aws-client :glacier credentials2501)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2503
       deleteArchive
       (glacier/delete-archive-request (clojure.core/nth args2502 0)))))))
  (clojure.core/defn
   delete-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         archive-id
                         account-id]}]]),
    :doc "Generate map for deleteArchive"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :delete-archive,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-archive
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         archive-id
                         account-id]}]]),
    :doc "Call deleteArchive"}
   [credentials2505 & args2506]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2507
     (com.palletops.awaze.common/aws-client :glacier credentials2505)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2507
      deleteArchive
      (glacier/delete-archive-request (clojure.core/nth args2506 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-vault-notifications
   [m2508]
   (clojure.core/let
    [credentials2509 (:credentials m2508) args2510 (:args m2508)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2511
      (com.palletops.awaze.common/aws-client :glacier credentials2509)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2511
       setVaultNotifications
       (glacier/set-vault-notifications-request
        (clojure.core/nth args2510 0)))))))
  (clojure.core/defn
   set-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-notification-config
                         vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for setVaultNotifications"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :set-vault-notifications,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [vault-notification-config
                         vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call setVaultNotifications"}
   [credentials2513 & args2514]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2515
     (com.palletops.awaze.common/aws-client :glacier credentials2513)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2515
      setVaultNotifications
      (glacier/set-vault-notifications-request
       (clojure.core/nth args2514 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-parts
   [m2516]
   (clojure.core/let
    [credentials2517 (:credentials m2516) args2518 (:args m2516)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2519
      (com.palletops.awaze.common/aws-client :glacier credentials2517)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2519
       listParts
       (glacier/list-parts-request (clojure.core/nth args2518 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         marker
                         limit
                         general-progress-listener
                         vault-name
                         account-id]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :list-parts,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         marker
                         limit
                         general-progress-listener
                         vault-name
                         account-id]}]]),
    :doc "Call listParts"}
   [credentials2521 & args2522]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2523
     (com.palletops.awaze.common/aws-client :glacier credentials2521)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2523
      listParts
      (glacier/list-parts-request (clojure.core/nth args2522 0))))))))
