(ns
 com.palletops.awaze.elasticmapreduce
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticmapreduce :as elasticmapreduce]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticmapreduce
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.KeyValue}
key-value
  [m4079]
  (clojure.core/let
   [bean4078
    (new com.amazonaws.services.elasticmapreduce.model.KeyValue)]
   (clojure.core/when-let
    [v4080 (:key m4079)]
    (. bean4078 setKey (clojure.core/str v4080)))
   (clojure.core/when-let
    [v4080 (:value m4079)]
    (. bean4078 setValue (clojure.core/str v4080)))
   bean4078))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.MarketType}
market-type
  [m4082]
  (.
   com.amazonaws.services.elasticmapreduce.model.MarketType
   fromValue
   (clojure.core/name m4082)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ActionOnFailure}
action-on-failure
  [m4085]
  (.
   com.amazonaws.services.elasticmapreduce.model.ActionOnFailure
   fromValue
   (clojure.core/name m4085)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig}
hadoop-jar-step-config
  [m4088]
  (clojure.core/let
   [bean4087
    (new
     com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig)]
   (clojure.core/when-let
    [v4089 (:properties m4088)]
    (.
     bean4087
     setProperties
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4168] (elasticmapreduce/key-value arg4168))
 v4089)))
   (clojure.core/when-let
    [v4089 (:args m4088)]
    (.
     bean4087
     setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4169] (clojure.core/str arg4169))
 v4089)))
   (clojure.core/when-let
    [v4089 (:jar m4088)]
    (. bean4087 setJar (clojure.core/str v4089)))
   (clojure.core/when-let
    [v4089 (:main-class m4088)]
    (. bean4087 setMainClass (clojure.core/str v4089)))
   bean4087))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig}
script-bootstrap-action-config
  [m4091]
  (clojure.core/let
   [bean4090
    (new
     com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig)]
   (clojure.core/when-let
    [v4092 (:args m4091)]
    (.
     bean4090
     setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4170] (clojure.core/str arg4170))
 v4092)))
   (clojure.core/when-let
    [v4092 (:path m4091)]
    (. bean4090 setPath (clojure.core/str v4092)))
   bean4090))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.PlacementType}
placement-type
  [m4094]
  (clojure.core/let
   [bean4093
    (new com.amazonaws.services.elasticmapreduce.model.PlacementType)]
   (clojure.core/when-let
    [v4095 (:availability-zone m4094)]
    (. bean4093 setAvailabilityZone (clojure.core/str v4095)))
   bean4093))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig}
instance-group-config
  [m4097]
  (clojure.core/let
   [bean4096
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig)]
   (clojure.core/when-let
    [v4098 (:instance-type m4097)]
    (. bean4096 setInstanceType (clojure.core/str v4098)))
   (clojure.core/when-let
    [v4098 (:name m4097)]
    (. bean4096 setName (clojure.core/str v4098)))
   (clojure.core/when-let
    [v4098 (:instance-count m4097)]
    (. bean4096 setInstanceCount (clojure.core/int v4098)))
   (clojure.core/when-let
    [v4098 (:market m4097)]
    (. bean4096 setMarket (elasticmapreduce/market-type v4098)))
   (clojure.core/when-let
    [v4098 (:instance-role m4097)]
    (. bean4096 setInstanceRole (clojure.core/str v4098)))
   (clojure.core/when-let
    [v4098 (:bid-price m4097)]
    (. bean4096 setBidPrice (clojure.core/str v4098)))
   bean4096))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.StepConfig}
step-config
  [m4100]
  (clojure.core/let
   [bean4099
    (new com.amazonaws.services.elasticmapreduce.model.StepConfig)]
   (clojure.core/when-let
    [v4101 (:name m4100)]
    (. bean4099 setName (clojure.core/str v4101)))
   (clojure.core/when-let
    [v4101 (:action-on-failure m4100)]
    (.
     bean4099
     setActionOnFailure
     (elasticmapreduce/action-on-failure v4101)))
   (clojure.core/when-let
    [v4101 (:hadoop-jar-step m4100)]
    (.
     bean4099
     setHadoopJarStep
     (elasticmapreduce/hadoop-jar-step-config v4101)))
   bean4099))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig}
bootstrap-action-config
  [m4103]
  (clojure.core/let
   [bean4102
    (new
     com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig)]
   (clojure.core/when-let
    [v4104 (:name m4103)]
    (. bean4102 setName (clojure.core/str v4104)))
   (clojure.core/when-let
    [v4104 (:script-bootstrap-action m4103)]
    (.
     bean4102
     setScriptBootstrapAction
     (elasticmapreduce/script-bootstrap-action-config v4104)))
   bean4102))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig}
supported-product-config
  [m4106]
  (clojure.core/let
   [bean4105
    (new
     com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig)]
   (clojure.core/when-let
    [v4107 (:name m4106)]
    (. bean4105 setName (clojure.core/str v4107)))
   (clojure.core/when-let
    [v4107 (:args m4106)]
    (.
     bean4105
     setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4171] (clojure.core/str arg4171))
 v4107)))
   bean4105))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Tag}
tag
  [m4109]
  (clojure.core/let
   [bean4108 (new com.amazonaws.services.elasticmapreduce.model.Tag)]
   (clojure.core/when-let
    [v4110 (:key m4109)]
    (. bean4108 setKey (clojure.core/str v4110)))
   (clojure.core/when-let
    [v4110 (:value m4109)]
    (. bean4108 setValue (clojure.core/str v4110)))
   bean4108))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig}
job-flow-instances-config
  [m4112]
  (clojure.core/let
   [bean4111
    (new
     com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig)]
   (clojure.core/when-let
    [v4113 (:placement m4112)]
    (. bean4111 setPlacement (elasticmapreduce/placement-type v4113)))
   (clojure.core/when-let
    [v4113 (:keep-job-flow-alive-when-no-steps m4112)]
    (.
     bean4111
     setKeepJobFlowAliveWhenNoSteps
     (clojure.core/boolean v4113)))
   (clojure.core/when-let
    [v4113 (:slave-instance-type m4112)]
    (. bean4111 setSlaveInstanceType (clojure.core/str v4113)))
   (clojure.core/when-let
    [v4113 (:ec2subnet-id m4112)]
    (. bean4111 setEc2SubnetId (clojure.core/str v4113)))
   (clojure.core/when-let
    [v4113 (:instance-groups m4112)]
    (.
     bean4111
     setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4172]
  (elasticmapreduce/instance-group-config arg4172))
 v4113)))
   (clojure.core/when-let
    [v4113 (:termination-protected m4112)]
    (. bean4111 setTerminationProtected (clojure.core/boolean v4113)))
   (clojure.core/when-let
    [v4113 (:hadoop-version m4112)]
    (. bean4111 setHadoopVersion (clojure.core/str v4113)))
   (clojure.core/when-let
    [v4113 (:master-instance-type m4112)]
    (. bean4111 setMasterInstanceType (clojure.core/str v4113)))
   (clojure.core/when-let
    [v4113 (:instance-count m4112)]
    (. bean4111 setInstanceCount (clojure.core/int v4113)))
   (clojure.core/when-let
    [v4113 (:ec2key-name m4112)]
    (. bean4111 setEc2KeyName (clojure.core/str v4113)))
   bean4111))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig}
instance-group-modify-config
  [m4115]
  (clojure.core/let
   [bean4114
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig)]
   (clojure.core/when-let
    [v4116 (:instance-group-id m4115)]
    (. bean4114 setInstanceGroupId (clojure.core/str v4116)))
   (clojure.core/when-let
    [v4116 (:instance-count m4115)]
    (. bean4114 setInstanceCount (clojure.core/int v4116)))
   (clojure.core/when-let
    [v4116 (:ec2instance-ids-to-terminate m4115)]
    (.
     bean4114
     setEC2InstanceIdsToTerminate
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4173] (clojure.core/str arg4173))
 v4116)))
   bean4114))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest}
run-job-flow-request
  [m4118]
  (clojure.core/let
   [bean4117
    (new
     com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest)]
   (clojure.core/when-let
    [v4119 (:steps m4118)]
    (.
     bean4117
     setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4174] (elasticmapreduce/step-config arg4174))
 v4119)))
   (clojure.core/when-let
    [v4119 (:service-role m4118)]
    (. bean4117 setServiceRole (clojure.core/str v4119)))
   (clojure.core/when-let
    [v4119 (:log-uri m4118)]
    (. bean4117 setLogUri (clojure.core/str v4119)))
   (clojure.core/when-let
    [v4119 (:name m4118)]
    (. bean4117 setName (clojure.core/str v4119)))
   (clojure.core/when-let
    [v4119 (:supported-products m4118)]
    (.
     bean4117
     setSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4175] (clojure.core/str arg4175))
 v4119)))
   (clojure.core/when-let
    [v4119 (:bootstrap-actions m4118)]
    (.
     bean4117
     setBootstrapActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4176]
  (elasticmapreduce/bootstrap-action-config arg4176))
 v4119)))
   (clojure.core/when-let
    [v4119 (:visible-to-all-users m4118)]
    (. bean4117 setVisibleToAllUsers (clojure.core/boolean v4119)))
   (clojure.core/when-let
    [v4119 (:new-supported-products m4118)]
    (.
     bean4117
     setNewSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4177]
  (elasticmapreduce/supported-product-config arg4177))
 v4119)))
   (clojure.core/when-let
    [v4119 (:additional-info m4118)]
    (. bean4117 setAdditionalInfo (clojure.core/str v4119)))
   (clojure.core/when-let
    [v4119 (:tags m4118)]
    (.
     bean4117
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4178] (elasticmapreduce/tag arg4178))
 v4119)))
   (clojure.core/when-let
    [v4119 (:instances m4118)]
    (.
     bean4117
     setInstances
     (elasticmapreduce/job-flow-instances-config v4119)))
   (clojure.core/when-let
    [v4119 (:ami-version m4118)]
    (. bean4117 setAmiVersion (clojure.core/str v4119)))
   (clojure.core/when-let
    [v4119 (:job-flow-role m4118)]
    (. bean4117 setJobFlowRole (clojure.core/str v4119)))
   bean4117))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest}
list-bootstrap-actions-request
  [m4121]
  (clojure.core/let
   [bean4120
    (new
     com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest)]
   (clojure.core/when-let
    [v4122 (:cluster-id m4121)]
    (. bean4120 setClusterId (clojure.core/str v4122)))
   (clojure.core/when-let
    [v4122 (:marker m4121)]
    (. bean4120 setMarker (clojure.core/str v4122)))
   bean4120))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest}
remove-tags-request
  [m4124]
  (clojure.core/let
   [bean4123
    (new
     com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest)]
   (clojure.core/when-let
    [v4125 (:resource-id m4124)]
    (. bean4123 setResourceId (clojure.core/str v4125)))
   (clojure.core/when-let
    [v4125 (:tag-keys m4124)]
    (.
     bean4123
     setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4179] (clojure.core/str arg4179))
 v4125)))
   bean4123))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest}
list-instance-groups-request
  [m4127]
  (clojure.core/let
   [bean4126
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest)]
   (clojure.core/when-let
    [v4128 (:cluster-id m4127)]
    (. bean4126 setClusterId (clojure.core/str v4128)))
   (clojure.core/when-let
    [v4128 (:marker m4127)]
    (. bean4126 setMarker (clojure.core/str v4128)))
   bean4126))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest}
set-visible-to-all-users-request
  [m4130]
  (clojure.core/let
   [bean4129
    (new
     com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest)]
   (clojure.core/when-let
    [v4131 (:visible-to-all-users m4130)]
    (. bean4129 setVisibleToAllUsers (clojure.core/boolean v4131)))
   (clojure.core/when-let
    [v4131 (:job-flow-ids m4130)]
    (.
     bean4129
     setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4180] (clojure.core/str arg4180))
 v4131)))
   bean4129))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest}
modify-instance-groups-request
  [m4133]
  (clojure.core/let
   [bean4132
    (new
     com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest)]
   (clojure.core/when-let
    [v4134 (:instance-groups m4133)]
    (.
     bean4132
     setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4181]
  (elasticmapreduce/instance-group-modify-config arg4181))
 v4134)))
   bean4132))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest}
describe-cluster-request
  [m4136]
  (clojure.core/let
   [bean4135
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest)]
   (clojure.core/when-let
    [v4137 (:cluster-id m4136)]
    (. bean4135 setClusterId (clojure.core/str v4137)))
   bean4135))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddTagsRequest}
add-tags-request
  [m4139]
  (clojure.core/let
   [bean4138
    (new com.amazonaws.services.elasticmapreduce.model.AddTagsRequest)]
   (clojure.core/when-let
    [v4140 (:tags m4139)]
    (.
     bean4138
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4182] (elasticmapreduce/tag arg4182))
 v4140)))
   (clojure.core/when-let
    [v4140 (:resource-id m4139)]
    (. bean4138 setResourceId (clojure.core/str v4140)))
   bean4138))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest}
set-termination-protection-request
  [m4142]
  (clojure.core/let
   [bean4141
    (new
     com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest)]
   (clojure.core/when-let
    [v4143 (:job-flow-ids m4142)]
    (.
     bean4141
     setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4183] (clojure.core/str arg4183))
 v4143)))
   (clojure.core/when-let
    [v4143 (:termination-protected m4142)]
    (. bean4141 setTerminationProtected (clojure.core/boolean v4143)))
   bean4141))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest}
add-instance-groups-request
  [m4145]
  (clojure.core/let
   [bean4144
    (new
     com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest)]
   (clojure.core/when-let
    [v4146 (:job-flow-id m4145)]
    (. bean4144 setJobFlowId (clojure.core/str v4146)))
   (clojure.core/when-let
    [v4146 (:instance-groups m4145)]
    (.
     bean4144
     setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4184]
  (elasticmapreduce/instance-group-config arg4184))
 v4146)))
   bean4144))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest}
describe-step-request
  [m4148]
  (clojure.core/let
   [bean4147
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest)]
   (clojure.core/when-let
    [v4149 (:cluster-id m4148)]
    (. bean4147 setClusterId (clojure.core/str v4149)))
   (clojure.core/when-let
    [v4149 (:step-id m4148)]
    (. bean4147 setStepId (clojure.core/str v4149)))
   bean4147))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest}
terminate-job-flows-request
  [m4151]
  (clojure.core/let
   [bean4150
    (new
     com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest)]
   (clojure.core/when-let
    [v4152 (:job-flow-ids m4151)]
    (.
     bean4150
     setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4185] (clojure.core/str arg4185))
 v4152)))
   bean4150))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest}
list-instances-request
  [m4154]
  (clojure.core/let
   [bean4153
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest)]
   (clojure.core/when-let
    [v4155 (:cluster-id m4154)]
    (. bean4153 setClusterId (clojure.core/str v4155)))
   (clojure.core/when-let
    [v4155 (:instance-group-id m4154)]
    (. bean4153 setInstanceGroupId (clojure.core/str v4155)))
   (clojure.core/when-let
    [v4155 (:instance-group-types m4154)]
    (.
     bean4153
     setInstanceGroupTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4186] (clojure.core/str arg4186))
 v4155)))
   (clojure.core/when-let
    [v4155 (:marker m4154)]
    (. bean4153 setMarker (clojure.core/str v4155)))
   bean4153))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListClustersRequest}
list-clusters-request
  [m4157]
  (clojure.core/let
   [bean4156
    (new
     com.amazonaws.services.elasticmapreduce.model.ListClustersRequest)]
   (clojure.core/when-let
    [v4158 (:created-after m4157)]
    (.
     bean4156
     setCreatedAfter
     (com.palletops.awaze.common/to-date v4158)))
   (clojure.core/when-let
    [v4158 (:created-before m4157)]
    (.
     bean4156
     setCreatedBefore
     (com.palletops.awaze.common/to-date v4158)))
   (clojure.core/when-let
    [v4158 (:cluster-states m4157)]
    (.
     bean4156
     setClusterStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4187] (clojure.core/str arg4187))
 v4158)))
   (clojure.core/when-let
    [v4158 (:marker m4157)]
    (. bean4156 setMarker (clojure.core/str v4158)))
   bean4156))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest}
add-job-flow-steps-request
  [m4160]
  (clojure.core/let
   [bean4159
    (new
     com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest)]
   (clojure.core/when-let
    [v4161 (:job-flow-id m4160)]
    (. bean4159 setJobFlowId (clojure.core/str v4161)))
   (clojure.core/when-let
    [v4161 (:steps m4160)]
    (.
     bean4159
     setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4188] (elasticmapreduce/step-config arg4188))
 v4161)))
   bean4159))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListStepsRequest}
list-steps-request
  [m4163]
  (clojure.core/let
   [bean4162
    (new
     com.amazonaws.services.elasticmapreduce.model.ListStepsRequest)]
   (clojure.core/when-let
    [v4164 (:cluster-id m4163)]
    (. bean4162 setClusterId (clojure.core/str v4164)))
   (clojure.core/when-let
    [v4164 (:step-states m4163)]
    (.
     bean4162
     setStepStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4189] (clojure.core/str arg4189))
 v4164)))
   (clojure.core/when-let
    [v4164 (:marker m4163)]
    (. bean4162 setMarker (clojure.core/str v4164)))
   bean4162))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest}
describe-job-flows-request
  [m4166]
  (clojure.core/let
   [bean4165
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest)]
   (clojure.core/when-let
    [v4167 (:job-flow-ids m4166)]
    (.
     bean4165
     setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4190] (clojure.core/str arg4190))
 v4167)))
   (clojure.core/when-let
    [v4167 (:created-after m4166)]
    (.
     bean4165
     setCreatedAfter
     (com.palletops.awaze.common/to-date v4167)))
   (clojure.core/when-let
    [v4167 (:created-before m4166)]
    (.
     bean4165
     setCreatedBefore
     (com.palletops.awaze.common/to-date v4167)))
   (clojure.core/when-let
    [v4167 (:job-flow-states m4166)]
    (.
     bean4165
     setJobFlowStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4191] (clojure.core/str arg4191))
 v4167)))
   bean4165))
 (clojure.core/defmulti
  elasticmapreduce
  (clojure.core/fn
   elasticmapreduce
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :run-job-flow
   [m4192]
   (clojure.core/let
    [credentials4193 (:credentials m4192) args4194 (:args m4192)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4195
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4193)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4195
       runJobFlow
       (elasticmapreduce/run-job-flow-request
        (clojure.core/nth args4194 0)))))))
  (clojure.core/defn
   run-job-flow-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-role
                         additional-info
                         general-progress-listener
                         name
                         service-role
                         log-uri
                         bootstrap-actions
                         visible-to-all-users
                         supported-products
                         ami-version
                         steps
                         new-supported-products
                         instances
                         tags]}]]),
    :doc "Generate map for runJobFlow"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :run-job-flow,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   run-job-flow
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-role
                         additional-info
                         general-progress-listener
                         name
                         service-role
                         log-uri
                         bootstrap-actions
                         visible-to-all-users
                         supported-products
                         ami-version
                         steps
                         new-supported-products
                         instances
                         tags]}]]),
    :doc "Call runJobFlow"}
   [credentials4197 & args4198]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4199
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4197)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4199
      runJobFlow
      (elasticmapreduce/run-job-flow-request
       (clojure.core/nth args4198 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-bootstrap-actions
   [m4200]
   (clojure.core/let
    [credentials4201 (:credentials m4200) args4202 (:args m4200)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4203
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4201)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4203
       listBootstrapActions
       (elasticmapreduce/list-bootstrap-actions-request
        (clojure.core/nth args4202 0)))))))
  (clojure.core/defn
   list-bootstrap-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Generate map for listBootstrapActions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-bootstrap-actions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-bootstrap-actions
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Call listBootstrapActions"}
   [credentials4205 & args4206]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4207
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4205)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4207
      listBootstrapActions
      (elasticmapreduce/list-bootstrap-actions-request
       (clojure.core/nth args4206 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :remove-tags
   [m4208]
   (clojure.core/let
    [credentials4209 (:credentials m4208) args4210 (:args m4208)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4211
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4209)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4211
       removeTags
       (elasticmapreduce/remove-tags-request
        (clojure.core/nth args4210 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-id
                         general-progress-listener]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :remove-tags,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [tag-keys
                         resource-id
                         general-progress-listener]}]]),
    :doc "Call removeTags"}
   [credentials4213 & args4214]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4215
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4213)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4215
      removeTags
      (elasticmapreduce/remove-tags-request
       (clojure.core/nth args4214 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instance-groups
   [m4216]
   (clojure.core/let
    [credentials4217 (:credentials m4216) args4218 (:args m4216)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4219
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4217)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4219
       listInstanceGroups
       (elasticmapreduce/list-instance-groups-request
        (clojure.core/nth args4218 0)))))))
  (clojure.core/defn
   list-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Generate map for listInstanceGroups"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-instance-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [marker general-progress-listener cluster-id]}]]),
    :doc "Call listInstanceGroups"}
   [credentials4221 & args4222]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4223
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4221)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4223
      listInstanceGroups
      (elasticmapreduce/list-instance-groups-request
       (clojure.core/nth args4222 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-visible-to-all-users
   [m4224]
   (clojure.core/let
    [credentials4225 (:credentials m4224) args4226 (:args m4224)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4227
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4225)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4227
       setVisibleToAllUsers
       (elasticmapreduce/set-visible-to-all-users-request
        (clojure.core/nth args4226 0)))))))
  (clojure.core/defn
   set-visible-to-all-users-map
   {:arglists (quote
               [[credentials
                 {:keys [visible-to-all-users
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Generate map for setVisibleToAllUsers"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :set-visible-to-all-users,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-visible-to-all-users
   {:arglists (quote
               [[credentials
                 {:keys [visible-to-all-users
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Call setVisibleToAllUsers"}
   [credentials4229 & args4230]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4231
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4229)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4231
      setVisibleToAllUsers
      (elasticmapreduce/set-visible-to-all-users-request
       (clojure.core/nth args4230 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :modify-instance-groups
   [m4232]
   (clojure.core/let
    [credentials4233 (:credentials m4232) args4234 (:args m4232)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4235
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4233)]
     (clojure.core/case
      (clojure.core/count args4234)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4235
        modifyInstanceGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4235
        modifyInstanceGroups
        (elasticmapreduce/modify-instance-groups-request
         (clojure.core/nth args4234 0))))))))
  (clojure.core/defn
   modify-instance-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-groups general-progress-listener]}]]),
    :doc "Generate map for modifyInstanceGroups, modifyInstanceGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :modify-instance-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :modify-instance-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-instance-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-groups general-progress-listener]}]]),
    :doc "Call modifyInstanceGroups, modifyInstanceGroups"}
   [credentials4237 & args4238]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4239
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4237)]
    (clojure.core/case
     (clojure.core/count args4238)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4239
       modifyInstanceGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4239
       modifyInstanceGroups
       (elasticmapreduce/modify-instance-groups-request
        (clojure.core/nth args4238 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-cluster
   [m4240]
   (clojure.core/let
    [credentials4241 (:credentials m4240) args4242 (:args m4240)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4243
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4241)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4243
       describeCluster
       (elasticmapreduce/describe-cluster-request
        (clojure.core/nth args4242 0)))))))
  (clojure.core/defn
   describe-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-id]}]]),
    :doc "Generate map for describeCluster"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-cluster,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-id]}]]),
    :doc "Call describeCluster"}
   [credentials4245 & args4246]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4247
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4245)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4247
      describeCluster
      (elasticmapreduce/describe-cluster-request
       (clojure.core/nth args4246 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-tags
   [m4248]
   (clojure.core/let
    [credentials4249 (:credentials m4248) args4250 (:args m4248)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4251
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4249)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4251
       addTags
       (elasticmapreduce/add-tags-request
        (clojure.core/nth args4250 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-id general-progress-listener]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-tags,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags resource-id general-progress-listener]}]]),
    :doc "Call addTags"}
   [credentials4253 & args4254]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4255
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4253)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4255
      addTags
      (elasticmapreduce/add-tags-request
       (clojure.core/nth args4254 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-termination-protection
   [m4256]
   (clojure.core/let
    [credentials4257 (:credentials m4256) args4258 (:args m4256)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4259
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4257)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4259
       setTerminationProtection
       (elasticmapreduce/set-termination-protection-request
        (clojure.core/nth args4258 0)))))))
  (clojure.core/defn
   set-termination-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [termination-protected
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Generate map for setTerminationProtection"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :set-termination-protection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-termination-protection
   {:arglists (quote
               [[credentials
                 {:keys [termination-protected
                         job-flow-ids
                         general-progress-listener]}]]),
    :doc "Call setTerminationProtection"}
   [credentials4261 & args4262]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4263
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4261)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4263
      setTerminationProtection
      (elasticmapreduce/set-termination-protection-request
       (clojure.core/nth args4262 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-instance-groups
   [m4264]
   (clojure.core/let
    [credentials4265 (:credentials m4264) args4266 (:args m4264)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4267
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4265)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4267
       addInstanceGroups
       (elasticmapreduce/add-instance-groups-request
        (clojure.core/nth args4266 0)))))))
  (clojure.core/defn
   add-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-id
                         instance-groups
                         general-progress-listener]}]]),
    :doc "Generate map for addInstanceGroups"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-instance-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-id
                         instance-groups
                         general-progress-listener]}]]),
    :doc "Call addInstanceGroups"}
   [credentials4269 & args4270]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4271
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4269)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4271
      addInstanceGroups
      (elasticmapreduce/add-instance-groups-request
       (clojure.core/nth args4270 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-step
   [m4272]
   (clojure.core/let
    [credentials4273 (:credentials m4272) args4274 (:args m4272)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4275
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4273)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4275
       describeStep
       (elasticmapreduce/describe-step-request
        (clojure.core/nth args4274 0)))))))
  (clojure.core/defn
   describe-step-map
   {:arglists (quote
               [[credentials
                 {:keys [step-id general-progress-listener cluster-id]}]]),
    :doc "Generate map for describeStep"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-step,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-step
   {:arglists (quote
               [[credentials
                 {:keys [step-id general-progress-listener cluster-id]}]]),
    :doc "Call describeStep"}
   [credentials4277 & args4278]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4279
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4277)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4279
      describeStep
      (elasticmapreduce/describe-step-request
       (clojure.core/nth args4278 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :terminate-job-flows
   [m4280]
   (clojure.core/let
    [credentials4281 (:credentials m4280) args4282 (:args m4280)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4283
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4281)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4283
       terminateJobFlows
       (elasticmapreduce/terminate-job-flows-request
        (clojure.core/nth args4282 0)))))))
  (clojure.core/defn
   terminate-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-ids general-progress-listener]}]]),
    :doc "Generate map for terminateJobFlows"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :terminate-job-flows,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   terminate-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-ids general-progress-listener]}]]),
    :doc "Call terminateJobFlows"}
   [credentials4285 & args4286]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4287
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4285)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4287
      terminateJobFlows
      (elasticmapreduce/terminate-job-flows-request
       (clojure.core/nth args4286 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instances
   [m4288]
   (clojure.core/let
    [credentials4289 (:credentials m4288) args4290 (:args m4288)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4291
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4289)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4291
       listInstances
       (elasticmapreduce/list-instances-request
        (clojure.core/nth args4290 0)))))))
  (clojure.core/defn
   list-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         instance-group-types
                         instance-group-id
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Generate map for listInstances"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-instances,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-instances
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         instance-group-types
                         instance-group-id
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Call listInstances"}
   [credentials4293 & args4294]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4295
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4293)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4295
      listInstances
      (elasticmapreduce/list-instances-request
       (clojure.core/nth args4294 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-clusters
   [m4296]
   (clojure.core/let
    [credentials4297 (:credentials m4296) args4298 (:args m4296)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4299
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4297)]
     (clojure.core/case
      (clojure.core/count args4298)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4299
        listClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4299
        listClusters
        (elasticmapreduce/list-clusters-request
         (clojure.core/nth args4298 0))))))))
  (clojure.core/defn
   list-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker
                         general-progress-listener
                         created-before
                         created-after
                         cluster-states]}]]),
    :doc "Generate map for listClusters, listClusters"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-clusters,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-clusters,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker
                         general-progress-listener
                         created-before
                         created-after
                         cluster-states]}]]),
    :doc "Call listClusters, listClusters"}
   [credentials4301 & args4302]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4303
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4301)]
    (clojure.core/case
     (clojure.core/count args4302)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4303
       listClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4303
       listClusters
       (elasticmapreduce/list-clusters-request
        (clojure.core/nth args4302 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-job-flow-steps
   [m4304]
   (clojure.core/let
    [credentials4305 (:credentials m4304) args4306 (:args m4304)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4307
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4305)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4307
       addJobFlowSteps
       (elasticmapreduce/add-job-flow-steps-request
        (clojure.core/nth args4306 0)))))))
  (clojure.core/defn
   add-job-flow-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [steps job-flow-id general-progress-listener]}]]),
    :doc "Generate map for addJobFlowSteps"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-job-flow-steps,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   add-job-flow-steps
   {:arglists (quote
               [[credentials
                 {:keys [steps job-flow-id general-progress-listener]}]]),
    :doc "Call addJobFlowSteps"}
   [credentials4309 & args4310]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4311
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4309)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4311
      addJobFlowSteps
      (elasticmapreduce/add-job-flow-steps-request
       (clojure.core/nth args4310 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-steps
   [m4312]
   (clojure.core/let
    [credentials4313 (:credentials m4312) args4314 (:args m4312)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4315
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4313)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4315
       listSteps
       (elasticmapreduce/list-steps-request
        (clojure.core/nth args4314 0)))))))
  (clojure.core/defn
   list-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [step-states
                         marker
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Generate map for listSteps"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-steps,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   list-steps
   {:arglists (quote
               [[credentials
                 {:keys [step-states
                         marker
                         general-progress-listener
                         cluster-id]}]]),
    :doc "Call listSteps"}
   [credentials4317 & args4318]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4319
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4317)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4319
      listSteps
      (elasticmapreduce/list-steps-request
       (clojure.core/nth args4318 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-job-flows
   [m4320]
   (clojure.core/let
    [credentials4321 (:credentials m4320) args4322 (:args m4320)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client4323
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials4321)]
     (clojure.core/case
      (clojure.core/count args4322)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4323
        describeJobFlows))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4323
        describeJobFlows
        (elasticmapreduce/describe-job-flows-request
         (clojure.core/nth args4322 0))))))))
  (clojure.core/defn
   describe-job-flows-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [job-flow-states
                         job-flow-ids
                         general-progress-listener
                         created-before
                         created-after]}]]),
    :doc "Generate map for describeJobFlows, describeJobFlows"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :describe-job-flows,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-job-flows,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-job-flows
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [job-flow-states
                         job-flow-ids
                         general-progress-listener
                         created-before
                         created-after]}]]),
    :doc "Call describeJobFlows, describeJobFlows"}
   [credentials4325 & args4326]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client4327
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials4325)]
    (clojure.core/case
     (clojure.core/count args4326)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4327
       describeJobFlows))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client4327
       describeJobFlows
       (elasticmapreduce/describe-job-flows-request
        (clojure.core/nth args4326 0)))))))))
