(ns
 com.palletops.awaze.elasticloadbalancing
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticloadbalancing :as elasticloadbalancing]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticloadbalancing
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing}
cross-zone-load-balancing
  [m4461]
  (clojure.core/let
   [bean4460
    (new
     com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing)]
   (clojure.core/when-let
    [v4462 (:enabled m4461)]
    (. bean4460 setEnabled (clojure.core/boolean v4462)))
   bean4460))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AccessLog}
access-log
  [m4464]
  (clojure.core/let
   [bean4463
    (new com.amazonaws.services.elasticloadbalancing.model.AccessLog)]
   (clojure.core/when-let
    [v4465 (:s3bucket-name m4464)]
    (. bean4463 setS3BucketName (clojure.core/str v4465)))
   (clojure.core/when-let
    [v4465 (:emit-interval m4464)]
    (. bean4463 setEmitInterval (clojure.core/int v4465)))
   (clojure.core/when-let
    [v4465 (:s3bucket-prefix m4464)]
    (. bean4463 setS3BucketPrefix (clojure.core/str v4465)))
   (clojure.core/when-let
    [v4465 (:enabled m4464)]
    (. bean4463 setEnabled (clojure.core/boolean v4465)))
   bean4463))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining}
connection-draining
  [m4467]
  (clojure.core/let
   [bean4466
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining)]
   (clojure.core/when-let
    [v4468 (:timeout m4467)]
    (. bean4466 setTimeout (clojure.core/int v4468)))
   (clojure.core/when-let
    [v4468 (:enabled m4467)]
    (. bean4466 setEnabled (clojure.core/boolean v4468)))
   bean4466))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Instance}
instance
  [m4470]
  (clojure.core/let
   [bean4469
    (new com.amazonaws.services.elasticloadbalancing.model.Instance)]
   (clojure.core/when-let
    [v4471 (:instance-id m4470)]
    (. bean4469 setInstanceId (clojure.core/str v4471)))
   bean4469))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute}
policy-attribute
  [m4473]
  (clojure.core/let
   [bean4472
    (new
     com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute)]
   (clojure.core/when-let
    [v4474 (:attribute-name m4473)]
    (. bean4472 setAttributeName (clojure.core/str v4474)))
   (clojure.core/when-let
    [v4474 (:attribute-value m4473)]
    (. bean4472 setAttributeValue (clojure.core/str v4474)))
   bean4472))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.HealthCheck}
health-check
  [m4476]
  (clojure.core/let
   [bean4475
    (new
     com.amazonaws.services.elasticloadbalancing.model.HealthCheck)]
   (clojure.core/when-let
    [v4477 (:interval m4476)]
    (. bean4475 setInterval (clojure.core/int v4477)))
   (clojure.core/when-let
    [v4477 (:timeout m4476)]
    (. bean4475 setTimeout (clojure.core/int v4477)))
   (clojure.core/when-let
    [v4477 (:unhealthy-threshold m4476)]
    (. bean4475 setUnhealthyThreshold (clojure.core/int v4477)))
   (clojure.core/when-let
    [v4477 (:healthy-threshold m4476)]
    (. bean4475 setHealthyThreshold (clojure.core/int v4477)))
   (clojure.core/when-let
    [v4477 (:target m4476)]
    (. bean4475 setTarget (clojure.core/str v4477)))
   bean4475))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Listener}
listener
  [m4479]
  (clojure.core/let
   [bean4478
    (new com.amazonaws.services.elasticloadbalancing.model.Listener)]
   (clojure.core/when-let
    [v4480 (:protocol m4479)]
    (. bean4478 setProtocol (clojure.core/str v4480)))
   (clojure.core/when-let
    [v4480 (:load-balancer-port m4479)]
    (. bean4478 setLoadBalancerPort (clojure.core/int v4480)))
   (clojure.core/when-let
    [v4480 (:instance-port m4479)]
    (. bean4478 setInstancePort (clojure.core/int v4480)))
   (clojure.core/when-let
    [v4480 (:sslcertificate-id m4479)]
    (. bean4478 setSSLCertificateId (clojure.core/str v4480)))
   (clojure.core/when-let
    [v4480 (:instance-protocol m4479)]
    (. bean4478 setInstanceProtocol (clojure.core/str v4480)))
   bean4478))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes}
load-balancer-attributes
  [m4482]
  (clojure.core/let
   [bean4481
    (new
     com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes)]
   (clojure.core/when-let
    [v4483 (:cross-zone-load-balancing m4482)]
    (.
     bean4481
     setCrossZoneLoadBalancing
     (elasticloadbalancing/cross-zone-load-balancing v4483)))
   (clojure.core/when-let
    [v4483 (:access-log m4482)]
    (. bean4481 setAccessLog (elasticloadbalancing/access-log v4483)))
   (clojure.core/when-let
    [v4483 (:connection-draining m4482)]
    (.
     bean4481
     setConnectionDraining
     (elasticloadbalancing/connection-draining v4483)))
   bean4481))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest}
deregister-instances-from-load-balancer-request
  [m4485]
  (clojure.core/let
   [bean4484
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest)]
   (clojure.core/when-let
    [v4486 (:load-balancer-name m4485)]
    (. bean4484 setLoadBalancerName (clojure.core/str v4486)))
   (clojure.core/when-let
    [v4486 (:instances m4485)]
    (.
     bean4484
     setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4559] (elasticloadbalancing/instance arg4559))
 v4486)))
   bean4484))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest}
enable-availability-zones-for-load-balancer-request
  [m4488]
  (clojure.core/let
   [bean4487
    (new
     com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/when-let
    [v4489 (:availability-zones m4488)]
    (.
     bean4487
     setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4560] (clojure.core/str arg4560))
 v4489)))
   (clojure.core/when-let
    [v4489 (:load-balancer-name m4488)]
    (. bean4487 setLoadBalancerName (clojure.core/str v4489)))
   bean4487))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest}
apply-security-groups-to-load-balancer-request
  [m4491]
  (clojure.core/let
   [bean4490
    (new
     com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest)]
   (clojure.core/when-let
    [v4492 (:security-groups m4491)]
    (.
     bean4490
     setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4561] (clojure.core/str arg4561))
 v4492)))
   (clojure.core/when-let
    [v4492 (:load-balancer-name m4491)]
    (. bean4490 setLoadBalancerName (clojure.core/str v4492)))
   bean4490))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest}
create-lbcookie-stickiness-policy-request
  [m4494]
  (clojure.core/let
   [bean4493
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest)]
   (clojure.core/when-let
    [v4495 (:policy-name m4494)]
    (. bean4493 setPolicyName (clojure.core/str v4495)))
   (clojure.core/when-let
    [v4495 (:load-balancer-name m4494)]
    (. bean4493 setLoadBalancerName (clojure.core/str v4495)))
   (clojure.core/when-let
    [v4495 (:cookie-expiration-period m4494)]
    (. bean4493 setCookieExpirationPeriod (clojure.core/long v4495)))
   bean4493))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest}
describe-load-balancer-policies-request
  [m4497]
  (clojure.core/let
   [bean4496
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest)]
   (clojure.core/when-let
    [v4498 (:policy-names m4497)]
    (.
     bean4496
     setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4562] (clojure.core/str arg4562))
 v4498)))
   (clojure.core/when-let
    [v4498 (:load-balancer-name m4497)]
    (. bean4496 setLoadBalancerName (clojure.core/str v4498)))
   bean4496))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest}
delete-load-balancer-request
  [m4500]
  (clojure.core/let
   [bean4499
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest)]
   (clojure.core/when-let
    [v4501 (:load-balancer-name m4500)]
    (. bean4499 setLoadBalancerName (clojure.core/str v4501)))
   bean4499))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest}
describe-load-balancer-policy-types-request
  [m4503]
  (clojure.core/let
   [bean4502
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest)]
   (clojure.core/when-let
    [v4504 (:policy-type-names m4503)]
    (.
     bean4502
     setPolicyTypeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4563] (clojure.core/str arg4563))
 v4504)))
   bean4502))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest}
delete-load-balancer-policy-request
  [m4506]
  (clojure.core/let
   [bean4505
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest)]
   (clojure.core/when-let
    [v4507 (:policy-name m4506)]
    (. bean4505 setPolicyName (clojure.core/str v4507)))
   (clojure.core/when-let
    [v4507 (:load-balancer-name m4506)]
    (. bean4505 setLoadBalancerName (clojure.core/str v4507)))
   bean4505))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest}
create-load-balancer-policy-request
  [m4509]
  (clojure.core/let
   [bean4508
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest)]
   (clojure.core/when-let
    [v4510 (:policy-name m4509)]
    (. bean4508 setPolicyName (clojure.core/str v4510)))
   (clojure.core/when-let
    [v4510 (:load-balancer-name m4509)]
    (. bean4508 setLoadBalancerName (clojure.core/str v4510)))
   (clojure.core/when-let
    [v4510 (:policy-type-name m4509)]
    (. bean4508 setPolicyTypeName (clojure.core/str v4510)))
   (clojure.core/when-let
    [v4510 (:policy-attributes m4509)]
    (.
     bean4508
     setPolicyAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4564]
  (elasticloadbalancing/policy-attribute arg4564))
 v4510)))
   bean4508))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest}
configure-health-check-request
  [m4512]
  (clojure.core/let
   [bean4511
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest)]
   (clojure.core/when-let
    [v4513 (:load-balancer-name m4512)]
    (. bean4511 setLoadBalancerName (clojure.core/str v4513)))
   (clojure.core/when-let
    [v4513 (:health-check m4512)]
    (.
     bean4511
     setHealthCheck
     (elasticloadbalancing/health-check v4513)))
   bean4511))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest}
describe-instance-health-request
  [m4515]
  (clojure.core/let
   [bean4514
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest)]
   (clojure.core/when-let
    [v4516 (:load-balancer-name m4515)]
    (. bean4514 setLoadBalancerName (clojure.core/str v4516)))
   (clojure.core/when-let
    [v4516 (:instances m4515)]
    (.
     bean4514
     setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4565] (elasticloadbalancing/instance arg4565))
 v4516)))
   bean4514))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest}
create-load-balancer-request
  [m4518]
  (clojure.core/let
   [bean4517
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest)]
   (clojure.core/when-let
    [v4519 (:subnets m4518)]
    (.
     bean4517
     setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4566] (clojure.core/str arg4566))
 v4519)))
   (clojure.core/when-let
    [v4519 (:availability-zones m4518)]
    (.
     bean4517
     setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4567] (clojure.core/str arg4567))
 v4519)))
   (clojure.core/when-let
    [v4519 (:security-groups m4518)]
    (.
     bean4517
     setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4568] (clojure.core/str arg4568))
 v4519)))
   (clojure.core/when-let
    [v4519 (:listeners m4518)]
    (.
     bean4517
     setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4569] (elasticloadbalancing/listener arg4569))
 v4519)))
   (clojure.core/when-let
    [v4519 (:load-balancer-name m4518)]
    (. bean4517 setLoadBalancerName (clojure.core/str v4519)))
   (clojure.core/when-let
    [v4519 (:scheme m4518)]
    (. bean4517 setScheme (clojure.core/str v4519)))
   bean4517))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest}
set-load-balancer-policies-for-backend-server-request
  [m4521]
  (clojure.core/let
   [bean4520
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest)]
   (clojure.core/when-let
    [v4522 (:policy-names m4521)]
    (.
     bean4520
     setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4570] (clojure.core/str arg4570))
 v4522)))
   (clojure.core/when-let
    [v4522 (:load-balancer-name m4521)]
    (. bean4520 setLoadBalancerName (clojure.core/str v4522)))
   (clojure.core/when-let
    [v4522 (:instance-port m4521)]
    (. bean4520 setInstancePort (clojure.core/int v4522)))
   bean4520))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest}
disable-availability-zones-for-load-balancer-request
  [m4524]
  (clojure.core/let
   [bean4523
    (new
     com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/when-let
    [v4525 (:availability-zones m4524)]
    (.
     bean4523
     setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4571] (clojure.core/str arg4571))
 v4525)))
   (clojure.core/when-let
    [v4525 (:load-balancer-name m4524)]
    (. bean4523 setLoadBalancerName (clojure.core/str v4525)))
   bean4523))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest}
detach-load-balancer-from-subnets-request
  [m4527]
  (clojure.core/let
   [bean4526
    (new
     com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest)]
   (clojure.core/when-let
    [v4528 (:subnets m4527)]
    (.
     bean4526
     setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4572] (clojure.core/str arg4572))
 v4528)))
   (clojure.core/when-let
    [v4528 (:load-balancer-name m4527)]
    (. bean4526 setLoadBalancerName (clojure.core/str v4528)))
   bean4526))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest}
create-load-balancer-listeners-request
  [m4530]
  (clojure.core/let
   [bean4529
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest)]
   (clojure.core/when-let
    [v4531 (:listeners m4530)]
    (.
     bean4529
     setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4573] (elasticloadbalancing/listener arg4573))
 v4531)))
   (clojure.core/when-let
    [v4531 (:load-balancer-name m4530)]
    (. bean4529 setLoadBalancerName (clojure.core/str v4531)))
   bean4529))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest}
delete-load-balancer-listeners-request
  [m4533]
  (clojure.core/let
   [bean4532
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest)]
   (clojure.core/when-let
    [v4534 (:load-balancer-name m4533)]
    (. bean4532 setLoadBalancerName (clojure.core/str v4534)))
   (clojure.core/when-let
    [v4534 (:load-balancer-ports m4533)]
    (.
     bean4532
     setLoadBalancerPorts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4574] (clojure.core/int arg4574))
 v4534)))
   bean4532))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest}
set-load-balancer-listener-sslcertificate-request
  [m4536]
  (clojure.core/let
   [bean4535
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest)]
   (clojure.core/when-let
    [v4537 (:load-balancer-name m4536)]
    (. bean4535 setLoadBalancerName (clojure.core/str v4537)))
   (clojure.core/when-let
    [v4537 (:load-balancer-port m4536)]
    (. bean4535 setLoadBalancerPort (clojure.core/int v4537)))
   (clojure.core/when-let
    [v4537 (:sslcertificate-id m4536)]
    (. bean4535 setSSLCertificateId (clojure.core/str v4537)))
   bean4535))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest}
register-instances-with-load-balancer-request
  [m4539]
  (clojure.core/let
   [bean4538
    (new
     com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest)]
   (clojure.core/when-let
    [v4540 (:load-balancer-name m4539)]
    (. bean4538 setLoadBalancerName (clojure.core/str v4540)))
   (clojure.core/when-let
    [v4540 (:instances m4539)]
    (.
     bean4538
     setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4575] (elasticloadbalancing/instance arg4575))
 v4540)))
   bean4538))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest}
set-load-balancer-policies-of-listener-request
  [m4542]
  (clojure.core/let
   [bean4541
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest)]
   (clojure.core/when-let
    [v4543 (:policy-names m4542)]
    (.
     bean4541
     setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4576] (clojure.core/str arg4576))
 v4543)))
   (clojure.core/when-let
    [v4543 (:load-balancer-name m4542)]
    (. bean4541 setLoadBalancerName (clojure.core/str v4543)))
   (clojure.core/when-let
    [v4543 (:load-balancer-port m4542)]
    (. bean4541 setLoadBalancerPort (clojure.core/int v4543)))
   bean4541))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest}
attach-load-balancer-to-subnets-request
  [m4545]
  (clojure.core/let
   [bean4544
    (new
     com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest)]
   (clojure.core/when-let
    [v4546 (:subnets m4545)]
    (.
     bean4544
     setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4577] (clojure.core/str arg4577))
 v4546)))
   (clojure.core/when-let
    [v4546 (:load-balancer-name m4545)]
    (. bean4544 setLoadBalancerName (clojure.core/str v4546)))
   bean4544))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest}
modify-load-balancer-attributes-request
  [m4548]
  (clojure.core/let
   [bean4547
    (new
     com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest)]
   (clojure.core/when-let
    [v4549 (:load-balancer-name m4548)]
    (. bean4547 setLoadBalancerName (clojure.core/str v4549)))
   (clojure.core/when-let
    [v4549 (:load-balancer-attributes m4548)]
    (.
     bean4547
     setLoadBalancerAttributes
     (elasticloadbalancing/load-balancer-attributes v4549)))
   bean4547))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m4551]
  (clojure.core/let
   [bean4550
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest)]
   (clojure.core/when-let
    [v4552 (:load-balancer-names m4551)]
    (.
     bean4550
     setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4578] (clojure.core/str arg4578))
 v4552)))
   (clojure.core/when-let
    [v4552 (:marker m4551)]
    (. bean4550 setMarker (clojure.core/str v4552)))
   bean4550))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest}
describe-load-balancer-attributes-request
  [m4554]
  (clojure.core/let
   [bean4553
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest)]
   (clojure.core/when-let
    [v4555 (:load-balancer-name m4554)]
    (. bean4553 setLoadBalancerName (clojure.core/str v4555)))
   bean4553))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest}
create-app-cookie-stickiness-policy-request
  [m4557]
  (clojure.core/let
   [bean4556
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest)]
   (clojure.core/when-let
    [v4558 (:policy-name m4557)]
    (. bean4556 setPolicyName (clojure.core/str v4558)))
   (clojure.core/when-let
    [v4558 (:load-balancer-name m4557)]
    (. bean4556 setLoadBalancerName (clojure.core/str v4558)))
   (clojure.core/when-let
    [v4558 (:cookie-name m4557)]
    (. bean4556 setCookieName (clojure.core/str v4558)))
   bean4556))
 (clojure.core/defmulti
  elasticloadbalancing
  (clojure.core/fn
   elasticloadbalancing
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :deregister-instances-from-load-balancer
   [m4579]
   (clojure.core/let
    [credentials4580 (:credentials m4579) args4581 (:args m4579)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4582
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4580)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4582
       deregisterInstancesFromLoadBalancer
       (elasticloadbalancing/deregister-instances-from-load-balancer-request
        (clojure.core/nth args4581 0)))))))
  (clojure.core/defn
   deregister-instances-from-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Generate map for deregisterInstancesFromLoadBalancer"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :deregister-instances-from-load-balancer,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   deregister-instances-from-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Call deregisterInstancesFromLoadBalancer"}
   [credentials4584 & args4585]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4586
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4584)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4586
      deregisterInstancesFromLoadBalancer
      (elasticloadbalancing/deregister-instances-from-load-balancer-request
       (clojure.core/nth args4585 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :enable-availability-zones-for-load-balancer
   [m4587]
   (clojure.core/let
    [credentials4588 (:credentials m4587) args4589 (:args m4587)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4590
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4588)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4590
       enableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4589 0)))))))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Generate map for enableAvailabilityZonesForLoadBalancer"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :enable-availability-zones-for-load-balancer,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Call enableAvailabilityZonesForLoadBalancer"}
   [credentials4592 & args4593]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4594
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4592)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4594
      enableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4593 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :apply-security-groups-to-load-balancer
   [m4595]
   (clojure.core/let
    [credentials4596 (:credentials m4595) args4597 (:args m4595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4598
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4596)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4598
       applySecurityGroupsToLoadBalancer
       (elasticloadbalancing/apply-security-groups-to-load-balancer-request
        (clojure.core/nth args4597 0)))))))
  (clojure.core/defn
   apply-security-groups-to-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [security-groups
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for applySecurityGroupsToLoadBalancer"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :apply-security-groups-to-load-balancer,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   apply-security-groups-to-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [security-groups
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call applySecurityGroupsToLoadBalancer"}
   [credentials4600 & args4601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4602
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4600)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4602
      applySecurityGroupsToLoadBalancer
      (elasticloadbalancing/apply-security-groups-to-load-balancer-request
       (clojure.core/nth args4601 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-lbcookie-stickiness-policy
   [m4603]
   (clojure.core/let
    [credentials4604 (:credentials m4603) args4605 (:args m4603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4606
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4604)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4606
       createLBCookieStickinessPolicy
       (elasticloadbalancing/create-lbcookie-stickiness-policy-request
        (clojure.core/nth args4605 0)))))))
  (clojure.core/defn
   create-lbcookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-expiration-period]}]]),
    :doc "Generate map for createLBCookieStickinessPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-lbcookie-stickiness-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-lbcookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-expiration-period]}]]),
    :doc "Call createLBCookieStickinessPolicy"}
   [credentials4608 & args4609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4610
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4608)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4610
      createLBCookieStickinessPolicy
      (elasticloadbalancing/create-lbcookie-stickiness-policy-request
       (clojure.core/nth args4609 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policies
   [m4611]
   (clojure.core/let
    [credentials4612 (:credentials m4611) args4613 (:args m4611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4614
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4612)]
     (clojure.core/case
      (clojure.core/count args4613)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4614
        describeLoadBalancerPolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4614
        describeLoadBalancerPolicies
        (elasticloadbalancing/describe-load-balancer-policies-request
         (clojure.core/nth args4613 0))))))))
  (clojure.core/defn
   describe-load-balancer-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policies,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policies,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-load-balancer-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   [credentials4616 & args4617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4618
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4616)]
    (clojure.core/case
     (clojure.core/count args4617)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4618
       describeLoadBalancerPolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4618
       describeLoadBalancerPolicies
       (elasticloadbalancing/describe-load-balancer-policies-request
        (clojure.core/nth args4617 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer
   [m4619]
   (clojure.core/let
    [credentials4620 (:credentials m4619) args4621 (:args m4619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4622
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4620)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4622
       deleteLoadBalancer
       (elasticloadbalancing/delete-load-balancer-request
        (clojure.core/nth args4621 0)))))))
  (clojure.core/defn
   delete-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Generate map for deleteLoadBalancer"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Call deleteLoadBalancer"}
   [credentials4624 & args4625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4626
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4624)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4626
      deleteLoadBalancer
      (elasticloadbalancing/delete-load-balancer-request
       (clojure.core/nth args4625 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policy-types
   [m4627]
   (clojure.core/let
    [credentials4628 (:credentials m4627) args4629 (:args m4627)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4630
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4628)]
     (clojure.core/case
      (clojure.core/count args4629)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4630
        describeLoadBalancerPolicyTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4630
        describeLoadBalancerPolicyTypes
        (elasticloadbalancing/describe-load-balancer-policy-types-request
         (clojure.core/nth args4629 0))))))))
  (clojure.core/defn
   describe-load-balancer-policy-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-type-names general-progress-listener]}]]),
    :doc "Generate map for describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-load-balancer-policy-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-type-names general-progress-listener]}]]),
    :doc "Call describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   [credentials4632 & args4633]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4634
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4632)]
    (clojure.core/case
     (clojure.core/count args4633)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4634
       describeLoadBalancerPolicyTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4634
       describeLoadBalancerPolicyTypes
       (elasticloadbalancing/describe-load-balancer-policy-types-request
        (clojure.core/nth args4633 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-policy
   [m4635]
   (clojure.core/let
    [credentials4636 (:credentials m4635) args4637 (:args m4635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4638
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4636)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4638
       deleteLoadBalancerPolicy
       (elasticloadbalancing/delete-load-balancer-policy-request
        (clojure.core/nth args4637 0)))))))
  (clojure.core/defn
   delete-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteLoadBalancerPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call deleteLoadBalancerPolicy"}
   [credentials4640 & args4641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4642
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4640)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4642
      deleteLoadBalancerPolicy
      (elasticloadbalancing/delete-load-balancer-policy-request
       (clojure.core/nth args4641 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-policy
   [m4643]
   (clojure.core/let
    [credentials4644 (:credentials m4643) args4645 (:args m4643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4646
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4644)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4646
       createLoadBalancerPolicy
       (elasticloadbalancing/create-load-balancer-policy-request
        (clojure.core/nth args4645 0)))))))
  (clojure.core/defn
   create-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-type-name
                         policy-name
                         policy-attributes
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for createLoadBalancerPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-type-name
                         policy-name
                         policy-attributes
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call createLoadBalancerPolicy"}
   [credentials4648 & args4649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4650
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4648)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4650
      createLoadBalancerPolicy
      (elasticloadbalancing/create-load-balancer-policy-request
       (clojure.core/nth args4649 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :configure-health-check
   [m4651]
   (clojure.core/let
    [credentials4652 (:credentials m4651) args4653 (:args m4651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4654
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4652)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4654
       configureHealthCheck
       (elasticloadbalancing/configure-health-check-request
        (clojure.core/nth args4653 0)))))))
  (clojure.core/defn
   configure-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         health-check
                         general-progress-listener]}]]),
    :doc "Generate map for configureHealthCheck"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :configure-health-check,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   configure-health-check
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         health-check
                         general-progress-listener]}]]),
    :doc "Call configureHealthCheck"}
   [credentials4656 & args4657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4658
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4656)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4658
      configureHealthCheck
      (elasticloadbalancing/configure-health-check-request
       (clojure.core/nth args4657 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-instance-health
   [m4659]
   (clojure.core/let
    [credentials4660 (:credentials m4659) args4661 (:args m4659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4662
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4660)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4662
       describeInstanceHealth
       (elasticloadbalancing/describe-instance-health-request
        (clojure.core/nth args4661 0)))))))
  (clojure.core/defn
   describe-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Generate map for describeInstanceHealth"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-instance-health,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Call describeInstanceHealth"}
   [credentials4664 & args4665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4666
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4664)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4666
      describeInstanceHealth
      (elasticloadbalancing/describe-instance-health-request
       (clojure.core/nth args4665 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer
   [m4667]
   (clojure.core/let
    [credentials4668 (:credentials m4667) args4669 (:args m4667)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4670
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4668)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4670
       createLoadBalancer
       (elasticloadbalancing/create-load-balancer-request
        (clojure.core/nth args4669 0)))))))
  (clojure.core/defn
   create-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [scheme
                         general-progress-listener
                         subnets
                         listeners
                         security-groups
                         availability-zones
                         load-balancer-name]}]]),
    :doc "Generate map for createLoadBalancer"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [scheme
                         general-progress-listener
                         subnets
                         listeners
                         security-groups
                         availability-zones
                         load-balancer-name]}]]),
    :doc "Call createLoadBalancer"}
   [credentials4672 & args4673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4674
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4672)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4674
      createLoadBalancer
      (elasticloadbalancing/create-load-balancer-request
       (clojure.core/nth args4673 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-for-backend-server
   [m4675]
   (clojure.core/let
    [credentials4676 (:credentials m4675) args4677 (:args m4675)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4678
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4676)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4678
       setLoadBalancerPoliciesForBackendServer
       (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
        (clojure.core/nth args4677 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-name
                         instance-port
                         general-progress-listener]}]]),
    :doc "Generate map for setLoadBalancerPoliciesForBackendServer"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-policies-for-backend-server,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-name
                         instance-port
                         general-progress-listener]}]]),
    :doc "Call setLoadBalancerPoliciesForBackendServer"}
   [credentials4680 & args4681]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4682
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4680)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4682
      setLoadBalancerPoliciesForBackendServer
      (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
       (clojure.core/nth args4681 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :disable-availability-zones-for-load-balancer
   [m4683]
   (clojure.core/let
    [credentials4684 (:credentials m4683) args4685 (:args m4683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4686
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4684)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4686
       disableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4685 0)))))))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Generate map for disableAvailabilityZonesForLoadBalancer"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :disable-availability-zones-for-load-balancer,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Call disableAvailabilityZonesForLoadBalancer"}
   [credentials4688 & args4689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4690
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4688)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4690
      disableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4689 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :detach-load-balancer-from-subnets
   [m4691]
   (clojure.core/let
    [credentials4692 (:credentials m4691) args4693 (:args m4691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4694
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4694
       detachLoadBalancerFromSubnets
       (elasticloadbalancing/detach-load-balancer-from-subnets-request
        (clojure.core/nth args4693 0)))))))
  (clojure.core/defn
   detach-load-balancer-from-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for detachLoadBalancerFromSubnets"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :detach-load-balancer-from-subnets,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   detach-load-balancer-from-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call detachLoadBalancerFromSubnets"}
   [credentials4696 & args4697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4698
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4698
      detachLoadBalancerFromSubnets
      (elasticloadbalancing/detach-load-balancer-from-subnets-request
       (clojure.core/nth args4697 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-listeners
   [m4699]
   (clojure.core/let
    [credentials4700 (:credentials m4699) args4701 (:args m4699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4702
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4702
       createLoadBalancerListeners
       (elasticloadbalancing/create-load-balancer-listeners-request
        (clojure.core/nth args4701 0)))))))
  (clojure.core/defn
   create-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         listeners
                         general-progress-listener]}]]),
    :doc "Generate map for createLoadBalancerListeners"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer-listeners,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         listeners
                         general-progress-listener]}]]),
    :doc "Call createLoadBalancerListeners"}
   [credentials4704 & args4705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4706
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4704)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4706
      createLoadBalancerListeners
      (elasticloadbalancing/create-load-balancer-listeners-request
       (clojure.core/nth args4705 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-listeners
   [m4707]
   (clojure.core/let
    [credentials4708 (:credentials m4707) args4709 (:args m4707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4710
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4708)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4710
       deleteLoadBalancerListeners
       (elasticloadbalancing/delete-load-balancer-listeners-request
        (clojure.core/nth args4709 0)))))))
  (clojure.core/defn
   delete-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-ports
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteLoadBalancerListeners"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer-listeners,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-ports
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call deleteLoadBalancerListeners"}
   [credentials4712 & args4713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4714
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4712)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4714
      deleteLoadBalancerListeners
      (elasticloadbalancing/delete-load-balancer-listeners-request
       (clojure.core/nth args4713 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-listener-sslcertificate
   [m4715]
   (clojure.core/let
    [credentials4716 (:credentials m4715) args4717 (:args m4715)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4718
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4716)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4718
       setLoadBalancerListenerSSLCertificate
       (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
        (clojure.core/nth args4717 0)))))))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-port
                         load-balancer-name
                         general-progress-listener
                         sslcertificate-id]}]]),
    :doc "Generate map for setLoadBalancerListenerSSLCertificate"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-listener-sslcertificate,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-port
                         load-balancer-name
                         general-progress-listener
                         sslcertificate-id]}]]),
    :doc "Call setLoadBalancerListenerSSLCertificate"}
   [credentials4720 & args4721]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4722
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4720)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4722
      setLoadBalancerListenerSSLCertificate
      (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
       (clojure.core/nth args4721 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :register-instances-with-load-balancer
   [m4723]
   (clojure.core/let
    [credentials4724 (:credentials m4723) args4725 (:args m4723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4726
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4724)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4726
       registerInstancesWithLoadBalancer
       (elasticloadbalancing/register-instances-with-load-balancer-request
        (clojure.core/nth args4725 0)))))))
  (clojure.core/defn
   register-instances-with-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Generate map for registerInstancesWithLoadBalancer"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :register-instances-with-load-balancer,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   register-instances-with-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Call registerInstancesWithLoadBalancer"}
   [credentials4728 & args4729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4730
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4728)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4730
      registerInstancesWithLoadBalancer
      (elasticloadbalancing/register-instances-with-load-balancer-request
       (clojure.core/nth args4729 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-of-listener
   [m4731]
   (clojure.core/let
    [credentials4732 (:credentials m4731) args4733 (:args m4731)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4734
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4732)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4734
       setLoadBalancerPoliciesOfListener
       (elasticloadbalancing/set-load-balancer-policies-of-listener-request
        (clojure.core/nth args4733 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-of-listener-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-port
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for setLoadBalancerPoliciesOfListener"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-policies-of-listener,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   set-load-balancer-policies-of-listener
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-port
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call setLoadBalancerPoliciesOfListener"}
   [credentials4736 & args4737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4738
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4736)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4738
      setLoadBalancerPoliciesOfListener
      (elasticloadbalancing/set-load-balancer-policies-of-listener-request
       (clojure.core/nth args4737 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :attach-load-balancer-to-subnets
   [m4739]
   (clojure.core/let
    [credentials4740 (:credentials m4739) args4741 (:args m4739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4742
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4740)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4742
       attachLoadBalancerToSubnets
       (elasticloadbalancing/attach-load-balancer-to-subnets-request
        (clojure.core/nth args4741 0)))))))
  (clojure.core/defn
   attach-load-balancer-to-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for attachLoadBalancerToSubnets"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :attach-load-balancer-to-subnets,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   attach-load-balancer-to-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call attachLoadBalancerToSubnets"}
   [credentials4744 & args4745]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4746
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4744)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4746
      attachLoadBalancerToSubnets
      (elasticloadbalancing/attach-load-balancer-to-subnets-request
       (clojure.core/nth args4745 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :modify-load-balancer-attributes
   [m4747]
   (clojure.core/let
    [credentials4748 (:credentials m4747) args4749 (:args m4747)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4750
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4748)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4750
       modifyLoadBalancerAttributes
       (elasticloadbalancing/modify-load-balancer-attributes-request
        (clojure.core/nth args4749 0)))))))
  (clojure.core/defn
   modify-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         load-balancer-attributes
                         general-progress-listener]}]]),
    :doc "Generate map for modifyLoadBalancerAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :modify-load-balancer-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         load-balancer-attributes
                         general-progress-listener]}]]),
    :doc "Call modifyLoadBalancerAttributes"}
   [credentials4752 & args4753]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4754
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4752)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4754
      modifyLoadBalancerAttributes
      (elasticloadbalancing/modify-load-balancer-attributes-request
       (clojure.core/nth args4753 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancers
   [m4755]
   (clojure.core/let
    [credentials4756 (:credentials m4755) args4757 (:args m4755)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4758
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4756)]
     (clojure.core/case
      (clojure.core/count args4757)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4758
        describeLoadBalancers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4758
        describeLoadBalancers
        (elasticloadbalancing/describe-load-balancers-request
         (clojure.core/nth args4757 0))))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker
                         load-balancer-names
                         general-progress-listener]}]]),
    :doc "Generate map for describeLoadBalancers, describeLoadBalancers"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancers,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancers,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker
                         load-balancer-names
                         general-progress-listener]}]]),
    :doc "Call describeLoadBalancers, describeLoadBalancers"}
   [credentials4760 & args4761]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4762
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4760)]
    (clojure.core/case
     (clojure.core/count args4761)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4762
       describeLoadBalancers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4762
       describeLoadBalancers
       (elasticloadbalancing/describe-load-balancers-request
        (clojure.core/nth args4761 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-attributes
   [m4763]
   (clojure.core/let
    [credentials4764 (:credentials m4763) args4765 (:args m4763)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4766
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4764)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4766
       describeLoadBalancerAttributes
       (elasticloadbalancing/describe-load-balancer-attributes-request
        (clojure.core/nth args4765 0)))))))
  (clojure.core/defn
   describe-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Generate map for describeLoadBalancerAttributes"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-attributes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Call describeLoadBalancerAttributes"}
   [credentials4768 & args4769]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4770
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4768)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4770
      describeLoadBalancerAttributes
      (elasticloadbalancing/describe-load-balancer-attributes-request
       (clojure.core/nth args4769 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-app-cookie-stickiness-policy
   [m4771]
   (clojure.core/let
    [credentials4772 (:credentials m4771) args4773 (:args m4771)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4774
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4772)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4774
       createAppCookieStickinessPolicy
       (elasticloadbalancing/create-app-cookie-stickiness-policy-request
        (clojure.core/nth args4773 0)))))))
  (clojure.core/defn
   create-app-cookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-name]}]]),
    :doc "Generate map for createAppCookieStickinessPolicy"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-app-cookie-stickiness-policy,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-app-cookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-name]}]]),
    :doc "Call createAppCookieStickinessPolicy"}
   [credentials4776 & args4777]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4778
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4776)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4778
      createAppCookieStickinessPolicy
      (elasticloadbalancing/create-app-cookie-stickiness-policy-request
       (clojure.core/nth args4777 0))))))))
