(ns
 com.palletops.awaze.elasticache
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticache :as elasticache]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticache
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.elasticache.AmazonElastiCacheClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ParameterNameValue}
parameter-name-value
  [m10914]
  (clojure.core/let
   [bean10913
    (new com.amazonaws.services.elasticache.model.ParameterNameValue)]
   (clojure.core/when-let
    [v10915 (:parameter-name m10914)]
    (. bean10913 setParameterName (clojure.core/str v10915)))
   (clojure.core/when-let
    [v10915 (:parameter-value m10914)]
    (. bean10913 setParameterValue (clojure.core/str v10915)))
   bean10913))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.SourceType}
source-type
  [m10917]
  (.
   com.amazonaws.services.elasticache.model.SourceType
   fromValue
   (clojure.core/name m10917)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest}
describe-cache-parameter-groups-request
  [m10920]
  (clojure.core/let
   [bean10919
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest)]
   (clojure.core/when-let
    [v10921 (:max-records m10920)]
    (. bean10919 setMaxRecords (clojure.core/int v10921)))
   (clojure.core/when-let
    [v10921 (:cache-parameter-group-name m10920)]
    (. bean10919 setCacheParameterGroupName (clojure.core/str v10921)))
   (clojure.core/when-let
    [v10921 (:marker m10920)]
    (. bean10919 setMarker (clojure.core/str v10921)))
   bean10919))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest}
create-cache-parameter-group-request
  [m10923]
  (clojure.core/let
   [bean10922
    (new
     com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10924 (:description m10923)]
    (. bean10922 setDescription (clojure.core/str v10924)))
   (clojure.core/when-let
    [v10924 (:cache-parameter-group-name m10923)]
    (. bean10922 setCacheParameterGroupName (clojure.core/str v10924)))
   (clojure.core/when-let
    [v10924 (:cache-parameter-group-family m10923)]
    (.
     bean10922
     setCacheParameterGroupFamily
     (clojure.core/str v10924)))
   bean10922))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest}
revoke-cache-security-group-ingress-request
  [m10926]
  (clojure.core/let
   [bean10925
    (new
     com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v10927 (:ec2security-group-name m10926)]
    (. bean10925 setEC2SecurityGroupName (clojure.core/str v10927)))
   (clojure.core/when-let
    [v10927 (:ec2security-group-owner-id m10926)]
    (. bean10925 setEC2SecurityGroupOwnerId (clojure.core/str v10927)))
   (clojure.core/when-let
    [v10927 (:cache-security-group-name m10926)]
    (. bean10925 setCacheSecurityGroupName (clojure.core/str v10927)))
   bean10925))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest}
create-replication-group-request
  [m10929]
  (clojure.core/let
   [bean10928
    (new
     com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest)]
   (clojure.core/when-let
    [v10930 (:replication-group-id m10929)]
    (. bean10928 setReplicationGroupId (clojure.core/str v10930)))
   (clojure.core/when-let
    [v10930 (:replication-group-description m10929)]
    (.
     bean10928
     setReplicationGroupDescription
     (clojure.core/str v10930)))
   (clojure.core/when-let
    [v10930 (:primary-cluster-id m10929)]
    (. bean10928 setPrimaryClusterId (clojure.core/str v10930)))
   bean10928))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m10932]
  (clojure.core/let
   [bean10931
    (new
     com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest)]
   (clojure.core/when-let
    [v10933 (:max-records m10932)]
    (. bean10931 setMaxRecords (clojure.core/int v10933)))
   (clojure.core/when-let
    [v10933 (:cache-cluster-id m10932)]
    (. bean10931 setCacheClusterId (clojure.core/str v10933)))
   (clojure.core/when-let
    [v10933 (:snapshot-name m10932)]
    (. bean10931 setSnapshotName (clojure.core/str v10933)))
   (clojure.core/when-let
    [v10933 (:snapshot-source m10932)]
    (. bean10931 setSnapshotSource (clojure.core/str v10933)))
   (clojure.core/when-let
    [v10933 (:marker m10932)]
    (. bean10931 setMarker (clojure.core/str v10933)))
   bean10931))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest}
authorize-cache-security-group-ingress-request
  [m10935]
  (clojure.core/let
   [bean10934
    (new
     com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v10936 (:ec2security-group-name m10935)]
    (. bean10934 setEC2SecurityGroupName (clojure.core/str v10936)))
   (clojure.core/when-let
    [v10936 (:ec2security-group-owner-id m10935)]
    (. bean10934 setEC2SecurityGroupOwnerId (clojure.core/str v10936)))
   (clojure.core/when-let
    [v10936 (:cache-security-group-name m10935)]
    (. bean10934 setCacheSecurityGroupName (clojure.core/str v10936)))
   bean10934))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest}
describe-reserved-cache-nodes-request
  [m10938]
  (clojure.core/let
   [bean10937
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest)]
   (clojure.core/when-let
    [v10939 (:max-records m10938)]
    (. bean10937 setMaxRecords (clojure.core/int v10939)))
   (clojure.core/when-let
    [v10939 (:duration m10938)]
    (. bean10937 setDuration (clojure.core/str v10939)))
   (clojure.core/when-let
    [v10939 (:offering-type m10938)]
    (. bean10937 setOfferingType (clojure.core/str v10939)))
   (clojure.core/when-let
    [v10939 (:reserved-cache-nodes-offering-id m10938)]
    (.
     bean10937
     setReservedCacheNodesOfferingId
     (clojure.core/str v10939)))
   (clojure.core/when-let
    [v10939 (:cache-node-type m10938)]
    (. bean10937 setCacheNodeType (clojure.core/str v10939)))
   (clojure.core/when-let
    [v10939 (:reserved-cache-node-id m10938)]
    (. bean10937 setReservedCacheNodeId (clojure.core/str v10939)))
   (clojure.core/when-let
    [v10939 (:marker m10938)]
    (. bean10937 setMarker (clojure.core/str v10939)))
   (clojure.core/when-let
    [v10939 (:product-description m10938)]
    (. bean10937 setProductDescription (clojure.core/str v10939)))
   bean10937))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest}
modify-cache-cluster-request
  [m10941]
  (clojure.core/let
   [bean10940
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest)]
   (clojure.core/when-let
    [v10942 (:cache-parameter-group-name m10941)]
    (. bean10940 setCacheParameterGroupName (clojure.core/str v10942)))
   (clojure.core/when-let
    [v10942 (:snapshot-retention-limit m10941)]
    (. bean10940 setSnapshotRetentionLimit (clojure.core/int v10942)))
   (clojure.core/when-let
    [v10942 (:preferred-maintenance-window m10941)]
    (.
     bean10940
     setPreferredMaintenanceWindow
     (clojure.core/str v10942)))
   (clojure.core/when-let
    [v10942 (:auto-minor-version-upgrade m10941)]
    (.
     bean10940
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v10942)))
   (clojure.core/when-let
    [v10942 (:cache-security-group-names m10941)]
    (.
     bean10940
     setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11021] (clojure.core/str arg11021))
 v10942)))
   (clojure.core/when-let
    [v10942 (:apply-immediately m10941)]
    (. bean10940 setApplyImmediately (clojure.core/boolean v10942)))
   (clojure.core/when-let
    [v10942 (:num-cache-nodes m10941)]
    (. bean10940 setNumCacheNodes (clojure.core/int v10942)))
   (clojure.core/when-let
    [v10942 (:notification-topic-status m10941)]
    (. bean10940 setNotificationTopicStatus (clojure.core/str v10942)))
   (clojure.core/when-let
    [v10942 (:engine-version m10941)]
    (. bean10940 setEngineVersion (clojure.core/str v10942)))
   (clojure.core/when-let
    [v10942 (:cache-cluster-id m10941)]
    (. bean10940 setCacheClusterId (clojure.core/str v10942)))
   (clojure.core/when-let
    [v10942 (:cache-node-ids-to-remove m10941)]
    (.
     bean10940
     setCacheNodeIdsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11022] (clojure.core/str arg11022))
 v10942)))
   (clojure.core/when-let
    [v10942 (:snapshot-window m10941)]
    (. bean10940 setSnapshotWindow (clojure.core/str v10942)))
   (clojure.core/when-let
    [v10942 (:notification-topic-arn m10941)]
    (. bean10940 setNotificationTopicArn (clojure.core/str v10942)))
   (clojure.core/when-let
    [v10942 (:security-group-ids m10941)]
    (.
     bean10940
     setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11023] (clojure.core/str arg11023))
 v10942)))
   bean10940))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest}
delete-cache-subnet-group-request
  [m10944]
  (clojure.core/let
   [bean10943
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v10945 (:cache-subnet-group-name m10944)]
    (. bean10943 setCacheSubnetGroupName (clojure.core/str v10945)))
   bean10943))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest}
describe-cache-engine-versions-request
  [m10947]
  (clojure.core/let
   [bean10946
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest)]
   (clojure.core/when-let
    [v10948 (:max-records m10947)]
    (. bean10946 setMaxRecords (clojure.core/int v10948)))
   (clojure.core/when-let
    [v10948 (:cache-parameter-group-family m10947)]
    (.
     bean10946
     setCacheParameterGroupFamily
     (clojure.core/str v10948)))
   (clojure.core/when-let
    [v10948 (:marker m10947)]
    (. bean10946 setMarker (clojure.core/str v10948)))
   (clojure.core/when-let
    [v10948 (:engine m10947)]
    (. bean10946 setEngine (clojure.core/str v10948)))
   (clojure.core/when-let
    [v10948 (:engine-version m10947)]
    (. bean10946 setEngineVersion (clojure.core/str v10948)))
   (clojure.core/when-let
    [v10948 (:default-only m10947)]
    (. bean10946 setDefaultOnly (clojure.core/boolean v10948)))
   bean10946))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest}
reset-cache-parameter-group-request
  [m10950]
  (clojure.core/let
   [bean10949
    (new
     com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10951 (:reset-all-parameters m10950)]
    (. bean10949 setResetAllParameters (clojure.core/boolean v10951)))
   (clojure.core/when-let
    [v10951 (:cache-parameter-group-name m10950)]
    (. bean10949 setCacheParameterGroupName (clojure.core/str v10951)))
   (clojure.core/when-let
    [v10951 (:parameter-name-values m10950)]
    (.
     bean10949
     setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11024]
  (elasticache/parameter-name-value arg11024))
 v10951)))
   bean10949))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m10953]
  (clojure.core/let
   [bean10952
    (new
     com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/when-let
    [v10954 (:max-records m10953)]
    (. bean10952 setMaxRecords (clojure.core/int v10954)))
   (clojure.core/when-let
    [v10954 (:cache-parameter-group-family m10953)]
    (.
     bean10952
     setCacheParameterGroupFamily
     (clojure.core/str v10954)))
   (clojure.core/when-let
    [v10954 (:marker m10953)]
    (. bean10952 setMarker (clojure.core/str v10954)))
   bean10952))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest}
delete-cache-cluster-request
  [m10956]
  (clojure.core/let
   [bean10955
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest)]
   (clojure.core/when-let
    [v10957 (:final-snapshot-identifier m10956)]
    (. bean10955 setFinalSnapshotIdentifier (clojure.core/str v10957)))
   (clojure.core/when-let
    [v10957 (:cache-cluster-id m10956)]
    (. bean10955 setCacheClusterId (clojure.core/str v10957)))
   bean10955))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest}
describe-cache-subnet-groups-request
  [m10959]
  (clojure.core/let
   [bean10958
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest)]
   (clojure.core/when-let
    [v10960 (:max-records m10959)]
    (. bean10958 setMaxRecords (clojure.core/int v10960)))
   (clojure.core/when-let
    [v10960 (:cache-subnet-group-name m10959)]
    (. bean10958 setCacheSubnetGroupName (clojure.core/str v10960)))
   (clojure.core/when-let
    [v10960 (:marker m10959)]
    (. bean10958 setMarker (clojure.core/str v10960)))
   bean10958))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest}
describe-replication-groups-request
  [m10962]
  (clojure.core/let
   [bean10961
    (new
     com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest)]
   (clojure.core/when-let
    [v10963 (:max-records m10962)]
    (. bean10961 setMaxRecords (clojure.core/int v10963)))
   (clojure.core/when-let
    [v10963 (:replication-group-id m10962)]
    (. bean10961 setReplicationGroupId (clojure.core/str v10963)))
   (clojure.core/when-let
    [v10963 (:marker m10962)]
    (. bean10961 setMarker (clojure.core/str v10963)))
   bean10961))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest}
describe-cache-security-groups-request
  [m10965]
  (clojure.core/let
   [bean10964
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest)]
   (clojure.core/when-let
    [v10966 (:max-records m10965)]
    (. bean10964 setMaxRecords (clojure.core/int v10966)))
   (clojure.core/when-let
    [v10966 (:cache-security-group-name m10965)]
    (. bean10964 setCacheSecurityGroupName (clojure.core/str v10966)))
   (clojure.core/when-let
    [v10966 (:marker m10965)]
    (. bean10964 setMarker (clojure.core/str v10966)))
   bean10964))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest}
create-cache-security-group-request
  [m10968]
  (clojure.core/let
   [bean10967
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest)]
   (clojure.core/when-let
    [v10969 (:description m10968)]
    (. bean10967 setDescription (clojure.core/str v10969)))
   (clojure.core/when-let
    [v10969 (:cache-security-group-name m10968)]
    (. bean10967 setCacheSecurityGroupName (clojure.core/str v10969)))
   bean10967))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest}
describe-cache-clusters-request
  [m10971]
  (clojure.core/let
   [bean10970
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest)]
   (clojure.core/when-let
    [v10972 (:max-records m10971)]
    (. bean10970 setMaxRecords (clojure.core/int v10972)))
   (clojure.core/when-let
    [v10972 (:cache-cluster-id m10971)]
    (. bean10970 setCacheClusterId (clojure.core/str v10972)))
   (clojure.core/when-let
    [v10972 (:show-cache-node-info m10971)]
    (. bean10970 setShowCacheNodeInfo (clojure.core/boolean v10972)))
   (clojure.core/when-let
    [v10972 (:marker m10971)]
    (. bean10970 setMarker (clojure.core/str v10972)))
   bean10970))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEventsRequest}
describe-events-request
  [m10974]
  (clojure.core/let
   [bean10973
    (new
     com.amazonaws.services.elasticache.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v10975 (:max-records m10974)]
    (. bean10973 setMaxRecords (clojure.core/int v10975)))
   (clojure.core/when-let
    [v10975 (:source-identifier m10974)]
    (. bean10973 setSourceIdentifier (clojure.core/str v10975)))
   (clojure.core/when-let
    [v10975 (:source-type m10974)]
    (. bean10973 setSourceType (elasticache/source-type v10975)))
   (clojure.core/when-let
    [v10975 (:start-time m10974)]
    (.
     bean10973
     setStartTime
     (com.palletops.awaze.common/to-date v10975)))
   (clojure.core/when-let
    [v10975 (:end-time m10974)]
    (.
     bean10973
     setEndTime
     (com.palletops.awaze.common/to-date v10975)))
   (clojure.core/when-let
    [v10975 (:duration m10974)]
    (. bean10973 setDuration (clojure.core/int v10975)))
   (clojure.core/when-let
    [v10975 (:marker m10974)]
    (. bean10973 setMarker (clojure.core/str v10975)))
   bean10973))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest}
modify-cache-parameter-group-request
  [m10977]
  (clojure.core/let
   [bean10976
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10978 (:cache-parameter-group-name m10977)]
    (. bean10976 setCacheParameterGroupName (clojure.core/str v10978)))
   (clojure.core/when-let
    [v10978 (:parameter-name-values m10977)]
    (.
     bean10976
     setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11025]
  (elasticache/parameter-name-value arg11025))
 v10978)))
   bean10976))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest}
delete-cache-security-group-request
  [m10980]
  (clojure.core/let
   [bean10979
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest)]
   (clojure.core/when-let
    [v10981 (:cache-security-group-name m10980)]
    (. bean10979 setCacheSecurityGroupName (clojure.core/str v10981)))
   bean10979))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest}
create-cache-subnet-group-request
  [m10983]
  (clojure.core/let
   [bean10982
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v10984 (:subnet-ids m10983)]
    (.
     bean10982
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11026] (clojure.core/str arg11026))
 v10984)))
   (clojure.core/when-let
    [v10984 (:cache-subnet-group-name m10983)]
    (. bean10982 setCacheSubnetGroupName (clojure.core/str v10984)))
   (clojure.core/when-let
    [v10984 (:cache-subnet-group-description m10983)]
    (.
     bean10982
     setCacheSubnetGroupDescription
     (clojure.core/str v10984)))
   bean10982))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest}
modify-replication-group-request
  [m10986]
  (clojure.core/let
   [bean10985
    (new
     com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest)]
   (clojure.core/when-let
    [v10987 (:cache-parameter-group-name m10986)]
    (. bean10985 setCacheParameterGroupName (clojure.core/str v10987)))
   (clojure.core/when-let
    [v10987 (:snapshotting-cluster-id m10986)]
    (. bean10985 setSnapshottingClusterId (clojure.core/str v10987)))
   (clojure.core/when-let
    [v10987 (:snapshot-retention-limit m10986)]
    (. bean10985 setSnapshotRetentionLimit (clojure.core/int v10987)))
   (clojure.core/when-let
    [v10987 (:preferred-maintenance-window m10986)]
    (.
     bean10985
     setPreferredMaintenanceWindow
     (clojure.core/str v10987)))
   (clojure.core/when-let
    [v10987 (:replication-group-description m10986)]
    (.
     bean10985
     setReplicationGroupDescription
     (clojure.core/str v10987)))
   (clojure.core/when-let
    [v10987 (:auto-minor-version-upgrade m10986)]
    (.
     bean10985
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v10987)))
   (clojure.core/when-let
    [v10987 (:cache-security-group-names m10986)]
    (.
     bean10985
     setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11027] (clojure.core/str arg11027))
 v10987)))
   (clojure.core/when-let
    [v10987 (:replication-group-id m10986)]
    (. bean10985 setReplicationGroupId (clojure.core/str v10987)))
   (clojure.core/when-let
    [v10987 (:apply-immediately m10986)]
    (. bean10985 setApplyImmediately (clojure.core/boolean v10987)))
   (clojure.core/when-let
    [v10987 (:notification-topic-status m10986)]
    (. bean10985 setNotificationTopicStatus (clojure.core/str v10987)))
   (clojure.core/when-let
    [v10987 (:engine-version m10986)]
    (. bean10985 setEngineVersion (clojure.core/str v10987)))
   (clojure.core/when-let
    [v10987 (:primary-cluster-id m10986)]
    (. bean10985 setPrimaryClusterId (clojure.core/str v10987)))
   (clojure.core/when-let
    [v10987 (:snapshot-window m10986)]
    (. bean10985 setSnapshotWindow (clojure.core/str v10987)))
   (clojure.core/when-let
    [v10987 (:notification-topic-arn m10986)]
    (. bean10985 setNotificationTopicArn (clojure.core/str v10987)))
   (clojure.core/when-let
    [v10987 (:security-group-ids m10986)]
    (.
     bean10985
     setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11028] (clojure.core/str arg11028))
 v10987)))
   bean10985))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest}
modify-cache-subnet-group-request
  [m10989]
  (clojure.core/let
   [bean10988
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v10990 (:subnet-ids m10989)]
    (.
     bean10988
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11029] (clojure.core/str arg11029))
 v10990)))
   (clojure.core/when-let
    [v10990 (:cache-subnet-group-name m10989)]
    (. bean10988 setCacheSubnetGroupName (clojure.core/str v10990)))
   (clojure.core/when-let
    [v10990 (:cache-subnet-group-description m10989)]
    (.
     bean10988
     setCacheSubnetGroupDescription
     (clojure.core/str v10990)))
   bean10988))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest}
describe-cache-parameters-request
  [m10992]
  (clojure.core/let
   [bean10991
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest)]
   (clojure.core/when-let
    [v10993 (:max-records m10992)]
    (. bean10991 setMaxRecords (clojure.core/int v10993)))
   (clojure.core/when-let
    [v10993 (:source m10992)]
    (. bean10991 setSource (clojure.core/str v10993)))
   (clojure.core/when-let
    [v10993 (:cache-parameter-group-name m10992)]
    (. bean10991 setCacheParameterGroupName (clojure.core/str v10993)))
   (clojure.core/when-let
    [v10993 (:marker m10992)]
    (. bean10991 setMarker (clojure.core/str v10993)))
   bean10991))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest}
delete-cache-parameter-group-request
  [m10995]
  (clojure.core/let
   [bean10994
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10996 (:cache-parameter-group-name m10995)]
    (. bean10994 setCacheParameterGroupName (clojure.core/str v10996)))
   bean10994))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest}
delete-replication-group-request
  [m10998]
  (clojure.core/let
   [bean10997
    (new
     com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest)]
   (clojure.core/when-let
    [v10999 (:replication-group-id m10998)]
    (. bean10997 setReplicationGroupId (clojure.core/str v10999)))
   (clojure.core/when-let
    [v10999 (:retain-primary-cluster m10998)]
    (.
     bean10997
     setRetainPrimaryCluster
     (clojure.core/boolean v10999)))
   (clojure.core/when-let
    [v10999 (:final-snapshot-identifier m10998)]
    (. bean10997 setFinalSnapshotIdentifier (clojure.core/str v10999)))
   bean10997))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CopySnapshotRequest}
copy-snapshot-request
  [m11001]
  (clojure.core/let
   [bean11000
    (new com.amazonaws.services.elasticache.model.CopySnapshotRequest)]
   (clojure.core/when-let
    [v11002 (:source-snapshot-name m11001)]
    (. bean11000 setSourceSnapshotName (clojure.core/str v11002)))
   (clojure.core/when-let
    [v11002 (:target-snapshot-name m11001)]
    (. bean11000 setTargetSnapshotName (clojure.core/str v11002)))
   bean11000))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest}
purchase-reserved-cache-nodes-offering-request
  [m11004]
  (clojure.core/let
   [bean11003
    (new
     com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest)]
   (clojure.core/when-let
    [v11005 (:reserved-cache-nodes-offering-id m11004)]
    (.
     bean11003
     setReservedCacheNodesOfferingId
     (clojure.core/str v11005)))
   (clojure.core/when-let
    [v11005 (:reserved-cache-node-id m11004)]
    (. bean11003 setReservedCacheNodeId (clojure.core/str v11005)))
   (clojure.core/when-let
    [v11005 (:cache-node-count m11004)]
    (. bean11003 setCacheNodeCount (clojure.core/int v11005)))
   bean11003))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RebootCacheClusterRequest}
reboot-cache-cluster-request
  [m11007]
  (clojure.core/let
   [bean11006
    (new
     com.amazonaws.services.elasticache.model.RebootCacheClusterRequest)]
   (clojure.core/when-let
    [v11008 (:cache-cluster-id m11007)]
    (. bean11006 setCacheClusterId (clojure.core/str v11008)))
   (clojure.core/when-let
    [v11008 (:cache-node-ids-to-reboot m11007)]
    (.
     bean11006
     setCacheNodeIdsToReboot
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11030] (clojure.core/str arg11030))
 v11008)))
   bean11006))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheClusterRequest}
create-cache-cluster-request
  [m11010]
  (clojure.core/let
   [bean11009
    (new
     com.amazonaws.services.elasticache.model.CreateCacheClusterRequest)]
   (clojure.core/when-let
    [v11011 (:cache-parameter-group-name m11010)]
    (. bean11009 setCacheParameterGroupName (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:port m11010)]
    (. bean11009 setPort (clojure.core/int v11011)))
   (clojure.core/when-let
    [v11011 (:snapshot-retention-limit m11010)]
    (. bean11009 setSnapshotRetentionLimit (clojure.core/int v11011)))
   (clojure.core/when-let
    [v11011 (:preferred-maintenance-window m11010)]
    (.
     bean11009
     setPreferredMaintenanceWindow
     (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:engine m11010)]
    (. bean11009 setEngine (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:preferred-availability-zone m11010)]
    (.
     bean11009
     setPreferredAvailabilityZone
     (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:auto-minor-version-upgrade m11010)]
    (.
     bean11009
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v11011)))
   (clojure.core/when-let
    [v11011 (:cache-security-group-names m11010)]
    (.
     bean11009
     setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11031] (clojure.core/str arg11031))
 v11011)))
   (clojure.core/when-let
    [v11011 (:cache-subnet-group-name m11010)]
    (. bean11009 setCacheSubnetGroupName (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:replication-group-id m11010)]
    (. bean11009 setReplicationGroupId (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:snapshot-name m11010)]
    (. bean11009 setSnapshotName (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:num-cache-nodes m11010)]
    (. bean11009 setNumCacheNodes (clojure.core/int v11011)))
   (clojure.core/when-let
    [v11011 (:engine-version m11010)]
    (. bean11009 setEngineVersion (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:cache-cluster-id m11010)]
    (. bean11009 setCacheClusterId (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:snapshot-window m11010)]
    (. bean11009 setSnapshotWindow (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:notification-topic-arn m11010)]
    (. bean11009 setNotificationTopicArn (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:security-group-ids m11010)]
    (.
     bean11009
     setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11032] (clojure.core/str arg11032))
 v11011)))
   (clojure.core/when-let
    [v11011 (:cache-node-type m11010)]
    (. bean11009 setCacheNodeType (clojure.core/str v11011)))
   (clojure.core/when-let
    [v11011 (:snapshot-arns m11010)]
    (.
     bean11009
     setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11033] (clojure.core/str arg11033))
 v11011)))
   bean11009))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest}
describe-reserved-cache-nodes-offerings-request
  [m11013]
  (clojure.core/let
   [bean11012
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)]
   (clojure.core/when-let
    [v11014 (:max-records m11013)]
    (. bean11012 setMaxRecords (clojure.core/int v11014)))
   (clojure.core/when-let
    [v11014 (:duration m11013)]
    (. bean11012 setDuration (clojure.core/str v11014)))
   (clojure.core/when-let
    [v11014 (:offering-type m11013)]
    (. bean11012 setOfferingType (clojure.core/str v11014)))
   (clojure.core/when-let
    [v11014 (:reserved-cache-nodes-offering-id m11013)]
    (.
     bean11012
     setReservedCacheNodesOfferingId
     (clojure.core/str v11014)))
   (clojure.core/when-let
    [v11014 (:cache-node-type m11013)]
    (. bean11012 setCacheNodeType (clojure.core/str v11014)))
   (clojure.core/when-let
    [v11014 (:marker m11013)]
    (. bean11012 setMarker (clojure.core/str v11014)))
   (clojure.core/when-let
    [v11014 (:product-description m11013)]
    (. bean11012 setProductDescription (clojure.core/str v11014)))
   bean11012))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateSnapshotRequest}
create-snapshot-request
  [m11016]
  (clojure.core/let
   [bean11015
    (new
     com.amazonaws.services.elasticache.model.CreateSnapshotRequest)]
   (clojure.core/when-let
    [v11017 (:cache-cluster-id m11016)]
    (. bean11015 setCacheClusterId (clojure.core/str v11017)))
   (clojure.core/when-let
    [v11017 (:snapshot-name m11016)]
    (. bean11015 setSnapshotName (clojure.core/str v11017)))
   bean11015))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m11019]
  (clojure.core/let
   [bean11018
    (new
     com.amazonaws.services.elasticache.model.DeleteSnapshotRequest)]
   (clojure.core/when-let
    [v11020 (:snapshot-name m11019)]
    (. bean11018 setSnapshotName (clojure.core/str v11020)))
   bean11018))
 (clojure.core/defmulti
  elasticache
  (clojure.core/fn
   elasticache
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameter-groups
   [m11034]
   (clojure.core/let
    [credentials11035 (:credentials m11034) args11036 (:args m11034)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11037
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11035)]
     (clojure.core/case
      (clojure.core/count args11036)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11037
        describeCacheParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11037
        describeCacheParameterGroups
        (elasticache/describe-cache-parameter-groups-request
         (clojure.core/nth args11036 0))))))))
  (clojure.core/defn
   describe-cache-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for describeCacheParameterGroups, describeCacheParameterGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cache-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call describeCacheParameterGroups, describeCacheParameterGroups"}
   [credentials11039 & args11040]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11041
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11039)]
    (clojure.core/case
     (clojure.core/count args11040)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11041
       describeCacheParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11041
       describeCacheParameterGroups
       (elasticache/describe-cache-parameter-groups-request
        (clojure.core/nth args11040 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-parameter-group
   [m11042]
   (clojure.core/let
    [credentials11043 (:credentials m11042) args11044 (:args m11042)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11045
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11043)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11045
       createCacheParameterGroup
       (elasticache/create-cache-parameter-group-request
        (clojure.core/nth args11044 0)))))))
  (clojure.core/defn
   create-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-parameter-group-name
                         cache-parameter-group-family]}]]),
    :doc "Generate map for createCacheParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-parameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-parameter-group-name
                         cache-parameter-group-family]}]]),
    :doc "Call createCacheParameterGroup"}
   [credentials11047 & args11048]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11049
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11047)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11049
      createCacheParameterGroup
      (elasticache/create-cache-parameter-group-request
       (clojure.core/nth args11048 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :revoke-cache-security-group-ingress
   [m11050]
   (clojure.core/let
    [credentials11051 (:credentials m11050) args11052 (:args m11050)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11053
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11051)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11053
       revokeCacheSecurityGroupIngress
       (elasticache/revoke-cache-security-group-ingress-request
        (clojure.core/nth args11052 0)))))))
  (clojure.core/defn
   revoke-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeCacheSecurityGroupIngress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :revoke-cache-security-group-ingress,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   revoke-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Call revokeCacheSecurityGroupIngress"}
   [credentials11055 & args11056]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11057
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11055)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11057
      revokeCacheSecurityGroupIngress
      (elasticache/revoke-cache-security-group-ingress-request
       (clojure.core/nth args11056 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-replication-group
   [m11058]
   (clojure.core/let
    [credentials11059 (:credentials m11058) args11060 (:args m11058)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11061
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11059)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11061
       createReplicationGroup
       (elasticache/create-replication-group-request
        (clojure.core/nth args11060 0)))))))
  (clojure.core/defn
   create-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [replication-group-id
                         replication-group-description
                         primary-cluster-id
                         general-progress-listener]}]]),
    :doc "Generate map for createReplicationGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-replication-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [replication-group-id
                         replication-group-description
                         primary-cluster-id
                         general-progress-listener]}]]),
    :doc "Call createReplicationGroup"}
   [credentials11063 & args11064]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11065
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11063)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11065
      createReplicationGroup
      (elasticache/create-replication-group-request
       (clojure.core/nth args11064 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-snapshots
   [m11066]
   (clojure.core/let
    [credentials11067 (:credentials m11066) args11068 (:args m11066)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11069
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11067)]
     (clojure.core/case
      (clojure.core/count args11068)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11069
        describeSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11069
        describeSnapshots
        (elasticache/describe-snapshots-request
         (clojure.core/nth args11068 0))))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cache-cluster-id
                         marker
                         snapshot-name
                         max-records
                         general-progress-listener
                         snapshot-source]}]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-snapshots,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-snapshots,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cache-cluster-id
                         marker
                         snapshot-name
                         max-records
                         general-progress-listener
                         snapshot-source]}]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials11071 & args11072]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11073
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11071)]
    (clojure.core/case
     (clojure.core/count args11072)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11073
       describeSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11073
       describeSnapshots
       (elasticache/describe-snapshots-request
        (clojure.core/nth args11072 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :authorize-cache-security-group-ingress
   [m11074]
   (clojure.core/let
    [credentials11075 (:credentials m11074) args11076 (:args m11074)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11077
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11075)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11077
       authorizeCacheSecurityGroupIngress
       (elasticache/authorize-cache-security-group-ingress-request
        (clojure.core/nth args11076 0)))))))
  (clojure.core/defn
   authorize-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeCacheSecurityGroupIngress"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :authorize-cache-security-group-ingress,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   authorize-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Call authorizeCacheSecurityGroupIngress"}
   [credentials11079 & args11080]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11081
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11079)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11081
      authorizeCacheSecurityGroupIngress
      (elasticache/authorize-cache-security-group-ingress-request
       (clojure.core/nth args11080 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes
   [m11082]
   (clojure.core/let
    [credentials11083 (:credentials m11082) args11084 (:args m11082)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11085
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11083)]
     (clojure.core/case
      (clojure.core/count args11084)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11085
        describeReservedCacheNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11085
        describeReservedCacheNodes
        (elasticache/describe-reserved-cache-nodes-request
         (clojure.core/nth args11084 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-cache-node-id
                         duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Generate map for describeReservedCacheNodes, describeReservedCacheNodes"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-reserved-cache-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-cache-node-id
                         duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Call describeReservedCacheNodes, describeReservedCacheNodes"}
   [credentials11087 & args11088]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11089
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11087)]
    (clojure.core/case
     (clojure.core/count args11088)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11089
       describeReservedCacheNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11089
       describeReservedCacheNodes
       (elasticache/describe-reserved-cache-nodes-request
        (clojure.core/nth args11088 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-cluster
   [m11090]
   (clojure.core/let
    [credentials11091 (:credentials m11090) args11092 (:args m11090)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11093
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11091)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11093
       modifyCacheCluster
       (elasticache/modify-cache-cluster-request
        (clojure.core/nth args11092 0)))))))
  (clojure.core/defn
   modify-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         num-cache-nodes
                         preferred-maintenance-window
                         cache-node-ids-to-remove
                         cache-security-group-names
                         security-group-ids
                         apply-immediately
                         engine-version
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Generate map for modifyCacheCluster"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-cluster,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         num-cache-nodes
                         preferred-maintenance-window
                         cache-node-ids-to-remove
                         cache-security-group-names
                         security-group-ids
                         apply-immediately
                         engine-version
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Call modifyCacheCluster"}
   [credentials11095 & args11096]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11097
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11095)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11097
      modifyCacheCluster
      (elasticache/modify-cache-cluster-request
       (clojure.core/nth args11096 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-subnet-group
   [m11098]
   (clojure.core/let
    [credentials11099 (:credentials m11098) args11100 (:args m11098)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11101
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11099)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11101
       deleteCacheSubnetGroup
       (elasticache/delete-cache-subnet-group-request
        (clojure.core/nth args11100 0)))))))
  (clojure.core/defn
   delete-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-subnet-group-name]}]]),
    :doc "Generate map for deleteCacheSubnetGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-subnet-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-subnet-group-name]}]]),
    :doc "Call deleteCacheSubnetGroup"}
   [credentials11103 & args11104]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11105
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11103)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11105
      deleteCacheSubnetGroup
      (elasticache/delete-cache-subnet-group-request
       (clojure.core/nth args11104 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-engine-versions
   [m11106]
   (clojure.core/let
    [credentials11107 (:credentials m11106) args11108 (:args m11106)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11109
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11107)]
     (clojure.core/case
      (clojure.core/count args11108)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11109
        describeCacheEngineVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11109
        describeCacheEngineVersions
        (elasticache/describe-cache-engine-versions-request
         (clojure.core/nth args11108 0))))))))
  (clojure.core/defn
   describe-cache-engine-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cache-parameter-group-family
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]]),
    :doc "Generate map for describeCacheEngineVersions, describeCacheEngineVersions"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-engine-versions,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-engine-versions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cache-engine-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cache-parameter-group-family
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]]),
    :doc "Call describeCacheEngineVersions, describeCacheEngineVersions"}
   [credentials11111 & args11112]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11113
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11111)]
    (clojure.core/case
     (clojure.core/count args11112)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11113
       describeCacheEngineVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11113
       describeCacheEngineVersions
       (elasticache/describe-cache-engine-versions-request
        (clojure.core/nth args11112 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reset-cache-parameter-group
   [m11114]
   (clojure.core/let
    [credentials11115 (:credentials m11114) args11116 (:args m11114)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11117
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11115)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11117
       resetCacheParameterGroup
       (elasticache/reset-cache-parameter-group-request
        (clojure.core/nth args11116 0)))))))
  (clojure.core/defn
   reset-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for resetCacheParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :reset-cache-parameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reset-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call resetCacheParameterGroup"}
   [credentials11119 & args11120]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11121
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11119)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11121
      resetCacheParameterGroup
      (elasticache/reset-cache-parameter-group-request
       (clojure.core/nth args11120 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-engine-default-parameters
   [m11122]
   (clojure.core/let
    [credentials11123 (:credentials m11122) args11124 (:args m11122)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11125
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11123)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11125
       describeEngineDefaultParameters
       (elasticache/describe-engine-default-parameters-request
        (clojure.core/nth args11124 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-family]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-engine-default-parameters,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-family]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials11127 & args11128]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11129
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11127)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11129
      describeEngineDefaultParameters
      (elasticache/describe-engine-default-parameters-request
       (clojure.core/nth args11128 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-cluster
   [m11130]
   (clojure.core/let
    [credentials11131 (:credentials m11130) args11132 (:args m11130)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11133
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11131)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11133
       deleteCacheCluster
       (elasticache/delete-cache-cluster-request
        (clojure.core/nth args11132 0)))))))
  (clojure.core/defn
   delete-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         final-snapshot-identifier
                         cache-cluster-id]}]]),
    :doc "Generate map for deleteCacheCluster"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-cluster,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         final-snapshot-identifier
                         cache-cluster-id]}]]),
    :doc "Call deleteCacheCluster"}
   [credentials11135 & args11136]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11137
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11135)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11137
      deleteCacheCluster
      (elasticache/delete-cache-cluster-request
       (clojure.core/nth args11136 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-subnet-groups
   [m11138]
   (clojure.core/let
    [credentials11139 (:credentials m11138) args11140 (:args m11138)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11141
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11139)]
     (clojure.core/case
      (clojure.core/count args11140)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11141
        describeCacheSubnetGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11141
        describeCacheSubnetGroups
        (elasticache/describe-cache-subnet-groups-request
         (clojure.core/nth args11140 0))))))))
  (clojure.core/defn
   describe-cache-subnet-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-subnet-group-name]}]]),
    :doc "Generate map for describeCacheSubnetGroups, describeCacheSubnetGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cache-subnet-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-subnet-group-name]}]]),
    :doc "Call describeCacheSubnetGroups, describeCacheSubnetGroups"}
   [credentials11143 & args11144]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11145
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11143)]
    (clojure.core/case
     (clojure.core/count args11144)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11145
       describeCacheSubnetGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11145
       describeCacheSubnetGroups
       (elasticache/describe-cache-subnet-groups-request
        (clojure.core/nth args11144 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-replication-groups
   [m11146]
   (clojure.core/let
    [credentials11147 (:credentials m11146) args11148 (:args m11146)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11149
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11147)]
     (clojure.core/case
      (clojure.core/count args11148)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11149
        describeReplicationGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11149
        describeReplicationGroups
        (elasticache/describe-replication-groups-request
         (clojure.core/nth args11148 0))))))))
  (clojure.core/defn
   describe-replication-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [replication-group-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeReplicationGroups, describeReplicationGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-replication-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-replication-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-replication-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [replication-group-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeReplicationGroups, describeReplicationGroups"}
   [credentials11151 & args11152]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11153
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11151)]
    (clojure.core/case
     (clojure.core/count args11152)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11153
       describeReplicationGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11153
       describeReplicationGroups
       (elasticache/describe-replication-groups-request
        (clojure.core/nth args11152 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-security-groups
   [m11154]
   (clojure.core/let
    [credentials11155 (:credentials m11154) args11156 (:args m11154)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11157
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11155)]
     (clojure.core/case
      (clojure.core/count args11156)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11157
        describeCacheSecurityGroups
        (elasticache/describe-cache-security-groups-request
         (clojure.core/nth args11156 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11157
        describeCacheSecurityGroups))))))
  (clojure.core/defn
   describe-cache-security-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-security-group-name]}]
                [credentials]]),
    :doc "Generate map for describeCacheSecurityGroups, describeCacheSecurityGroups"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-security-groups,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-security-groups,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cache-security-groups
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-security-group-name]}]
                [credentials]]),
    :doc "Call describeCacheSecurityGroups, describeCacheSecurityGroups"}
   [credentials11159 & args11160]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11161
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11159)]
    (clojure.core/case
     (clojure.core/count args11160)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11161
       describeCacheSecurityGroups
       (elasticache/describe-cache-security-groups-request
        (clojure.core/nth args11160 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11161
       describeCacheSecurityGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-security-group
   [m11162]
   (clojure.core/let
    [credentials11163 (:credentials m11162) args11164 (:args m11162)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11165
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11163)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11165
       createCacheSecurityGroup
       (elasticache/create-cache-security-group-request
        (clojure.core/nth args11164 0)))))))
  (clojure.core/defn
   create-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-security-group-name]}]]),
    :doc "Generate map for createCacheSecurityGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-security-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-security-group-name]}]]),
    :doc "Call createCacheSecurityGroup"}
   [credentials11167 & args11168]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11169
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11167)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11169
      createCacheSecurityGroup
      (elasticache/create-cache-security-group-request
       (clojure.core/nth args11168 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-clusters
   [m11170]
   (clojure.core/let
    [credentials11171 (:credentials m11170) args11172 (:args m11170)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11173
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11171)]
     (clojure.core/case
      (clojure.core/count args11172)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11173
        describeCacheClusters
        (elasticache/describe-cache-clusters-request
         (clojure.core/nth args11172 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11173
        describeCacheClusters))))))
  (clojure.core/defn
   describe-cache-clusters-map
   {:arglists (quote
               [[credentials
                 {:keys [show-cache-node-info
                         max-records
                         marker
                         general-progress-listener
                         cache-cluster-id]}]
                [credentials]]),
    :doc "Generate map for describeCacheClusters, describeCacheClusters"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-clusters,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-clusters,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cache-clusters
   {:arglists (quote
               [[credentials
                 {:keys [show-cache-node-info
                         max-records
                         marker
                         general-progress-listener
                         cache-cluster-id]}]
                [credentials]]),
    :doc "Call describeCacheClusters, describeCacheClusters"}
   [credentials11175 & args11176]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11177
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11175)]
    (clojure.core/case
     (clojure.core/count args11176)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11177
       describeCacheClusters
       (elasticache/describe-cache-clusters-request
        (clojure.core/nth args11176 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11177
       describeCacheClusters))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-events
   [m11178]
   (clojure.core/let
    [credentials11179 (:credentials m11178) args11180 (:args m11178)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11181
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11179)]
     (clojure.core/case
      (clojure.core/count args11180)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11181
        describeEvents
        (elasticache/describe-events-request
         (clojure.core/nth args11180 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11181
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-events,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-events,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials11183 & args11184]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11185
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11183)]
    (clojure.core/case
     (clojure.core/count args11184)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11185
       describeEvents
       (elasticache/describe-events-request
        (clojure.core/nth args11184 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11185
       describeEvents))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-parameter-group
   [m11186]
   (clojure.core/let
    [credentials11187 (:credentials m11186) args11188 (:args m11186)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11189
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11187)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11189
       modifyCacheParameterGroup
       (elasticache/modify-cache-parameter-group-request
        (clojure.core/nth args11188 0)))))))
  (clojure.core/defn
   modify-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for modifyCacheParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-parameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call modifyCacheParameterGroup"}
   [credentials11191 & args11192]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11193
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11191)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11193
      modifyCacheParameterGroup
      (elasticache/modify-cache-parameter-group-request
       (clojure.core/nth args11192 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-security-group
   [m11194]
   (clojure.core/let
    [credentials11195 (:credentials m11194) args11196 (:args m11194)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11197
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11195)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11197
       deleteCacheSecurityGroup
       (elasticache/delete-cache-security-group-request
        (clojure.core/nth args11196 0)))))))
  (clojure.core/defn
   delete-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name]}]]),
    :doc "Generate map for deleteCacheSecurityGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-security-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name]}]]),
    :doc "Call deleteCacheSecurityGroup"}
   [credentials11199 & args11200]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11201
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11199)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11201
      deleteCacheSecurityGroup
      (elasticache/delete-cache-security-group-request
       (clojure.core/nth args11200 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-subnet-group
   [m11202]
   (clojure.core/let
    [credentials11203 (:credentials m11202) args11204 (:args m11202)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11205
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11203)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11205
       createCacheSubnetGroup
       (elasticache/create-cache-subnet-group-request
        (clojure.core/nth args11204 0)))))))
  (clojure.core/defn
   create-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Generate map for createCacheSubnetGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-subnet-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Call createCacheSubnetGroup"}
   [credentials11207 & args11208]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11209
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11207)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11209
      createCacheSubnetGroup
      (elasticache/create-cache-subnet-group-request
       (clojure.core/nth args11208 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-replication-group
   [m11210]
   (clojure.core/let
    [credentials11211 (:credentials m11210) args11212 (:args m11210)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11213
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11211)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11213
       modifyReplicationGroup
       (elasticache/modify-replication-group-request
        (clojure.core/nth args11212 0)))))))
  (clojure.core/defn
   modify-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         primary-cluster-id
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         replication-group-description
                         security-group-ids
                         apply-immediately
                         engine-version
                         snapshotting-cluster-id
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Generate map for modifyReplicationGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-replication-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         primary-cluster-id
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         replication-group-description
                         security-group-ids
                         apply-immediately
                         engine-version
                         snapshotting-cluster-id
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Call modifyReplicationGroup"}
   [credentials11215 & args11216]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11217
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11215)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11217
      modifyReplicationGroup
      (elasticache/modify-replication-group-request
       (clojure.core/nth args11216 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-subnet-group
   [m11218]
   (clojure.core/let
    [credentials11219 (:credentials m11218) args11220 (:args m11218)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11221
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11219)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11221
       modifyCacheSubnetGroup
       (elasticache/modify-cache-subnet-group-request
        (clojure.core/nth args11220 0)))))))
  (clojure.core/defn
   modify-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Generate map for modifyCacheSubnetGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-subnet-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   modify-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Call modifyCacheSubnetGroup"}
   [credentials11223 & args11224]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11225
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11223)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11225
      modifyCacheSubnetGroup
      (elasticache/modify-cache-subnet-group-request
       (clojure.core/nth args11224 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameters
   [m11226]
   (clojure.core/let
    [credentials11227 (:credentials m11226) args11228 (:args m11226)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11229
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11227)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11229
       describeCacheParameters
       (elasticache/describe-cache-parameters-request
        (clojure.core/nth args11228 0)))))))
  (clojure.core/defn
   describe-cache-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for describeCacheParameters"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-parameters,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-cache-parameters
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call describeCacheParameters"}
   [credentials11231 & args11232]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11233
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11231)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11233
      describeCacheParameters
      (elasticache/describe-cache-parameters-request
       (clojure.core/nth args11232 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-parameter-group
   [m11234]
   (clojure.core/let
    [credentials11235 (:credentials m11234) args11236 (:args m11234)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11237
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11235)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11237
       deleteCacheParameterGroup
       (elasticache/delete-cache-parameter-group-request
        (clojure.core/nth args11236 0)))))))
  (clojure.core/defn
   delete-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for deleteCacheParameterGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-parameter-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call deleteCacheParameterGroup"}
   [credentials11239 & args11240]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11241
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11239)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11241
      deleteCacheParameterGroup
      (elasticache/delete-cache-parameter-group-request
       (clojure.core/nth args11240 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-replication-group
   [m11242]
   (clojure.core/let
    [credentials11243 (:credentials m11242) args11244 (:args m11242)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11245
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11243)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11245
       deleteReplicationGroup
       (elasticache/delete-replication-group-request
        (clojure.core/nth args11244 0)))))))
  (clojure.core/defn
   delete-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         replication-group-id
                         general-progress-listener
                         final-snapshot-identifier]}]]),
    :doc "Generate map for deleteReplicationGroup"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-replication-group,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         replication-group-id
                         general-progress-listener
                         final-snapshot-identifier]}]]),
    :doc "Call deleteReplicationGroup"}
   [credentials11247 & args11248]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11249
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11247)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11249
      deleteReplicationGroup
      (elasticache/delete-replication-group-request
       (clojure.core/nth args11248 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :copy-snapshot
   [m11250]
   (clojure.core/let
    [credentials11251 (:credentials m11250) args11252 (:args m11250)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11253
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11251)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11253
       copySnapshot
       (elasticache/copy-snapshot-request
        (clojure.core/nth args11252 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-name
                         source-snapshot-name
                         general-progress-listener]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :copy-snapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-name
                         source-snapshot-name
                         general-progress-listener]}]]),
    :doc "Call copySnapshot"}
   [credentials11255 & args11256]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11257
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11255)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11257
      copySnapshot
      (elasticache/copy-snapshot-request
       (clojure.core/nth args11256 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :purchase-reserved-cache-nodes-offering
   [m11258]
   (clojure.core/let
    [credentials11259 (:credentials m11258) args11260 (:args m11258)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11261
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11259)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11261
       purchaseReservedCacheNodesOffering
       (elasticache/purchase-reserved-cache-nodes-offering-request
        (clojure.core/nth args11260 0)))))))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-cache-nodes-offering-id
                         reserved-cache-node-id
                         general-progress-listener
                         cache-node-count]}]]),
    :doc "Generate map for purchaseReservedCacheNodesOffering"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :purchase-reserved-cache-nodes-offering,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-cache-nodes-offering-id
                         reserved-cache-node-id
                         general-progress-listener
                         cache-node-count]}]]),
    :doc "Call purchaseReservedCacheNodesOffering"}
   [credentials11263 & args11264]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11265
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11263)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11265
      purchaseReservedCacheNodesOffering
      (elasticache/purchase-reserved-cache-nodes-offering-request
       (clojure.core/nth args11264 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reboot-cache-cluster
   [m11266]
   (clojure.core/let
    [credentials11267 (:credentials m11266) args11268 (:args m11266)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11269
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11267)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11269
       rebootCacheCluster
       (elasticache/reboot-cache-cluster-request
        (clojure.core/nth args11268 0)))))))
  (clojure.core/defn
   reboot-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-node-ids-to-reboot
                         cache-cluster-id]}]]),
    :doc "Generate map for rebootCacheCluster"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :reboot-cache-cluster,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   reboot-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-node-ids-to-reboot
                         cache-cluster-id]}]]),
    :doc "Call rebootCacheCluster"}
   [credentials11271 & args11272]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11273
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11271)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11273
      rebootCacheCluster
      (elasticache/reboot-cache-cluster-request
       (clojure.core/nth args11272 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-cluster
   [m11274]
   (clojure.core/let
    [credentials11275 (:credentials m11274) args11276 (:args m11274)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11277
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11275)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11277
       createCacheCluster
       (elasticache/create-cache-cluster-request
        (clojure.core/nth args11276 0)))))))
  (clojure.core/defn
   create-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-retention-limit
                         engine
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         preferred-availability-zone
                         num-cache-nodes
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         port
                         security-group-ids
                         snapshot-arns
                         engine-version
                         snapshot-name
                         auto-minor-version-upgrade
                         cache-node-type
                         snapshot-window
                         cache-subnet-group-name]}]]),
    :doc "Generate map for createCacheCluster"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-cluster,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-retention-limit
                         engine
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         preferred-availability-zone
                         num-cache-nodes
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         port
                         security-group-ids
                         snapshot-arns
                         engine-version
                         snapshot-name
                         auto-minor-version-upgrade
                         cache-node-type
                         snapshot-window
                         cache-subnet-group-name]}]]),
    :doc "Call createCacheCluster"}
   [credentials11279 & args11280]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11281
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11279)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11281
      createCacheCluster
      (elasticache/create-cache-cluster-request
       (clojure.core/nth args11280 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes-offerings
   [m11282]
   (clojure.core/let
    [credentials11283 (:credentials m11282) args11284 (:args m11282)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11285
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11283)]
     (clojure.core/case
      (clojure.core/count args11284)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11285
        describeReservedCacheNodesOfferings
        (elasticache/describe-reserved-cache-nodes-offerings-request
         (clojure.core/nth args11284 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11285
        describeReservedCacheNodesOfferings))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]
                [credentials]]),
    :doc "Generate map for describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   ([credentials__1649__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings
   {:arglists (quote
               [[credentials
                 {:keys [duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]
                [credentials]]),
    :doc "Call describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   [credentials11287 & args11288]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11289
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11287)]
    (clojure.core/case
     (clojure.core/count args11288)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11289
       describeReservedCacheNodesOfferings
       (elasticache/describe-reserved-cache-nodes-offerings-request
        (clojure.core/nth args11288 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11289
       describeReservedCacheNodesOfferings))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-snapshot
   [m11290]
   (clojure.core/let
    [credentials11291 (:credentials m11290) args11292 (:args m11290)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11293
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11291)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11293
       createSnapshot
       (elasticache/create-snapshot-request
        (clojure.core/nth args11292 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name
                         general-progress-listener
                         cache-cluster-id]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-snapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name
                         general-progress-listener
                         cache-cluster-id]}]]),
    :doc "Call createSnapshot"}
   [credentials11295 & args11296]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11297
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11295)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11297
      createSnapshot
      (elasticache/create-snapshot-request
       (clojure.core/nth args11296 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-snapshot
   [m11298]
   (clojure.core/let
    [credentials11299 (:credentials m11298) args11300 (:args m11298)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11301
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11299)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11301
       deleteSnapshot
       (elasticache/delete-snapshot-request
        (clojure.core/nth args11300 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name general-progress-listener]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-snapshot,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name general-progress-listener]}]]),
    :doc "Call deleteSnapshot"}
   [credentials11303 & args11304]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11305
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11303)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11305
      deleteSnapshot
      (elasticache/delete-snapshot-request
       (clojure.core/nth args11304 0))))))))
